/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.net.bytebuddy.implementation.bind.annotation;

import io.trino.jdbc.$internal.net.bytebuddy.description.annotation.AnnotationDescription;
import io.trino.jdbc.$internal.net.bytebuddy.description.method.MethodDescription;
import io.trino.jdbc.$internal.net.bytebuddy.description.method.MethodList;
import io.trino.jdbc.$internal.net.bytebuddy.description.method.ParameterDescription;
import io.trino.jdbc.$internal.net.bytebuddy.description.type.TypeDescription;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.Implementation;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.bind.MethodDelegationBinder;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.bytecode.StackManipulation;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.bytecode.assign.Assigner;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.bytecode.constant.NullConstant;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import io.trino.jdbc.$internal.net.bytebuddy.matcher.ElementMatchers;
import io.trino.jdbc.$internal.net.bytebuddy.utility.CompoundList;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.util.ArrayList;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface AllArguments {
    public Assignment value() default Assignment.STRICT;

    public boolean includeSelf() default false;

    public boolean nullIfEmpty() default false;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Binder implements TargetMethodAnnotationDrivenBinder.ParameterBinder<AllArguments>
    {
        INSTANCE;

        private static final MethodDescription.InDefinedShape VALUE;
        private static final MethodDescription.InDefinedShape INCLUDE_SELF;
        private static final MethodDescription.InDefinedShape NULL_IF_EMPTY;

        @Override
        public Class<AllArguments> getHandledType() {
            return AllArguments.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<AllArguments> annotation, MethodDescription source2, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner, Assigner.Typing typing) {
            boolean includeThis;
            TypeDescription.Generic componentType;
            if (target.getType().represents((Type)((Object)Object.class))) {
                componentType = TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(Object.class);
            } else if (target.getType().isArray()) {
                componentType = target.getType().getComponentType();
            } else {
                throw new IllegalStateException("Expected an array type for all argument annotation on " + source2);
            }
            boolean bl = includeThis = !source2.isStatic() && annotation.getValue(INCLUDE_SELF).resolve(Boolean.class) != false;
            if (!includeThis && source2.getParameters().isEmpty() && annotation.getValue(NULL_IF_EMPTY).resolve(Boolean.class).booleanValue()) {
                return new MethodDelegationBinder.ParameterBinding.Anonymous(NullConstant.INSTANCE);
            }
            ArrayList<StackManipulation.Compound> stackManipulations = new ArrayList<StackManipulation.Compound>(source2.getParameters().size() + (includeThis ? 1 : 0));
            int offset = source2.isStatic() || includeThis ? 0 : 1;
            for (TypeDescription.Generic sourceParameter : includeThis ? CompoundList.of(implementationTarget.getInstrumentedType().asGenericType(), source2.getParameters().asTypeList()) : source2.getParameters().asTypeList()) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.of(sourceParameter).loadFrom(offset), assigner.assign(sourceParameter, componentType, typing));
                if (stackManipulation.isValid()) {
                    stackManipulations.add(stackManipulation);
                } else if (annotation.getValue(VALUE).load(AllArguments.class.getClassLoader()).resolve(Assignment.class).isStrict()) {
                    return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
                }
                offset += sourceParameter.getStackSize().getSize();
            }
            return new MethodDelegationBinder.ParameterBinding.Anonymous(ArrayFactory.forType(componentType).withValues(stackManipulations));
        }

        static {
            MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(AllArguments.class).getDeclaredMethods();
            VALUE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("value"))).getOnly();
            INCLUDE_SELF = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("includeSelf"))).getOnly();
            NULL_IF_EMPTY = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("nullIfEmpty"))).getOnly();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Assignment {
        STRICT(true),
        SLACK(false);

        private final boolean strict;

        private Assignment(boolean strict) {
            this.strict = strict;
        }

        protected boolean isStrict() {
            return this.strict;
        }
    }
}

