/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.net.bytebuddy.implementation.bytecode.assign.primitive;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import io.trino.jdbc.$internal.net.bytebuddy.description.type.TypeDescription;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.bytecode.StackManipulation;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.bytecode.assign.Assigner;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveBoxingDelegate;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveUnboxingDelegate;
import io.trino.jdbc.$internal.net.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveWideningDelegate;

@HashCodeAndEqualsPlugin.Enhance
public class PrimitiveTypeAwareAssigner
implements Assigner {
    private final Assigner referenceTypeAwareAssigner;

    public PrimitiveTypeAwareAssigner(Assigner referenceTypeAwareAssigner) {
        this.referenceTypeAwareAssigner = referenceTypeAwareAssigner;
    }

    public StackManipulation assign(TypeDescription.Generic source2, TypeDescription.Generic target, Assigner.Typing typing) {
        if (source2.isPrimitive() && target.isPrimitive()) {
            return PrimitiveWideningDelegate.forPrimitive(source2).widenTo(target);
        }
        if (source2.isPrimitive()) {
            return PrimitiveBoxingDelegate.forPrimitive(source2).assignBoxedTo(target, this.referenceTypeAwareAssigner, typing);
        }
        if (target.isPrimitive()) {
            return PrimitiveUnboxingDelegate.forReferenceType(source2).assignUnboxedTo(target, this.referenceTypeAwareAssigner, typing);
        }
        return this.referenceTypeAwareAssigner.assign(source2, target, typing);
    }

    public boolean equals(@.MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.referenceTypeAwareAssigner.equals(((PrimitiveTypeAwareAssigner)object).referenceTypeAwareAssigner);
    }

    public int hashCode() {
        return this.getClass().hashCode() * 31 + this.referenceTypeAwareAssigner.hashCode();
    }
}

