/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import io.airlift.log.Logging;
import io.trino.client.ClientTypeSignature;
import io.trino.client.ClientTypeSignatureParameter;
import io.trino.jdbc.BaseTestJdbcResultSet;
import io.trino.jdbc.TestingJdbcUtils;
import io.trino.jdbc.TrinoPreparedStatement;
import io.trino.plugin.blackhole.BlackHolePlugin;
import io.trino.plugin.memory.MemoryPlugin;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.Plugin;
import io.trino.testing.TestingNames;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.JDBCType;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.LongStream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestJdbcPreparedStatement {
    private static final int HEADER_SIZE_LIMIT = 16384;
    private TestingTrinoServer server;

    @BeforeAll
    public void setup() throws Exception {
        Logging.initialize();
        this.server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().put((Object)"http-server.max-request-header-size", (Object)String.format("%sB", 16384)).put((Object)"http-server.max-response-header-size", (Object)String.format("%sB", 16384)).buildOrThrow()).build();
        this.server.installPlugin((Plugin)new BlackHolePlugin());
        this.server.installPlugin((Plugin)new MemoryPlugin());
        this.server.createCatalog("blackhole", "blackhole");
        this.server.createCatalog("memory", "memory");
        try (Connection connection = this.createConnection(false);
             Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE SCHEMA blackhole.blackhole");
        }
    }

    @AfterAll
    public void tearDown() throws Exception {
        this.server.close();
        this.server = null;
    }

    @Test
    public void testExecuteQuery() throws Exception {
        this.testExecuteQuery(false);
        this.testExecuteQuery(true);
    }

    private void testExecuteQuery(boolean explicitPrepare) throws Exception {
        try (Connection connection = this.createConnection(explicitPrepare);
             PreparedStatement statement = connection.prepareStatement("SELECT ?, ?");){
            statement.setInt(1, 123);
            statement.setString(2, "hello");
            try (ResultSet rs = statement.executeQuery();){
                Assertions.assertThat((boolean)rs.next()).isTrue();
                Assertions.assertThat((int)rs.getInt(1)).isEqualTo(123);
                Assertions.assertThat((String)rs.getString(2)).isEqualTo("hello");
                Assertions.assertThat((boolean)rs.next()).isFalse();
            }
            Assertions.assertThat((boolean)statement.execute()).isTrue();
            rs = statement.getResultSet();
            try {
                Assertions.assertThat((boolean)rs.next()).isTrue();
                Assertions.assertThat((int)rs.getInt(1)).isEqualTo(123);
                Assertions.assertThat((String)rs.getString(2)).isEqualTo("hello");
                Assertions.assertThat((boolean)rs.next()).isFalse();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testGetMetadata() throws Exception {
        this.testGetMetadata(true);
        this.testGetMetadata(false);
    }

    private void testGetMetadata(boolean explicitPrepare) throws Exception {
        String tableName = "test_get_metadata_" + TestingNames.randomNameSuffix();
        try (Connection connection = this.createConnection("blackhole", "blackhole", explicitPrepare);){
            try (Statement statement = connection.createStatement();){
                statement.execute("CREATE TABLE " + tableName + " (c_boolean boolean, c_decimal decimal, c_decimal_2 decimal(10,3),c_varchar varchar, c_varchar_2 varchar(10), c_row row(x integer, y array(integer)), c_array array(integer), c_map map(integer, integer))");
            }
            statement = connection.prepareStatement("SELECT * FROM " + tableName);
            try {
                ResultSetMetaData metadata = statement.getMetaData();
                Assertions.assertThat((int)metadata.getColumnCount()).isEqualTo(8);
                for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                    Assertions.assertThat((String)metadata.getCatalogName(i)).isEqualTo("blackhole");
                    Assertions.assertThat((String)metadata.getSchemaName(i)).isEqualTo("blackhole");
                    Assertions.assertThat((String)metadata.getTableName(i)).isEqualTo(tableName);
                }
                Assertions.assertThat((String)metadata.getColumnName(1)).isEqualTo("c_boolean");
                Assertions.assertThat((String)metadata.getColumnTypeName(1)).isEqualTo("boolean");
                Assertions.assertThat((String)metadata.getColumnName(2)).isEqualTo("c_decimal");
                Assertions.assertThat((String)metadata.getColumnTypeName(2)).isEqualTo("decimal(38,0)");
                Assertions.assertThat((String)metadata.getColumnName(3)).isEqualTo("c_decimal_2");
                Assertions.assertThat((String)metadata.getColumnTypeName(3)).isEqualTo("decimal(10,3)");
                Assertions.assertThat((String)metadata.getColumnName(4)).isEqualTo("c_varchar");
                Assertions.assertThat((String)metadata.getColumnTypeName(4)).isEqualTo("varchar");
                Assertions.assertThat((String)metadata.getColumnName(5)).isEqualTo("c_varchar_2");
                Assertions.assertThat((String)metadata.getColumnTypeName(5)).isEqualTo("varchar(10)");
                Assertions.assertThat((String)metadata.getColumnName(6)).isEqualTo("c_row");
                Assertions.assertThat((String)metadata.getColumnTypeName(6)).isEqualTo("row");
                Assertions.assertThat((String)metadata.getColumnName(7)).isEqualTo("c_array");
                Assertions.assertThat((String)metadata.getColumnTypeName(7)).isEqualTo("array");
                Assertions.assertThat((String)metadata.getColumnName(8)).isEqualTo("c_map");
                Assertions.assertThat((String)metadata.getColumnTypeName(8)).isEqualTo("map");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            statement = connection.createStatement();
            try {
                statement.execute("DROP TABLE " + tableName);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    @Test
    public void testGetParameterMetaData() throws Exception {
        this.testGetParameterMetaData(true);
        this.testGetParameterMetaData(false);
    }

    private void testGetParameterMetaData(boolean explicitPrepare) throws Exception {
        String tableName = "test_get_parameterMetaData_" + TestingNames.randomNameSuffix();
        try (Connection connection = this.createConnection("blackhole", "blackhole", explicitPrepare);){
            try (Statement statement = connection.createStatement();){
                statement.execute("CREATE TABLE " + tableName + " (c_boolean boolean, c_decimal decimal, c_decimal_2 decimal(10,3),c_varchar varchar, c_varchar_2 varchar(5), c_row row(x integer, y array(integer)), c_array array(integer), c_map map(integer, integer), c_tinyint tinyint, c_integer integer, c_bigint bigint, c_smallint smallint, c_real real, c_double double)");
            }
            statement = connection.prepareStatement("SELECT ? FROM " + tableName + " WHERE c_boolean = ? AND c_decimal = ? AND c_decimal_2 = ? AND c_varchar = ? AND c_varchar_2 = ? AND c_row = ? AND c_array = ? AND c_map = ? AND c_tinyint = ? AND c_integer = ? AND c_bigint = ? AND c_smallint = ? AND c_real = ? AND c_double = ?");
            try {
                ParameterMetaData parameterMetaData = statement.getParameterMetaData();
                Assertions.assertThat((int)parameterMetaData.getParameterCount()).isEqualTo(15);
                Assertions.assertThat((String)parameterMetaData.getParameterClassName(1)).isEqualTo("unknown");
                Assertions.assertThat((int)parameterMetaData.getParameterType(1)).isEqualTo(0);
                Assertions.assertThat((String)parameterMetaData.getParameterTypeName(1)).isEqualTo("unknown");
                Assertions.assertThat((int)parameterMetaData.isNullable(1)).isEqualTo(2);
                Assertions.assertThat((boolean)parameterMetaData.isSigned(1)).isFalse();
                Assertions.assertThat((int)parameterMetaData.getParameterMode(1)).isEqualTo(0);
                Assertions.assertThat((String)parameterMetaData.getParameterClassName(2)).isEqualTo(Boolean.class.getName());
                Assertions.assertThat((int)parameterMetaData.getParameterType(2)).isEqualTo(16);
                Assertions.assertThat((String)parameterMetaData.getParameterTypeName(2)).isEqualTo("boolean");
                Assertions.assertThat((int)parameterMetaData.isNullable(2)).isEqualTo(2);
                Assertions.assertThat((boolean)parameterMetaData.isSigned(2)).isFalse();
                Assertions.assertThat((int)parameterMetaData.getParameterMode(2)).isEqualTo(0);
                Assertions.assertThat((String)parameterMetaData.getParameterClassName(3)).isEqualTo(BigDecimal.class.getName());
                Assertions.assertThat((int)parameterMetaData.getParameterType(3)).isEqualTo(3);
                Assertions.assertThat((String)parameterMetaData.getParameterTypeName(3)).isEqualTo("decimal");
                Assertions.assertThat((int)parameterMetaData.isNullable(3)).isEqualTo(2);
                Assertions.assertThat((boolean)parameterMetaData.isSigned(3)).isTrue();
                Assertions.assertThat((int)parameterMetaData.getParameterMode(3)).isEqualTo(0);
                Assertions.assertThat((String)parameterMetaData.getParameterClassName(4)).isEqualTo(BigDecimal.class.getName());
                Assertions.assertThat((int)parameterMetaData.getParameterType(4)).isEqualTo(3);
                Assertions.assertThat((String)parameterMetaData.getParameterTypeName(4)).isEqualTo("decimal");
                Assertions.assertThat((int)parameterMetaData.getPrecision(4)).isEqualTo(10);
                Assertions.assertThat((int)parameterMetaData.getScale(4)).isEqualTo(3);
                Assertions.assertThat((int)parameterMetaData.isNullable(4)).isEqualTo(2);
                Assertions.assertThat((boolean)parameterMetaData.isSigned(4)).isTrue();
                Assertions.assertThat((int)parameterMetaData.getParameterMode(4)).isEqualTo(0);
                Assertions.assertThat((String)parameterMetaData.getParameterClassName(5)).isEqualTo(String.class.getName());
                Assertions.assertThat((int)parameterMetaData.getParameterType(5)).isEqualTo(12);
                Assertions.assertThat((String)parameterMetaData.getParameterTypeName(5)).isEqualTo("varchar");
                Assertions.assertThat((int)parameterMetaData.isNullable(5)).isEqualTo(2);
                Assertions.assertThat((boolean)parameterMetaData.isSigned(5)).isFalse();
                Assertions.assertThat((int)parameterMetaData.getParameterMode(5)).isEqualTo(0);
                Assertions.assertThat((String)parameterMetaData.getParameterClassName(6)).isEqualTo(String.class.getName());
                Assertions.assertThat((int)parameterMetaData.getParameterType(6)).isEqualTo(12);
                Assertions.assertThat((String)parameterMetaData.getParameterTypeName(6)).isEqualTo("varchar");
                Assertions.assertThat((int)parameterMetaData.getPrecision(6)).isEqualTo(5);
                Assertions.assertThat((int)parameterMetaData.isNullable(6)).isEqualTo(2);
                Assertions.assertThat((boolean)parameterMetaData.isSigned(6)).isFalse();
                Assertions.assertThat((int)parameterMetaData.getParameterMode(6)).isEqualTo(0);
                Assertions.assertThat((String)parameterMetaData.getParameterClassName(7)).isEqualTo(String.class.getName());
                Assertions.assertThat((int)parameterMetaData.getParameterType(7)).isEqualTo(2000);
                Assertions.assertThat((String)parameterMetaData.getParameterTypeName(7)).isEqualTo("row");
                Assertions.assertThat((int)parameterMetaData.isNullable(7)).isEqualTo(2);
                Assertions.assertThat((boolean)parameterMetaData.isSigned(7)).isFalse();
                Assertions.assertThat((int)parameterMetaData.getParameterMode(7)).isEqualTo(0);
                Assertions.assertThat((String)parameterMetaData.getParameterClassName(8)).isEqualTo(Array.class.getName());
                Assertions.assertThat((int)parameterMetaData.getParameterType(8)).isEqualTo(2003);
                Assertions.assertThat((String)parameterMetaData.getParameterTypeName(8)).isEqualTo("array");
                Assertions.assertThat((int)parameterMetaData.isNullable(8)).isEqualTo(2);
                Assertions.assertThat((boolean)parameterMetaData.isSigned(8)).isFalse();
                Assertions.assertThat((int)parameterMetaData.getParameterMode(8)).isEqualTo(0);
                Assertions.assertThat((String)parameterMetaData.getParameterClassName(9)).isEqualTo(String.class.getName());
                Assertions.assertThat((int)parameterMetaData.getParameterType(9)).isEqualTo(2000);
                Assertions.assertThat((String)parameterMetaData.getParameterTypeName(9)).isEqualTo("map");
                Assertions.assertThat((int)parameterMetaData.isNullable(9)).isEqualTo(2);
                Assertions.assertThat((boolean)parameterMetaData.isSigned(9)).isFalse();
                Assertions.assertThat((int)parameterMetaData.getParameterMode(9)).isEqualTo(0);
                Assertions.assertThat((String)parameterMetaData.getParameterClassName(10)).isEqualTo(Byte.class.getName());
                Assertions.assertThat((int)parameterMetaData.getParameterType(10)).isEqualTo(-6);
                Assertions.assertThat((String)parameterMetaData.getParameterTypeName(10)).isEqualTo("tinyint");
                Assertions.assertThat((int)parameterMetaData.isNullable(10)).isEqualTo(2);
                Assertions.assertThat((boolean)parameterMetaData.isSigned(10)).isTrue();
                Assertions.assertThat((int)parameterMetaData.getParameterMode(10)).isEqualTo(0);
                Assertions.assertThat((String)parameterMetaData.getParameterClassName(11)).isEqualTo(Integer.class.getName());
                Assertions.assertThat((int)parameterMetaData.getParameterType(11)).isEqualTo(4);
                Assertions.assertThat((String)parameterMetaData.getParameterTypeName(11)).isEqualTo("integer");
                Assertions.assertThat((int)parameterMetaData.isNullable(11)).isEqualTo(2);
                Assertions.assertThat((boolean)parameterMetaData.isSigned(11)).isTrue();
                Assertions.assertThat((int)parameterMetaData.getParameterMode(11)).isEqualTo(0);
                Assertions.assertThat((String)parameterMetaData.getParameterClassName(12)).isEqualTo(Long.class.getName());
                Assertions.assertThat((int)parameterMetaData.getParameterType(12)).isEqualTo(-5);
                Assertions.assertThat((String)parameterMetaData.getParameterTypeName(12)).isEqualTo("bigint");
                Assertions.assertThat((int)parameterMetaData.isNullable(12)).isEqualTo(2);
                Assertions.assertThat((boolean)parameterMetaData.isSigned(12)).isTrue();
                Assertions.assertThat((int)parameterMetaData.getParameterMode(12)).isEqualTo(0);
                Assertions.assertThat((String)parameterMetaData.getParameterClassName(13)).isEqualTo(Short.class.getName());
                Assertions.assertThat((int)parameterMetaData.getParameterType(13)).isEqualTo(5);
                Assertions.assertThat((String)parameterMetaData.getParameterTypeName(13)).isEqualTo("smallint");
                Assertions.assertThat((int)parameterMetaData.isNullable(13)).isEqualTo(2);
                Assertions.assertThat((boolean)parameterMetaData.isSigned(13)).isTrue();
                Assertions.assertThat((int)parameterMetaData.getParameterMode(13)).isEqualTo(0);
                Assertions.assertThat((String)parameterMetaData.getParameterClassName(14)).isEqualTo(Float.class.getName());
                Assertions.assertThat((int)parameterMetaData.getParameterType(14)).isEqualTo(7);
                Assertions.assertThat((String)parameterMetaData.getParameterTypeName(14)).isEqualTo("real");
                Assertions.assertThat((int)parameterMetaData.isNullable(14)).isEqualTo(2);
                Assertions.assertThat((boolean)parameterMetaData.isSigned(14)).isTrue();
                Assertions.assertThat((int)parameterMetaData.getParameterMode(14)).isEqualTo(0);
                Assertions.assertThat((String)parameterMetaData.getParameterClassName(15)).isEqualTo(Double.class.getName());
                Assertions.assertThat((int)parameterMetaData.getParameterType(15)).isEqualTo(8);
                Assertions.assertThat((String)parameterMetaData.getParameterTypeName(15)).isEqualTo("double");
                Assertions.assertThat((int)parameterMetaData.isNullable(15)).isEqualTo(2);
                Assertions.assertThat((boolean)parameterMetaData.isSigned(15)).isTrue();
                Assertions.assertThat((int)parameterMetaData.getParameterMode(15)).isEqualTo(0);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            statement = connection.createStatement();
            try {
                statement.execute("DROP TABLE " + tableName);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    @Test
    public void testGetClientTypeSignatureFromTypeString() {
        ClientTypeSignature actualClientTypeSignature = TrinoPreparedStatement.getClientTypeSignatureFromTypeString((String)"boolean");
        ClientTypeSignature expectedClientTypeSignature = new ClientTypeSignature("boolean", (List)ImmutableList.of());
        Assertions.assertThat((Object)actualClientTypeSignature).isEqualTo((Object)expectedClientTypeSignature);
        actualClientTypeSignature = TrinoPreparedStatement.getClientTypeSignatureFromTypeString((String)"decimal(10,3)");
        expectedClientTypeSignature = new ClientTypeSignature("decimal", (List)ImmutableList.of((Object)ClientTypeSignatureParameter.ofLong((long)10L), (Object)ClientTypeSignatureParameter.ofLong((long)3L)));
        Assertions.assertThat((Object)actualClientTypeSignature).isEqualTo((Object)expectedClientTypeSignature);
        actualClientTypeSignature = TrinoPreparedStatement.getClientTypeSignatureFromTypeString((String)"varchar");
        expectedClientTypeSignature = new ClientTypeSignature("varchar", (List)ImmutableList.of((Object)ClientTypeSignatureParameter.ofLong((long)Integer.MAX_VALUE)));
        Assertions.assertThat((Object)actualClientTypeSignature).isEqualTo((Object)expectedClientTypeSignature);
        actualClientTypeSignature = TrinoPreparedStatement.getClientTypeSignatureFromTypeString((String)"varchar(10)");
        expectedClientTypeSignature = new ClientTypeSignature("varchar", (List)ImmutableList.of((Object)ClientTypeSignatureParameter.ofLong((long)10L)));
        Assertions.assertThat((Object)actualClientTypeSignature).isEqualTo((Object)expectedClientTypeSignature);
        actualClientTypeSignature = TrinoPreparedStatement.getClientTypeSignatureFromTypeString((String)"row(x integer, y array(integer))");
        expectedClientTypeSignature = new ClientTypeSignature("row", (List)ImmutableList.of());
        Assertions.assertThat((Object)actualClientTypeSignature).isEqualTo((Object)expectedClientTypeSignature);
        actualClientTypeSignature = TrinoPreparedStatement.getClientTypeSignatureFromTypeString((String)"array(integer)");
        expectedClientTypeSignature = new ClientTypeSignature("array", (List)ImmutableList.of());
        Assertions.assertThat((Object)actualClientTypeSignature).isEqualTo((Object)expectedClientTypeSignature);
        actualClientTypeSignature = TrinoPreparedStatement.getClientTypeSignatureFromTypeString((String)"map(integer, integer)");
        expectedClientTypeSignature = new ClientTypeSignature("map", (List)ImmutableList.of());
        Assertions.assertThat((Object)actualClientTypeSignature).isEqualTo((Object)expectedClientTypeSignature);
        actualClientTypeSignature = TrinoPreparedStatement.getClientTypeSignatureFromTypeString((String)"timestamp(12) with time zone");
        expectedClientTypeSignature = new ClientTypeSignature("timestamp with time zone", (List)ImmutableList.of((Object)ClientTypeSignatureParameter.ofLong((long)12L)));
        Assertions.assertThat((Object)actualClientTypeSignature).isEqualTo((Object)expectedClientTypeSignature);
        actualClientTypeSignature = TrinoPreparedStatement.getClientTypeSignatureFromTypeString((String)"time(13) with time zone");
        expectedClientTypeSignature = new ClientTypeSignature("time with time zone", (List)ImmutableList.of((Object)ClientTypeSignatureParameter.ofLong((long)13L)));
        Assertions.assertThat((Object)actualClientTypeSignature).isEqualTo((Object)expectedClientTypeSignature);
    }

    @Test
    public void testDeallocate() throws Exception {
        this.testDeallocate(true);
        this.testDeallocate(false);
    }

    private void testDeallocate(boolean explicitPrepare) throws Exception {
        try (Connection connection = this.createConnection(explicitPrepare);){
            for (int i = 0; i < 200; ++i) {
                try {
                    connection.prepareStatement("SELECT '" + Strings.repeat((String)"a", (int)300) + "'").close();
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed at " + i, e);
                }
            }
        }
    }

    @Test
    public void testCloseIdempotency() throws Exception {
        this.testCloseIdempotency(true);
        this.testCloseIdempotency(false);
    }

    private void testCloseIdempotency(boolean explicitPrepare) throws Exception {
        try (Connection connection = this.createConnection(explicitPrepare);){
            PreparedStatement statement = connection.prepareStatement("SELECT 123");
            statement.close();
            statement.close();
        }
    }

    @Test
    public void testLargePreparedStatement() throws Exception {
        this.testLargePreparedStatement(true);
        this.testLargePreparedStatement(false);
    }

    private void testLargePreparedStatement(boolean explicitPrepare) throws Exception {
        int elements = 16385;
        try (Connection connection = this.createConnection(explicitPrepare);
             PreparedStatement statement = connection.prepareStatement("VALUES ?" + Strings.repeat((String)", ?", (int)(elements - 1)));){
            for (int i = 0; i < elements; ++i) {
                statement.setLong(i + 1, i);
            }
            try (ResultSet resultSet = statement.executeQuery();){
                Assertions.assertThat(TestingJdbcUtils.readRows(resultSet).stream().map(Iterables::getOnlyElement)).containsExactlyInAnyOrder(LongStream.range(0L, elements).boxed().toArray());
            }
        }
    }

    @Test
    public void testExecuteUpdate() throws Exception {
        this.testExecuteUpdate(true);
        this.testExecuteUpdate(false);
    }

    public void testExecuteUpdate(boolean explicitPrepare) throws Exception {
        String tableName = "test_execute_update_" + TestingNames.randomNameSuffix();
        try (Connection connection = this.createConnection("blackhole", "blackhole", explicitPrepare);){
            try (Statement statement = connection.createStatement();){
                statement.execute("CREATE TABLE " + tableName + " (c_boolean boolean, c_bigint bigint, c_double double, c_decimal decimal, c_varchar varchar, c_varbinary varbinary, c_null bigint)");
            }
            statement = connection.prepareStatement("INSERT INTO " + tableName + " VALUES (?, ?, ?, ?, ?, ?, ?)");
            try {
                statement.setBoolean(1, true);
                statement.setLong(2, 5L);
                statement.setDouble(3, 7.0);
                statement.setBigDecimal(4, BigDecimal.valueOf(8L));
                statement.setString(5, "abc'xyz");
                statement.setBytes(6, "xyz".getBytes(StandardCharsets.UTF_8));
                statement.setNull(7, -5);
                Assertions.assertThat((int)statement.executeUpdate()).isEqualTo(1);
                Assertions.assertThat((boolean)statement.execute()).isFalse();
                Assertions.assertThat((int)statement.getUpdateCount()).isEqualTo(1);
                Assertions.assertThat((long)statement.getLargeUpdateCount()).isEqualTo(1L);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            statement = connection.createStatement();
            try {
                statement.execute("DROP TABLE " + tableName);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    @Test
    public void testExecuteBatch() throws Exception {
        this.testExecuteBatch(true);
        this.testExecuteBatch(false);
    }

    private void testExecuteBatch(boolean explicitPrepare) throws Exception {
        String tableName = "test_execute_batch_" + TestingNames.randomNameSuffix();
        try (Connection connection = this.createConnection("memory", "default", explicitPrepare);){
            try (Statement statement = connection.createStatement();){
                statement.execute("CREATE TABLE " + tableName + "(c_int integer)");
            }
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO " + tableName + " VALUES (?)");){
                Assertions.assertThat((int[])preparedStatement.executeBatch()).isEqualTo((Object)new int[0]);
                for (int i = 0; i < 3; ++i) {
                    preparedStatement.setInt(1, i);
                    preparedStatement.addBatch();
                }
                Assertions.assertThat((int[])preparedStatement.executeBatch()).isEqualTo((Object)new int[]{1, 1, 1});
                try (Statement statement = connection.createStatement();){
                    ResultSet resultSet = statement.executeQuery("SELECT c_int FROM " + tableName);
                    Assertions.assertThat(TestingJdbcUtils.readRows(resultSet)).containsExactlyInAnyOrder((Object[])new List[]{TestingJdbcUtils.list(0), TestingJdbcUtils.list(1), TestingJdbcUtils.list(2)});
                }
                Assertions.assertThat((int[])preparedStatement.executeBatch()).isEqualTo((Object)new int[0]);
                preparedStatement.setBoolean(1, true);
                preparedStatement.clearBatch();
                Assertions.assertThat((int[])preparedStatement.executeBatch()).isEqualTo((Object)new int[0]);
                preparedStatement.setInt(1, 1);
                Assertions.assertThat((int)preparedStatement.executeUpdate()).isEqualTo(1);
            }
            statement = connection.createStatement();
            try {
                statement.execute("DROP TABLE " + tableName);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    @Test
    public void testInvalidExecuteBatch() throws Exception {
        this.testInvalidExecuteBatch(true);
        this.testInvalidExecuteBatch(false);
    }

    private void testInvalidExecuteBatch(boolean explicitPrepare) throws Exception {
        String tableName = "test_execute_invalid_batch_" + TestingNames.randomNameSuffix();
        try (Connection connection = this.createConnection("blackhole", "blackhole", explicitPrepare);){
            try (Statement statement = connection.createStatement();){
                statement.execute("CREATE TABLE " + tableName + "(c_int integer)");
            }
            statement = connection.prepareStatement("INSERT INTO " + tableName + " VALUES (?)");
            try {
                statement.setInt(1, 1);
                statement.addBatch();
                String message = "Batch prepared statement must be executed using executeBatch method";
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(((PreparedStatement)statement)::executeQuery).isInstanceOf(SQLException.class)).hasMessage(message);
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(((PreparedStatement)statement)::executeUpdate).isInstanceOf(SQLException.class)).hasMessage(message);
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(((PreparedStatement)statement)::executeLargeUpdate).isInstanceOf(SQLException.class)).hasMessage(message);
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(((PreparedStatement)statement)::execute).isInstanceOf(SQLException.class)).hasMessage(message);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            statement = connection.createStatement();
            try {
                statement.execute("DROP TABLE " + tableName);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    @Test
    public void testPrepareMultiple() throws Exception {
        this.testPrepareMultiple(true);
        this.testPrepareMultiple(false);
    }

    private void testPrepareMultiple(boolean explicitPrepare) throws Exception {
        try (Connection connection = this.createConnection(explicitPrepare);
             PreparedStatement statement1 = connection.prepareStatement("SELECT 123");
             PreparedStatement statement2 = connection.prepareStatement("SELECT 456");){
            try (ResultSet rs = statement1.executeQuery();){
                Assertions.assertThat((boolean)rs.next()).isTrue();
                Assertions.assertThat((long)rs.getLong(1)).isEqualTo(123L);
                Assertions.assertThat((boolean)rs.next()).isFalse();
            }
            rs = statement2.executeQuery();
            try {
                Assertions.assertThat((boolean)rs.next()).isTrue();
                Assertions.assertThat((long)rs.getLong(1)).isEqualTo(456L);
                Assertions.assertThat((boolean)rs.next()).isFalse();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testPrepareLarge() throws Exception {
        this.testPrepareLarge(true);
        this.testPrepareLarge(false);
    }

    private void testPrepareLarge(boolean explicitPrepare) throws Exception {
        String sql = String.format("SELECT '%s' = '%s'", Strings.repeat((String)"x", (int)100000), Strings.repeat((String)"y", (int)100000));
        try (Connection connection = this.createConnection(explicitPrepare);
             PreparedStatement statement = connection.prepareStatement(sql);
             ResultSet rs = statement.executeQuery();){
            Assertions.assertThat((boolean)rs.next()).isTrue();
            Assertions.assertThat((boolean)rs.getBoolean(1)).isFalse();
            Assertions.assertThat((boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void testSetNull() throws Exception {
        this.testSetNull(true);
        this.testSetNull(false);
    }

    private void testSetNull(boolean explicitPrepare) throws Exception {
        this.assertSetNull(16, explicitPrepare);
        this.assertSetNull(-7, 16, explicitPrepare);
        this.assertSetNull(-6, explicitPrepare);
        this.assertSetNull(5, explicitPrepare);
        this.assertSetNull(4, explicitPrepare);
        this.assertSetNull(-5, explicitPrepare);
        this.assertSetNull(7, explicitPrepare);
        this.assertSetNull(6, 7, explicitPrepare);
        this.assertSetNull(3, explicitPrepare);
        this.assertSetNull(2, 3, explicitPrepare);
        this.assertSetNull(1, explicitPrepare);
        this.assertSetNull(-15, 1, explicitPrepare);
        this.assertSetNull(12, 12, explicitPrepare);
        this.assertSetNull(-9, 12, explicitPrepare);
        this.assertSetNull(-1, 12, explicitPrepare);
        this.assertSetNull(12, 12, explicitPrepare);
        this.assertSetNull(2005, 12, explicitPrepare);
        this.assertSetNull(2011, 12, explicitPrepare);
        this.assertSetNull(-3, -3, explicitPrepare);
        this.assertSetNull(-3, explicitPrepare);
        this.assertSetNull(2004, -3, explicitPrepare);
        this.assertSetNull(91, explicitPrepare);
        this.assertSetNull(92, explicitPrepare);
        this.assertSetNull(93, explicitPrepare);
        this.assertSetNull(0, explicitPrepare);
    }

    private void assertSetNull(int sqlType, boolean explicitPrepare) throws SQLException {
        this.assertSetNull(sqlType, sqlType, explicitPrepare);
    }

    private void assertSetNull(int sqlType, int expectedSqlType, boolean explicitPrepare) throws SQLException {
        try (Connection connection = this.createConnection(explicitPrepare);
             PreparedStatement statement = connection.prepareStatement("SELECT ?");){
            statement.setNull(1, sqlType);
            try (ResultSet rs = statement.executeQuery();){
                Assertions.assertThat((boolean)rs.next()).isTrue();
                Assertions.assertThat((Object)rs.getObject(1)).isNull();
                Assertions.assertThat((boolean)rs.wasNull()).isTrue();
                Assertions.assertThat((boolean)rs.next()).isFalse();
                Assertions.assertThat((int)rs.getMetaData().getColumnType(1)).isEqualTo(expectedSqlType);
            }
        }
    }

    @Test
    public void testConvertBoolean() throws SQLException {
        this.testConvertBoolean(true);
        this.testConvertBoolean(false);
    }

    private void testConvertBoolean(boolean explicitPrepare) throws SQLException {
        this.assertBind((ps, i) -> ps.setBoolean(i, true), explicitPrepare).roundTripsAs(16, true);
        this.assertBind((ps, i) -> ps.setBoolean(i, false), explicitPrepare).roundTripsAs(16, false);
        this.assertBind((ps, i) -> ps.setObject(i, true), explicitPrepare).roundTripsAs(16, true);
        this.assertBind((ps, i) -> ps.setObject(i, false), explicitPrepare).roundTripsAs(16, false);
        Iterator iterator = Ints.asList((int[])new int[]{16, -7}).iterator();
        while (iterator.hasNext()) {
            int type = (Integer)iterator.next();
            this.assertBind((ps, i) -> ps.setObject(i, (Object)true, type), explicitPrepare).roundTripsAs(16, true);
            this.assertBind((ps, i) -> ps.setObject(i, (Object)false, type), explicitPrepare).roundTripsAs(16, false);
            this.assertBind((ps, i) -> ps.setObject(i, (Object)13, type), explicitPrepare).roundTripsAs(16, true);
            this.assertBind((ps, i) -> ps.setObject(i, (Object)0, type), explicitPrepare).roundTripsAs(16, false);
            this.assertBind((ps, i) -> ps.setObject(i, (Object)"1", type), explicitPrepare).roundTripsAs(16, true);
            this.assertBind((ps, i) -> ps.setObject(i, (Object)"true", type), explicitPrepare).roundTripsAs(16, true);
            this.assertBind((ps, i) -> ps.setObject(i, (Object)"0", type), explicitPrepare).roundTripsAs(16, false);
            this.assertBind((ps, i) -> ps.setObject(i, (Object)"false", type), explicitPrepare).roundTripsAs(16, false);
        }
    }

    @Test
    public void testConvertTinyint() throws SQLException {
        this.testConvertTinyint(true);
        this.testConvertTinyint(false);
    }

    private void testConvertTinyint(boolean explicitPrepare) throws SQLException {
        this.assertBind((ps, i) -> ps.setByte(i, (byte)123), explicitPrepare).roundTripsAs(-6, (byte)123);
        this.assertBind((ps, i) -> ps.setObject(i, (byte)123), explicitPrepare).roundTripsAs(-6, (byte)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123, -6), explicitPrepare).roundTripsAs(-6, (byte)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123, -6), explicitPrepare).roundTripsAs(-6, (byte)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123, -6), explicitPrepare).roundTripsAs(-6, (byte)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123L, -6), explicitPrepare).roundTripsAs(-6, (byte)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)Float.valueOf(123.9f), -6), explicitPrepare).roundTripsAs(-6, (byte)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123.9, -6), explicitPrepare).roundTripsAs(-6, (byte)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)BigInteger.valueOf(123L), -6), explicitPrepare).roundTripsAs(-6, (byte)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)BigDecimal.valueOf(123L), -6), explicitPrepare).roundTripsAs(-6, (byte)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)BigDecimal.valueOf(123.9), -6), explicitPrepare).roundTripsAs(-6, (byte)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"123", -6), explicitPrepare).roundTripsAs(-6, (byte)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)true, -6), explicitPrepare).roundTripsAs(-6, (byte)1);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)false, -6), explicitPrepare).roundTripsAs(-6, (byte)0);
    }

    @Test
    public void testConvertSmallint() throws SQLException {
        this.testConvertSmallint(true);
        this.testConvertSmallint(false);
    }

    private void testConvertSmallint(boolean explicitPrepare) throws SQLException {
        this.assertBind((ps, i) -> ps.setShort(i, (short)123), explicitPrepare).roundTripsAs(5, (short)123);
        this.assertBind((ps, i) -> ps.setObject(i, (short)123), explicitPrepare).roundTripsAs(5, (short)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123, 5), explicitPrepare).roundTripsAs(5, (short)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123, 5), explicitPrepare).roundTripsAs(5, (short)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123, 5), explicitPrepare).roundTripsAs(5, (short)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123L, 5), explicitPrepare).roundTripsAs(5, (short)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)Float.valueOf(123.9f), 5), explicitPrepare).roundTripsAs(5, (short)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123.9, 5), explicitPrepare).roundTripsAs(5, (short)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)BigInteger.valueOf(123L), 5), explicitPrepare).roundTripsAs(5, (short)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)BigDecimal.valueOf(123L), 5), explicitPrepare).roundTripsAs(5, (short)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)BigDecimal.valueOf(123.9), 5), explicitPrepare).roundTripsAs(5, (short)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"123", 5), explicitPrepare).roundTripsAs(5, (short)123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)true, 5), explicitPrepare).roundTripsAs(5, (short)1);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)false, 5), explicitPrepare).roundTripsAs(5, (short)0);
    }

    @Test
    public void testConvertInteger() throws SQLException {
        this.testConvertInteger(true);
        this.testConvertInteger(false);
    }

    private void testConvertInteger(boolean explicitPrepare) throws SQLException {
        this.assertBind((ps, i) -> ps.setInt(i, 123), explicitPrepare).roundTripsAs(4, 123);
        this.assertBind((ps, i) -> ps.setObject(i, 123), explicitPrepare).roundTripsAs(4, 123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123, 4), explicitPrepare).roundTripsAs(4, 123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123, 4), explicitPrepare).roundTripsAs(4, 123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123, 4), explicitPrepare).roundTripsAs(4, 123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123, 4), explicitPrepare).roundTripsAs(4, 123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123L, 4), explicitPrepare).roundTripsAs(4, 123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)Float.valueOf(123.9f), 4), explicitPrepare).roundTripsAs(4, 123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123.9, 4), explicitPrepare).roundTripsAs(4, 123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)BigInteger.valueOf(123L), 4), explicitPrepare).roundTripsAs(4, 123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)BigDecimal.valueOf(123L), 4), explicitPrepare).roundTripsAs(4, 123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)BigDecimal.valueOf(123.9), 4), explicitPrepare).roundTripsAs(4, 123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"123", 4), explicitPrepare).roundTripsAs(4, 123);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)true, 4), explicitPrepare).roundTripsAs(4, 1);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)false, 4), explicitPrepare).roundTripsAs(4, 0);
    }

    @Test
    public void testConvertBigint() throws SQLException {
        this.testConvertBigint(true);
        this.testConvertBigint(false);
    }

    private void testConvertBigint(boolean explicitPrepare) throws SQLException {
        this.assertBind((ps, i) -> ps.setLong(i, 123L), explicitPrepare).roundTripsAs(-5, 123L);
        this.assertBind((ps, i) -> ps.setObject(i, 123L), explicitPrepare).roundTripsAs(-5, 123L);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123, -5), explicitPrepare).roundTripsAs(-5, 123L);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123, -5), explicitPrepare).roundTripsAs(-5, 123L);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123, -5), explicitPrepare).roundTripsAs(-5, 123L);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123L, -5), explicitPrepare).roundTripsAs(-5, 123L);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)Float.valueOf(123.9f), -5), explicitPrepare).roundTripsAs(-5, 123L);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123.9, -5), explicitPrepare).roundTripsAs(-5, 123L);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)BigInteger.valueOf(123L), -5), explicitPrepare).roundTripsAs(-5, 123L);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)BigDecimal.valueOf(123L), -5), explicitPrepare).roundTripsAs(-5, 123L);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)BigDecimal.valueOf(123.9), -5), explicitPrepare).roundTripsAs(-5, 123L);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"123", -5), explicitPrepare).roundTripsAs(-5, 123L);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)true, -5), explicitPrepare).roundTripsAs(-5, 1L);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)false, -5), explicitPrepare).roundTripsAs(-5, 0L);
    }

    @Test
    public void testConvertReal() throws SQLException {
        this.testConvertReal(true);
        this.testConvertReal(false);
    }

    private void testConvertReal(boolean explicitPrepare) throws SQLException {
        this.assertBind((ps, i) -> ps.setFloat(i, 4.2f), explicitPrepare).roundTripsAs(7, Float.valueOf(4.2f));
        this.assertBind((ps, i) -> ps.setObject(i, Float.valueOf(4.2f)), explicitPrepare).roundTripsAs(7, Float.valueOf(4.2f));
        Iterator iterator = Ints.asList((int[])new int[]{7, 6}).iterator();
        while (iterator.hasNext()) {
            int type = (Integer)iterator.next();
            this.assertBind((ps, i) -> ps.setObject(i, (Object)123, type), explicitPrepare).roundTripsAs(7, Float.valueOf(123.0f));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)123, type), explicitPrepare).roundTripsAs(7, Float.valueOf(123.0f));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)123, type), explicitPrepare).roundTripsAs(7, Float.valueOf(123.0f));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)123L, type), explicitPrepare).roundTripsAs(7, Float.valueOf(123.0f));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)Float.valueOf(123.9f), type), explicitPrepare).roundTripsAs(7, Float.valueOf(123.9f));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)123.9, type), explicitPrepare).roundTripsAs(7, Float.valueOf(123.9f));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)BigInteger.valueOf(123L), type), explicitPrepare).roundTripsAs(7, Float.valueOf(123.0f));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)BigDecimal.valueOf(123L), type), explicitPrepare).roundTripsAs(7, Float.valueOf(123.0f));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)BigDecimal.valueOf(123.9), type), explicitPrepare).roundTripsAs(7, Float.valueOf(123.9f));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)"4.2", type), explicitPrepare).roundTripsAs(7, Float.valueOf(4.2f));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)true, type), explicitPrepare).roundTripsAs(7, Float.valueOf(1.0f));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)false, type), explicitPrepare).roundTripsAs(7, Float.valueOf(0.0f));
        }
    }

    @Test
    public void testConvertDouble() throws SQLException {
        this.testConvertDouble(true);
        this.testConvertDouble(false);
    }

    private void testConvertDouble(boolean explicitPrepare) throws SQLException {
        this.assertBind((ps, i) -> ps.setDouble(i, 4.2), explicitPrepare).roundTripsAs(8, 4.2);
        this.assertBind((ps, i) -> ps.setObject(i, 4.2), explicitPrepare).roundTripsAs(8, 4.2);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123, 8), explicitPrepare).roundTripsAs(8, 123.0);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123, 8), explicitPrepare).roundTripsAs(8, 123.0);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123, 8), explicitPrepare).roundTripsAs(8, 123.0);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123L, 8), explicitPrepare).roundTripsAs(8, 123.0);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)Float.valueOf(123.9f), 8), explicitPrepare).roundTripsAs(8, 123.9f);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)123.9, 8), explicitPrepare).roundTripsAs(8, 123.9);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)BigInteger.valueOf(123L), 8), explicitPrepare).roundTripsAs(8, 123.0);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)BigDecimal.valueOf(123L), 8), explicitPrepare).roundTripsAs(8, 123.0);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)BigDecimal.valueOf(123.9), 8), explicitPrepare).roundTripsAs(8, 123.9);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"4.2", 8), explicitPrepare).roundTripsAs(8, 4.2);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)true, 8), explicitPrepare).roundTripsAs(8, 1.0);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)false, 8), explicitPrepare).roundTripsAs(8, 0.0);
    }

    @Test
    public void testConvertDecimal() throws SQLException {
        this.testConvertDecimal(true);
        this.testConvertDecimal(false);
    }

    private void testConvertDecimal(boolean explicitPrepare) throws SQLException {
        this.assertBind((ps, i) -> ps.setBigDecimal(i, BigDecimal.valueOf(123L)), explicitPrepare).roundTripsAs(3, BigDecimal.valueOf(123L));
        this.assertBind((ps, i) -> ps.setObject(i, BigDecimal.valueOf(123L)), explicitPrepare).roundTripsAs(3, BigDecimal.valueOf(123L));
        Iterator iterator = Ints.asList((int[])new int[]{3, 2}).iterator();
        while (iterator.hasNext()) {
            int type = (Integer)iterator.next();
            this.assertBind((ps, i) -> ps.setObject(i, (Object)123, type), explicitPrepare).roundTripsAs(3, BigDecimal.valueOf(123L));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)123, type), explicitPrepare).roundTripsAs(3, BigDecimal.valueOf(123L));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)123, type), explicitPrepare).roundTripsAs(3, BigDecimal.valueOf(123L));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)123L, type), explicitPrepare).roundTripsAs(3, BigDecimal.valueOf(123L));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)Float.valueOf(123.9f), type), explicitPrepare).roundTripsAs(3, BigDecimal.valueOf(123.9f));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)123.9, type), explicitPrepare).roundTripsAs(3, BigDecimal.valueOf(123.9));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)BigInteger.valueOf(123L), type), explicitPrepare).roundTripsAs(3, BigDecimal.valueOf(123L));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)BigDecimal.valueOf(123L), type), explicitPrepare).roundTripsAs(3, BigDecimal.valueOf(123L));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)BigDecimal.valueOf(123.9), type), explicitPrepare).roundTripsAs(3, BigDecimal.valueOf(123.9));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)"123", type), explicitPrepare).roundTripsAs(3, BigDecimal.valueOf(123L));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)true, type), explicitPrepare).roundTripsAs(3, BigDecimal.valueOf(1L));
            this.assertBind((ps, i) -> ps.setObject(i, (Object)false, type), explicitPrepare).roundTripsAs(3, BigDecimal.valueOf(0L));
        }
    }

    @Test
    public void testConvertVarchar() throws SQLException {
        this.testConvertVarchar(true);
        this.testConvertVarchar(false);
    }

    private void testConvertVarchar(boolean explicitPrepare) throws SQLException {
        this.assertBind((ps, i) -> ps.setString(i, "hello"), explicitPrepare).roundTripsAs(12, "hello");
        this.assertBind((ps, i) -> ps.setObject(i, "hello"), explicitPrepare).roundTripsAs(12, "hello");
        String unicodeAndNull = "abc'xyz\u0000\u2603\ud835\udcabtest";
        this.assertBind((ps, i) -> ps.setString(i, unicodeAndNull), explicitPrepare).roundTripsAs(12, unicodeAndNull);
        Iterator iterator = Ints.asList((int[])new int[]{1, -15, 12, -9, -1, -16}).iterator();
        while (iterator.hasNext()) {
            int type = (Integer)iterator.next();
            this.assertBind((ps, i) -> ps.setObject(i, (Object)123, type), explicitPrepare).roundTripsAs(12, "123");
            this.assertBind((ps, i) -> ps.setObject(i, (Object)123, type), explicitPrepare).roundTripsAs(12, "123");
            this.assertBind((ps, i) -> ps.setObject(i, (Object)123, type), explicitPrepare).roundTripsAs(12, "123");
            this.assertBind((ps, i) -> ps.setObject(i, (Object)123, type), explicitPrepare).roundTripsAs(12, "123");
            this.assertBind((ps, i) -> ps.setObject(i, (Object)123L, type), explicitPrepare).roundTripsAs(12, "123");
            this.assertBind((ps, i) -> ps.setObject(i, (Object)Float.valueOf(123.9f), type), explicitPrepare).roundTripsAs(12, "123.9");
            this.assertBind((ps, i) -> ps.setObject(i, (Object)123.9, type), explicitPrepare).roundTripsAs(12, "123.9");
            this.assertBind((ps, i) -> ps.setObject(i, (Object)BigInteger.valueOf(123L), type), explicitPrepare).roundTripsAs(12, "123");
            this.assertBind((ps, i) -> ps.setObject(i, (Object)BigDecimal.valueOf(123L), type), explicitPrepare).roundTripsAs(12, "123");
            this.assertBind((ps, i) -> ps.setObject(i, (Object)BigDecimal.valueOf(123.9), type), explicitPrepare).roundTripsAs(12, "123.9");
            this.assertBind((ps, i) -> ps.setObject(i, (Object)"hello", type), explicitPrepare).roundTripsAs(12, "hello");
            this.assertBind((ps, i) -> ps.setObject(i, (Object)true, type), explicitPrepare).roundTripsAs(12, "true");
            this.assertBind((ps, i) -> ps.setObject(i, (Object)false, type), explicitPrepare).roundTripsAs(12, "false");
        }
    }

    @Test
    public void testConvertVarbinary() throws SQLException {
        this.testConvertVarbinary(true);
        this.testConvertVarbinary(false);
    }

    private void testConvertVarbinary(boolean explicitPrepare) throws SQLException {
        String value = "abc\u0000xyz";
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.assertBind((ps, i) -> ps.setBytes(i, bytes), explicitPrepare).roundTripsAs(-3, bytes);
        this.assertBind((ps, i) -> ps.setObject(i, bytes), explicitPrepare).roundTripsAs(-3, bytes);
        Iterator iterator = Ints.asList((int[])new int[]{-2, -3, -4}).iterator();
        while (iterator.hasNext()) {
            int type = (Integer)iterator.next();
            this.assertBind((ps, i) -> ps.setObject(i, (Object)bytes, type), explicitPrepare).roundTripsAs(-3, bytes);
            this.assertBind((ps, i) -> ps.setObject(i, (Object)value, type), explicitPrepare).roundTripsAs(-3, bytes);
        }
    }

    @Test
    public void testConvertDate() throws SQLException {
        this.testConvertDate(true);
        this.testConvertDate(false);
    }

    private void testConvertDate(boolean explicitPrepare) throws SQLException {
        LocalDate date = LocalDate.of(2001, 5, 6);
        Date sqlDate = Date.valueOf(date);
        java.util.Date javaDate = new java.util.Date(sqlDate.getTime());
        LocalDateTime dateTime = LocalDateTime.of(date, LocalTime.of(12, 34, 56));
        Timestamp sqlTimestamp = Timestamp.valueOf(dateTime);
        this.assertBind((ps, i) -> ps.setDate(i, sqlDate), explicitPrepare).resultsIn("date", "DATE '2001-05-06'").roundTripsAs(91, sqlDate);
        this.assertBind((ps, i) -> ps.setObject(i, sqlDate), explicitPrepare).resultsIn("date", "DATE '2001-05-06'").roundTripsAs(91, sqlDate);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)sqlDate, 91), explicitPrepare).resultsIn("date", "DATE '2001-05-06'").roundTripsAs(91, sqlDate);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)sqlTimestamp, 91), explicitPrepare).resultsIn("date", "DATE '2001-05-06'").roundTripsAs(91, sqlDate);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)javaDate, 91), explicitPrepare).resultsIn("date", "DATE '2001-05-06'").roundTripsAs(91, sqlDate);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)date, 91), explicitPrepare).resultsIn("date", "DATE '2001-05-06'").roundTripsAs(91, sqlDate);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)dateTime, 91), explicitPrepare).resultsIn("date", "DATE '2001-05-06'").roundTripsAs(91, sqlDate);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"2001-05-06", 91), explicitPrepare).resultsIn("date", "DATE '2001-05-06'").roundTripsAs(91, sqlDate);
    }

    @Test
    public void testConvertLocalDate() throws SQLException {
        this.testConvertLocalDate(true);
        this.testConvertLocalDate(false);
    }

    private void testConvertLocalDate(boolean explicitPrepare) throws SQLException {
        LocalDate date = LocalDate.of(2001, 5, 6);
        this.assertBind((ps, i) -> ps.setObject(i, date), explicitPrepare).resultsIn("date", "DATE '2001-05-06'").roundTripsAs(91, Date.valueOf(date));
        this.assertBind((ps, i) -> ps.setObject(i, (Object)date, 91), explicitPrepare).resultsIn("date", "DATE '2001-05-06'").roundTripsAs(91, Date.valueOf(date));
        this.assertBind((ps, i) -> ps.setObject(i, (Object)date, 92), explicitPrepare).isInvalid("Cannot convert instance of java.time.LocalDate to time");
        this.assertBind((ps, i) -> ps.setObject(i, (Object)date, 2013), explicitPrepare).isInvalid("Cannot convert instance of java.time.LocalDate to time with time zone");
        this.assertBind((ps, i) -> ps.setObject(i, (Object)date, 93), explicitPrepare).isInvalid("Cannot convert instance of java.time.LocalDate to timestamp");
        this.assertBind((ps, i) -> ps.setObject(i, (Object)date, 2014), explicitPrepare).isInvalid("Cannot convert instance of java.time.LocalDate to timestamp with time zone");
        LocalDate jvmGapDate = LocalDate.of(1970, 1, 1);
        TestJdbcPreparedStatement.checkIsGap(ZoneId.systemDefault(), jvmGapDate.atTime(LocalTime.MIDNIGHT));
        this.assertBind((ps, i) -> ps.setObject(i, jvmGapDate), explicitPrepare).resultsIn("date", "DATE '1970-01-01'").roundTripsAs(91, Date.valueOf(jvmGapDate));
        this.assertBind((ps, i) -> ps.setObject(i, (Object)jvmGapDate, 91), explicitPrepare).roundTripsAs(91, Date.valueOf(jvmGapDate));
    }

    @Test
    public void testConvertTime() throws SQLException {
        this.testConvertTime(true);
        this.testConvertTime(false);
    }

    private void testConvertTime(boolean explicitPrepare) throws SQLException {
        LocalTime time = LocalTime.of(12, 34, 56);
        Time sqlTime = Time.valueOf(time);
        java.util.Date javaDate = new java.util.Date(sqlTime.getTime());
        LocalDateTime dateTime = LocalDateTime.of(LocalDate.of(2001, 5, 6), time);
        Timestamp sqlTimestamp = Timestamp.valueOf(dateTime);
        this.assertBind((ps, i) -> ps.setTime(i, sqlTime), explicitPrepare).resultsIn("time(3)", "TIME '12:34:56.000'").roundTripsAs(92, sqlTime);
        this.assertBind((ps, i) -> ps.setObject(i, sqlTime), explicitPrepare).resultsIn("time(3)", "TIME '12:34:56.000'").roundTripsAs(92, sqlTime);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)sqlTime, 92), explicitPrepare).resultsIn("time(3)", "TIME '12:34:56.000'").roundTripsAs(92, sqlTime);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)sqlTimestamp, 92), explicitPrepare).resultsIn("time(3)", "TIME '12:34:56.000'").roundTripsAs(92, sqlTime);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)javaDate, 92), explicitPrepare).resultsIn("time(3)", "TIME '12:34:56.000'").roundTripsAs(92, sqlTime);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)dateTime, 92), explicitPrepare).resultsIn("time(0)", "TIME '12:34:56'").roundTripsAs(92, sqlTime);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"12:34:56", 92), explicitPrepare).resultsIn("time(0)", "TIME '12:34:56'").roundTripsAs(92, sqlTime);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"12:34:56.123", 92), explicitPrepare).resultsIn("time(3)", "TIME '12:34:56.123'");
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"12:34:56.123456", 92), explicitPrepare).resultsIn("time(6)", "TIME '12:34:56.123456'");
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"12:34:56.123456789", 92), explicitPrepare).resultsIn("time(9)", "TIME '12:34:56.123456789'");
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"12:34:56.123456789012", 92), explicitPrepare).resultsIn("time(12)", "TIME '12:34:56.123456789012'");
        Time timeWithDecisecond = new Time(sqlTime.getTime() + 100L);
        this.assertBind((ps, i) -> ps.setObject(i, timeWithDecisecond), explicitPrepare).resultsIn("time(3)", "TIME '12:34:56.100'").roundTripsAs(92, timeWithDecisecond);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)timeWithDecisecond, 92), explicitPrepare).resultsIn("time(3)", "TIME '12:34:56.100'").roundTripsAs(92, timeWithDecisecond);
        Time timeWithMillisecond = new Time(sqlTime.getTime() + 123L);
        this.assertBind((ps, i) -> ps.setObject(i, timeWithMillisecond), explicitPrepare).resultsIn("time(3)", "TIME '12:34:56.123'").roundTripsAs(92, timeWithMillisecond);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)timeWithMillisecond, 92), explicitPrepare).resultsIn("time(3)", "TIME '12:34:56.123'").roundTripsAs(92, timeWithMillisecond);
    }

    @Test
    public void testConvertTimeWithTimeZone() throws SQLException {
        this.testConvertTimeWithTimeZone(true);
        this.testConvertTimeWithTimeZone(false);
    }

    private void testConvertTimeWithTimeZone(boolean explicitPrepare) throws SQLException {
        this.assertBind((ps, i) -> ps.setObject(i, (Object)OffsetTime.of(12, 34, 56, 0, ZoneOffset.UTC), 2013), explicitPrepare).resultsIn("time(0) with time zone", "TIME '12:34:56+00:00'").roundTripsAs(2013, BaseTestJdbcResultSet.toSqlTime(LocalTime.of(5, 34, 56)));
        this.assertBind((ps, i) -> ps.setObject(i, OffsetTime.of(12, 34, 56, 0, ZoneOffset.UTC)), explicitPrepare).resultsIn("time(0) with time zone", "TIME '12:34:56+00:00'");
        this.assertBind((ps, i) -> ps.setObject(i, (Object)OffsetTime.of(12, 34, 56, 0, ZoneOffset.UTC), JDBCType.TIME_WITH_TIMEZONE), explicitPrepare).resultsIn("time(0) with time zone", "TIME '12:34:56+00:00'");
        this.assertBind((ps, i) -> ps.setObject(i, (Object)OffsetTime.of(12, 34, 56, 555000000, ZoneOffset.UTC), 2013), explicitPrepare).resultsIn("time(3) with time zone", "TIME '12:34:56.555+00:00'").roundTripsAs(2013, BaseTestJdbcResultSet.toSqlTime(LocalTime.of(5, 34, 56, 555000000)));
        this.assertBind((ps, i) -> ps.setObject(i, (Object)OffsetTime.of(12, 34, 56, 555555000, ZoneOffset.UTC), 2013), explicitPrepare).resultsIn("time(6) with time zone", "TIME '12:34:56.555555+00:00'").roundTripsAs(2013, BaseTestJdbcResultSet.toSqlTime(LocalTime.of(5, 34, 56, 556000000)));
        this.assertBind((ps, i) -> ps.setObject(i, (Object)OffsetTime.of(12, 34, 56, 555555555, ZoneOffset.UTC), 2013), explicitPrepare).resultsIn("time(9) with time zone", "TIME '12:34:56.555555555+00:00'").roundTripsAs(2013, BaseTestJdbcResultSet.toSqlTime(LocalTime.of(5, 34, 56, 556000000)));
        this.assertBind((ps, i) -> ps.setObject(i, (Object)OffsetTime.of(12, 34, 56, 123456789, ZoneOffset.ofHoursMinutes(7, 35)), 2013), explicitPrepare).resultsIn("time(9) with time zone", "TIME '12:34:56.123456789+07:35'");
        this.assertBind((ps, i) -> ps.setObject(i, (Object)OffsetTime.of(12, 34, 56, 123456789, ZoneOffset.ofHoursMinutes(-7, -35)), 2013), explicitPrepare).resultsIn("time(9) with time zone", "TIME '12:34:56.123456789-07:35'").roundTripsAs(2013, BaseTestJdbcResultSet.toSqlTime(LocalTime.of(13, 9, 56, 123000000)));
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"12:34:56.123 +05:45", 2013), explicitPrepare).resultsIn("time(3) with time zone", "TIME '12:34:56.123 +05:45'");
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"12:34:56.123456 +05:45", 2013), explicitPrepare).resultsIn("time(6) with time zone", "TIME '12:34:56.123456 +05:45'");
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"12:34:56.123456789 +05:45", 2013), explicitPrepare).resultsIn("time(9) with time zone", "TIME '12:34:56.123456789 +05:45'");
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"12:34:56.123456789012 +05:45", 2013), explicitPrepare).resultsIn("time(12) with time zone", "TIME '12:34:56.123456789012 +05:45'");
    }

    @Test
    public void testConvertTimestamp() throws SQLException {
        this.testConvertTimestamp(true);
        this.testConvertTimestamp(false);
    }

    private void testConvertTimestamp(boolean explicitPrepare) throws SQLException {
        LocalDateTime dateTime = LocalDateTime.of(2001, 5, 6, 12, 34, 56);
        Date sqlDate = Date.valueOf(dateTime.toLocalDate());
        Time sqlTime = Time.valueOf(dateTime.toLocalTime());
        Timestamp sqlTimestamp = Timestamp.valueOf(dateTime);
        Timestamp sameInstantInWarsawZone = Timestamp.valueOf(dateTime.atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneId.of("Europe/Warsaw")).toLocalDateTime());
        java.util.Date javaDate = java.util.Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
        this.assertBind((ps, i) -> ps.setTimestamp(i, sqlTimestamp), explicitPrepare).resultsIn("timestamp(3)", "TIMESTAMP '2001-05-06 12:34:56.000'").roundTripsAs(93, sqlTimestamp);
        this.assertBind((ps, i) -> ps.setTimestamp(i, sqlTimestamp, null), explicitPrepare).resultsIn("timestamp(3)", "TIMESTAMP '2001-05-06 12:34:56.000'").roundTripsAs(93, sqlTimestamp);
        this.assertBind((ps, i) -> ps.setTimestamp(i, sqlTimestamp, Calendar.getInstance()), explicitPrepare).resultsIn("timestamp(3)", "TIMESTAMP '2001-05-06 12:34:56.000'").roundTripsAs(93, sqlTimestamp);
        this.assertBind((ps, i) -> ps.setTimestamp(i, sqlTimestamp, Calendar.getInstance(TimeZone.getTimeZone(ZoneId.of("Europe/Warsaw")))), explicitPrepare).resultsIn("timestamp(3)", "TIMESTAMP '2001-05-06 20:34:56.000'").roundTripsAs(93, sameInstantInWarsawZone);
        this.assertBind((ps, i) -> ps.setObject(i, sqlTimestamp), explicitPrepare).resultsIn("timestamp(3)", "TIMESTAMP '2001-05-06 12:34:56.000'").roundTripsAs(93, sqlTimestamp);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)sqlDate, 93), explicitPrepare).resultsIn("timestamp(3)", "TIMESTAMP '2001-05-06 00:00:00.000'").roundTripsAs(93, new Timestamp(sqlDate.getTime()));
        this.assertBind((ps, i) -> ps.setObject(i, (Object)sqlTime, 93), explicitPrepare).resultsIn("timestamp(3)", "TIMESTAMP '1970-01-01 12:34:56.000'").roundTripsAs(93, new Timestamp(sqlTime.getTime()));
        this.assertBind((ps, i) -> ps.setObject(i, (Object)sqlTimestamp, 93), explicitPrepare).resultsIn("timestamp(3)", "TIMESTAMP '2001-05-06 12:34:56.000'").roundTripsAs(93, sqlTimestamp);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)javaDate, 93), explicitPrepare).resultsIn("timestamp(3)", "TIMESTAMP '2001-05-06 12:34:56.000'").roundTripsAs(93, sqlTimestamp);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)dateTime, 93), explicitPrepare).resultsIn("timestamp(0)", "TIMESTAMP '2001-05-06 12:34:56'").roundTripsAs(93, sqlTimestamp);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"2001-05-06 12:34:56", 93), explicitPrepare).resultsIn("timestamp(0)", "TIMESTAMP '2001-05-06 12:34:56'").roundTripsAs(93, sqlTimestamp);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"2001-05-06 12:34:56.123", 93), explicitPrepare).resultsIn("timestamp(3)", "TIMESTAMP '2001-05-06 12:34:56.123'");
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"2001-05-06 12:34:56.123456", 93), explicitPrepare).resultsIn("timestamp(6)", "TIMESTAMP '2001-05-06 12:34:56.123456'");
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"2001-05-06 12:34:56.123456789", 93), explicitPrepare).resultsIn("timestamp(9)", "TIMESTAMP '2001-05-06 12:34:56.123456789'");
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"2001-05-06 12:34:56.123456789012", 93), explicitPrepare).resultsIn("timestamp(12)", "TIMESTAMP '2001-05-06 12:34:56.123456789012'");
        Timestamp timestampWithWithDecisecond = new Timestamp(sqlTimestamp.getTime() + 100L);
        this.assertBind((ps, i) -> ps.setTimestamp(i, timestampWithWithDecisecond), explicitPrepare).resultsIn("timestamp(3)", "TIMESTAMP '2001-05-06 12:34:56.100'").roundTripsAs(93, timestampWithWithDecisecond);
        this.assertBind((ps, i) -> ps.setObject(i, timestampWithWithDecisecond), explicitPrepare).resultsIn("timestamp(3)", "TIMESTAMP '2001-05-06 12:34:56.100'").roundTripsAs(93, timestampWithWithDecisecond);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)timestampWithWithDecisecond, 93), explicitPrepare).resultsIn("timestamp(3)", "TIMESTAMP '2001-05-06 12:34:56.100'").roundTripsAs(93, timestampWithWithDecisecond);
        Timestamp timestampWithMillisecond = new Timestamp(sqlTimestamp.getTime() + 123L);
        this.assertBind((ps, i) -> ps.setTimestamp(i, timestampWithMillisecond), explicitPrepare).resultsIn("timestamp(3)", "TIMESTAMP '2001-05-06 12:34:56.123'").roundTripsAs(93, timestampWithMillisecond);
        this.assertBind((ps, i) -> ps.setObject(i, timestampWithMillisecond), explicitPrepare).resultsIn("timestamp(3)", "TIMESTAMP '2001-05-06 12:34:56.123'").roundTripsAs(93, timestampWithMillisecond);
        this.assertBind((ps, i) -> ps.setObject(i, (Object)timestampWithMillisecond, 93), explicitPrepare).resultsIn("timestamp(3)", "TIMESTAMP '2001-05-06 12:34:56.123'").roundTripsAs(93, timestampWithMillisecond);
    }

    @Test
    public void testConvertTimestampWithTimeZone() throws SQLException {
        this.testConvertTimestampWithTimeZone(true);
        this.testConvertTimestampWithTimeZone(false);
    }

    private void testConvertTimestampWithTimeZone(boolean explicitPrepare) throws SQLException {
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"1970-01-01 12:34:56.123 +05:45", 2014), explicitPrepare).resultsIn("timestamp(3) with time zone", "TIMESTAMP '1970-01-01 12:34:56.123 +05:45'");
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"1970-01-01 12:34:56.123456 +05:45", 2014), explicitPrepare).resultsIn("timestamp(6) with time zone", "TIMESTAMP '1970-01-01 12:34:56.123456 +05:45'");
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"1970-01-01 12:34:56.123456789 +05:45", 2014), explicitPrepare).resultsIn("timestamp(9) with time zone", "TIMESTAMP '1970-01-01 12:34:56.123456789 +05:45'");
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"1970-01-01 12:34:56.123456789012 +05:45", 2014), explicitPrepare).resultsIn("timestamp(12) with time zone", "TIMESTAMP '1970-01-01 12:34:56.123456789012 +05:45'");
    }

    @Test
    public void testInvalidConversions() throws SQLException {
        this.testInvalidConversions(true);
        this.testInvalidConversions(false);
    }

    private void testInvalidConversions(boolean explicitPrepare) throws SQLException {
        this.assertBind((ps, i) -> ps.setObject(i, String.class), explicitPrepare).isInvalid("Unsupported object type: java.lang.Class");
        this.assertBind((ps, i) -> ps.setObject(i, String.class, -5), explicitPrepare).isInvalid("Cannot convert instance of java.lang.Class to SQL type -5");
        this.assertBind((ps, i) -> ps.setObject(i, (Object)"abc", 5), explicitPrepare).isInvalid("Cannot convert instance of java.lang.String to SQL type 5");
    }

    @Test
    public void testExplicitPrepare() throws Exception {
        this.testExplicitPrepareSetting(true, "EXECUTE %statement% USING %values%");
    }

    @Test
    public void testExecuteImmediate() throws Exception {
        this.testExplicitPrepareSetting(false, "EXECUTE IMMEDIATE '%query%' USING %values%");
    }

    private BindAssertion assertBind(Binder binder, boolean explicitPrepare) {
        return new BindAssertion(() -> this.createConnection(explicitPrepare), binder);
    }

    private Connection createConnection(boolean explicitPrepare) throws SQLException {
        String url = String.format("jdbc:trino://%s?explicitPrepare=" + explicitPrepare, this.server.getAddress());
        return DriverManager.getConnection(url, "test", null);
    }

    private Connection createConnection(String catalog, String schema, boolean explicitPrepare) throws SQLException {
        String url = String.format("jdbc:trino://%s/%s/%s?explicitPrepare=" + explicitPrepare, this.server.getAddress(), catalog, schema);
        return DriverManager.getConnection(url, "test", null);
    }

    private void testExplicitPrepareSetting(boolean explicitPrepare, String expectedSql) throws Exception {
        String tableName = "test_table_" + TestingNames.randomNameSuffix();
        String selectSql = "SELECT * FROM blackhole.blackhole." + tableName + " WHERE x = ? AND y = ? AND y <> 'Test'";
        String insertSql = "INSERT INTO blackhole.blackhole." + tableName + " (x, y) VALUES (?, ?)";
        try (Connection connection = this.createConnection(explicitPrepare);){
            try (Statement statement = connection.createStatement();){
                Assertions.assertThat((int)statement.executeUpdate("CREATE TABLE blackhole.blackhole." + tableName + " (x bigint, y varchar)")).isEqualTo(0);
            }
            try (PreparedStatement ps = connection.prepareStatement(selectSql);){
                ps.setInt(1, 42);
                ps.setString(2, "value1's");
                ps.executeQuery();
                this.checkSQLExecuted(connection, expectedSql.replace("%statement%", "statement1").replace("%query%", selectSql.replace("'", "''")).replace("%values%", "INTEGER '42', 'value1''s'"));
            }
            ps = connection.prepareStatement(selectSql);
            try {
                ps.setInt(1, 42);
                ps.setString(2, "value1's");
                ps.execute();
                this.checkSQLExecuted(connection, expectedSql.replace("%statement%", "statement2").replace("%query%", selectSql.replace("'", "''")).replace("%values%", "INTEGER '42', 'value1''s'"));
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = connection.prepareStatement(insertSql);
            try {
                ps.setInt(1, 42);
                ps.setString(2, "value1's");
                ps.executeLargeUpdate();
                this.checkSQLExecuted(connection, expectedSql.replace("%statement%", "statement3").replace("%query%", insertSql.replace("'", "''")).replace("%values%", "INTEGER '42', 'value1''s'"));
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = connection.prepareStatement(insertSql);
            try {
                ps.setInt(1, 42);
                ps.setString(2, "value1's");
                ps.addBatch();
                ps.setInt(1, 43);
                ps.setString(2, "value2's");
                ps.addBatch();
                ps.executeBatch();
                String statement4 = expectedSql.replace("%statement%", "statement4").replace("%query%", insertSql.replace("'", "''"));
                this.checkSQLExecuted(connection, statement4.replace("%values%", "INTEGER '42', 'value1''s'"));
                this.checkSQLExecuted(connection, statement4.replace("%values%", "INTEGER '43', 'value2''s'"));
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            statement = connection.createStatement();
            try {
                Assertions.assertThat((int)statement.executeUpdate("DROP TABLE blackhole.blackhole." + tableName)).isEqualTo(0);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    private void checkSQLExecuted(Connection connection, String expectedSql) {
        String sql = String.format("SELECT state FROM system.runtime.queries WHERE query = '%s'", expectedSql.replace("'", "''"));
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(sql);){
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)resultSet.next()).describedAs("Cannot find SQL query " + expectedSql, new Object[0])).isTrue();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static void checkIsGap(ZoneId zone, LocalDateTime dateTime) {
        Verify.verify((boolean)TestJdbcPreparedStatement.isGap(zone, dateTime), (String)"Expected %s to be a gap in %s", (Object)dateTime, (Object)zone);
    }

    private static boolean isGap(ZoneId zone, LocalDateTime dateTime) {
        return zone.getRules().getValidOffsets(dateTime).isEmpty();
    }

    private static interface Binder {
        public void bind(PreparedStatement var1, int var2) throws SQLException;
    }

    private static class BindAssertion {
        private final ConnectionFactory connectionFactory;
        private final Binder binder;

        public BindAssertion(ConnectionFactory connectionFactory, Binder binder) {
            this.connectionFactory = Objects.requireNonNull(connectionFactory, "connectionFactory is null");
            this.binder = Objects.requireNonNull(binder, "binder is null");
        }

        public BindAssertion isInvalid(String expectedMessage) throws SQLException {
            try (Connection connection = this.connectionFactory.createConnection();
                 PreparedStatement statement = connection.prepareStatement("SELECT ?");){
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.binder.bind(statement, 1)).isInstanceOf(SQLException.class)).hasMessage(expectedMessage);
            }
            return this;
        }

        public BindAssertion roundTripsAs(int expectedSqlType, Object expectedValue) throws SQLException {
            try (Connection connection = this.connectionFactory.createConnection();
                 PreparedStatement statement = connection.prepareStatement("SELECT ?");){
                this.binder.bind(statement, 1);
                try (ResultSet rs = statement.executeQuery();){
                    Verify.verify((boolean)rs.next(), (String)"no row returned", (Object[])new Object[0]);
                    Assertions.assertThat((Object)rs.getObject(1)).isEqualTo(expectedValue);
                    Verify.verify((!rs.next() ? 1 : 0) != 0, (String)"unexpected second row", (Object[])new Object[0]);
                    Assertions.assertThat((int)rs.getMetaData().getColumnType(1)).isEqualTo(expectedSqlType);
                }
            }
            return this;
        }

        public BindAssertion resultsIn(String type, String expectedValueLiteral) throws SQLException {
            String sql = "SELECT   typeof(bound) type_of_bind,   bound,   CAST(bound AS varchar) bound_as_varchar,   typeof(literal) type_of_literal,   literal,   CAST(literal AS varchar) literal_as_varchar,   bound = literal are_equal FROM (VALUES (?, " + expectedValueLiteral + ")) t(bound, literal)";
            try (Connection connection = this.connectionFactory.createConnection();
                 PreparedStatement statement = connection.prepareStatement(sql);){
                this.binder.bind(statement, 1);
                try (ResultSet rs = statement.executeQuery();){
                    Verify.verify((boolean)rs.next(), (String)"no row returned", (Object[])new Object[0]);
                    ((AbstractStringAssert)Assertions.assertThat((String)rs.getString("type_of_bind")).as("type_of_bind", new Object[0])).isEqualTo(type);
                    ((AbstractStringAssert)Assertions.assertThat((String)rs.getString("type_of_literal")).as("type_of_literal (sanity check)", new Object[0])).isEqualTo(type);
                    ((AbstractStringAssert)Assertions.assertThat((String)rs.getString("bound_as_varchar")).as("bound should cast to VARCHAR the same way as literal " + expectedValueLiteral, new Object[0])).isEqualTo(rs.getString("literal_as_varchar"));
                    ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("are_equal")).as("Expected bound value to be equal to " + expectedValueLiteral, new Object[0])).isEqualTo((Object)true);
                    Verify.verify((!rs.next() ? 1 : 0) != 0, (String)"unexpected second row", (Object[])new Object[0]);
                }
            }
            return this;
        }
    }

    private static interface ConnectionFactory {
        public Connection createConnection() throws SQLException;
    }
}

