/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logging;
import io.airlift.testing.Closeables;
import io.trino.jdbc.TestJdbcConnection;
import io.trino.plugin.blackhole.BlackHolePlugin;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.Plugin;
import io.trino.testing.assertions.Assert;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestJdbcStatement {
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)this.getClass().getName()));
    private TestingTrinoServer server;

    @BeforeAll
    public void setupServer() throws Exception {
        Logging.initialize();
        this.server = TestingTrinoServer.create();
        this.server.installPlugin((Plugin)new BlackHolePlugin());
        this.server.createCatalog("blackhole", "blackhole", (Map)ImmutableMap.of());
        try (Connection connection = this.createConnection();
             Statement statement = connection.createStatement();){
            statement.execute("CREATE TABLE blackhole.default.devzero(dummy bigint) WITH (split_count = 100000, pages_per_split = 100000, rows_per_page = 10000)");
            statement.execute("CREATE TABLE blackhole.default.delay(dummy bigint) WITH (split_count = 1, pages_per_split = 1, rows_per_page = 1, page_processing_delay = '60s')");
        }
    }

    @AfterAll
    public void tearDown() throws Exception {
        Closeable[] closeableArray = new Closeable[2];
        closeableArray[0] = this.server;
        closeableArray[1] = this.executor::shutdownNow;
        Closeables.closeAll((Closeable[])closeableArray);
        this.server = null;
    }

    @Test
    @Timeout(value=60L)
    public void testCancellationOnStatementClose() throws Exception {
        String sql = "SELECT * FROM blackhole.default.devzero -- test cancellation " + UUID.randomUUID();
        try (Connection connection = this.createConnection();){
            Statement statement = connection.createStatement();
            statement.execute(sql);
            ResultSet resultSet = statement.getResultSet();
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
            ((ListAssert)Assertions.assertThat(this.listQueryStatuses(sql)).containsExactly((Object[])new String[]{"RUNNING"})).hasSize(1);
            statement.close();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(resultSet::next).isInstanceOf(SQLException.class)).hasMessage("ResultSet is closed");
            ((ListAssert)Assertions.assertThat(this.listQueryErrorCodes(sql)).containsExactly((Object[])new String[]{"USER_CANCELED"})).hasSize(1);
        }
    }

    @Test
    @Timeout(value=60L)
    public void testConcurrentCancellationOnStatementClose() throws Exception {
        String sql = "SELECT * FROM blackhole.default.delay -- test cancellation " + UUID.randomUUID();
        try (Connection connection = this.createConnection();){
            Statement statement = connection.createStatement();
            Future<Object> future = this.executor.submit(() -> {
                try (ResultSet resultSet = statement.executeQuery(sql);){
                    while (resultSet.next()) {
                    }
                }
                return null;
            });
            Assert.assertEventually(() -> {
                TestJdbcConnection.assertThatFutureIsBlocked(future);
                ((ListAssert)Assertions.assertThat(this.listQueryStatuses(sql)).contains((Object[])new String[]{"RUNNING"})).hasSize(1);
            });
            statement.close();
            Assertions.assertThatThrownBy(future::get).isNotNull();
            ((ListAssert)Assertions.assertThat(this.listQueryErrorCodes(sql)).allMatch(errorCode -> "TRANSACTION_ALREADY_ABORTED".equals(errorCode) || "USER_CANCELED".equals(errorCode))).hasSize(1);
        }
    }

    private Connection createConnection() throws SQLException {
        String url = String.format("jdbc:trino://%s/", this.server.getAddress());
        return DriverManager.getConnection(url, "a_user", null);
    }

    private List<String> listQueryStatuses(String sql) {
        return this.listSingleStringColumn(String.format("SELECT state FROM system.runtime.queries WHERE query = '%s'", sql));
    }

    private List<String> listQueryErrorCodes(String sql) {
        return this.listSingleStringColumn(String.format("SELECT error_code FROM system.runtime.queries WHERE query = '%s'", sql));
    }

    private List<String> listSingleStringColumn(String sql) {
        ImmutableList.Builder statuses = ImmutableList.builder();
        try (Connection connection = this.createConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(sql);){
            Assertions.assertThat((int)resultSet.getMetaData().getColumnCount()).isOne();
            Assertions.assertThat((int)resultSet.getMetaData().getColumnType(1)).isEqualTo(12);
            while (resultSet.next()) {
                statuses.add((Object)resultSet.getString(1));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return statuses.build();
    }
}

