/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import io.airlift.log.Logging;
import io.trino.jdbc.TestingJdbcUtils;
import io.trino.jdbc.TrinoConnection;
import io.trino.jdbc.TrinoDatabaseMetaData;
import io.trino.plugin.blackhole.BlackHolePlugin;
import io.trino.plugin.hive.HivePlugin;
import io.trino.plugin.tpch.TpchMetadata;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.server.BasicQueryInfo;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.Plugin;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.CountingMockConnector;
import io.trino.testing.MultisetAssertions;
import io.trino.type.ColorType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestTrinoDatabaseMetaData {
    private static final String TEST_CATALOG = "test_catalog";
    private static final String COUNTING_CATALOG = "mock_catalog";
    private CountingMockConnector countingMockConnector;
    private TestingTrinoServer server;

    @BeforeAll
    public void setupServer() throws Exception {
        Statement statement;
        Logging.initialize();
        this.server = TestingTrinoServer.create();
        this.server.installPlugin((Plugin)new TpchPlugin());
        this.server.createCatalog(TEST_CATALOG, "tpch");
        this.server.installPlugin((Plugin)new BlackHolePlugin());
        this.server.createCatalog("blackhole", "blackhole");
        this.server.installPlugin((Plugin)new HivePlugin());
        this.server.createCatalog("hive", "hive", (Map)ImmutableMap.builder().put((Object)"hive.metastore", (Object)"file").put((Object)"hive.metastore.catalog.dir", (Object)this.server.getBaseDataDir().resolve("hive").toAbsolutePath().toString()).put((Object)"hive.security", (Object)"sql-standard").put((Object)"bootstrap.quiet", (Object)"true").buildOrThrow());
        this.countingMockConnector = new CountingMockConnector();
        this.server.installPlugin(this.countingMockConnector.getPlugin());
        this.server.createCatalog(COUNTING_CATALOG, "mock", (Map)ImmutableMap.of());
        try (Connection connection = this.createConnection();){
            statement = connection.createStatement();
            try {
                statement.executeUpdate("CREATE SCHEMA blackhole.blackhole");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        connection = this.createConnection();
        try {
            connection.setCatalog("hive");
            statement = connection.createStatement();
            try {
                statement.execute("SET ROLE admin IN hive");
                statement.execute("CREATE SCHEMA default");
                statement.execute("CREATE TABLE default.test_table (a varchar)");
                statement.execute("CREATE VIEW default.test_view AS SELECT * FROM hive.default.test_table");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @AfterAll
    public void tearDownServer() throws Exception {
        this.server.close();
        this.server = null;
        this.countingMockConnector.close();
        this.countingMockConnector = null;
    }

    @Test
    public void testGetClientInfoProperties() throws Exception {
        try (Connection connection = this.createConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet resultSet = metaData.getClientInfoProperties();){
                TestingJdbcUtils.assertResultSet(resultSet).hasColumnCount(4).hasColumn(1, "NAME", 12).hasColumn(2, "MAX_LEN", 4).hasColumn(3, "DEFAULT_VALUE", 12).hasColumn(4, "DESCRIPTION", 12).hasRows(TestingJdbcUtils.list(TestingJdbcUtils.list("ApplicationName", Integer.MAX_VALUE, null, null), TestingJdbcUtils.list("ClientInfo", Integer.MAX_VALUE, null, null), TestingJdbcUtils.list("ClientTags", Integer.MAX_VALUE, null, null), TestingJdbcUtils.list("TraceToken", Integer.MAX_VALUE, null, null)));
            }
        }
    }

    @Test
    public void testPassEscapeInMetaDataQuery() throws Exception {
        try (Connection connection = this.createConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            Set<String> queries = this.captureQueries(() -> {
                String schemaPattern = "defau" + metaData.getSearchStringEscape() + "_t";
                try (ResultSet resultSet = metaData.getColumns("blackhole", schemaPattern, null, null);){
                    ((AbstractBooleanAssert)Assertions.assertThat((boolean)resultSet.next()).describedAs("There should be no results", new Object[0])).isFalse();
                }
                return null;
            });
            ((AbstractIntegerAssert)Assertions.assertThat((int)queries.size()).describedAs("Expected exactly one query, got " + queries.size(), new Object[0])).isEqualTo(1);
            String query = (String)Iterables.getOnlyElement(queries);
            io.airlift.testing.Assertions.assertContains((String)query, (String)"_t' ESCAPE '", (String)"Metadata query does not contain ESCAPE");
        }
    }

    @Test
    public void testGetTypeInfo() throws Exception {
        try (Connection connection = this.createConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet typeInfo = metaData.getTypeInfo();
            while (typeInfo.next()) {
                int jdbcType = typeInfo.getInt("DATA_TYPE");
                switch (jdbcType) {
                    case -5: {
                        TestTrinoDatabaseMetaData.assertColumnSpec(typeInfo, -5, 19L, 10L, "bigint");
                        break;
                    }
                    case 16: {
                        TestTrinoDatabaseMetaData.assertColumnSpec(typeInfo, 16, null, null, "boolean");
                        break;
                    }
                    case 4: {
                        TestTrinoDatabaseMetaData.assertColumnSpec(typeInfo, 4, 10L, 10L, "integer");
                        break;
                    }
                    case 3: {
                        TestTrinoDatabaseMetaData.assertColumnSpec(typeInfo, 3, 38L, 10L, "decimal");
                        break;
                    }
                    case 12: {
                        TestTrinoDatabaseMetaData.assertColumnSpec(typeInfo, 12, null, null, "varchar");
                        break;
                    }
                    case 93: {
                        TestTrinoDatabaseMetaData.assertColumnSpec(typeInfo, 93, 23L, null, "timestamp");
                        break;
                    }
                    case 8: {
                        TestTrinoDatabaseMetaData.assertColumnSpec(typeInfo, 8, 53L, 2L, "double");
                    }
                }
            }
        }
    }

    @Test
    public void testGetUrl() throws Exception {
        try (Connection connection = this.createConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            Assertions.assertThat((String)metaData.getURL()).isEqualTo("jdbc:trino://" + this.server.getAddress());
        }
    }

    @Test
    public void testGetDatabaseProductVersion() throws Exception {
        try (Connection connection = this.createConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            Assertions.assertThat((String)metaData.getDatabaseProductName()).isEqualTo("Trino");
            Assertions.assertThat((String)metaData.getDatabaseProductVersion()).isEqualTo("testversion");
            Assertions.assertThat((int)metaData.getDatabaseMajorVersion()).isEqualTo(0);
            Assertions.assertThat((int)metaData.getDatabaseMinorVersion()).isEqualTo(0);
        }
    }

    @Test
    public void testGetUserName() throws Exception {
        try (Connection connection = this.createConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            Assertions.assertThat((String)metaData.getUserName()).isEqualTo("admin");
        }
    }

    @Test
    public void testGetCatalogs() throws Exception {
        try (Connection connection = this.createConnection();
             ResultSet rs = connection.getMetaData().getCatalogs();){
            Assertions.assertThat(TestingJdbcUtils.readRows(rs)).isEqualTo(TestingJdbcUtils.list(TestingJdbcUtils.list("blackhole"), TestingJdbcUtils.list("hive"), TestingJdbcUtils.list(COUNTING_CATALOG), TestingJdbcUtils.list("system"), TestingJdbcUtils.list(TEST_CATALOG)));
            ResultSetMetaData metadata = rs.getMetaData();
            Assertions.assertThat((int)metadata.getColumnCount()).isEqualTo(1);
            Assertions.assertThat((String)metadata.getColumnLabel(1)).isEqualTo("TABLE_CAT");
            Assertions.assertThat((int)metadata.getColumnType(1)).isEqualTo(12);
        }
    }

    @Test
    public void testGetSchemas() throws Exception {
        ArrayList<List<String>> hive = new ArrayList<List<String>>();
        hive.add(TestingJdbcUtils.list("hive", "information_schema"));
        hive.add(TestingJdbcUtils.list("hive", "default"));
        ArrayList<List<String>> countingCatalog = new ArrayList<List<String>>();
        countingCatalog.add(TestingJdbcUtils.list(COUNTING_CATALOG, "information_schema"));
        countingCatalog.add(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1"));
        countingCatalog.add(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema2"));
        countingCatalog.add(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema3_empty"));
        countingCatalog.add(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema4_empty"));
        ArrayList<List<String>> system = new ArrayList<List<String>>();
        system.add(TestingJdbcUtils.list("system", "information_schema"));
        system.add(TestingJdbcUtils.list("system", "jdbc"));
        system.add(TestingJdbcUtils.list("system", "metadata"));
        system.add(TestingJdbcUtils.list("system", "runtime"));
        ArrayList<List<String>> blackhole = new ArrayList<List<String>>();
        blackhole.add(TestingJdbcUtils.list("blackhole", "information_schema"));
        blackhole.add(TestingJdbcUtils.list("blackhole", "default"));
        blackhole.add(TestingJdbcUtils.list("blackhole", "blackhole"));
        ArrayList<List<String>> test = new ArrayList<List<String>>();
        test.add(TestingJdbcUtils.list(TEST_CATALOG, "information_schema"));
        for (String schema : TpchMetadata.SCHEMA_NAMES) {
            test.add(TestingJdbcUtils.list(TEST_CATALOG, schema));
        }
        ArrayList<List<String>> all = new ArrayList<List<String>>();
        all.addAll(hive);
        all.addAll(countingCatalog);
        all.addAll(system);
        all.addAll(test);
        all.addAll(blackhole);
        try (Connection connection = this.createConnection();){
            try (ResultSet rs = connection.getMetaData().getSchemas();){
                TestTrinoDatabaseMetaData.assertGetSchemasResult(rs, all);
            }
            rs = connection.getMetaData().getSchemas(null, null);
            try {
                TestTrinoDatabaseMetaData.assertGetSchemasResult(rs, all);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.getMetaData().getSchemas(TEST_CATALOG, null);
            try {
                TestTrinoDatabaseMetaData.assertGetSchemasResult(rs, test);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.getMetaData().getSchemas("", null);
            try {
                TestTrinoDatabaseMetaData.assertGetSchemasResult(rs, TestingJdbcUtils.list(new List[0]));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.getMetaData().getSchemas(null, "");
            try {
                TestTrinoDatabaseMetaData.assertGetSchemasResult(rs, TestingJdbcUtils.list(new List[0]));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.getMetaData().getSchemas(TEST_CATALOG, "information_schema");
            try {
                TestTrinoDatabaseMetaData.assertGetSchemasResult(rs, TestingJdbcUtils.list(TestingJdbcUtils.list(TEST_CATALOG, "information_schema")));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.getMetaData().getSchemas(null, "information_schema");
            try {
                TestTrinoDatabaseMetaData.assertGetSchemasResult(rs, TestingJdbcUtils.list(TestingJdbcUtils.list(TEST_CATALOG, "information_schema"), TestingJdbcUtils.list(COUNTING_CATALOG, "information_schema"), TestingJdbcUtils.list("blackhole", "information_schema"), TestingJdbcUtils.list("hive", "information_schema"), TestingJdbcUtils.list("system", "information_schema")));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.getMetaData().getSchemas(null, "sf_");
            try {
                TestTrinoDatabaseMetaData.assertGetSchemasResult(rs, TestingJdbcUtils.list(TestingJdbcUtils.list(TEST_CATALOG, "sf1")));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.getMetaData().getSchemas(null, "sf%");
            try {
                List<List<String>> expected = test.stream().filter(item -> ((String)item.get(1)).startsWith("sf")).collect(Collectors.toList());
                TestTrinoDatabaseMetaData.assertGetSchemasResult(rs, expected);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.getMetaData().getSchemas("unknown", null);
            try {
                TestTrinoDatabaseMetaData.assertGetSchemasResult(rs, TestingJdbcUtils.list(new List[0]));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.getMetaData().getSchemas(null, "unknown");
            try {
                TestTrinoDatabaseMetaData.assertGetSchemasResult(rs, TestingJdbcUtils.list(new List[0]));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.getMetaData().getSchemas(TEST_CATALOG, "unknown");
            try {
                TestTrinoDatabaseMetaData.assertGetSchemasResult(rs, TestingJdbcUtils.list(new List[0]));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = connection.getMetaData().getSchemas("unknown", "unknown");
            try {
                TestTrinoDatabaseMetaData.assertGetSchemasResult(rs, TestingJdbcUtils.list(new List[0]));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    private static void assertGetSchemasResult(ResultSet rs, List<List<String>> expectedSchemas) throws SQLException {
        List<List<Object>> data = TestingJdbcUtils.readRows(rs);
        Assertions.assertThat(data).hasSize(expectedSchemas.size());
        for (List<Object> row : data) {
            Assertions.assertThat(TestingJdbcUtils.list((String)row.get(1), (String)row.get(0))).isIn(expectedSchemas);
        }
        ResultSetMetaData metadata = rs.getMetaData();
        Assertions.assertThat((int)metadata.getColumnCount()).isEqualTo(2);
        Assertions.assertThat((String)metadata.getColumnLabel(1)).isEqualTo("TABLE_SCHEM");
        Assertions.assertThat((int)metadata.getColumnType(1)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(2)).isEqualTo("TABLE_CATALOG");
        Assertions.assertThat((int)metadata.getColumnType(2)).isEqualTo(12);
    }

    @Test
    public void testGetTables() throws Exception {
        ResultSet rs;
        try (Connection connection = this.createConnection();){
            rs = connection.getMetaData().getTables(null, null, null, null);
            try {
                TestTrinoDatabaseMetaData.assertTableMetadata(rs);
                ((ListAssert)Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "tables")})).contains((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, null, null, null);
            try {
                TestTrinoDatabaseMetaData.assertTableMetadata(rs);
                ((ListAssert)Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "tables")})).contains((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables("", null, null, null);
            try {
                TestTrinoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).isEmpty();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "information_schema", null, null);
            try {
                TestTrinoDatabaseMetaData.assertTableMetadata(rs);
                ((ListAssert)Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "tables")})).contains((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "", null, null);
            try {
                TestTrinoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).isEmpty();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "information_schema", "tables", null);
            try {
                TestTrinoDatabaseMetaData.assertTableMetadata(rs);
                ((ListAssert)Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "tables")})).doesNotContain((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "information_schema", "tables", TestingJdbcUtils.array("TABLE"));
            try {
                TestTrinoDatabaseMetaData.assertTableMetadata(rs);
                ((ListAssert)Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "tables")})).doesNotContain((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(null, "information_schema", null, null);
            try {
                TestTrinoDatabaseMetaData.assertTableMetadata(rs);
                ((ListAssert)Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "tables")})).contains((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(null, null, "tables", null);
            try {
                TestTrinoDatabaseMetaData.assertTableMetadata(rs);
                ((ListAssert)Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "tables")})).doesNotContain((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(null, null, null, TestingJdbcUtils.array("TABLE"));
            try {
                TestTrinoDatabaseMetaData.assertTableMetadata(rs);
                ((ListAssert)Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "tables")})).contains((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "inf%", "tables", null);
            try {
                TestTrinoDatabaseMetaData.assertTableMetadata(rs);
                ((ListAssert)Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "tables")})).doesNotContain((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "information_schema", "tab%", null);
            try {
                TestTrinoDatabaseMetaData.assertTableMetadata(rs);
                ((ListAssert)Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "tables")})).doesNotContain((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables("unknown", "information_schema", "tables", TestingJdbcUtils.array("TABLE"));
            try {
                TestTrinoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).isEmpty();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "unknown", "tables", TestingJdbcUtils.array("TABLE"));
            try {
                TestTrinoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).isEmpty();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "information_schema", "unknown", TestingJdbcUtils.array("TABLE"));
            try {
                TestTrinoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).isEmpty();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "information_schema", "tables", TestingJdbcUtils.array("unknown"));
            try {
                TestTrinoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).isEmpty();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "information_schema", "tables", TestingJdbcUtils.array("unknown", "TABLE"));
            try {
                TestTrinoDatabaseMetaData.assertTableMetadata(rs);
                ((ListAssert)Assertions.assertThat(TestingJdbcUtils.readRows(rs)).contains((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "tables")})).doesNotContain((Object[])new List[]{TestTrinoDatabaseMetaData.getTablesRow("information_schema", "schemata")});
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getTables(TEST_CATALOG, "information_schema", "tables", TestingJdbcUtils.array(new String[0]));
            try {
                TestTrinoDatabaseMetaData.assertTableMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).isEmpty();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            for (boolean includeTable : new boolean[]{false, true}) {
                for (boolean includeView : new boolean[]{false, true}) {
                    ArrayList<String> types = new ArrayList<String>();
                    ArrayList<List<Object>> expected = new ArrayList<List<Object>>();
                    if (includeTable) {
                        types.add("TABLE");
                        expected.add(TestTrinoDatabaseMetaData.getTablesRow("hive", "default", "test_table", "TABLE"));
                    }
                    if (includeView) {
                        types.add("VIEW");
                        expected.add(TestTrinoDatabaseMetaData.getTablesRow("hive", "default", "test_view", "VIEW"));
                    }
                    try (ResultSet rs2 = connection.getMetaData().getTables("hive", "default", "test_%", types.toArray(new String[0]));){
                        TestTrinoDatabaseMetaData.assertTableMetadata(rs2);
                        ImmutableMultiset rows = ImmutableMultiset.copyOf(TestingJdbcUtils.readRows(rs2));
                        Assertions.assertThat((Collection)rows).isEqualTo((Object)ImmutableMultiset.copyOf(expected));
                    }
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private static List<Object> getTablesRow(String schema, String table) {
        return TestTrinoDatabaseMetaData.getTablesRow(TEST_CATALOG, schema, table, "TABLE");
    }

    private static List<Object> getTablesRow(String catalog, String schema, String table, String type) {
        return TestingJdbcUtils.list(catalog, schema, table, type, null, null, null, null, null, null);
    }

    private static void assertTableMetadata(ResultSet rs) throws SQLException {
        ResultSetMetaData metadata = rs.getMetaData();
        Assertions.assertThat((int)metadata.getColumnCount()).isEqualTo(10);
        Assertions.assertThat((String)metadata.getColumnLabel(1)).isEqualTo("TABLE_CAT");
        Assertions.assertThat((int)metadata.getColumnType(1)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(2)).isEqualTo("TABLE_SCHEM");
        Assertions.assertThat((int)metadata.getColumnType(2)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(3)).isEqualTo("TABLE_NAME");
        Assertions.assertThat((int)metadata.getColumnType(3)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(4)).isEqualTo("TABLE_TYPE");
        Assertions.assertThat((int)metadata.getColumnType(4)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(5)).isEqualTo("REMARKS");
        Assertions.assertThat((int)metadata.getColumnType(5)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(6)).isEqualTo("TYPE_CAT");
        Assertions.assertThat((int)metadata.getColumnType(6)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(7)).isEqualTo("TYPE_SCHEM");
        Assertions.assertThat((int)metadata.getColumnType(7)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(8)).isEqualTo("TYPE_NAME");
        Assertions.assertThat((int)metadata.getColumnType(8)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(9)).isEqualTo("SELF_REFERENCING_COL_NAME");
        Assertions.assertThat((int)metadata.getColumnType(9)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(10)).isEqualTo("REF_GENERATION");
        Assertions.assertThat((int)metadata.getColumnType(10)).isEqualTo(12);
    }

    @Test
    public void testGetTableTypes() throws Exception {
        try (Connection connection = this.createConnection();
             ResultSet tableTypes = connection.getMetaData().getTableTypes();){
            Assertions.assertThat(TestingJdbcUtils.readRows(tableTypes)).isEqualTo(TestingJdbcUtils.list(TestingJdbcUtils.list("TABLE"), TestingJdbcUtils.list("VIEW")));
            ResultSetMetaData metadata = tableTypes.getMetaData();
            Assertions.assertThat((int)metadata.getColumnCount()).isEqualTo(1);
            Assertions.assertThat((String)metadata.getColumnLabel(1)).isEqualTo("TABLE_TYPE");
            Assertions.assertThat((int)metadata.getColumnType(1)).isEqualTo(12);
        }
    }

    @Test
    public void testGetColumns() throws Exception {
        ResultSet rs;
        try (Connection connection = this.createConnection();){
            rs = connection.getMetaData().getColumns(null, null, "tables", "table_name");
            try {
                TestTrinoDatabaseMetaData.assertColumnMetadata(rs);
                Assertions.assertThat((boolean)rs.next()).isTrue();
                Assertions.assertThat((String)rs.getString("TABLE_CAT")).isEqualTo("blackhole");
                Assertions.assertThat((String)rs.getString("TABLE_SCHEM")).isEqualTo("information_schema");
                Assertions.assertThat((String)rs.getString("TABLE_NAME")).isEqualTo("tables");
                Assertions.assertThat((String)rs.getString("COLUMN_NAME")).isEqualTo("table_name");
                Assertions.assertThat((long)rs.getLong("NULLABLE")).isEqualTo(1L);
                Assertions.assertThat((String)rs.getString("IS_NULLABLE")).isEqualTo("YES");
                Assertions.assertThat((int)rs.getInt("DATA_TYPE")).isEqualTo(12);
                Assertions.assertThat((boolean)rs.next()).isTrue();
                Assertions.assertThat((String)rs.getString("TABLE_CAT")).isEqualTo("hive");
                Assertions.assertThat((String)rs.getString("TABLE_SCHEM")).isEqualTo("information_schema");
                Assertions.assertThat((boolean)rs.next()).isTrue();
                Assertions.assertThat((String)rs.getString("TABLE_CAT")).isEqualTo(COUNTING_CATALOG);
                Assertions.assertThat((String)rs.getString("TABLE_SCHEM")).isEqualTo("information_schema");
                Assertions.assertThat((boolean)rs.next()).isTrue();
                Assertions.assertThat((String)rs.getString("TABLE_CAT")).isEqualTo("system");
                Assertions.assertThat((String)rs.getString("TABLE_SCHEM")).isEqualTo("information_schema");
                Assertions.assertThat((boolean)rs.next()).isTrue();
                Assertions.assertThat((String)rs.getString("TABLE_CAT")).isEqualTo("system");
                Assertions.assertThat((String)rs.getString("TABLE_SCHEM")).isEqualTo("jdbc");
                Assertions.assertThat((boolean)rs.next()).isTrue();
                Assertions.assertThat((String)rs.getString("TABLE_CAT")).isEqualTo(TEST_CATALOG);
                Assertions.assertThat((String)rs.getString("TABLE_SCHEM")).isEqualTo("information_schema");
                Assertions.assertThat((boolean)rs.next()).isFalse();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getColumns(TEST_CATALOG, null, "tables", "table_name");
            try {
                TestTrinoDatabaseMetaData.assertColumnMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).hasSize(1);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getColumns(null, "information_schema", "tables", "table_name");
            try {
                TestTrinoDatabaseMetaData.assertColumnMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).hasSize(5);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getColumns(TEST_CATALOG, "information_schema", "tables", "table_name");
            try {
                TestTrinoDatabaseMetaData.assertColumnMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).hasSize(1);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getColumns(TEST_CATALOG, "inf%", "tables", "table_name");
            try {
                TestTrinoDatabaseMetaData.assertColumnMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).hasSize(1);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getColumns(TEST_CATALOG, "information_schema", "tab%", "table_name");
            try {
                TestTrinoDatabaseMetaData.assertColumnMetadata(rs);
                Assertions.assertThat(TestingJdbcUtils.readRows(rs)).hasSize(2);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getColumns(TEST_CATALOG, "information_schema", "tables", "%m%");
            try {
                TestTrinoDatabaseMetaData.assertColumnMetadata(rs);
                Assertions.assertThat((boolean)rs.next()).isTrue();
                Assertions.assertThat((String)rs.getString("COLUMN_NAME")).isEqualTo("table_schema");
                Assertions.assertThat((boolean)rs.next()).isTrue();
                Assertions.assertThat((String)rs.getString("COLUMN_NAME")).isEqualTo("table_name");
                Assertions.assertThat((boolean)rs.next()).isFalse();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection();
        try {
            rs = connection.getMetaData().getColumns(TEST_CATALOG, "tiny", "supplier", "suppkey");
            try {
                TestTrinoDatabaseMetaData.assertColumnMetadata(rs);
                Assertions.assertThat((boolean)rs.next()).isTrue();
                Assertions.assertThat((long)rs.getLong("NULLABLE")).isEqualTo(0L);
                Assertions.assertThat((String)rs.getString("IS_NULLABLE")).isEqualTo("NO");
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnection("blackhole", "blackhole");
        try (Statement statement = connection.createStatement();){
            Assertions.assertThat((int)statement.executeUpdate("CREATE TABLE test_get_columns_table (c_boolean boolean, c_bigint bigint, c_integer integer, c_smallint smallint, c_tinyint tinyint, c_real real, c_double double, c_varchar_1234 varchar(1234), c_varchar varchar, c_char_345 char(345), c_varbinary varbinary, c_time time, c_time_0 time(0), c_time_3 time(3), c_time_6 time(6), c_time_9 time(9), c_time_12 time(12), c_time_with_time_zone time with time zone, c_time_with_time_zone_0 time(0) with time zone, c_time_with_time_zone_3 time(3) with time zone, c_time_with_time_zone_6 time(6) with time zone, c_time_with_time_zone_9 time(9) with time zone, c_time_with_time_zone_12 time(12) with time zone, c_timestamp timestamp, c_timestamp_0 timestamp(0), c_timestamp_3 timestamp(3), c_timestamp_6 timestamp(6), c_timestamp_9 timestamp(9), c_timestamp_12 timestamp(12), c_timestamp_with_time_zone timestamp with time zone, c_timestamp_with_time_zone_0 timestamp(0) with time zone, c_timestamp_with_time_zone_3 timestamp(3) with time zone, c_timestamp_with_time_zone_6 timestamp(6) with time zone, c_timestamp_with_time_zone_9 timestamp(9) with time zone, c_timestamp_with_time_zone_12 timestamp(12) with time zone, c_date date, c_decimal_8_2 decimal(8,2), c_decimal_38_0 decimal(38,0), c_array array<bigint>, c_color color)")).isEqualTo(0);
            try (ResultSet rs2 = connection.getMetaData().getColumns("blackhole", "blackhole", "test_get_columns_table", null);){
                TestTrinoDatabaseMetaData.assertColumnMetadata(rs2);
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 16, null, null, null, null, (Type)BooleanType.BOOLEAN);
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, -5, 19L, 10L, null, null, (Type)BigintType.BIGINT);
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 4, 10L, 10L, null, null, (Type)IntegerType.INTEGER);
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 5, 5L, 10L, null, null, (Type)SmallintType.SMALLINT);
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, -6, 3L, 10L, null, null, (Type)TinyintType.TINYINT);
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 7, 24L, 2L, null, null, (Type)RealType.REAL);
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 8, 53L, 2L, null, null, (Type)DoubleType.DOUBLE);
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 12, 1234L, null, null, 1234L, (Type)VarcharType.createVarcharType((int)1234));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 12, Integer.MAX_VALUE, null, null, Integer.MAX_VALUE, (Type)VarcharType.createUnboundedVarcharType());
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 1, 345L, null, null, 345L, (Type)CharType.createCharType((int)345));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, -3, Integer.MAX_VALUE, null, null, Integer.MAX_VALUE, (Type)VarbinaryType.VARBINARY);
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 92, 12L, null, 3L, null, (Type)TimeType.TIME_MILLIS);
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 92, 8L, null, 0L, null, (Type)TimeType.createTimeType((int)0));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 92, 12L, null, 3L, null, (Type)TimeType.createTimeType((int)3));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 92, 15L, null, 6L, null, (Type)TimeType.createTimeType((int)6));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 92, 18L, null, 9L, null, (Type)TimeType.createTimeType((int)9));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 92, 21L, null, 12L, null, (Type)TimeType.createTimeType((int)12));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 2013, 18L, null, 3L, null, (Type)TimeWithTimeZoneType.TIME_TZ_MILLIS);
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 2013, 14L, null, 0L, null, (Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)0));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 2013, 18L, null, 3L, null, (Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)3));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 2013, 21L, null, 6L, null, (Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)6));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 2013, 24L, null, 9L, null, (Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)9));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 2013, 27L, null, 12L, null, (Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)12));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 93, 25L, null, 3L, null, (Type)TimestampType.TIMESTAMP_MILLIS);
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 93, 21L, null, 0L, null, (Type)TimestampType.createTimestampType((int)0));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 93, 25L, null, 3L, null, (Type)TimestampType.createTimestampType((int)3));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 93, 28L, null, 6L, null, (Type)TimestampType.createTimestampType((int)6));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 93, 31L, null, 9L, null, (Type)TimestampType.createTimestampType((int)9));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 93, 34L, null, 12L, null, (Type)TimestampType.createTimestampType((int)12));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 2014, 59L, null, 3L, null, (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS);
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 2014, 55L, null, 0L, null, (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 2014, 59L, null, 3L, null, (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 2014, 62L, null, 6L, null, (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 2014, 65L, null, 9L, null, (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 2014, 68L, null, 12L, null, (Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 91, 14L, null, null, null, (Type)DateType.DATE);
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 3, 8L, 10L, 2L, null, (Type)DecimalType.createDecimalType((int)8, (int)2));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 3, 38L, 10L, 0L, null, (Type)DecimalType.createDecimalType((int)38, (int)0));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 2003, null, null, null, null, (Type)new ArrayType((Type)BigintType.BIGINT));
                TestTrinoDatabaseMetaData.assertColumnSpec(rs2, 2000, null, null, null, null, (Type)ColorType.COLOR);
                Assertions.assertThat((boolean)rs2.next()).isFalse();
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private static void assertColumnSpec(ResultSet rs, int jdbcType, Long columnSize, Long numPrecRadix, Long decimalDigits, Long charOctetLength, Type type) throws SQLException {
        String message = " of " + type.getDisplayName() + ": ";
        Assertions.assertThat((boolean)rs.next()).isTrue();
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("TYPE_NAME")).describedAs("TYPE_NAME", new Object[0])).isEqualTo((Object)type.getDisplayName());
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("DATA_TYPE")).describedAs("DATA_TYPE" + message, new Object[0])).isEqualTo((Object)jdbcType);
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("COLUMN_SIZE")).describedAs("COLUMN_SIZE" + message, new Object[0])).isEqualTo((Object)columnSize);
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("NUM_PREC_RADIX")).describedAs("NUM_PREC_RADIX" + message, new Object[0])).isEqualTo((Object)numPrecRadix);
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("DECIMAL_DIGITS")).describedAs("DECIMAL_DIGITS" + message, new Object[0])).isEqualTo((Object)decimalDigits);
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("CHAR_OCTET_LENGTH")).describedAs("CHAR_OCTET_LENGTH" + message, new Object[0])).isEqualTo((Object)charOctetLength);
    }

    private static void assertColumnMetadata(ResultSet rs) throws SQLException {
        ResultSetMetaData metadata = rs.getMetaData();
        Assertions.assertThat((int)metadata.getColumnCount()).isEqualTo(24);
        Assertions.assertThat((String)metadata.getColumnLabel(1)).isEqualTo("TABLE_CAT");
        Assertions.assertThat((int)metadata.getColumnType(1)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(2)).isEqualTo("TABLE_SCHEM");
        Assertions.assertThat((int)metadata.getColumnType(2)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(3)).isEqualTo("TABLE_NAME");
        Assertions.assertThat((int)metadata.getColumnType(3)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(4)).isEqualTo("COLUMN_NAME");
        Assertions.assertThat((int)metadata.getColumnType(4)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(5)).isEqualTo("DATA_TYPE");
        Assertions.assertThat((int)metadata.getColumnType(5)).isEqualTo(-5);
        Assertions.assertThat((String)metadata.getColumnLabel(6)).isEqualTo("TYPE_NAME");
        Assertions.assertThat((int)metadata.getColumnType(6)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(7)).isEqualTo("COLUMN_SIZE");
        Assertions.assertThat((int)metadata.getColumnType(7)).isEqualTo(-5);
        Assertions.assertThat((String)metadata.getColumnLabel(8)).isEqualTo("BUFFER_LENGTH");
        Assertions.assertThat((int)metadata.getColumnType(8)).isEqualTo(-5);
        Assertions.assertThat((String)metadata.getColumnLabel(9)).isEqualTo("DECIMAL_DIGITS");
        Assertions.assertThat((int)metadata.getColumnType(9)).isEqualTo(-5);
        Assertions.assertThat((String)metadata.getColumnLabel(10)).isEqualTo("NUM_PREC_RADIX");
        Assertions.assertThat((int)metadata.getColumnType(10)).isEqualTo(-5);
        Assertions.assertThat((String)metadata.getColumnLabel(11)).isEqualTo("NULLABLE");
        Assertions.assertThat((int)metadata.getColumnType(11)).isEqualTo(-5);
        Assertions.assertThat((String)metadata.getColumnLabel(12)).isEqualTo("REMARKS");
        Assertions.assertThat((int)metadata.getColumnType(12)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(13)).isEqualTo("COLUMN_DEF");
        Assertions.assertThat((int)metadata.getColumnType(13)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(14)).isEqualTo("SQL_DATA_TYPE");
        Assertions.assertThat((int)metadata.getColumnType(14)).isEqualTo(-5);
        Assertions.assertThat((String)metadata.getColumnLabel(15)).isEqualTo("SQL_DATETIME_SUB");
        Assertions.assertThat((int)metadata.getColumnType(15)).isEqualTo(-5);
        Assertions.assertThat((String)metadata.getColumnLabel(16)).isEqualTo("CHAR_OCTET_LENGTH");
        Assertions.assertThat((int)metadata.getColumnType(16)).isEqualTo(-5);
        Assertions.assertThat((String)metadata.getColumnLabel(17)).isEqualTo("ORDINAL_POSITION");
        Assertions.assertThat((int)metadata.getColumnType(17)).isEqualTo(-5);
        Assertions.assertThat((String)metadata.getColumnLabel(18)).isEqualTo("IS_NULLABLE");
        Assertions.assertThat((int)metadata.getColumnType(18)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(19)).isEqualTo("SCOPE_CATALOG");
        Assertions.assertThat((int)metadata.getColumnType(19)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(20)).isEqualTo("SCOPE_SCHEMA");
        Assertions.assertThat((int)metadata.getColumnType(20)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(21)).isEqualTo("SCOPE_TABLE");
        Assertions.assertThat((int)metadata.getColumnType(21)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(22)).isEqualTo("SOURCE_DATA_TYPE");
        Assertions.assertThat((int)metadata.getColumnType(22)).isEqualTo(-5);
        Assertions.assertThat((String)metadata.getColumnLabel(23)).isEqualTo("IS_AUTOINCREMENT");
        Assertions.assertThat((int)metadata.getColumnType(23)).isEqualTo(12);
        Assertions.assertThat((String)metadata.getColumnLabel(24)).isEqualTo("IS_GENERATEDCOLUMN");
        Assertions.assertThat((int)metadata.getColumnType(24)).isEqualTo(12);
    }

    @Test
    public void testGetPseudoColumns() throws Exception {
        try (Connection connection = this.createConnection();
             ResultSet rs = connection.getMetaData().getPseudoColumns(null, null, null, null);){
            Assertions.assertThat((boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void testGetProcedures() throws Exception {
        try (Connection connection = this.createConnection();
             ResultSet rs = connection.getMetaData().getProcedures(null, null, null);){
            Assertions.assertThat((boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void testGetProcedureColumns() throws Exception {
        try (Connection connection = this.createConnection();
             ResultSet rs = connection.getMetaData().getProcedureColumns(null, null, null, null);){
            Assertions.assertThat((boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void testGetSuperTables() throws Exception {
        try (Connection connection = this.createConnection();
             ResultSet rs = connection.getMetaData().getSuperTables(null, null, null);){
            Assertions.assertThat((boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void testGetUdts() throws Exception {
        try (Connection connection = this.createConnection();
             ResultSet rs = connection.getMetaData().getUDTs(null, null, null, null);){
            Assertions.assertThat((boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void testGetAttributes() throws Exception {
        try (Connection connection = this.createConnection();
             ResultSet rs = connection.getMetaData().getAttributes(null, null, null, null);){
            Assertions.assertThat((boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void testGetSuperTypes() throws Exception {
        try (Connection connection = this.createConnection();
             ResultSet rs = connection.getMetaData().getSuperTypes(null, null, null);){
            Assertions.assertThat((boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void testGetSchemasMetadataCalls() throws Exception {
        try (Connection connection = this.createConnection();){
            Verify.verify((boolean)connection.getMetaData().getSearchStringEscape().equals("\\"));
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getSchemas(null, null), TestingJdbcUtils.list("TABLE_CATALOG", "TABLE_SCHEM")), (Multiset<String>)ImmutableMultiset.of((Object)"ConnectorMetadata.listSchemaNames"));
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getSchemas(COUNTING_CATALOG, null), TestingJdbcUtils.list("TABLE_CATALOG", "TABLE_SCHEM")), TestingJdbcUtils.list(TestingJdbcUtils.list(COUNTING_CATALOG, "information_schema"), TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1"), TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema2"), TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema3_empty"), TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema4_empty")), (Multiset<String>)ImmutableMultiset.of((Object)"ConnectorMetadata.listSchemaNames"));
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getSchemas(COUNTING_CATALOG, "test\\_schema%"), TestingJdbcUtils.list("TABLE_CATALOG", "TABLE_SCHEM")), TestingJdbcUtils.list(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1"), TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema2"), TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema3_empty"), TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema4_empty")), (Multiset<String>)ImmutableMultiset.of((Object)"ConnectorMetadata.listSchemaNames"));
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getSchemas(COUNTING_CATALOG, "test_sch_ma1"), TestingJdbcUtils.list("TABLE_CATALOG", "TABLE_SCHEM")), TestingJdbcUtils.list(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1")), (Multiset<String>)ImmutableMultiset.of((Object)"ConnectorMetadata.listSchemaNames"));
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getSchemas(COUNTING_CATALOG, ""), TestingJdbcUtils.list("TABLE_CATALOG", "TABLE_SCHEM")), TestingJdbcUtils.list(new List[0]), (Multiset<String>)ImmutableMultiset.of());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getSchemas("wrong", null), TestingJdbcUtils.list("TABLE_CATALOG", "TABLE_SCHEM")), TestingJdbcUtils.list(new List[0]), (Multiset<String>)ImmutableMultiset.of());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getSchemas("", null), TestingJdbcUtils.list("TABLE_CATALOG", "TABLE_SCHEM")), TestingJdbcUtils.list(new List[0]), (Multiset<String>)ImmutableMultiset.of());
        }
    }

    @Test
    public void testGetTablesMetadataCalls() throws Exception {
        try (Connection connection = this.createConnection();){
            Verify.verify((boolean)connection.getMetaData().getSearchStringEscape().equals("\\"));
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getTables(null, null, null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getRelationTypes").build());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, null, null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getRelationTypes").build());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, "test\\_schema1", null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), (Collection)this.countingMockConnector.getAllTables().filter(schemaTableName -> schemaTableName.getSchemaName().equals("test_schema1")).map(schemaTableName -> TestingJdbcUtils.list(COUNTING_CATALOG, schemaTableName.getSchemaName(), schemaTableName.getTableName(), "TABLE")).collect(ImmutableList.toImmutableList()), (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getRelationTypes(schema=test_schema1)").build());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, "test_sch_ma1", null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), (Collection)this.countingMockConnector.getAllTables().filter(schemaTableName -> schemaTableName.getSchemaName().equals("test_schema1")).map(schemaTableName -> TestingJdbcUtils.list(COUNTING_CATALOG, schemaTableName.getSchemaName(), schemaTableName.getTableName(), "TABLE")).collect(ImmutableList.toImmutableList()), (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getRelationTypes").build());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, null, "test\\_table1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), TestingJdbcUtils.list(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table1", "TABLE"), TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema2", "test_table1", "TABLE")), (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getRelationTypes").build());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, null, "test_t_ble1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), TestingJdbcUtils.list(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table1", "TABLE"), TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema2", "test_table1", "TABLE")), (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getRelationTypes").build());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, "test\\_schema1", "test\\_table1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), TestingJdbcUtils.list(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table1", "TABLE")), (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema1, table=test_table1)", 4).add((Object)"ConnectorMetadata.getView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema1, table=test_table1)").build());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, "test_schema1", "test_table1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), TestingJdbcUtils.list(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table1", "TABLE")), (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getRelationTypes").build());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getTables("wrong", null, null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), TestingJdbcUtils.list(new List[0]), (Multiset<String>)ImmutableMultiset.of());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getTables("", null, null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), TestingJdbcUtils.list(new List[0]), (Multiset<String>)ImmutableMultiset.of());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, "", null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), TestingJdbcUtils.list(new List[0]), (Multiset<String>)ImmutableMultiset.of());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, null, "", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), TestingJdbcUtils.list(new List[0]), (Multiset<String>)ImmutableMultiset.of());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, null, null, new String[0]), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), TestingJdbcUtils.list(new List[0]), (Multiset<String>)ImmutableMultiset.of());
        }
    }

    @Test
    public void testGetColumnsMetadataCalls() throws Exception {
        try (Connection connection = this.createConnection();){
            Verify.verify((boolean)connection.getMetaData().getSearchStringEscape().equals("\\"));
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(null, null, null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), (Multiset<String>)ImmutableMultiset.of((Object)"ConnectorMetadata.streamRelationColumns"));
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, null, null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), (Multiset<String>)ImmutableMultiset.of((Object)"ConnectorMetadata.streamRelationColumns"));
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, "test\\_schema1", null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), (Multiset<String>)ImmutableMultiset.of((Object)"ConnectorMetadata.streamRelationColumns(schema=test_schema1)"));
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, "test\\_schema1", "test\\_table1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), (Collection)IntStream.range(0, 100).mapToObj(i -> TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table1", "column_" + i, "varchar")).collect(ImmutableList.toImmutableList()), (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema1, table=test_table1)", 4).add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableMetadata(handle=test_schema1.test_table1)").build());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, "test\\_schema1", "test\\_table1", "column\\_17"), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), TestingJdbcUtils.list(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table1", "column_17", "varchar")), (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema1, table=test_table1)", 4).add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableMetadata(handle=test_schema1.test_table1)").build());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, "test_schema1", "test_table1", "column_17"), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), TestingJdbcUtils.list(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table1", "column_17", "varchar")), (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.listSchemaNames").add((Object)"ConnectorMetadata.listTables(schema=test_schema1)").addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema1, table=test_table1)", 4).add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableMetadata(handle=test_schema1.test_table1)").build());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(null, "test_schema1", "test_table1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), (Collection)IntStream.range(0, 100).mapToObj(columnIndex -> TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table1", "column_" + columnIndex, "varchar")).collect(ImmutableList.toImmutableList()), (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.listSchemaNames").add((Object)"ConnectorMetadata.listTables(schema=test_schema1)").addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema1, table=test_table1)", 4).add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableMetadata(handle=test_schema1.test_table1)").build());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(null, "test_schema1", null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), (Collection)IntStream.range(0, 1000).boxed().flatMap(tableIndex -> IntStream.range(0, 100).mapToObj(columnIndex -> TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table" + tableIndex, "column_" + columnIndex, "varchar"))).collect(ImmutableList.toImmutableList()), (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"ConnectorMetadata.listSchemaNames", 4).add((Object)"ConnectorMetadata.streamRelationColumns(schema=test_schema1)").build());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(null, null, "test_table1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), (Collection)IntStream.rangeClosed(1, 2).boxed().flatMap(schemaIndex -> IntStream.range(0, 100).mapToObj(columnIndex -> TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema" + schemaIndex, "test_table1", "column_" + columnIndex, "varchar"))).collect(ImmutableList.toImmutableList()), (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"ConnectorMetadata.listSchemaNames", 5).add((Object)"ConnectorMetadata.listTables(schema=test_schema1)").add((Object)"ConnectorMetadata.listTables(schema=test_schema2)").add((Object)"ConnectorMetadata.listTables(schema=test_schema3_empty)").add((Object)"ConnectorMetadata.listTables(schema=test_schema4_empty)").addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema1, table=test_table1)", 20).addCopies((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema1, table=test_table1)", 5).addCopies((Object)"ConnectorMetadata.getView(schema=test_schema1, table=test_table1)", 5).addCopies((Object)"ConnectorMetadata.redirectTable(schema=test_schema1, table=test_table1)", 5).addCopies((Object)"ConnectorMetadata.getTableHandle(schema=test_schema1, table=test_table1)", 5).addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema2, table=test_table1)", 20).addCopies((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema2, table=test_table1)", 5).addCopies((Object)"ConnectorMetadata.getView(schema=test_schema2, table=test_table1)", 5).addCopies((Object)"ConnectorMetadata.redirectTable(schema=test_schema2, table=test_table1)", 5).addCopies((Object)"ConnectorMetadata.getTableHandle(schema=test_schema2, table=test_table1)", 5).add((Object)"ConnectorMetadata.getTableMetadata(handle=test_schema1.test_table1)").add((Object)"ConnectorMetadata.getTableMetadata(handle=test_schema2.test_table1)").build());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(null, "test\\_schema1", "test\\_table1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), (Collection)IntStream.range(0, 100).mapToObj(i -> TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table1", "column_" + i, "varchar")).collect(ImmutableList.toImmutableList()), (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema1, table=test_table1)", 4).add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableMetadata(handle=test_schema1.test_table1)").build());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getColumns("wrong", null, null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), TestingJdbcUtils.list(new List[0]), (Multiset<String>)ImmutableMultiset.of());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getColumns("", null, null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), TestingJdbcUtils.list(new List[0]), (Multiset<String>)ImmutableMultiset.of());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, "wrong\\_schema1", "test\\_table1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), TestingJdbcUtils.list(new List[0]), (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"ConnectorMetadata.getSystemTable(schema=wrong_schema1, table=test_table1)", 4).add((Object)"ConnectorMetadata.getMaterializedView(schema=wrong_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getView(schema=wrong_schema1, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=wrong_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=wrong_schema1, table=test_table1)").build());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, "wrong_schema1", "test_table1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), TestingJdbcUtils.list(new List[0]), (Multiset<String>)ImmutableMultiset.of((Object)"ConnectorMetadata.listSchemaNames"));
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, "", null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), TestingJdbcUtils.list(new List[0]), (Multiset<String>)ImmutableMultiset.of());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, null, "", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), TestingJdbcUtils.list(new List[0]), (Multiset<String>)ImmutableMultiset.of());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, null, null, ""), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), TestingJdbcUtils.list(new List[0]), (Multiset<String>)ImmutableMultiset.of((Object)"ConnectorMetadata.streamRelationColumns"));
        }
    }

    @Test
    public void testAssumeLiteralMetadataCalls() throws Exception {
        this.testAssumeLiteralMetadataCalls("assumeLiteralNamesInMetadataCallsForNonConformingClients=true");
        this.testAssumeLiteralMetadataCalls("assumeLiteralUnderscoreInMetadataCallsForNonConformingClients=true");
        this.testAssumeLiteralMetadataCalls("assumeLiteralNamesInMetadataCallsForNonConformingClients=false&assumeLiteralUnderscoreInMetadataCallsForNonConformingClients=true");
        this.testAssumeLiteralMetadataCalls("assumeLiteralNamesInMetadataCallsForNonConformingClients=true&assumeLiteralUnderscoreInMetadataCallsForNonConformingClients=false");
    }

    private void testAssumeLiteralMetadataCalls(String escapeLiteralParameter) throws Exception {
        try (Connection connection = DriverManager.getConnection(String.format("jdbc:trino://%s?%s", this.server.getAddress(), escapeLiteralParameter), "admin", null);){
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, "test_schema1", null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), (Collection)this.countingMockConnector.getAllTables().filter(schemaTableName -> schemaTableName.getSchemaName().equals("test_schema1")).map(schemaTableName -> TestingJdbcUtils.list(COUNTING_CATALOG, schemaTableName.getSchemaName(), schemaTableName.getTableName(), "TABLE")).collect(ImmutableList.toImmutableList()), (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getRelationTypes(schema=test_schema1)").build());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, "test_schema1", "test_table1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), TestingJdbcUtils.list(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table1", "TABLE")), (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema1, table=test_table1)", 4).add((Object)"ConnectorMetadata.getView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema1, table=test_table1)").build());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getTables(COUNTING_CATALOG, "test_schema_", null, null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE")), TestingJdbcUtils.list(new List[0]), (Multiset<String>)ImmutableMultiset.builder().add((Object)"ConnectorMetadata.getRelationTypes(schema=test_schema_)").build());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, "test_schema1", "test_table1", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), (Collection)IntStream.range(0, 100).mapToObj(i -> TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table1", "column_" + i, "varchar")).collect(ImmutableList.toImmutableList()), (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema1, table=test_table1)", 4).add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableMetadata(handle=test_schema1.test_table1)").build());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, "test_schema1", "test_table1", "column_17"), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), TestingJdbcUtils.list(TestingJdbcUtils.list(COUNTING_CATALOG, "test_schema1", "test_table1", "column_17", "varchar")), (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema1, table=test_table1)", 4).add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getView(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema1, table=test_table1)").add((Object)"ConnectorMetadata.getTableMetadata(handle=test_schema1.test_table1)").build());
            this.assertMetadataCalls(connection, this.readMetaData(databaseMetaData -> databaseMetaData.getColumns(COUNTING_CATALOG, "test_schema1", "test_table_", null), TestingJdbcUtils.list("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "TYPE_NAME")), TestingJdbcUtils.list(new List[0]), (Multiset<String>)ImmutableMultiset.builder().addCopies((Object)"ConnectorMetadata.getSystemTable(schema=test_schema1, table=test_table_)", 4).add((Object)"ConnectorMetadata.getMaterializedView(schema=test_schema1, table=test_table_)").add((Object)"ConnectorMetadata.getView(schema=test_schema1, table=test_table_)").add((Object)"ConnectorMetadata.redirectTable(schema=test_schema1, table=test_table_)").add((Object)"ConnectorMetadata.getTableHandle(schema=test_schema1, table=test_table_)").build());
        }
    }

    @Test
    public void testFailedBothEscapeLiteralParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DriverManager.getConnection(String.format("jdbc:trino://%s?%s", this.server.getAddress(), "assumeLiteralNamesInMetadataCallsForNonConformingClients=true&assumeLiteralUnderscoreInMetadataCallsForNonConformingClients=true"), "admin", null)).isInstanceOf(SQLException.class)).hasMessage("Connection property assumeLiteralNamesInMetadataCallsForNonConformingClients cannot be set if assumeLiteralUnderscoreInMetadataCallsForNonConformingClients is enabled");
    }

    @Test
    public void testEscapeIfNecessary() {
        Assertions.assertThat((String)TrinoDatabaseMetaData.escapeIfNecessary((boolean)false, (boolean)false, null)).isEqualTo(null);
        Assertions.assertThat((String)TrinoDatabaseMetaData.escapeIfNecessary((boolean)false, (boolean)false, (String)"a")).isEqualTo("a");
        Assertions.assertThat((String)TrinoDatabaseMetaData.escapeIfNecessary((boolean)false, (boolean)false, (String)"abc_def")).isEqualTo("abc_def");
        Assertions.assertThat((String)TrinoDatabaseMetaData.escapeIfNecessary((boolean)false, (boolean)false, (String)"abc__de_f")).isEqualTo("abc__de_f");
        Assertions.assertThat((String)TrinoDatabaseMetaData.escapeIfNecessary((boolean)false, (boolean)false, (String)"abc%def")).isEqualTo("abc%def");
        Assertions.assertThat((String)TrinoDatabaseMetaData.escapeIfNecessary((boolean)false, (boolean)false, (String)"abc\\_def")).isEqualTo("abc\\_def");
        Assertions.assertThat((String)TrinoDatabaseMetaData.escapeIfNecessary((boolean)true, (boolean)false, null)).isEqualTo(null);
        Assertions.assertThat((String)TrinoDatabaseMetaData.escapeIfNecessary((boolean)true, (boolean)false, (String)"a")).isEqualTo("a");
        Assertions.assertThat((String)TrinoDatabaseMetaData.escapeIfNecessary((boolean)true, (boolean)false, (String)"abc_def")).isEqualTo("abc\\_def");
        Assertions.assertThat((String)TrinoDatabaseMetaData.escapeIfNecessary((boolean)true, (boolean)false, (String)"abc__de_f")).isEqualTo("abc\\_\\_de\\_f");
        Assertions.assertThat((String)TrinoDatabaseMetaData.escapeIfNecessary((boolean)true, (boolean)false, (String)"abc%def")).isEqualTo("abc\\%def");
        Assertions.assertThat((String)TrinoDatabaseMetaData.escapeIfNecessary((boolean)true, (boolean)false, (String)"abc\\_def")).isEqualTo("abc\\\\\\_def");
        Assertions.assertThat((String)TrinoDatabaseMetaData.escapeIfNecessary((boolean)false, (boolean)true, null)).isEqualTo(null);
        Assertions.assertThat((String)TrinoDatabaseMetaData.escapeIfNecessary((boolean)false, (boolean)true, (String)"a")).isEqualTo("a");
        Assertions.assertThat((String)TrinoDatabaseMetaData.escapeIfNecessary((boolean)false, (boolean)true, (String)"abc_def")).isEqualTo("abc\\_def");
        Assertions.assertThat((String)TrinoDatabaseMetaData.escapeIfNecessary((boolean)false, (boolean)true, (String)"abc__de_f")).isEqualTo("abc\\_\\_de\\_f");
        Assertions.assertThat((String)TrinoDatabaseMetaData.escapeIfNecessary((boolean)false, (boolean)true, (String)"abc\\_def")).isEqualTo("abc\\\\\\_def");
    }

    @Test
    public void testStatementsDoNotLeak() throws Exception {
        try (TrinoConnection connection = (TrinoConnection)this.createConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet resultSet = metaData.getCatalogs();){
                Assertions.assertThat((int)this.countRows(resultSet)).isEqualTo(5);
            }
            resultSet = metaData.getSchemas(TEST_CATALOG, null);
            try {
                Assertions.assertThat((int)this.countRows(resultSet)).isEqualTo(10);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = metaData.getTables(TEST_CATALOG, "sf%", null, null);
            try {
                Assertions.assertThat((int)this.countRows(resultSet)).isEqualTo(64);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            metaData.getCatalogs().close();
            metaData.getSchemas(TEST_CATALOG, null).close();
            metaData.getTables(TEST_CATALOG, "sf%", null, null).close();
            ((AbstractIntegerAssert)Assertions.assertThat((int)connection.activeStatements()).as("activeStatements", new Object[0])).isEqualTo(0);
        }
    }

    private static void assertColumnSpec(ResultSet rs, int dataType, Long precision, Long numPrecRadix, String typeName) throws SQLException {
        String message = " of " + typeName + ": ";
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("TYPE_NAME")).describedAs("TYPE_NAME" + message, new Object[0])).isEqualTo((Object)typeName);
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("DATA_TYPE")).describedAs("DATA_TYPE" + message, new Object[0])).isEqualTo((Object)dataType);
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("PRECISION")).describedAs("PRECISION" + message, new Object[0])).isEqualTo((Object)precision);
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("LITERAL_PREFIX")).describedAs("LITERAL_PREFIX" + message, new Object[0])).isEqualTo(null);
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("LITERAL_SUFFIX")).describedAs("LITERAL_SUFFIX" + message, new Object[0])).isEqualTo(null);
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("CREATE_PARAMS")).describedAs("CREATE_PARAMS" + message, new Object[0])).isEqualTo(null);
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("NULLABLE")).describedAs("NULLABLE" + message, new Object[0])).isEqualTo((Object)1L);
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("CASE_SENSITIVE")).describedAs("CASE_SENSITIVE" + message, new Object[0])).isEqualTo((Object)false);
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("SEARCHABLE")).describedAs("SEARCHABLE" + message, new Object[0])).isEqualTo((Object)3L);
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("UNSIGNED_ATTRIBUTE")).describedAs("UNSIGNED_ATTRIBUTE" + message, new Object[0])).isEqualTo(null);
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("FIXED_PREC_SCALE")).describedAs("FIXED_PREC_SCALE" + message, new Object[0])).isEqualTo((Object)false);
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("AUTO_INCREMENT")).describedAs("AUTO_INCREMENT" + message, new Object[0])).isEqualTo(null);
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("LOCAL_TYPE_NAME")).describedAs("LOCAL_TYPE_NAME" + message, new Object[0])).isEqualTo(null);
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("MINIMUM_SCALE")).describedAs("MINIMUM_SCALE" + message, new Object[0])).isEqualTo((Object)0L);
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("MAXIMUM_SCALE")).describedAs("MAXIMUM_SCALE" + message, new Object[0])).isEqualTo((Object)0L);
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("SQL_DATA_TYPE")).describedAs("SQL_DATA_TYPE" + message, new Object[0])).isEqualTo(null);
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("SQL_DATETIME_SUB")).describedAs("SQL_DATETIME_SUB" + message, new Object[0])).isEqualTo(null);
        ((ObjectAssert)Assertions.assertThat((Object)rs.getObject("NUM_PREC_RADIX")).describedAs("NUM_PREC_RADIX" + message, new Object[0])).isEqualTo((Object)numPrecRadix);
    }

    private Set<String> captureQueries(Callable<?> action) throws Exception {
        Set queryIdsBefore = (Set)this.server.getQueryManager().getQueries().stream().map(BasicQueryInfo::getQueryId).collect(ImmutableSet.toImmutableSet());
        action.call();
        return (Set)this.server.getQueryManager().getQueries().stream().filter(queryInfo -> !queryIdsBefore.contains(queryInfo.getQueryId())).map(BasicQueryInfo::getQuery).collect(ImmutableSet.toImmutableSet());
    }

    private void assertMetadataCalls(Connection connection, MetaDataCallback<? extends Collection<List<Object>>> callback, Multiset<String> expectedMetadataCallsCount) {
        this.assertMetadataCalls(connection, callback, (Collection<List<Object>> actual) -> {}, expectedMetadataCallsCount);
    }

    private void assertMetadataCalls(Connection connection, MetaDataCallback<? extends Collection<List<Object>>> callback, Collection<List<?>> expected, Multiset<String> expectedMetadataCallsCount) {
        this.assertMetadataCalls(connection, callback, (Collection<List<Object>> actual) -> Assertions.assertThat((Collection)ImmutableMultiset.copyOf((Iterable)Objects.requireNonNull(actual, "actual is null"))).isEqualTo((Object)ImmutableMultiset.copyOf((Iterable)Objects.requireNonNull(expected, "expected is null"))), expectedMetadataCallsCount);
    }

    private void assertMetadataCalls(Connection connection, MetaDataCallback<? extends Collection<List<Object>>> callback, Consumer<Collection<List<Object>>> resultsVerification, Multiset<String> expectedMetadataCallsCount) {
        Multiset actualMetadataCallsCount = this.countingMockConnector.runTracing(() -> {
            try {
                Collection actual = (Collection)callback.apply(connection.getMetaData());
                resultsVerification.accept(actual);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
        actualMetadataCallsCount = (Multiset)actualMetadataCallsCount.stream().filter(method -> !"ConnectorMetadata.beginQuery".equals(method) && !"ConnectorMetadata.cleanupQuery".equals(method)).collect(ImmutableMultiset.toImmutableMultiset());
        MultisetAssertions.assertMultisetsEqual((Multiset)actualMetadataCallsCount, expectedMetadataCallsCount);
    }

    private MetaDataCallback<List<List<Object>>> readMetaData(MetaDataCallback<ResultSet> query, List<String> columns) {
        return metaData -> {
            try (ResultSet resultSet = (ResultSet)query.apply(metaData);){
                List<List<Object>> list = TestingJdbcUtils.readRows(resultSet, columns);
                return list;
            }
        };
    }

    private int countRows(ResultSet resultSet) throws Exception {
        int rows = 0;
        while (resultSet.next()) {
            ++rows;
        }
        return rows;
    }

    private Connection createConnection() throws SQLException {
        String url = String.format("jdbc:trino://%s", this.server.getAddress());
        return DriverManager.getConnection(url, "admin", null);
    }

    private Connection createConnection(String catalog, String schema) throws SQLException {
        String url = String.format("jdbc:trino://%s/%s/%s", this.server.getAddress(), catalog, schema);
        return DriverManager.getConnection(url, "admin", null);
    }

    private static interface MetaDataCallback<T> {
        public T apply(DatabaseMetaData var1) throws SQLException;
    }
}

