/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.google.inject.Key;
import io.trino.server.security.PasswordAuthenticatorManager;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.BasicPrincipal;
import io.trino.spi.security.PasswordAuthenticator;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Map;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestTrinoDriverImpersonateUser {
    private static final String TEST_USER = "test_user";
    private static final String PASSWORD = "password";
    private TestingTrinoServer server;

    @BeforeAll
    public void setup() throws Exception {
        Path passwordConfigDummy = Files.createTempFile("passwordConfigDummy", null, new FileAttribute[0]);
        passwordConfigDummy.toFile().deleteOnExit();
        this.server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().put((Object)"password-authenticator.config-files", (Object)passwordConfigDummy.toString()).put((Object)"http-server.authentication.type", (Object)PASSWORD).put((Object)"http-server.https.enabled", (Object)"true").put((Object)"http-server.https.keystore.path", (Object)new File(Resources.getResource((String)"localhost.keystore").toURI()).getPath()).put((Object)"http-server.https.keystore.key", (Object)"changeit").buildOrThrow()).build();
        ((PasswordAuthenticatorManager)this.server.getInstance(Key.get(PasswordAuthenticatorManager.class))).setAuthenticators(new PasswordAuthenticator[]{TestTrinoDriverImpersonateUser::authenticate});
    }

    private static Principal authenticate(String user, String password) {
        if (TEST_USER.equals(user) && PASSWORD.equals(password)) {
            return new BasicPrincipal(user);
        }
        throw new AccessDeniedException("Invalid credentials");
    }

    @AfterAll
    public void teardown() throws Exception {
        this.server.close();
        this.server = null;
    }

    @Test
    public void testInvalidCredentials() {
        Assertions.assertThatThrownBy(() -> this.trySelectCurrentUser((Map<String, String>)ImmutableMap.of()));
        Assertions.assertThatThrownBy(() -> this.trySelectCurrentUser((Map<String, String>)ImmutableMap.of((Object)"user", (Object)"invalidUser", (Object)PASSWORD, (Object)PASSWORD)));
        Assertions.assertThatThrownBy(() -> this.trySelectCurrentUser((Map<String, String>)ImmutableMap.of((Object)"user", (Object)TEST_USER, (Object)PASSWORD, (Object)"invalidPassword")));
        Assertions.assertThatThrownBy(() -> this.trySelectCurrentUser((Map<String, String>)ImmutableMap.of((Object)"user", (Object)"invalidUser", (Object)PASSWORD, (Object)PASSWORD, (Object)"sessionUser", (Object)TEST_USER)));
    }

    @Test
    public void testQueryUserNotSpecified() throws Exception {
        Assertions.assertThat((String)this.trySelectCurrentUser((Map<String, String>)ImmutableMap.of((Object)"user", (Object)TEST_USER, (Object)PASSWORD, (Object)PASSWORD))).isEqualTo(TEST_USER);
    }

    @Test
    public void testImpersonateUser() throws Exception {
        Assertions.assertThat((String)this.trySelectCurrentUser((Map<String, String>)ImmutableMap.of((Object)"user", (Object)TEST_USER, (Object)PASSWORD, (Object)PASSWORD, (Object)"sessionUser", (Object)"differentUser"))).isEqualTo("differentUser");
    }

    /*
     * Exception decompiling
     */
    private String trySelectCurrentUser(Map<String, String> additionalProperties) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Connection createConnection(Map<String, String> additionalProperties) throws Exception {
        String url = String.format("jdbc:trino://localhost:%s", this.server.getHttpsAddress().getPort());
        Properties properties = new Properties();
        properties.setProperty("SSL", "true");
        properties.setProperty("SSLTrustStorePath", new File(Resources.getResource((String)"localhost.truststore").toURI()).getPath());
        properties.setProperty("SSLTrustStorePassword", "changeit");
        additionalProperties.forEach(properties::setProperty);
        return DriverManager.getConnection(url, properties);
    }
}

