/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.uri;

import io.trino.jdbc.$internal.airlift.units.Duration;
import io.trino.jdbc.$internal.client.ClientException;
import io.trino.jdbc.$internal.client.ClientSelectedRole;
import io.trino.jdbc.$internal.client.DnsResolver;
import io.trino.jdbc.$internal.client.KerberosUtil;
import io.trino.jdbc.$internal.client.OkHttpUtil;
import io.trino.jdbc.$internal.client.auth.external.CompositeRedirectHandler;
import io.trino.jdbc.$internal.client.auth.external.ExternalAuthenticator;
import io.trino.jdbc.$internal.client.auth.external.ExternalRedirectStrategy;
import io.trino.jdbc.$internal.client.auth.external.HttpTokenPoller;
import io.trino.jdbc.$internal.client.auth.external.RedirectHandler;
import io.trino.jdbc.$internal.client.uri.ConnectionProperties;
import io.trino.jdbc.$internal.client.uri.ConnectionProperty;
import io.trino.jdbc.$internal.client.uri.KnownTokenCache;
import io.trino.jdbc.$internal.client.uri.PropertyName;
import io.trino.jdbc.$internal.client.uri.RestrictedPropertyException;
import io.trino.jdbc.$internal.guava.annotations.VisibleForTesting;
import io.trino.jdbc.$internal.guava.base.MoreObjects;
import io.trino.jdbc.$internal.guava.base.Splitter;
import io.trino.jdbc.$internal.guava.base.Strings;
import io.trino.jdbc.$internal.guava.collect.ImmutableMap;
import io.trino.jdbc.$internal.guava.net.HostAndPort;
import io.trino.jdbc.$internal.okhttp3.OkHttpClient;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.ietf.jgss.GSSCredential;

public class TrinoUri {
    private static final String URL_START = "trino:";
    private static final Splitter QUERY_SPLITTER = Splitter.on('&').omitEmptyStrings();
    private static final Splitter ARG_SPLITTER = Splitter.on('=').limit(2);
    private static final AtomicReference<RedirectHandler> REDIRECT_HANDLER = new AtomicReference<Object>(null);
    private final HostAndPort address;
    private final URI uri;
    private final Properties properties;
    private Optional<String> user;
    private Optional<String> password;
    private Optional<String> sessionUser;
    private Optional<Map<String, ClientSelectedRole>> roles;
    private Optional<HostAndPort> socksProxy;
    private Optional<HostAndPort> httpProxy;
    private Optional<String> applicationNamePrefix;
    private Optional<Boolean> disableCompression;
    private Optional<Boolean> assumeLiteralNamesInMetadataCallsForNonConformingClients;
    private Optional<Boolean> assumeLiteralUnderscoreInMetadataCallsForNonConformingClients;
    private Optional<Boolean> ssl;
    private Optional<ConnectionProperties.SslVerificationMode> sslVerification;
    private Optional<String> sslKeyStorePath;
    private Optional<String> sslKeyStorePassword;
    private Optional<String> sslKeyStoreType;
    private Optional<String> sslTrustStorePath;
    private Optional<String> sslTrustStorePassword;
    private Optional<String> sslTrustStoreType;
    private Optional<Boolean> sslUseSystemTrustStore;
    private Optional<String> kerberosServicePrincipalPattern;
    private Optional<String> kerberosRemoteServiceName;
    private Optional<Boolean> kerberosUseCanonicalHostname;
    private Optional<String> kerberosPrincipal;
    private Optional<File> kerberosConfigPath;
    private Optional<File> kerberosKeytabPath;
    private Optional<File> kerberosCredentialCachePath;
    private Optional<Boolean> kerberosDelegation;
    private Optional<GSSCredential> kerberosConstrainedDelegation;
    private Optional<String> accessToken;
    private Optional<Boolean> externalAuthentication;
    private Optional<Duration> externalAuthenticationTimeout;
    private Optional<List<ExternalRedirectStrategy>> externalRedirectStrategies;
    private Optional<KnownTokenCache> externalAuthenticationTokenCache;
    private Optional<Map<String, String>> extraCredentials;
    private Optional<String> hostnameInCertificate;
    private Optional<ZoneId> timeZone;
    private Optional<String> clientInfo;
    private Optional<String> clientTags;
    private Optional<String> traceToken;
    private Optional<Map<String, String>> sessionProperties;
    private Optional<String> source;
    private Optional<Boolean> explicitPrepare;
    private Optional<String> catalog = Optional.empty();
    private Optional<String> schema = Optional.empty();
    private final List<PropertyName> restrictedProperties;
    private final boolean useSecureConnection;

    private TrinoUri(URI uri, Optional<String> catalog, Optional<String> schema, List<PropertyName> restrictedProperties, Optional<String> user, Optional<String> password, Optional<String> sessionUser, Optional<Map<String, ClientSelectedRole>> roles, Optional<HostAndPort> socksProxy, Optional<HostAndPort> httpProxy, Optional<String> applicationNamePrefix, Optional<Boolean> disableCompression, Optional<Boolean> assumeLiteralNamesInMetadataCallsForNonConformingClients, Optional<Boolean> assumeLiteralUnderscoreInMetadataCallsForNonConformingClients, Optional<Boolean> ssl, Optional<ConnectionProperties.SslVerificationMode> sslVerification, Optional<String> sslKeyStorePath, Optional<String> sslKeyStorePassword, Optional<String> sslKeyStoreType, Optional<String> sslTrustStorePath, Optional<String> sslTrustStorePassword, Optional<String> sslTrustStoreType, Optional<Boolean> sslUseSystemTrustStore, Optional<String> kerberosServicePrincipalPattern, Optional<String> kerberosRemoteServiceName, Optional<Boolean> kerberosUseCanonicalHostname, Optional<String> kerberosPrincipal, Optional<File> kerberosConfigPath, Optional<File> kerberosKeytabPath, Optional<File> kerberosCredentialCachePath, Optional<Boolean> kerberosDelegation, Optional<GSSCredential> kerberosConstrainedDelegation, Optional<String> accessToken, Optional<Boolean> externalAuthentication, Optional<Duration> externalAuthenticationTimeout, Optional<List<ExternalRedirectStrategy>> externalRedirectStrategies, Optional<KnownTokenCache> externalAuthenticationTokenCache, Optional<Map<String, String>> extraCredentials, Optional<String> hostnameInCertificate, Optional<ZoneId> timeZone, Optional<String> clientInfo, Optional<String> clientTags, Optional<String> traceToken, Optional<Map<String, String>> sessionProperties, Optional<String> source2, Optional<Boolean> explicitPrepare) throws SQLException {
        this.uri = Objects.requireNonNull(uri, "uri is null");
        this.catalog = catalog;
        this.schema = schema;
        this.restrictedProperties = restrictedProperties;
        Map<String, Object> urlParameters = this.parseParameters(uri.getQuery());
        Properties urlProperties = new Properties();
        urlProperties.putAll(urlParameters);
        this.user = ConnectionProperties.USER.getValueOrDefault(urlProperties, user);
        this.password = ConnectionProperties.PASSWORD.getValueOrDefault(urlProperties, password);
        this.sessionUser = ConnectionProperties.SESSION_USER.getValueOrDefault(urlProperties, sessionUser);
        this.roles = ConnectionProperties.ROLES.getValueOrDefault(urlProperties, roles);
        this.socksProxy = ConnectionProperties.SOCKS_PROXY.getValueOrDefault(urlProperties, socksProxy);
        this.httpProxy = ConnectionProperties.HTTP_PROXY.getValueOrDefault(urlProperties, httpProxy);
        this.applicationNamePrefix = ConnectionProperties.APPLICATION_NAME_PREFIX.getValueOrDefault(urlProperties, applicationNamePrefix);
        this.disableCompression = ConnectionProperties.DISABLE_COMPRESSION.getValueOrDefault(urlProperties, disableCompression);
        this.assumeLiteralNamesInMetadataCallsForNonConformingClients = ConnectionProperties.ASSUME_LITERAL_NAMES_IN_METADATA_CALLS_FOR_NON_CONFORMING_CLIENTS.getValueOrDefault(urlProperties, assumeLiteralNamesInMetadataCallsForNonConformingClients);
        this.assumeLiteralUnderscoreInMetadataCallsForNonConformingClients = ConnectionProperties.ASSUME_LITERAL_UNDERSCORE_IN_METADATA_CALLS_FOR_NON_CONFORMING_CLIENTS.getValueOrDefault(urlProperties, assumeLiteralUnderscoreInMetadataCallsForNonConformingClients);
        this.ssl = ConnectionProperties.SSL.getValueOrDefault(urlProperties, ssl);
        this.sslVerification = ConnectionProperties.SSL_VERIFICATION.getValueOrDefault(urlProperties, sslVerification);
        this.sslKeyStorePath = ConnectionProperties.SSL_KEY_STORE_PATH.getValueOrDefault(urlProperties, sslKeyStorePath);
        this.sslKeyStorePassword = ConnectionProperties.SSL_KEY_STORE_PASSWORD.getValueOrDefault(urlProperties, sslKeyStorePassword);
        this.sslKeyStoreType = ConnectionProperties.SSL_KEY_STORE_TYPE.getValueOrDefault(urlProperties, sslKeyStoreType);
        this.sslTrustStorePath = ConnectionProperties.SSL_TRUST_STORE_PATH.getValueOrDefault(urlProperties, sslTrustStorePath);
        this.sslTrustStorePassword = ConnectionProperties.SSL_TRUST_STORE_PASSWORD.getValueOrDefault(urlProperties, sslTrustStorePassword);
        this.sslTrustStoreType = ConnectionProperties.SSL_TRUST_STORE_TYPE.getValueOrDefault(urlProperties, sslTrustStoreType);
        this.sslUseSystemTrustStore = ConnectionProperties.SSL_USE_SYSTEM_TRUST_STORE.getValueOrDefault(urlProperties, sslUseSystemTrustStore);
        this.kerberosServicePrincipalPattern = ConnectionProperties.KERBEROS_SERVICE_PRINCIPAL_PATTERN.getValueOrDefault(urlProperties, kerberosServicePrincipalPattern);
        this.kerberosRemoteServiceName = ConnectionProperties.KERBEROS_REMOTE_SERVICE_NAME.getValueOrDefault(urlProperties, kerberosRemoteServiceName);
        this.kerberosUseCanonicalHostname = ConnectionProperties.KERBEROS_USE_CANONICAL_HOSTNAME.getValueOrDefault(urlProperties, kerberosUseCanonicalHostname);
        this.kerberosPrincipal = ConnectionProperties.KERBEROS_PRINCIPAL.getValueOrDefault(urlProperties, kerberosPrincipal);
        this.kerberosConfigPath = ConnectionProperties.KERBEROS_CONFIG_PATH.getValueOrDefault(urlProperties, kerberosConfigPath);
        this.kerberosKeytabPath = ConnectionProperties.KERBEROS_KEYTAB_PATH.getValueOrDefault(urlProperties, kerberosKeytabPath);
        this.kerberosCredentialCachePath = ConnectionProperties.KERBEROS_CREDENTIAL_CACHE_PATH.getValueOrDefault(urlProperties, kerberosCredentialCachePath);
        this.kerberosDelegation = ConnectionProperties.KERBEROS_DELEGATION.getValueOrDefault(urlProperties, kerberosDelegation);
        this.kerberosConstrainedDelegation = ConnectionProperties.KERBEROS_CONSTRAINED_DELEGATION.getValueOrDefault(urlProperties, kerberosConstrainedDelegation);
        this.accessToken = ConnectionProperties.ACCESS_TOKEN.getValueOrDefault(urlProperties, accessToken);
        this.externalAuthentication = ConnectionProperties.EXTERNAL_AUTHENTICATION.getValueOrDefault(urlProperties, externalAuthentication);
        this.externalAuthenticationTimeout = ConnectionProperties.EXTERNAL_AUTHENTICATION_TIMEOUT.getValueOrDefault(urlProperties, externalAuthenticationTimeout);
        this.externalRedirectStrategies = ConnectionProperties.EXTERNAL_AUTHENTICATION_REDIRECT_HANDLERS.getValueOrDefault(urlProperties, externalRedirectStrategies);
        this.externalAuthenticationTokenCache = ConnectionProperties.EXTERNAL_AUTHENTICATION_TOKEN_CACHE.getValueOrDefault(urlProperties, externalAuthenticationTokenCache);
        this.extraCredentials = ConnectionProperties.EXTRA_CREDENTIALS.getValueOrDefault(urlProperties, extraCredentials);
        this.hostnameInCertificate = ConnectionProperties.HOSTNAME_IN_CERTIFICATE.getValueOrDefault(urlProperties, hostnameInCertificate);
        this.timeZone = ConnectionProperties.TIMEZONE.getValueOrDefault(urlProperties, timeZone);
        this.clientInfo = ConnectionProperties.CLIENT_INFO.getValueOrDefault(urlProperties, clientInfo);
        this.clientTags = ConnectionProperties.CLIENT_TAGS.getValueOrDefault(urlProperties, clientTags);
        this.traceToken = ConnectionProperties.TRACE_TOKEN.getValueOrDefault(urlProperties, traceToken);
        this.sessionProperties = ConnectionProperties.SESSION_PROPERTIES.getValueOrDefault(urlProperties, sessionProperties);
        this.source = ConnectionProperties.SOURCE.getValueOrDefault(urlProperties, source2);
        this.explicitPrepare = ConnectionProperties.EXPLICIT_PREPARE.getValueOrDefault(urlProperties, explicitPrepare);
        this.properties = this.buildProperties();
        this.useSecureConnection = ConnectionProperties.SSL.getValue(this.properties).orElse(uri.getScheme().equals("https") || uri.getScheme().equals("trino") && uri.getPort() == 443);
        if (!password.orElse("").isEmpty() && !this.useSecureConnection) {
            throw new SQLException("TLS/SSL required for authentication with username and password");
        }
        TrinoUri.validateConnectionProperties(this.properties);
        this.address = HostAndPort.fromParts(uri.getHost(), uri.getPort() == -1 ? (this.useSecureConnection ? 443 : 80) : uri.getPort());
        this.initCatalogAndSchema();
    }

    private Properties buildProperties() {
        Properties properties = new Properties();
        this.user.ifPresent(value -> properties.setProperty(PropertyName.USER.toString(), (String)value));
        this.password.ifPresent(value -> properties.setProperty(PropertyName.PASSWORD.toString(), (String)value));
        this.sessionUser.ifPresent(value -> properties.setProperty(PropertyName.SESSION_USER.toString(), (String)value));
        this.roles.ifPresent(value -> properties.setProperty(PropertyName.ROLES.toString(), value.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + entry.getValue()).collect(Collectors.joining(";"))));
        this.socksProxy.ifPresent(value -> properties.setProperty(PropertyName.SOCKS_PROXY.toString(), value.toString()));
        this.httpProxy.ifPresent(value -> properties.setProperty(PropertyName.HTTP_PROXY.toString(), value.toString()));
        this.applicationNamePrefix.ifPresent(value -> properties.setProperty(PropertyName.APPLICATION_NAME_PREFIX.toString(), (String)value));
        this.disableCompression.ifPresent(value -> properties.setProperty(PropertyName.DISABLE_COMPRESSION.toString(), Boolean.toString(value)));
        this.assumeLiteralNamesInMetadataCallsForNonConformingClients.ifPresent(value -> properties.setProperty(PropertyName.ASSUME_LITERAL_NAMES_IN_METADATA_CALLS_FOR_NON_CONFORMING_CLIENTS.toString(), Boolean.toString(value)));
        this.assumeLiteralUnderscoreInMetadataCallsForNonConformingClients.ifPresent(value -> properties.setProperty(PropertyName.ASSUME_LITERAL_UNDERSCORE_IN_METADATA_CALLS_FOR_NON_CONFORMING_CLIENTS.toString(), Boolean.toString(value)));
        this.ssl.ifPresent(value -> properties.setProperty(PropertyName.SSL.toString(), Boolean.toString(value)));
        this.sslVerification.ifPresent(value -> properties.setProperty(PropertyName.SSL_VERIFICATION.toString(), value.toString()));
        this.sslKeyStoreType.ifPresent(value -> properties.setProperty(PropertyName.SSL_KEY_STORE_TYPE.toString(), (String)value));
        this.sslKeyStorePath.ifPresent(value -> properties.setProperty(PropertyName.SSL_KEY_STORE_PATH.toString(), (String)value));
        this.sslKeyStorePassword.ifPresent(value -> properties.setProperty(PropertyName.SSL_KEY_STORE_PASSWORD.toString(), (String)value));
        this.sslTrustStoreType.ifPresent(value -> properties.setProperty(PropertyName.SSL_TRUST_STORE_TYPE.toString(), (String)value));
        this.sslTrustStorePath.ifPresent(value -> properties.setProperty(PropertyName.SSL_TRUST_STORE_PATH.toString(), (String)value));
        this.sslTrustStorePassword.ifPresent(value -> properties.setProperty(PropertyName.SSL_TRUST_STORE_PASSWORD.toString(), (String)value));
        this.sslUseSystemTrustStore.ifPresent(value -> properties.setProperty(PropertyName.SSL_USE_SYSTEM_TRUST_STORE.toString(), Boolean.toString(value)));
        this.kerberosServicePrincipalPattern.ifPresent(value -> properties.setProperty(PropertyName.KERBEROS_SERVICE_PRINCIPAL_PATTERN.toString(), (String)value));
        this.kerberosRemoteServiceName.ifPresent(value -> properties.setProperty(PropertyName.KERBEROS_REMOTE_SERVICE_NAME.toString(), (String)value));
        this.kerberosUseCanonicalHostname.ifPresent(value -> properties.setProperty(PropertyName.KERBEROS_USE_CANONICAL_HOSTNAME.toString(), Boolean.toString(value)));
        this.kerberosPrincipal.ifPresent(value -> properties.setProperty(PropertyName.KERBEROS_PRINCIPAL.toString(), (String)value));
        this.kerberosConfigPath.ifPresent(value -> properties.setProperty(PropertyName.KERBEROS_CONFIG_PATH.toString(), value.getPath()));
        this.kerberosKeytabPath.ifPresent(value -> properties.setProperty(PropertyName.KERBEROS_KEYTAB_PATH.toString(), value.getPath()));
        this.kerberosCredentialCachePath.ifPresent(value -> properties.setProperty(PropertyName.KERBEROS_CREDENTIAL_CACHE_PATH.toString(), value.getPath()));
        this.kerberosDelegation.ifPresent(value -> properties.setProperty(PropertyName.KERBEROS_DELEGATION.toString(), Boolean.toString(value)));
        this.kerberosConstrainedDelegation.ifPresent(value -> properties.put(PropertyName.KERBEROS_CONSTRAINED_DELEGATION.toString(), value));
        this.accessToken.ifPresent(value -> properties.setProperty(PropertyName.ACCESS_TOKEN.toString(), (String)value));
        this.externalAuthentication.ifPresent(value -> properties.setProperty(PropertyName.EXTERNAL_AUTHENTICATION.toString(), Boolean.toString(value)));
        this.externalAuthenticationTimeout.ifPresent(value -> properties.setProperty(PropertyName.EXTERNAL_AUTHENTICATION_TIMEOUT.toString(), value.toString()));
        this.externalRedirectStrategies.ifPresent(value -> properties.setProperty(PropertyName.EXTERNAL_AUTHENTICATION_REDIRECT_HANDLERS.toString(), value.stream().map(Enum::toString).collect(Collectors.joining(","))));
        this.externalAuthenticationTokenCache.ifPresent(value -> properties.setProperty(PropertyName.EXTERNAL_AUTHENTICATION_TOKEN_CACHE.toString(), value.toString()));
        this.extraCredentials.ifPresent(value -> properties.setProperty(PropertyName.EXTRA_CREDENTIALS.toString(), value.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + (String)entry.getValue()).collect(Collectors.joining(";"))));
        this.sessionProperties.ifPresent(value -> properties.setProperty(PropertyName.SESSION_PROPERTIES.toString(), value.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + (String)entry.getValue()).collect(Collectors.joining(";"))));
        this.hostnameInCertificate.ifPresent(value -> properties.setProperty(PropertyName.HOSTNAME_IN_CERTIFICATE.toString(), (String)value));
        this.timeZone.ifPresent(value -> properties.setProperty(PropertyName.TIMEZONE.toString(), value.getId()));
        this.clientInfo.ifPresent(value -> properties.setProperty(PropertyName.CLIENT_INFO.toString(), (String)value));
        this.clientTags.ifPresent(value -> properties.setProperty(PropertyName.CLIENT_TAGS.toString(), (String)value));
        this.traceToken.ifPresent(value -> properties.setProperty(PropertyName.TRACE_TOKEN.toString(), (String)value));
        this.source.ifPresent(value -> properties.setProperty(PropertyName.SOURCE.toString(), (String)value));
        this.explicitPrepare.ifPresent(value -> properties.setProperty(PropertyName.EXPLICIT_PREPARE.toString(), value.toString()));
        return properties;
    }

    protected TrinoUri(String url, Properties properties) throws SQLException {
        this(TrinoUri.parseDriverUrl(url), properties);
    }

    protected TrinoUri(URI uri, Properties driverProperties) throws SQLException {
        this.restrictedProperties = Collections.emptyList();
        this.uri = Objects.requireNonNull(uri, "uri is null");
        this.properties = this.mergeConnectionProperties(uri, driverProperties);
        TrinoUri.validateConnectionProperties(this.properties);
        this.user = ConnectionProperties.USER.getValue(this.properties);
        this.password = ConnectionProperties.PASSWORD.getValue(this.properties);
        this.sessionUser = ConnectionProperties.SESSION_USER.getValue(this.properties);
        this.roles = ConnectionProperties.ROLES.getValue(this.properties);
        this.socksProxy = ConnectionProperties.SOCKS_PROXY.getValue(this.properties);
        this.httpProxy = ConnectionProperties.HTTP_PROXY.getValue(this.properties);
        this.applicationNamePrefix = ConnectionProperties.APPLICATION_NAME_PREFIX.getValue(this.properties);
        this.disableCompression = ConnectionProperties.DISABLE_COMPRESSION.getValue(this.properties);
        this.assumeLiteralNamesInMetadataCallsForNonConformingClients = ConnectionProperties.ASSUME_LITERAL_NAMES_IN_METADATA_CALLS_FOR_NON_CONFORMING_CLIENTS.getValue(this.properties);
        this.assumeLiteralUnderscoreInMetadataCallsForNonConformingClients = ConnectionProperties.ASSUME_LITERAL_UNDERSCORE_IN_METADATA_CALLS_FOR_NON_CONFORMING_CLIENTS.getValue(this.properties);
        this.ssl = ConnectionProperties.SSL.getValue(this.properties);
        this.sslVerification = ConnectionProperties.SSL_VERIFICATION.getValue(this.properties);
        this.sslKeyStorePath = ConnectionProperties.SSL_KEY_STORE_PATH.getValue(this.properties);
        this.sslKeyStorePassword = ConnectionProperties.SSL_KEY_STORE_PASSWORD.getValue(this.properties);
        this.sslKeyStoreType = ConnectionProperties.SSL_KEY_STORE_TYPE.getValue(this.properties);
        this.sslTrustStorePath = ConnectionProperties.SSL_TRUST_STORE_PATH.getValue(this.properties);
        this.sslTrustStorePassword = ConnectionProperties.SSL_TRUST_STORE_PASSWORD.getValue(this.properties);
        this.sslTrustStoreType = ConnectionProperties.SSL_TRUST_STORE_TYPE.getValue(this.properties);
        this.sslUseSystemTrustStore = ConnectionProperties.SSL_USE_SYSTEM_TRUST_STORE.getValue(this.properties);
        this.kerberosServicePrincipalPattern = ConnectionProperties.KERBEROS_SERVICE_PRINCIPAL_PATTERN.getValue(this.properties);
        this.kerberosRemoteServiceName = ConnectionProperties.KERBEROS_REMOTE_SERVICE_NAME.getValue(this.properties);
        this.kerberosUseCanonicalHostname = ConnectionProperties.KERBEROS_USE_CANONICAL_HOSTNAME.getValue(this.properties);
        this.kerberosPrincipal = ConnectionProperties.KERBEROS_PRINCIPAL.getValue(this.properties);
        this.kerberosConfigPath = ConnectionProperties.KERBEROS_CONFIG_PATH.getValue(this.properties);
        this.kerberosKeytabPath = ConnectionProperties.KERBEROS_KEYTAB_PATH.getValue(this.properties);
        this.kerberosCredentialCachePath = ConnectionProperties.KERBEROS_CREDENTIAL_CACHE_PATH.getValue(this.properties);
        this.kerberosDelegation = ConnectionProperties.KERBEROS_DELEGATION.getValue(this.properties);
        this.kerberosConstrainedDelegation = ConnectionProperties.KERBEROS_CONSTRAINED_DELEGATION.getValue(this.properties);
        this.accessToken = ConnectionProperties.ACCESS_TOKEN.getValue(this.properties);
        this.externalAuthentication = ConnectionProperties.EXTERNAL_AUTHENTICATION.getValue(this.properties);
        this.externalAuthenticationTimeout = ConnectionProperties.EXTERNAL_AUTHENTICATION_TIMEOUT.getValue(this.properties);
        this.externalRedirectStrategies = ConnectionProperties.EXTERNAL_AUTHENTICATION_REDIRECT_HANDLERS.getValue(this.properties);
        this.externalAuthenticationTokenCache = ConnectionProperties.EXTERNAL_AUTHENTICATION_TOKEN_CACHE.getValue(this.properties);
        this.extraCredentials = ConnectionProperties.EXTRA_CREDENTIALS.getValue(this.properties);
        this.hostnameInCertificate = ConnectionProperties.HOSTNAME_IN_CERTIFICATE.getValue(this.properties);
        this.timeZone = ConnectionProperties.TIMEZONE.getValue(this.properties);
        this.clientInfo = ConnectionProperties.CLIENT_INFO.getValue(this.properties);
        this.clientTags = ConnectionProperties.CLIENT_TAGS.getValue(this.properties);
        this.traceToken = ConnectionProperties.TRACE_TOKEN.getValue(this.properties);
        this.sessionProperties = ConnectionProperties.SESSION_PROPERTIES.getValue(this.properties);
        this.source = ConnectionProperties.SOURCE.getValue(this.properties);
        this.explicitPrepare = ConnectionProperties.EXPLICIT_PREPARE.getValue(this.properties);
        this.useSecureConnection = this.ssl.orElse(uri.getScheme().equals("https") || uri.getScheme().equals("trino") && uri.getPort() == 443);
        this.address = HostAndPort.fromParts(uri.getHost(), uri.getPort() == -1 ? (this.useSecureConnection ? 443 : 80) : uri.getPort());
        this.initCatalogAndSchema();
    }

    public static TrinoUri create(String url, Properties properties) throws SQLException {
        return new TrinoUri(url, MoreObjects.firstNonNull(properties, new Properties()));
    }

    public static TrinoUri create(URI uri, Properties properties) throws SQLException {
        return new TrinoUri(uri, MoreObjects.firstNonNull(properties, new Properties()));
    }

    public URI getUri() {
        return this.uri;
    }

    public Optional<String> getSchema() {
        return this.schema;
    }

    public Optional<String> getCatalog() {
        return this.catalog;
    }

    public URI getHttpUri() {
        return this.buildHttpUri();
    }

    public String getRequiredUser() throws SQLException {
        return TrinoUri.checkRequired(this.user, PropertyName.USER);
    }

    public static <T> T checkRequired(Optional<T> obj, PropertyName name) throws SQLException {
        return obj.orElseThrow(() -> new SQLException(String.format("Connection property '%s' is required", new Object[]{name})));
    }

    public Optional<String> getUser() {
        return this.user;
    }

    public boolean hasPassword() {
        return this.password.isPresent();
    }

    public Optional<String> getSessionUser() {
        return this.sessionUser;
    }

    public Map<String, ClientSelectedRole> getRoles() {
        return this.roles.orElse(ImmutableMap.of());
    }

    public Optional<String> getApplicationNamePrefix() {
        return this.applicationNamePrefix;
    }

    public Map<String, String> getExtraCredentials() {
        return this.extraCredentials.orElse(ImmutableMap.of());
    }

    public Optional<String> getClientInfo() {
        return this.clientInfo;
    }

    public Optional<String> getClientTags() {
        return this.clientTags;
    }

    public Optional<String> getTraceToken() {
        return this.traceToken;
    }

    public Map<String, String> getSessionProperties() {
        return this.sessionProperties.orElse(ImmutableMap.of());
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public Optional<Boolean> getExplicitPrepare() {
        return this.explicitPrepare;
    }

    public boolean isCompressionDisabled() {
        return this.disableCompression.orElse(false);
    }

    public boolean isAssumeLiteralNamesInMetadataCallsForNonConformingClients() {
        return this.assumeLiteralNamesInMetadataCallsForNonConformingClients.orElse(false);
    }

    public boolean isAssumeLiteralUnderscoreInMetadataCallsForNonConformingClients() {
        return this.assumeLiteralUnderscoreInMetadataCallsForNonConformingClients.orElse(false);
    }

    public ZoneId getTimeZone() {
        return this.timeZone.orElseGet(ZoneId::systemDefault);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        Properties properties = TrinoUri.urlProperties(url, info);
        return (DriverPropertyInfo[])ConnectionProperties.allProperties().stream().filter(property -> property.isValid(properties)).map(property -> property.getDriverPropertyInfo(properties)).toArray(DriverPropertyInfo[]::new);
    }

    private static Properties urlProperties(String url, Properties info) {
        try {
            return TrinoUri.create(url, info).getProperties();
        }
        catch (SQLException e) {
            return info;
        }
    }

    public Consumer<OkHttpClient.Builder> getSetupSsl() {
        if (!this.useSecureConnection) {
            return OkHttpUtil::setupInsecureSsl;
        }
        ConnectionProperties.SslVerificationMode sslVerificationMode = this.sslVerification.orElse(ConnectionProperties.SslVerificationMode.FULL);
        if (sslVerificationMode.equals((Object)ConnectionProperties.SslVerificationMode.NONE)) {
            return OkHttpUtil::setupInsecureSsl;
        }
        return builder -> OkHttpUtil.setupSsl(builder, this.sslKeyStorePath, this.sslKeyStorePassword, this.sslKeyStoreType, this.sslTrustStorePath, this.sslTrustStorePassword, this.sslTrustStoreType, this.sslUseSystemTrustStore.orElse(false));
    }

    public void setupClient(OkHttpClient.Builder builder) throws SQLException {
        try {
            OkHttpUtil.setupCookieJar(builder);
            OkHttpUtil.setupSocksProxy(builder, this.socksProxy);
            OkHttpUtil.setupHttpProxy(builder, this.httpProxy);
            String password = this.password.orElse("");
            if (!password.isEmpty()) {
                if (!this.useSecureConnection) {
                    throw new SQLException("TLS/SSL is required for authentication with username and password");
                }
                builder.addInterceptor(OkHttpUtil.basicAuth(this.getRequiredUser(), password));
            }
            if (this.useSecureConnection) {
                ConnectionProperties.SslVerificationMode sslVerificationMode = this.sslVerification.orElse(ConnectionProperties.SslVerificationMode.FULL);
                if (sslVerificationMode.equals((Object)ConnectionProperties.SslVerificationMode.FULL) || sslVerificationMode.equals((Object)ConnectionProperties.SslVerificationMode.CA)) {
                    OkHttpUtil.setupSsl(builder, this.sslKeyStorePath, this.sslKeyStorePassword, this.sslKeyStoreType, this.sslTrustStorePath, this.sslTrustStorePassword, this.sslTrustStoreType, this.sslUseSystemTrustStore.orElse(false));
                }
                if (sslVerificationMode.equals((Object)ConnectionProperties.SslVerificationMode.FULL)) {
                    ConnectionProperties.HOSTNAME_IN_CERTIFICATE.getValue(this.properties).ifPresent(certHostname -> OkHttpUtil.setupAlternateHostnameVerification(builder, certHostname));
                }
                if (sslVerificationMode.equals((Object)ConnectionProperties.SslVerificationMode.CA)) {
                    builder.hostnameVerifier((hostname, session) -> true);
                }
                if (sslVerificationMode.equals((Object)ConnectionProperties.SslVerificationMode.NONE)) {
                    OkHttpUtil.setupInsecureSsl(builder);
                }
            }
            if (this.kerberosRemoteServiceName.isPresent()) {
                if (!this.useSecureConnection) {
                    throw new SQLException("TLS/SSL is required for Kerberos authentication");
                }
                OkHttpUtil.setupKerberos(builder, TrinoUri.checkRequired(this.kerberosServicePrincipalPattern, PropertyName.KERBEROS_SERVICE_PRINCIPAL_PATTERN), TrinoUri.checkRequired(this.kerberosRemoteServiceName, PropertyName.KERBEROS_REMOTE_SERVICE_NAME), TrinoUri.checkRequired(this.kerberosUseCanonicalHostname, PropertyName.KERBEROS_USE_CANONICAL_HOSTNAME), this.kerberosPrincipal, this.kerberosConfigPath, this.kerberosKeytabPath, Optional.ofNullable(this.kerberosCredentialCachePath.orElseGet(() -> KerberosUtil.defaultCredentialCachePath().map(File::new).orElse(null))), this.kerberosDelegation.orElse(false), this.kerberosConstrainedDelegation);
            }
            if (this.accessToken.isPresent()) {
                if (!this.useSecureConnection) {
                    throw new SQLException("TLS/SSL required for authentication using an access token");
                }
                builder.addNetworkInterceptor(OkHttpUtil.tokenAuth(this.accessToken.get()));
            }
            if (this.externalAuthentication.orElse(false).booleanValue()) {
                if (!this.useSecureConnection) {
                    throw new SQLException("TLS/SSL required for authentication using external authorization");
                }
                HttpTokenPoller poller = new HttpTokenPoller(builder.build());
                java.time.Duration timeout2 = this.externalAuthenticationTimeout.map(value -> java.time.Duration.ofMillis(value.toMillis())).orElse(java.time.Duration.ofMinutes(2L));
                KnownTokenCache knownTokenCache = this.externalAuthenticationTokenCache.orElse(KnownTokenCache.NONE);
                Optional<RedirectHandler> configuredHandler = this.externalRedirectStrategies.map(CompositeRedirectHandler::new).map(RedirectHandler.class::cast);
                RedirectHandler redirectHandler = Optional.ofNullable(REDIRECT_HANDLER.get()).orElseGet(() -> (RedirectHandler)configuredHandler.orElseThrow(() -> new RuntimeException("External authentication redirect handler is not configured")));
                ExternalAuthenticator authenticator = new ExternalAuthenticator(redirectHandler, poller, knownTokenCache.create(), timeout2);
                builder.authenticator(authenticator);
                builder.addNetworkInterceptor(authenticator);
            }
            Optional<String> resolverContext = ConnectionProperties.DNS_RESOLVER_CONTEXT.getValue(this.properties);
            ConnectionProperties.DNS_RESOLVER.getValue(this.properties).ifPresent(resolverClass -> builder.dns(TrinoUri.instantiateDnsResolver(resolverClass, resolverContext)::lookup));
        }
        catch (ClientException e) {
            throw new SQLException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw new SQLException("Error setting up connection", e);
        }
    }

    private static DnsResolver instantiateDnsResolver(Class<? extends DnsResolver> resolverClass, Optional<String> context) {
        try {
            return resolverClass.getConstructor(String.class).newInstance(context.orElse(null));
        }
        catch (ReflectiveOperationException e) {
            throw new ClientException("Unable to instantiate custom DNS resolver " + resolverClass.getName(), e);
        }
    }

    private Map<String, Object> parseParameters(String query) throws SQLException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (query == null) {
            return result;
        }
        Iterable<String> queryArgs = QUERY_SPLITTER.split(query);
        for (String queryArg : queryArgs) {
            List<String> parts = ARG_SPLITTER.splitToList(queryArg);
            if (parts.size() != 2) {
                throw new SQLException(String.format("Connection argument is not a valid connection property: '%s'", queryArg));
            }
            String key = parts.get(0);
            PropertyName name = PropertyName.findByKey(key).orElseThrow(() -> new SQLException(String.format("Unrecognized connection property '%s'", key)));
            if (this.restrictedProperties.contains((Object)name)) {
                throw new RestrictedPropertyException(name, String.format("Connection property %s cannot be set in the URL", parts.get(0)));
            }
            if (result.put(parts.get(0), parts.get(1)) == null) continue;
            throw new SQLException(String.format("Connection property %s is in the URL multiple times", parts.get(0)));
        }
        return result;
    }

    private static URI parseDriverUrl(String url) throws SQLException {
        TrinoUri.validatePrefix(url);
        URI uri = TrinoUri.parseUrl(url);
        if (Strings.isNullOrEmpty(uri.getHost())) {
            throw new SQLException("No host specified: " + url);
        }
        if (uri.getPort() == -1) {
            throw new SQLException("No port number specified: " + url);
        }
        if (uri.getPort() < 1 || uri.getPort() > 65535) {
            throw new SQLException("Invalid port number: " + url);
        }
        return uri;
    }

    private static URI parseUrl(String url) throws SQLException {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new SQLException("Invalid Trino URL: " + url, e);
        }
    }

    private static void validatePrefix(String url) throws SQLException {
        if (!url.startsWith(URL_START)) {
            throw new SQLException("Invalid Trino URL: " + url);
        }
        if (url.equals(URL_START)) {
            throw new SQLException("Empty Trino URL: " + url);
        }
    }

    private URI buildHttpUri() {
        String scheme = this.useSecureConnection ? "https" : "http";
        try {
            return new URI(scheme, null, this.address.getHost(), this.address.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void initCatalogAndSchema() throws SQLException {
        String path = this.uri.getPath();
        if (Strings.isNullOrEmpty(this.uri.getPath()) || path.equals("/")) {
            return;
        }
        if (!path.startsWith("/")) {
            throw new SQLException("Path does not start with a slash: " + this.uri);
        }
        path = path.substring(1);
        List<String> parts = Splitter.on("/").splitToList(path);
        if (parts.get(parts.size() - 1).isEmpty()) {
            parts = parts.subList(0, parts.size() - 1);
        }
        if (parts.size() > 2) {
            throw new SQLException("Invalid path segments in URL: " + this.uri);
        }
        if (parts.get(0).isEmpty()) {
            throw new SQLException("Catalog name is empty: " + this.uri);
        }
        if (this.catalog.isPresent()) {
            throw new RestrictedPropertyException(PropertyName.CATALOG, "Catalog cannot be set in the URL");
        }
        this.catalog = Optional.ofNullable(parts.get(0));
        if (parts.size() > 1) {
            if (parts.get(1).isEmpty()) {
                throw new SQLException("Schema name is empty: " + this.uri);
            }
            if (this.schema.isPresent()) {
                throw new RestrictedPropertyException(PropertyName.SCHEMA, "Schema cannot be set in the URL");
            }
            this.schema = Optional.ofNullable(parts.get(1));
        }
    }

    private Properties mergeConnectionProperties(URI uri, Properties driverProperties) throws SQLException {
        Map<String, Object> urlProperties = this.parseParameters(uri.getQuery());
        Map suppliedProperties = driverProperties.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> (String)entry.getKey(), Map.Entry::getValue));
        for (String key : urlProperties.keySet()) {
            if (!suppliedProperties.containsKey(key)) continue;
            throw new SQLException(String.format("Connection property %s is both in the URL and an argument", key));
        }
        Properties result = new Properties();
        TrinoUri.setProperties(result, suppliedProperties);
        TrinoUri.setProperties(result, urlProperties);
        return result;
    }

    private static void setProperties(Properties properties, Map<String, Object> values2) {
        properties.putAll(values2);
    }

    private static void validateConnectionProperties(Properties connectionProperties) throws SQLException {
        for (String string : connectionProperties.stringPropertyNames()) {
            if (ConnectionProperties.forKey(string) != null) continue;
            throw new SQLException(String.format("Unrecognized connection property '%s'", string));
        }
        for (ConnectionProperty connectionProperty : ConnectionProperties.allProperties()) {
            connectionProperty.validate(connectionProperties);
        }
    }

    @VisibleForTesting
    public static void setRedirectHandler(RedirectHandler handler) {
        REDIRECT_HANDLER.set(Objects.requireNonNull(handler, "handler is null"));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private URI uri;
        private String catalog;
        private String schema;
        private List<PropertyName> restrictedProperties;
        private String user;
        private String password;
        private String sessionUser;
        private Map<String, ClientSelectedRole> roles;
        private HostAndPort socksProxy;
        private HostAndPort httpProxy;
        private String applicationNamePrefix;
        private Boolean disableCompression;
        private Boolean assumeLiteralNamesInMetadataCallsForNonConformingClients;
        private Boolean assumeLiteralUnderscoreInMetadataCallsForNonConformingClients;
        private Boolean ssl;
        private ConnectionProperties.SslVerificationMode sslVerification;
        private String sslKeyStorePath;
        private String sslKeyStorePassword;
        private String sslKeyStoreType;
        private String sslTrustStorePath;
        private String sslTrustStorePassword;
        private String sslTrustStoreType;
        private Boolean sslUseSystemTrustStore;
        private String kerberosServicePrincipalPattern;
        private String kerberosRemoteServiceName;
        private Boolean kerberosUseCanonicalHostname;
        private String kerberosPrincipal;
        private File kerberosConfigPath;
        private File kerberosKeytabPath;
        private File kerberosCredentialCachePath;
        private Boolean kerberosDelegation;
        private GSSCredential kerberosConstrainedDelegation;
        private String accessToken;
        private Boolean externalAuthentication;
        private Duration externalAuthenticationTimeout;
        private List<ExternalRedirectStrategy> externalRedirectStrategies;
        private KnownTokenCache externalAuthenticationTokenCache;
        private Map<String, String> extraCredentials;
        private String hostnameInCertificate;
        private ZoneId timeZone;
        private String clientInfo;
        private String clientTags;
        private String traceToken;
        private Map<String, String> sessionProperties;
        private String source;
        private Boolean explicitPrepare;

        private Builder() {
        }

        public Builder setUri(URI uri) {
            this.uri = Objects.requireNonNull(uri, "uri is null");
            return this;
        }

        public Builder setCatalog(String catalog) {
            this.catalog = Objects.requireNonNull(catalog, "catalog is null");
            return this;
        }

        public Builder setSchema(String schema) {
            this.schema = Objects.requireNonNull(schema, "schema is null");
            return this;
        }

        public Builder setRestrictedProperties(List<PropertyName> restrictedProperties) {
            this.restrictedProperties = Objects.requireNonNull(restrictedProperties, "restrictedProperties is null");
            return this;
        }

        public Builder setUser(String user) {
            this.user = Objects.requireNonNull(user, "user is null");
            return this;
        }

        public Builder setPassword(String password) {
            this.password = Objects.requireNonNull(password, "password is null");
            return this;
        }

        public Builder setSessionUser(String sessionUser) {
            this.sessionUser = Objects.requireNonNull(sessionUser, "sessionUser is null");
            return this;
        }

        public Builder setRoles(Map<String, ClientSelectedRole> roles) {
            this.roles = Objects.requireNonNull(roles, "roles is null");
            return this;
        }

        public Builder setSocksProxy(HostAndPort socksProxy) {
            this.socksProxy = Objects.requireNonNull(socksProxy, "socksProxy is null");
            return this;
        }

        public Builder setHttpProxy(HostAndPort httpProxy) {
            this.httpProxy = Objects.requireNonNull(httpProxy, "httpProxy is null");
            return this;
        }

        public Builder setApplicationNamePrefix(String applicationNamePrefix) {
            this.applicationNamePrefix = Objects.requireNonNull(applicationNamePrefix, "applicationNamePrefix is null");
            return this;
        }

        public Builder setDisableCompression(Boolean disableCompression) {
            this.disableCompression = Objects.requireNonNull(disableCompression, "disableCompression is null");
            return this;
        }

        public Builder setAssumeLiteralNamesInMetadataCallsForNonConformingClients(Boolean assumeLiteralNamesInMetadataCallsForNonConformingClients) {
            this.assumeLiteralNamesInMetadataCallsForNonConformingClients = Objects.requireNonNull(assumeLiteralNamesInMetadataCallsForNonConformingClients, "assumeLiteralNamesInMetadataCallsForNonConformingClients is null");
            return this;
        }

        public Builder setAssumeLiteralUnderscoreInMetadataCallsForNonConformingClients(Boolean assumeLiteralUnderscoreInMetadataCallsForNonConformingClients) {
            this.assumeLiteralUnderscoreInMetadataCallsForNonConformingClients = Objects.requireNonNull(assumeLiteralUnderscoreInMetadataCallsForNonConformingClients, "assumeLiteralUnderscoreInMetadataCallsForNonConformingClients is null");
            return this;
        }

        public Builder setSsl(Boolean ssl) {
            this.ssl = Objects.requireNonNull(ssl, "ssl is null");
            return this;
        }

        public Builder setSslVerificationNone() {
            this.sslVerification = ConnectionProperties.SslVerificationMode.NONE;
            return this;
        }

        public Builder setSslKeyStorePath(String sslKeyStorePath) {
            this.sslKeyStorePath = Objects.requireNonNull(sslKeyStorePath, "sslKeyStorePath is null");
            return this;
        }

        public Builder setSslKeyStorePassword(String sslKeyStorePassword) {
            this.sslKeyStorePassword = Objects.requireNonNull(sslKeyStorePassword, "sslKeyStorePassword is null");
            return this;
        }

        public Builder setSslKeyStoreType(String sslKeyStoreType) {
            this.sslKeyStoreType = Objects.requireNonNull(sslKeyStoreType, "sslKeyStoreType is null");
            return this;
        }

        public Builder setSslTrustStorePath(String sslTrustStorePath) {
            this.sslTrustStorePath = Objects.requireNonNull(sslTrustStorePath, "sslTrustStorePath is null");
            return this;
        }

        public Builder setSslTrustStorePassword(String sslTrustStorePassword) {
            this.sslTrustStorePassword = Objects.requireNonNull(sslTrustStorePassword, "sslTrustStorePassword is null");
            return this;
        }

        public Builder setSslTrustStoreType(String sslTrustStoreType) {
            this.sslTrustStoreType = Objects.requireNonNull(sslTrustStoreType, "sslTrustStoreType is null");
            return this;
        }

        public Builder setSslUseSystemTrustStore(Boolean sslUseSystemTrustStore) {
            this.sslUseSystemTrustStore = Objects.requireNonNull(sslUseSystemTrustStore, "sslUseSystemTrustStore is null");
            return this;
        }

        public Builder setKerberosServicePrincipalPattern(String kerberosServicePrincipalPattern) {
            this.kerberosServicePrincipalPattern = Objects.requireNonNull(kerberosServicePrincipalPattern, "kerberosServicePrincipalPattern is null");
            return this;
        }

        public Builder setKerberosRemoveServiceName(String kerberosRemoteServiceName) {
            this.kerberosRemoteServiceName = Objects.requireNonNull(kerberosRemoteServiceName, "kerberosRemoteServiceName is null");
            return this;
        }

        public Builder setKerberosUseCanonicalHostname(Boolean kerberosUseCanonicalHostname) {
            this.kerberosUseCanonicalHostname = Objects.requireNonNull(kerberosUseCanonicalHostname, "kerberosUseCanonicalHostname is null");
            return this;
        }

        public Builder setKerberosPrincipal(String kerberosPrincipal) {
            this.kerberosPrincipal = Objects.requireNonNull(kerberosPrincipal, "kerberosPrincipal is null");
            return this;
        }

        public Builder setKerberosConfigPath(String kerberosConfigPath) {
            return this.setKerberosConfigPath(new File(Objects.requireNonNull(kerberosConfigPath, "kerberosConfigPath is null")));
        }

        public Builder setKerberosConfigPath(File kerberosConfigPath) {
            this.kerberosConfigPath = Objects.requireNonNull(kerberosConfigPath, "kerberosConfigPath is null");
            return this;
        }

        public Builder setKerberosKeytabPath(String kerberosKeytabPath) {
            return this.setKerberosKeytabPath(new File(Objects.requireNonNull(kerberosKeytabPath, "kerberosKeytabPath is null")));
        }

        public Builder setKerberosKeytabPath(File kerberosKeytabPath) {
            this.kerberosKeytabPath = Objects.requireNonNull(kerberosKeytabPath, "kerberosKeytabPath is null");
            return this;
        }

        public Builder setKerberosCredentialCachePath(String kerberosCredentialCachePath) {
            return this.setKerberosCredentialCachePath(new File(Objects.requireNonNull(kerberosCredentialCachePath, "kerberosCredentialCachePath is null")));
        }

        public Builder setKerberosCredentialCachePath(File kerberosCredentialCachePath) {
            this.kerberosCredentialCachePath = Objects.requireNonNull(kerberosCredentialCachePath, "kerberosCredentialCachePath is null");
            return this;
        }

        public Builder setKerberosDelegation(Boolean kerberosDelegation) {
            this.kerberosDelegation = Objects.requireNonNull(kerberosDelegation, "kerberosDelegation is null");
            return this;
        }

        public Builder setKerberosConstrainedDelegation(GSSCredential kerberosConstrainedDelegation) {
            this.kerberosConstrainedDelegation = Objects.requireNonNull(kerberosConstrainedDelegation, "kerberosConstrainedDelegation is null");
            return this;
        }

        public Builder setAccessToken(String accessToken) {
            this.accessToken = Objects.requireNonNull(accessToken, "accessToken is null");
            return this;
        }

        public Builder setExternalAuthentication(Boolean externalAuthentication) {
            this.externalAuthentication = Objects.requireNonNull(externalAuthentication, "externalAuthentication is null");
            return this;
        }

        public Builder setExternalAuthenticationTimeout(Duration externalAuthenticationTimeout) {
            this.externalAuthenticationTimeout = Objects.requireNonNull(externalAuthenticationTimeout, "externalAuthenticationTimeout is null");
            return this;
        }

        public Builder setExternalRedirectStrategies(List<ExternalRedirectStrategy> externalRedirectStrategies) {
            this.externalRedirectStrategies = Objects.requireNonNull(externalRedirectStrategies, "externalRedirectStrategies is null");
            return this;
        }

        public Builder setExternalAuthenticationTokenCache(KnownTokenCache externalAuthenticationTokenCache) {
            this.externalAuthenticationTokenCache = Objects.requireNonNull(externalAuthenticationTokenCache, "externalAuthenticationTokenCache is null");
            return this;
        }

        public Builder setExtraCredentials(Map<String, String> extraCredentials) {
            this.extraCredentials = Objects.requireNonNull(extraCredentials, "extraCredentials is null");
            return this;
        }

        public Builder setHostnameInCertificate(String hostnameInCertificate) {
            this.hostnameInCertificate = Objects.requireNonNull(hostnameInCertificate, "hostnameInCertificate is null");
            return this;
        }

        public Builder setTimeZone(ZoneId timeZone) {
            this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
            return this;
        }

        public Builder setClientInfo(String clientInfo) {
            this.clientInfo = Objects.requireNonNull(clientInfo, "clientInfo is null");
            return this;
        }

        public Builder setClientTags(String clientTags) {
            this.clientTags = Objects.requireNonNull(clientTags, "clientTags is null");
            return this;
        }

        public Builder setTraceToken(String traceToken) {
            this.traceToken = Objects.requireNonNull(traceToken, "traceToken is null");
            return this;
        }

        public Builder setSessionProperties(Map<String, String> sessionProperties) {
            this.sessionProperties = Objects.requireNonNull(sessionProperties, "sessionProperties is null");
            return this;
        }

        public Builder setSource(String source2) {
            this.source = Objects.requireNonNull(source2, "source is null");
            return this;
        }

        public Builder setExplicitPrepare(Boolean explicitPrepare) {
            this.explicitPrepare = Objects.requireNonNull(explicitPrepare, "explicitPrepare is null");
            return this;
        }

        public TrinoUri build() throws SQLException {
            return new TrinoUri(this.uri, Optional.ofNullable(this.catalog), Optional.ofNullable(this.schema), this.restrictedProperties, Optional.ofNullable(this.user), Optional.ofNullable(this.password), Optional.ofNullable(this.sessionUser), Optional.ofNullable(this.roles), Optional.ofNullable(this.socksProxy), Optional.ofNullable(this.httpProxy), Optional.ofNullable(this.applicationNamePrefix), Optional.ofNullable(this.disableCompression), Optional.ofNullable(this.assumeLiteralNamesInMetadataCallsForNonConformingClients), Optional.ofNullable(this.assumeLiteralUnderscoreInMetadataCallsForNonConformingClients), Optional.ofNullable(this.ssl), Optional.ofNullable(this.sslVerification), Optional.ofNullable(this.sslKeyStorePath), Optional.ofNullable(this.sslKeyStorePassword), Optional.ofNullable(this.sslKeyStoreType), Optional.ofNullable(this.sslTrustStorePath), Optional.ofNullable(this.sslTrustStorePassword), Optional.ofNullable(this.sslTrustStoreType), Optional.ofNullable(this.sslUseSystemTrustStore), Optional.ofNullable(this.kerberosServicePrincipalPattern), Optional.ofNullable(this.kerberosRemoteServiceName), Optional.ofNullable(this.kerberosUseCanonicalHostname), Optional.ofNullable(this.kerberosPrincipal), Optional.ofNullable(this.kerberosConfigPath), Optional.ofNullable(this.kerberosKeytabPath), Optional.ofNullable(this.kerberosCredentialCachePath), Optional.ofNullable(this.kerberosDelegation), Optional.ofNullable(this.kerberosConstrainedDelegation), Optional.ofNullable(this.accessToken), Optional.ofNullable(this.externalAuthentication), Optional.ofNullable(this.externalAuthenticationTimeout), Optional.ofNullable(this.externalRedirectStrategies), Optional.ofNullable(this.externalAuthenticationTokenCache), Optional.ofNullable(this.extraCredentials), Optional.ofNullable(this.hostnameInCertificate), Optional.ofNullable(this.timeZone), Optional.ofNullable(this.clientInfo), Optional.ofNullable(this.clientTags), Optional.ofNullable(this.traceToken), Optional.ofNullable(this.sessionProperties), Optional.ofNullable(this.source), Optional.ofNullable(this.explicitPrepare));
        }
    }
}

