/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.uri;

import io.trino.jdbc.$internal.client.ClientException;
import io.trino.jdbc.$internal.client.DnsResolver;
import io.trino.jdbc.$internal.client.KerberosUtil;
import io.trino.jdbc.$internal.client.OkHttpUtil;
import io.trino.jdbc.$internal.client.auth.external.CompositeRedirectHandler;
import io.trino.jdbc.$internal.client.auth.external.ExternalAuthenticator;
import io.trino.jdbc.$internal.client.auth.external.HttpTokenPoller;
import io.trino.jdbc.$internal.client.auth.external.RedirectHandler;
import io.trino.jdbc.$internal.client.uri.ConnectionProperties;
import io.trino.jdbc.$internal.client.uri.KnownTokenCache;
import io.trino.jdbc.$internal.client.uri.TrinoUri;
import io.trino.jdbc.$internal.okhttp3.OkHttpClient;
import java.io.File;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class HttpClientFactory {
    private HttpClientFactory() {
    }

    public static OkHttpClient.Builder toHttpClientBuilder(TrinoUri uri, String userAgent) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        HttpClientFactory.setupUserAgent(builder, userAgent);
        OkHttpUtil.setupCookieJar(builder);
        OkHttpUtil.setupSocksProxy(builder, uri.getSocksProxy());
        OkHttpUtil.setupHttpProxy(builder, uri.getHttpProxy());
        OkHttpUtil.setupTimeouts(builder, Math.toIntExact(uri.getTimeout().toMillis()), TimeUnit.MILLISECONDS);
        OkHttpUtil.setupHttpLogging(builder, uri.getHttpLoggingLevel());
        if (!uri.isUseSecureConnection()) {
            OkHttpUtil.setupInsecureSsl(builder);
        }
        if (uri.hasPassword()) {
            if (!uri.isUseSecureConnection()) {
                throw new RuntimeException("TLS/SSL is required for authentication with username and password");
            }
            builder.addInterceptor(OkHttpUtil.basicAuth(uri.getRequiredUser(), uri.getPassword().orElseThrow(() -> new RuntimeException("Password expected"))));
        }
        if (uri.isUseSecureConnection()) {
            ConnectionProperties.SslVerificationMode sslVerificationMode = uri.getSslVerification();
            if (sslVerificationMode.equals((Object)ConnectionProperties.SslVerificationMode.FULL) || sslVerificationMode.equals((Object)ConnectionProperties.SslVerificationMode.CA)) {
                OkHttpUtil.setupSsl(builder, uri.getSslKeyStorePath(), uri.getSslKeyStorePassword(), uri.getSslKeyStoreType(), uri.getSslUseSystemKeyStore(), uri.getSslTrustStorePath(), uri.getSslTrustStorePassword(), uri.getSslTrustStoreType(), uri.getSslUseSystemTrustStore());
            }
            if (sslVerificationMode.equals((Object)ConnectionProperties.SslVerificationMode.FULL)) {
                uri.getHostnameInCertificate().ifPresent(certHostname -> OkHttpUtil.setupAlternateHostnameVerification(builder, certHostname));
            }
            if (sslVerificationMode.equals((Object)ConnectionProperties.SslVerificationMode.CA)) {
                builder.hostnameVerifier((hostname, session) -> true);
            }
            if (sslVerificationMode.equals((Object)ConnectionProperties.SslVerificationMode.NONE)) {
                OkHttpUtil.setupInsecureSsl(builder);
            }
        }
        if (uri.getKerberosRemoteServiceName().isPresent()) {
            if (!uri.isUseSecureConnection()) {
                throw new RuntimeException("TLS/SSL is required for Kerberos authentication");
            }
            OkHttpUtil.setupKerberos(builder, uri.getRequiredKerberosServicePrincipalPattern(), uri.getRequiredKerberosRemoteServiceName(), uri.getRequiredKerberosUseCanonicalHostname(), uri.getKerberosPrincipal(), uri.getKerberosConfigPath(), uri.getKerberosKeytabPath(), Optional.ofNullable(uri.getKerberosCredentialCachePath().orElseGet(() -> KerberosUtil.defaultCredentialCachePath().map(File::new).orElse(null))), uri.getKerberosDelegation(), uri.getKerberosConstrainedDelegation());
        }
        if (uri.getAccessToken().isPresent()) {
            if (!uri.isUseSecureConnection()) {
                throw new RuntimeException("TLS/SSL required for authentication using an access token");
            }
            builder.addInterceptor(OkHttpUtil.tokenAuth(uri.getAccessToken().get()));
        }
        if (uri.isExternalAuthenticationEnabled()) {
            if (!uri.isUseSecureConnection()) {
                throw new RuntimeException("TLS/SSL required for authentication using external authorization");
            }
            HttpTokenPoller poller = new HttpTokenPoller(builder.build());
            Duration timeout2 = uri.getExternalAuthenticationTimeout().map(value -> Duration.ofMillis(value.toMillis())).orElse(Duration.ofMinutes(2L));
            KnownTokenCache knownTokenCache = uri.getExternalAuthenticationTokenCache();
            Optional<RedirectHandler> configuredHandler = uri.getExternalRedirectStrategies().map(CompositeRedirectHandler::new).map(RedirectHandler.class::cast);
            RedirectHandler redirectHandler = TrinoUri.getRedirectHandler().orElseGet(() -> (RedirectHandler)configuredHandler.orElseThrow(() -> new RuntimeException("External authentication redirect handler is not configured")));
            ExternalAuthenticator authenticator = new ExternalAuthenticator(redirectHandler, poller, knownTokenCache.create(), timeout2);
            builder.authenticator(authenticator);
            builder.addInterceptor(authenticator);
        }
        uri.getDnsResolver().ifPresent(resolverClass -> builder.dns(HttpClientFactory.instantiateDnsResolver(resolverClass, uri.getDnsResolverContext())::lookup));
        return builder;
    }

    protected static void setupUserAgent(OkHttpClient.Builder builder, String userAgent) {
        builder.addInterceptor(OkHttpUtil.userAgent(userAgent));
    }

    private static DnsResolver instantiateDnsResolver(Class<? extends DnsResolver> resolverClass, String context) {
        try {
            return resolverClass.getConstructor(String.class).newInstance(context);
        }
        catch (ReflectiveOperationException e) {
            throw new ClientException("Unable to instantiate custom DNS resolver " + resolverClass.getName(), e);
        }
    }
}

