/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.$internal.client.ProtocolDetectionException;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class ProtocolHeaders {
    public static final ProtocolHeaders TRINO_HEADERS = new ProtocolHeaders("Trino");
    private final String name;
    private final String requestUser;
    private final String requestOriginalUser;
    private final String requestSource;
    private final String requestCatalog;
    private final String requestSchema;
    private final String requestPath;
    private final String requestTimeZone;
    private final String requestLanguage;
    private final String requestTraceToken;
    private final String requestSession;
    private final String requestRole;
    private final String requestPreparedStatement;
    private final String requestTransactionId;
    private final String requestClientInfo;
    private final String requestClientTags;
    private final String requestClientCapabilities;
    private final String requestResourceEstimate;
    private final String requestExtraCredential;
    private final String requestQueryDataEncoding;
    private final String responseSetCatalog;
    private final String responseSetSchema;
    private final String responseSetPath;
    private final String responseSetSession;
    private final String responseClearSession;
    private final String responseSetRole;
    private final String responseAddedPrepare;
    private final String responseDeallocatedPrepare;
    private final String responseStartedTransactionId;
    private final String responseClearTransactionId;
    private final String responseSetAuthorizationUser;
    private final String responseResetAuthorizationUser;

    public static ProtocolHeaders createProtocolHeaders(String name) {
        if (TRINO_HEADERS.getProtocolName().equalsIgnoreCase(name)) {
            return TRINO_HEADERS;
        }
        return new ProtocolHeaders(name);
    }

    private ProtocolHeaders(String name) {
        Objects.requireNonNull(name, "name is null");
        Preconditions.checkArgument(!name.isEmpty(), "name is empty");
        this.name = name;
        String prefix = "X-" + name + "-";
        this.requestUser = prefix + "User";
        this.requestOriginalUser = prefix + "Original-User";
        this.requestSource = prefix + "Source";
        this.requestCatalog = prefix + "Catalog";
        this.requestSchema = prefix + "Schema";
        this.requestPath = prefix + "Path";
        this.requestTimeZone = prefix + "Time-Zone";
        this.requestLanguage = prefix + "Language";
        this.requestTraceToken = prefix + "Trace-Token";
        this.requestSession = prefix + "Session";
        this.requestRole = prefix + "Role";
        this.requestPreparedStatement = prefix + "Prepared-Statement";
        this.requestTransactionId = prefix + "Transaction-Id";
        this.requestClientInfo = prefix + "Client-Info";
        this.requestClientTags = prefix + "Client-Tags";
        this.requestClientCapabilities = prefix + "Client-Capabilities";
        this.requestResourceEstimate = prefix + "Resource-Estimate";
        this.requestExtraCredential = prefix + "Extra-Credential";
        this.requestQueryDataEncoding = prefix + "Query-Data-Encoding";
        this.responseSetCatalog = prefix + "Set-Catalog";
        this.responseSetSchema = prefix + "Set-Schema";
        this.responseSetPath = prefix + "Set-Path";
        this.responseSetSession = prefix + "Set-Session";
        this.responseClearSession = prefix + "Clear-Session";
        this.responseSetRole = prefix + "Set-Role";
        this.responseAddedPrepare = prefix + "Added-Prepare";
        this.responseDeallocatedPrepare = prefix + "Deallocated-Prepare";
        this.responseStartedTransactionId = prefix + "Started-Transaction-Id";
        this.responseClearTransactionId = prefix + "Clear-Transaction-Id";
        this.responseSetAuthorizationUser = prefix + "Set-Authorization-User";
        this.responseResetAuthorizationUser = prefix + "Reset-Authorization-User";
    }

    public String getProtocolName() {
        return this.name;
    }

    public String requestUser() {
        return this.requestUser;
    }

    public String requestOriginalUser() {
        return this.requestOriginalUser;
    }

    public String requestSource() {
        return this.requestSource;
    }

    public String requestCatalog() {
        return this.requestCatalog;
    }

    public String requestSchema() {
        return this.requestSchema;
    }

    public String requestPath() {
        return this.requestPath;
    }

    public String requestTimeZone() {
        return this.requestTimeZone;
    }

    public String requestLanguage() {
        return this.requestLanguage;
    }

    public String requestTraceToken() {
        return this.requestTraceToken;
    }

    public String requestSession() {
        return this.requestSession;
    }

    public String requestRole() {
        return this.requestRole;
    }

    public String requestPreparedStatement() {
        return this.requestPreparedStatement;
    }

    public String requestTransactionId() {
        return this.requestTransactionId;
    }

    public String requestClientInfo() {
        return this.requestClientInfo;
    }

    public String requestClientTags() {
        return this.requestClientTags;
    }

    public String requestClientCapabilities() {
        return this.requestClientCapabilities;
    }

    public String requestResourceEstimate() {
        return this.requestResourceEstimate;
    }

    public String requestExtraCredential() {
        return this.requestExtraCredential;
    }

    public String requestQueryDataEncoding() {
        return this.requestQueryDataEncoding;
    }

    public String responseSetCatalog() {
        return this.responseSetCatalog;
    }

    public String responseSetSchema() {
        return this.responseSetSchema;
    }

    public String responseSetPath() {
        return this.responseSetPath;
    }

    public String responseSetSession() {
        return this.responseSetSession;
    }

    public String responseClearSession() {
        return this.responseClearSession;
    }

    public String responseSetRole() {
        return this.responseSetRole;
    }

    public String responseAddedPrepare() {
        return this.responseAddedPrepare;
    }

    public String responseDeallocatedPrepare() {
        return this.responseDeallocatedPrepare;
    }

    public String responseStartedTransactionId() {
        return this.responseStartedTransactionId;
    }

    public String responseClearTransactionId() {
        return this.responseClearTransactionId;
    }

    public String responseSetAuthorizationUser() {
        return this.responseSetAuthorizationUser;
    }

    public String responseResetAuthorizationUser() {
        return this.responseResetAuthorizationUser;
    }

    public static ProtocolHeaders detectProtocol(Optional<String> alternateHeaderName, Set<String> headerNames) throws ProtocolDetectionException {
        Objects.requireNonNull(alternateHeaderName, "alternateHeaderName is null");
        Objects.requireNonNull(headerNames, "headerNames is null");
        if (alternateHeaderName.isPresent() && !alternateHeaderName.get().equalsIgnoreCase("Trino")) {
            String headerPrefix = "x-" + alternateHeaderName.get().toLowerCase(Locale.ENGLISH);
            if (headerNames.stream().anyMatch(header -> header.toLowerCase(Locale.ENGLISH).startsWith(headerPrefix))) {
                if (headerNames.stream().anyMatch(header -> header.toLowerCase(Locale.ENGLISH).startsWith("x-trino-"))) {
                    throw new ProtocolDetectionException("Both Trino and " + alternateHeaderName.get() + " headers detected");
                }
                return ProtocolHeaders.createProtocolHeaders(alternateHeaderName.get());
            }
        }
        return TRINO_HEADERS;
    }
}

