/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import com.google.errorprone.annotations.Immutable;
import io.trino.jdbc.;
import io.trino.jdbc.$internal.client.Column;
import io.trino.jdbc.$internal.client.QueryData;
import io.trino.jdbc.$internal.client.QueryError;
import io.trino.jdbc.$internal.client.QueryStatusInfo;
import io.trino.jdbc.$internal.client.RawQueryData;
import io.trino.jdbc.$internal.client.StatementStats;
import io.trino.jdbc.$internal.client.Warning;
import io.trino.jdbc.$internal.guava.base.MoreObjects;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.Objects;

@Immutable
public class QueryResults
implements QueryStatusInfo {
    private final String id;
    private final URI infoUri;
    private final URI partialCancelUri;
    private final URI nextUri;
    private final List<Column> columns;
    private final QueryData data;
    private final StatementStats stats;
    private final QueryError error;
    private final List<Warning> warnings;
    private final String updateType;
    private final Long updateCount;

    @.JsonCreator
    public QueryResults(@.JsonProperty(value="id") String id, @.JsonProperty(value="infoUri") URI infoUri, @.JsonProperty(value="partialCancelUri") URI partialCancelUri, @.JsonProperty(value="nextUri") URI nextUri, @.JsonProperty(value="columns") List<Column> columns, @.JsonProperty(value="data") QueryData data, @.JsonProperty(value="stats") StatementStats stats, @.JsonProperty(value="error") QueryError error, @.JsonProperty(value="warnings") List<Warning> warnings, @.JsonProperty(value="updateType") String updateType, @.JsonProperty(value="updateCount") Long updateCount) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.infoUri = Objects.requireNonNull(infoUri, "infoUri is null");
        this.partialCancelUri = partialCancelUri;
        this.nextUri = nextUri;
        this.columns = columns != null ? ImmutableList.copyOf(columns) : null;
        this.data = data;
        Preconditions.checkArgument(!QueryResults.hasData(data) || columns != null, "data present without columns");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.error = error;
        this.warnings = ImmutableList.copyOf(MoreObjects.firstNonNull(warnings, ImmutableList.of()));
        this.updateType = updateType;
        this.updateCount = updateCount;
    }

    @Override
    @.JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @.JsonProperty
    public URI getInfoUri() {
        return this.infoUri;
    }

    @Override
    @.Nullable
    @.JsonProperty
    public URI getPartialCancelUri() {
        return this.partialCancelUri;
    }

    @Override
    @.Nullable
    @.JsonProperty
    public URI getNextUri() {
        return this.nextUri;
    }

    @Override
    @.Nullable
    @.JsonProperty
    public List<Column> getColumns() {
        return this.columns;
    }

    @.JsonIgnore
    public QueryData getData() {
        return this.data;
    }

    @.JsonProperty(value="data")
    @.JsonInclude(value=.JsonInclude.Include.NON_EMPTY)
    public QueryData getRawData() {
        return this.data;
    }

    @Override
    @.JsonProperty
    public StatementStats getStats() {
        return this.stats;
    }

    @Override
    @.Nullable
    @.JsonProperty
    public QueryError getError() {
        return this.error;
    }

    @Override
    @.JsonProperty
    public List<Warning> getWarnings() {
        return this.warnings;
    }

    @Override
    @.Nullable
    @.JsonProperty
    public String getUpdateType() {
        return this.updateType;
    }

    @Override
    @.Nullable
    @.JsonProperty
    public Long getUpdateCount() {
        return this.updateCount;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("infoUri", this.infoUri).add("partialCancelUri", this.partialCancelUri).add("nextUri", this.nextUri).add("columns", this.columns).add("hasData", QueryResults.hasData(this.data)).add("stats", this.stats).add("error", this.error).add("updateType", this.updateType).add("updateCount", this.updateCount).toString();
    }

    private static boolean hasData(QueryData data) {
        if (data == null) {
            return false;
        }
        if (data instanceof RawQueryData) {
            return data.getData() != null;
        }
        return true;
    }
}

