/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.trino.jdbc.\$internal.airlift.compress.hadoop;

import java.io.IOException;
import java.io.InputStream;

@SuppressWarnings("AbstractMethodOverridesConcreteMethod")
public abstract class HadoopInputStream
        extends InputStream
{
    public abstract void resetState();

    @Override
    public abstract int read(byte[] b, int off, int len)
            throws IOException;

    @Override
    public abstract void close()
            throws IOException;
}
