/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.spooling;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.client.QueryData;
import io.trino.jdbc.$internal.client.spooling.DataAttributes;
import io.trino.jdbc.$internal.client.spooling.Segment;
import io.trino.jdbc.$internal.guava.base.MoreObjects;
import io.trino.jdbc.$internal.guava.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EncodedQueryData
implements QueryData {
    private final String encoding;
    private final DataAttributes metadata;
    private final List<Segment> segments;

    @.JsonCreator
    public EncodedQueryData(@.JsonProperty(value="encoding") String encoding, @.JsonProperty(value="metadata") Map<String, Object> metadata, @.JsonProperty(value="segments") List<Segment> segments) {
        this(encoding, new DataAttributes(metadata), segments);
    }

    public EncodedQueryData(String encoding, DataAttributes metadata, List<Segment> segments) {
        this.encoding = Objects.requireNonNull(encoding, "encoding is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.segments = ImmutableList.copyOf((Collection)Objects.requireNonNull(segments, "segments is null"));
    }

    @.JsonProperty(value="segments")
    public List<Segment> getSegments() {
        return this.segments;
    }

    @.JsonProperty(value="encoding")
    public String getEncoding() {
        return this.encoding;
    }

    @.JsonInclude(value=.JsonInclude.Include.NON_EMPTY)
    @.JsonProperty(value="metadata")
    public Map<String, Object> getJsonMetadata() {
        return this.metadata.attributes;
    }

    @.JsonIgnore
    public DataAttributes getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("encoding", this.encoding).add("segments", this.segments).add("metadata", this.metadata.attributes.keySet()).toString();
    }

    public static Builder builder(String encoding) {
        return new Builder(encoding);
    }

    @Override
    public boolean isNull() {
        return this.segments.isEmpty();
    }

    public static class Builder {
        private final String encoding;
        private final ImmutableList.Builder<Segment> segments = ImmutableList.builder();
        private DataAttributes metadata = DataAttributes.empty();

        private Builder(String encoding) {
            this.encoding = Objects.requireNonNull(encoding, "encoding is null");
        }

        public Builder withSegment(Segment segment) {
            this.segments.add((Object)segment);
            return this;
        }

        public Builder withSegments(List<Segment> segments) {
            this.segments.addAll(segments);
            return this;
        }

        public Builder withAttributes(DataAttributes attributes) {
            this.metadata = Objects.requireNonNull(attributes, "attributes is null");
            return this;
        }

        public EncodedQueryData build() {
            return new EncodedQueryData(this.encoding, this.metadata, (List<Segment>)((Object)this.segments.build()));
        }
    }
}

