/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.spooling.encoding;

import io.trino.jdbc.$internal.client.Column;
import io.trino.jdbc.$internal.client.JsonDecodingUtils;
import io.trino.jdbc.$internal.client.JsonResultRows;
import io.trino.jdbc.$internal.client.QueryDataDecoder;
import io.trino.jdbc.$internal.client.ResultRows;
import io.trino.jdbc.$internal.client.spooling.DataAttributes;
import io.trino.jdbc.$internal.client.spooling.encoding.Lz4QueryDataDecoder;
import io.trino.jdbc.$internal.client.spooling.encoding.ZstdQueryDataDecoder;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;

public class JsonQueryDataDecoder
implements QueryDataDecoder {
    private final JsonDecodingUtils.TypeDecoder[] decoders;

    JsonQueryDataDecoder(JsonDecodingUtils.TypeDecoder[] decoders) {
        this.decoders = Objects.requireNonNull(decoders, "decoders is null");
    }

    @Override
    public ResultRows decode(InputStream stream, DataAttributes queryAttributes) {
        return JsonResultRows.forInputStream(stream, this.decoders);
    }

    @Override
    public String encoding() {
        return "json";
    }

    public static class Lz4Factory
    extends Factory {
        @Override
        public QueryDataDecoder create(List<Column> columns, DataAttributes queryAttributes) {
            return new Lz4QueryDataDecoder(super.create(columns, queryAttributes));
        }

        @Override
        public String encoding() {
            return super.encoding() + "+lz4";
        }
    }

    public static class ZstdFactory
    extends Factory {
        @Override
        public QueryDataDecoder create(List<Column> columns, DataAttributes queryAttributes) {
            return new ZstdQueryDataDecoder(super.create(columns, queryAttributes));
        }

        @Override
        public String encoding() {
            return super.encoding() + "+zstd";
        }
    }

    public static class Factory
    implements QueryDataDecoder.Factory {
        @Override
        public QueryDataDecoder create(List<Column> columns, DataAttributes queryAttributes) {
            return new JsonQueryDataDecoder(JsonDecodingUtils.createTypeDecoders(columns));
        }

        @Override
        public String encoding() {
            return "json";
        }
    }
}

