/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

public class JdbcDriverIT {
    private static final Set<String> MANIFEST_FILES = ImmutableSet.of((Object)"META-INF/MANIFEST.MF", (Object)"META-INF/services/java.sql.Driver");

    @Test
    public void testDependenciesRelocated() {
        String file = System.getProperty("jdbc-jar");
        try (JarFile jarFile = new JarFile(file);){
            List nonRelocatedFiles = (List)jarFile.stream().filter(value -> !value.isDirectory()).map(ZipEntry::getName).filter(name -> !JdbcDriverIT.isExpectedFile(name)).collect(ImmutableList.toImmutableList());
            ((ListAssert)Assertions.assertThat((List)nonRelocatedFiles).describedAs("Non-relocated files in the shaded jar", new Object[0])).isEmpty();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Test
    public void testOpenTelemetryIsNotShaded() {
        String file = System.getProperty("jdbc-jar");
        try (JarFile jarFile = new JarFile(file);){
            List openTelemetryFiles = (List)jarFile.stream().filter(value -> !value.isDirectory()).map(ZipEntry::getName).filter(name -> name.contains("io/opentelemetry")).filter(name -> !name.contains("io/opentelemetry/instrumentation/okhttp/v3_0")).collect(ImmutableList.toImmutableList());
            ((ListAssert)Assertions.assertThat((List)openTelemetryFiles).describedAs("OpenTelemetry files in the shaded jar", new Object[0])).isEmpty();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static boolean isExpectedFile(String filename) {
        return MANIFEST_FILES.contains(filename) || filename.startsWith("io/trino/jdbc") || filename.startsWith("aircompressor/");
    }
}

