/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logging;
import io.trino.client.ClientSelectedRole;
import io.trino.client.DnsResolver;
import io.trino.execution.QueryState;
import io.trino.jdbc.TrinoConnection;
import io.trino.jdbc.TrinoIntervalDayTime;
import io.trino.jdbc.TrinoIntervalYearMonth;
import io.trino.jdbc.TrinoResultSet;
import io.trino.jdbc.TrinoStatement;
import io.trino.plugin.blackhole.BlackHolePlugin;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.Plugin;
import io.trino.spi.type.TimeZoneKey;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.zone.ZoneRulesException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestTrinoDriver {
    private static final DateTimeZone ASIA_ORAL_ZONE = DateTimeZone.forID((String)"Asia/Oral");
    private static final GregorianCalendar ASIA_ORAL_CALENDAR = new GregorianCalendar(TimeZone.getTimeZone(ZoneId.of(ASIA_ORAL_ZONE.getID())));
    private static final String TEST_CATALOG = "test_catalog";
    private TestingTrinoServer server;
    private ExecutorService executorService;

    @BeforeAll
    public void setup() throws Exception {
        Logging.initialize();
        this.server = TestingTrinoServer.create();
        this.server.installPlugin((Plugin)new TpchPlugin());
        this.server.createCatalog(TEST_CATALOG, "tpch");
        this.server.installPlugin((Plugin)new BlackHolePlugin());
        this.server.createCatalog("blackhole", "blackhole");
        this.setupTestTables();
        this.executorService = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
    }

    private void setupTestTables() throws SQLException {
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            Assertions.assertThat((int)statement.executeUpdate("CREATE SCHEMA blackhole.blackhole")).isEqualTo(0);
            Assertions.assertThat((int)statement.executeUpdate("CREATE TABLE test_table (x bigint)")).isEqualTo(0);
            Assertions.assertThat((int)statement.executeUpdate("CREATE TABLE slow_test_table (x bigint) WITH (   split_count = 1,    pages_per_split = 1,    rows_per_page = 1,    page_processing_delay = '1m')")).isEqualTo(0);
        }
    }

    @AfterAll
    public void teardown() throws Exception {
        this.executorService.shutdownNow();
        this.executorService = null;
        this.server.close();
        this.server = null;
    }

    @Test
    public void testDriverManager() throws Exception {
        try (Connection connection = this.createConnection();
             Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery("SELECT   123 _integer,  12300000000 _bigint, 'foo' _varchar, 0.1E0 _double, true _boolean, cast('hello' as varbinary) _varbinary, DECIMAL '1234567890.1234567' _decimal_short, DECIMAL '.12345678901234567890123456789012345678' _decimal_long, approx_set(42) _hll, cast('foo' as char(5)) _char");){
            ResultSetMetaData metadata = rs.getMetaData();
            Assertions.assertThat((int)metadata.getColumnCount()).isEqualTo(10);
            Assertions.assertThat((String)metadata.getColumnLabel(1)).isEqualTo("_integer");
            Assertions.assertThat((int)metadata.getColumnType(1)).isEqualTo(4);
            Assertions.assertThat((String)metadata.getColumnLabel(2)).isEqualTo("_bigint");
            Assertions.assertThat((int)metadata.getColumnType(2)).isEqualTo(-5);
            Assertions.assertThat((String)metadata.getColumnLabel(3)).isEqualTo("_varchar");
            Assertions.assertThat((int)metadata.getColumnType(3)).isEqualTo(12);
            Assertions.assertThat((String)metadata.getColumnLabel(4)).isEqualTo("_double");
            Assertions.assertThat((int)metadata.getColumnType(4)).isEqualTo(8);
            Assertions.assertThat((String)metadata.getColumnLabel(5)).isEqualTo("_boolean");
            Assertions.assertThat((int)metadata.getColumnType(5)).isEqualTo(16);
            Assertions.assertThat((String)metadata.getColumnLabel(6)).isEqualTo("_varbinary");
            Assertions.assertThat((int)metadata.getColumnType(6)).isEqualTo(-3);
            Assertions.assertThat((String)metadata.getColumnLabel(7)).isEqualTo("_decimal_short");
            Assertions.assertThat((int)metadata.getColumnType(7)).isEqualTo(3);
            Assertions.assertThat((String)metadata.getColumnLabel(8)).isEqualTo("_decimal_long");
            Assertions.assertThat((int)metadata.getColumnType(8)).isEqualTo(3);
            Assertions.assertThat((String)metadata.getColumnLabel(9)).isEqualTo("_hll");
            Assertions.assertThat((int)metadata.getColumnType(9)).isEqualTo(2000);
            Assertions.assertThat((String)metadata.getColumnLabel(10)).isEqualTo("_char");
            Assertions.assertThat((int)metadata.getColumnType(10)).isEqualTo(1);
            Assertions.assertThat((boolean)rs.next()).isTrue();
            Assertions.assertThat((Object)rs.getObject(1)).isEqualTo((Object)123);
            Assertions.assertThat((Object)rs.getObject("_integer")).isEqualTo((Object)123);
            Assertions.assertThat((int)rs.getInt(1)).isEqualTo(123);
            Assertions.assertThat((int)rs.getInt("_integer")).isEqualTo(123);
            Assertions.assertThat((long)rs.getLong(1)).isEqualTo(123L);
            Assertions.assertThat((long)rs.getLong("_integer")).isEqualTo(123L);
            Assertions.assertThat((Object)rs.getObject(2)).isEqualTo((Object)12300000000L);
            Assertions.assertThat((Object)rs.getObject("_bigint")).isEqualTo((Object)12300000000L);
            Assertions.assertThat((long)rs.getLong(2)).isEqualTo(12300000000L);
            Assertions.assertThat((long)rs.getLong("_bigint")).isEqualTo(12300000000L);
            Assertions.assertThat((Object)rs.getObject(3)).isEqualTo((Object)"foo");
            Assertions.assertThat((Object)rs.getObject("_varchar")).isEqualTo((Object)"foo");
            Assertions.assertThat((String)rs.getString(3)).isEqualTo("foo");
            Assertions.assertThat((String)rs.getString("_varchar")).isEqualTo("foo");
            Assertions.assertThat((Object)rs.getObject(4)).isEqualTo((Object)0.1);
            Assertions.assertThat((Object)rs.getObject("_double")).isEqualTo((Object)0.1);
            Assertions.assertThat((double)rs.getDouble(4)).isEqualTo(0.1);
            Assertions.assertThat((double)rs.getDouble("_double")).isEqualTo(0.1);
            Assertions.assertThat((Object)rs.getObject(5)).isEqualTo((Object)true);
            Assertions.assertThat((Object)rs.getObject("_boolean")).isEqualTo((Object)true);
            Assertions.assertThat((boolean)rs.getBoolean(5)).isEqualTo(true);
            Assertions.assertThat((boolean)rs.getBoolean("_boolean")).isEqualTo(true);
            Assertions.assertThat((byte)rs.getByte("_boolean")).isEqualTo((byte)1);
            Assertions.assertThat((short)rs.getShort("_boolean")).isEqualTo((short)1);
            Assertions.assertThat((int)rs.getInt("_boolean")).isEqualTo(1);
            Assertions.assertThat((long)rs.getLong("_boolean")).isEqualTo(1L);
            Assertions.assertThat((float)rs.getFloat("_boolean")).isEqualTo(1.0f);
            Assertions.assertThat((double)rs.getDouble("_boolean")).isEqualTo(1.0);
            Assertions.assertThat((Object)rs.getObject(6)).isEqualTo((Object)"hello".getBytes(StandardCharsets.UTF_8));
            Assertions.assertThat((Object)rs.getObject("_varbinary")).isEqualTo((Object)"hello".getBytes(StandardCharsets.UTF_8));
            Assertions.assertThat((byte[])rs.getBytes(6)).isEqualTo((Object)"hello".getBytes(StandardCharsets.UTF_8));
            Assertions.assertThat((byte[])rs.getBytes("_varbinary")).isEqualTo((Object)"hello".getBytes(StandardCharsets.UTF_8));
            Assertions.assertThat((Object)rs.getObject(7)).isEqualTo((Object)new BigDecimal("1234567890.1234567"));
            Assertions.assertThat((Object)rs.getObject("_decimal_short")).isEqualTo((Object)new BigDecimal("1234567890.1234567"));
            Assertions.assertThat((BigDecimal)rs.getBigDecimal(7)).isEqualTo((Object)new BigDecimal("1234567890.1234567"));
            Assertions.assertThat((BigDecimal)rs.getBigDecimal("_decimal_short")).isEqualTo((Object)new BigDecimal("1234567890.1234567"));
            Assertions.assertThat((BigDecimal)rs.getBigDecimal(7, 1)).isEqualTo((Object)new BigDecimal("1234567890.1"));
            Assertions.assertThat((BigDecimal)rs.getBigDecimal("_decimal_short", 1)).isEqualTo((Object)new BigDecimal("1234567890.1"));
            Assertions.assertThat((Object)rs.getObject(8)).isEqualTo((Object)new BigDecimal(".12345678901234567890123456789012345678"));
            Assertions.assertThat((Object)rs.getObject("_decimal_long")).isEqualTo((Object)new BigDecimal(".12345678901234567890123456789012345678"));
            Assertions.assertThat((BigDecimal)rs.getBigDecimal(8)).isEqualTo((Object)new BigDecimal(".12345678901234567890123456789012345678"));
            Assertions.assertThat((BigDecimal)rs.getBigDecimal("_decimal_long")).isEqualTo((Object)new BigDecimal(".12345678901234567890123456789012345678"));
            Assertions.assertThat((BigDecimal)rs.getBigDecimal(8, 6)).isEqualTo((Object)new BigDecimal(".123457"));
            Assertions.assertThat((BigDecimal)rs.getBigDecimal("_decimal_long", 6)).isEqualTo((Object)new BigDecimal(".123457"));
            Assertions.assertThat((Object)rs.getObject(9)).isInstanceOf(byte[].class);
            Assertions.assertThat((Object)rs.getObject("_hll")).isInstanceOf(byte[].class);
            Assertions.assertThat((byte[])rs.getBytes(9)).isInstanceOf(byte[].class);
            Assertions.assertThat((byte[])rs.getBytes("_hll")).isInstanceOf(byte[].class);
            Assertions.assertThat((Object)rs.getObject(10)).isEqualTo((Object)"foo  ");
            Assertions.assertThat((Object)rs.getObject("_char")).isEqualTo((Object)"foo  ");
            Assertions.assertThat((String)rs.getString(10)).isEqualTo("foo  ");
            Assertions.assertThat((String)rs.getString("_char")).isEqualTo("foo  ");
            Assertions.assertThat((boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void testTypes() throws Exception {
        try (Connection connection = this.createConnection();
             Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery("SELECT   TIME '3:04:05' as a, TIME '6:07:08 +06:17' as b, TIME '9:10:11 +02:00' as c, TIMESTAMP '2001-02-03 3:04:05' as d, TIMESTAMP '2004-05-06 6:07:08 +06:17' as e, TIMESTAMP '2007-08-09 9:10:11 Europe/Berlin' as f, DATE '2013-03-22' as g, INTERVAL '123-11' YEAR TO MONTH as h, INTERVAL '11 22:33:44.555' DAY TO SECOND as i, REAL '123.45' as j, REAL 'Infinity' as k");){
            Assertions.assertThat((boolean)rs.next()).isTrue();
            Assertions.assertThat((java.util.Date)rs.getTime(1)).isEqualTo((Object)new Time(new DateTime(1970, 1, 1, 3, 4, 5).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getTime(1, (Calendar)ASIA_ORAL_CALENDAR)).isEqualTo((Object)new Time(new DateTime(1970, 1, 1, 3, 4, 5, ASIA_ORAL_ZONE).getMillis()));
            Assertions.assertThat((Object)rs.getObject(1)).isEqualTo((Object)new Time(new DateTime(1970, 1, 1, 3, 4, 5).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getTime("a")).isEqualTo((Object)new Time(new DateTime(1970, 1, 1, 3, 4, 5).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getTime("a", (Calendar)ASIA_ORAL_CALENDAR)).isEqualTo((Object)new Time(new DateTime(1970, 1, 1, 3, 4, 5, ASIA_ORAL_ZONE).getMillis()));
            Assertions.assertThat((Object)rs.getObject("a")).isEqualTo((Object)new Time(new DateTime(1970, 1, 1, 3, 4, 5).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getTime(2)).isEqualTo((Object)new Time(new DateTime(1970, 1, 1, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getTime(2, (Calendar)ASIA_ORAL_CALENDAR)).isEqualTo((Object)new Time(new DateTime(1970, 1, 1, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assertions.assertThat((Object)rs.getObject(2)).isEqualTo((Object)new Time(new DateTime(1970, 1, 1, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getTime("b")).isEqualTo((Object)new Time(new DateTime(1970, 1, 1, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getTime("b", (Calendar)ASIA_ORAL_CALENDAR)).isEqualTo((Object)new Time(new DateTime(1970, 1, 1, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assertions.assertThat((Object)rs.getObject("b")).isEqualTo((Object)new Time(new DateTime(1970, 1, 1, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getTime(3)).isEqualTo((Object)new Time(new DateTime(1970, 1, 1, 9, 10, 11, DateTimeZone.forOffsetHoursMinutes((int)2, (int)0)).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getTime(3, (Calendar)ASIA_ORAL_CALENDAR)).isEqualTo((Object)new Time(new DateTime(1970, 1, 1, 9, 10, 11, DateTimeZone.forOffsetHoursMinutes((int)2, (int)0)).getMillis()));
            Assertions.assertThat((Object)rs.getObject(3)).isEqualTo((Object)new Time(new DateTime(1970, 1, 1, 9, 10, 11, DateTimeZone.forOffsetHoursMinutes((int)2, (int)0)).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getTime("c")).isEqualTo((Object)new Time(new DateTime(1970, 1, 1, 9, 10, 11, DateTimeZone.forOffsetHoursMinutes((int)2, (int)0)).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getTime("c", (Calendar)ASIA_ORAL_CALENDAR)).isEqualTo((Object)new Time(new DateTime(1970, 1, 1, 9, 10, 11, DateTimeZone.forOffsetHoursMinutes((int)2, (int)0)).getMillis()));
            Assertions.assertThat((Object)rs.getObject("c")).isEqualTo((Object)new Time(new DateTime(1970, 1, 1, 9, 10, 11, DateTimeZone.forOffsetHoursMinutes((int)2, (int)0)).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getTimestamp(4)).isEqualTo((Object)new Timestamp(new DateTime(2001, 2, 3, 3, 4, 5).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getTimestamp(4, (Calendar)ASIA_ORAL_CALENDAR)).isEqualTo((Object)new Timestamp(new DateTime(2001, 2, 3, 3, 4, 5, ASIA_ORAL_ZONE).getMillis()));
            Assertions.assertThat((Object)rs.getObject(4)).isEqualTo((Object)new Timestamp(new DateTime(2001, 2, 3, 3, 4, 5).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getTimestamp("d")).isEqualTo((Object)new Timestamp(new DateTime(2001, 2, 3, 3, 4, 5).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getTimestamp("d", (Calendar)ASIA_ORAL_CALENDAR)).isEqualTo((Object)new Timestamp(new DateTime(2001, 2, 3, 3, 4, 5, ASIA_ORAL_ZONE).getMillis()));
            Assertions.assertThat((Object)rs.getObject("d")).isEqualTo((Object)new Timestamp(new DateTime(2001, 2, 3, 3, 4, 5).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getTimestamp(5)).isEqualTo((Object)new Timestamp(new DateTime(2004, 5, 6, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getTimestamp(5, (Calendar)ASIA_ORAL_CALENDAR)).isEqualTo((Object)new Timestamp(new DateTime(2004, 5, 6, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assertions.assertThat((Object)rs.getObject(5)).isEqualTo((Object)new Timestamp(new DateTime(2004, 5, 6, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assertions.assertThat((ZonedDateTime)rs.getObject(5, ZonedDateTime.class)).isEqualTo((Object)ZonedDateTime.of(2004, 5, 6, 6, 7, 8, 0, ZoneOffset.ofHoursMinutes(6, 17)));
            Assertions.assertThat((java.util.Date)rs.getTimestamp("e")).isEqualTo((Object)new Timestamp(new DateTime(2004, 5, 6, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getTimestamp("e", (Calendar)ASIA_ORAL_CALENDAR)).isEqualTo((Object)new Timestamp(new DateTime(2004, 5, 6, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assertions.assertThat((Object)rs.getObject("e")).isEqualTo((Object)new Timestamp(new DateTime(2004, 5, 6, 6, 7, 8, DateTimeZone.forOffsetHoursMinutes((int)6, (int)17)).getMillis()));
            Assertions.assertThat((ZonedDateTime)rs.getObject("e", ZonedDateTime.class)).isEqualTo((Object)ZonedDateTime.of(2004, 5, 6, 6, 7, 8, 0, ZoneOffset.ofHoursMinutes(6, 17)));
            Assertions.assertThat((java.util.Date)rs.getTimestamp(6)).isEqualTo((Object)new Timestamp(new DateTime(2007, 8, 9, 9, 10, 11, DateTimeZone.forID((String)"Europe/Berlin")).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getTimestamp(6, (Calendar)ASIA_ORAL_CALENDAR)).isEqualTo((Object)new Timestamp(new DateTime(2007, 8, 9, 9, 10, 11, DateTimeZone.forID((String)"Europe/Berlin")).getMillis()));
            Assertions.assertThat((Object)rs.getObject(6)).isEqualTo((Object)new Timestamp(new DateTime(2007, 8, 9, 9, 10, 11, DateTimeZone.forID((String)"Europe/Berlin")).getMillis()));
            Assertions.assertThat((ZonedDateTime)rs.getObject(6, ZonedDateTime.class)).isEqualTo((Object)ZonedDateTime.of(2007, 8, 9, 9, 10, 11, 0, ZoneId.of("Europe/Berlin")));
            Assertions.assertThat((java.util.Date)rs.getTimestamp("f")).isEqualTo((Object)new Timestamp(new DateTime(2007, 8, 9, 9, 10, 11, DateTimeZone.forID((String)"Europe/Berlin")).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getTimestamp("f", (Calendar)ASIA_ORAL_CALENDAR)).isEqualTo((Object)new Timestamp(new DateTime(2007, 8, 9, 9, 10, 11, DateTimeZone.forID((String)"Europe/Berlin")).getMillis()));
            Assertions.assertThat((Object)rs.getObject("f")).isEqualTo((Object)new Timestamp(new DateTime(2007, 8, 9, 9, 10, 11, DateTimeZone.forID((String)"Europe/Berlin")).getMillis()));
            Assertions.assertThat((ZonedDateTime)rs.getObject("f", ZonedDateTime.class)).isEqualTo((Object)ZonedDateTime.of(2007, 8, 9, 9, 10, 11, 0, ZoneId.of("Europe/Berlin")));
            Assertions.assertThat((java.util.Date)rs.getDate(7)).isEqualTo((Object)new Date(new DateTime(2013, 3, 22, 0, 0).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getDate(7, (Calendar)ASIA_ORAL_CALENDAR)).isEqualTo((Object)new Date(new DateTime(2013, 3, 22, 0, 0, ASIA_ORAL_ZONE).getMillis()));
            Assertions.assertThat((Object)rs.getObject(7)).isEqualTo((Object)new Date(new DateTime(2013, 3, 22, 0, 0).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getDate("g")).isEqualTo((Object)new Date(new DateTime(2013, 3, 22, 0, 0).getMillis()));
            Assertions.assertThat((java.util.Date)rs.getDate("g", (Calendar)ASIA_ORAL_CALENDAR)).isEqualTo((Object)new Date(new DateTime(2013, 3, 22, 0, 0, ASIA_ORAL_ZONE).getMillis()));
            Assertions.assertThat((Object)rs.getObject("g")).isEqualTo((Object)new Date(new DateTime(2013, 3, 22, 0, 0).getMillis()));
            Assertions.assertThat((Object)rs.getObject(8)).isEqualTo((Object)new TrinoIntervalYearMonth(123, 11));
            Assertions.assertThat((Object)rs.getObject("h")).isEqualTo((Object)new TrinoIntervalYearMonth(123, 11));
            Assertions.assertThat((Object)rs.getObject(9)).isEqualTo((Object)new TrinoIntervalDayTime(11, 22, 33, 44, 555));
            Assertions.assertThat((Object)rs.getObject("i")).isEqualTo((Object)new TrinoIntervalDayTime(11, 22, 33, 44, 555));
            Assertions.assertThat((float)rs.getFloat(10)).isEqualTo(123.45f);
            Assertions.assertThat((Object)rs.getObject(10)).isEqualTo((Object)Float.valueOf(123.45f));
            Assertions.assertThat((float)rs.getFloat("j")).isEqualTo(123.45f);
            Assertions.assertThat((Object)rs.getObject("j")).isEqualTo((Object)Float.valueOf(123.45f));
            Assertions.assertThat((float)rs.getFloat(11)).isEqualTo(Float.POSITIVE_INFINITY);
            Assertions.assertThat((Object)rs.getObject(11)).isEqualTo((Object)Float.valueOf(Float.POSITIVE_INFINITY));
            Assertions.assertThat((float)rs.getFloat("k")).isEqualTo(Float.POSITIVE_INFINITY);
            Assertions.assertThat((Object)rs.getObject("k")).isEqualTo((Object)Float.valueOf(Float.POSITIVE_INFINITY));
            Assertions.assertThat((boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void testGetDriverVersion() throws Exception {
        Driver driver = DriverManager.getDriver("jdbc:trino:");
        Assertions.assertThat((int)driver.getMajorVersion()).isGreaterThan(350);
        Assertions.assertThat((int)driver.getMinorVersion()).isEqualTo(0);
        try (Connection connection = this.createConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            Assertions.assertThat((String)metaData.getDriverName()).isEqualTo("Trino JDBC Driver");
            Assertions.assertThat((String)metaData.getDriverVersion()).startsWith((CharSequence)String.valueOf(driver.getMajorVersion()));
            Assertions.assertThat((int)metaData.getDriverMajorVersion()).isEqualTo(driver.getMajorVersion());
            Assertions.assertThat((int)metaData.getDriverMinorVersion()).isEqualTo(driver.getMinorVersion());
        }
    }

    @Test
    public void testNullUrl() throws Exception {
        Driver driver = DriverManager.getDriver("jdbc:trino:");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> driver.connect(null, null)).isInstanceOf(SQLException.class)).hasMessage("URL is null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> driver.acceptsURL(null)).isInstanceOf(SQLException.class)).hasMessage("URL is null");
    }

    @Test
    public void testDriverPropertyInfoEmpty() throws Exception {
        Driver driver = DriverManager.getDriver("jdbc:trino:");
        Properties properties = new Properties();
        Object[] infos = driver.getPropertyInfo(this.jdbcUrl(), properties);
        ((AbstractListAssert)((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Object[])infos).extracting(TestTrinoDriver::driverPropertyInfoToString).contains((Object[])new String[]{"{name=user, required=false}"})).contains((Object[])new String[]{"{name=password, required=false}"})).contains((Object[])new String[]{"{name=accessToken, required=false}"})).contains((Object[])new String[]{"{name=SSL, value=false, required=false, choices=[true, false]}"});
    }

    @Test
    public void testDriverPropertyInfoSslEnabled() throws Exception {
        Driver driver = DriverManager.getDriver("jdbc:trino:");
        Properties properties = new Properties();
        properties.setProperty("user", "test");
        properties.setProperty("SSL", "true");
        Object[] infos = driver.getPropertyInfo(this.jdbcUrl(), properties);
        ((AbstractListAssert)((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Object[])infos).extracting(TestTrinoDriver::driverPropertyInfoToString).contains((Object[])new String[]{"{name=user, value=test, required=false}"})).contains((Object[])new String[]{"{name=SSL, value=true, required=false, choices=[true, false]}"})).contains((Object[])new String[]{"{name=SSLVerification, value=FULL, required=false, choices=[FULL, CA, NONE]}"})).contains((Object[])new String[]{"{name=SSLTrustStorePath, required=false}"});
    }

    private static String driverPropertyInfoToString(DriverPropertyInfo info) {
        return MoreObjects.toStringHelper((String)"").add("name", (Object)info.name).add("value", (Object)info.value).add("description", (Object)info.description).add("required", info.required).add("choices", (Object)info.choices).omitNullValues().toString();
    }

    @Test
    public void testExecuteWithQuery() throws Exception {
        try (Connection connection = this.createConnection();
             Statement statement = connection.createStatement();){
            Assertions.assertThat((boolean)statement.execute("SELECT 123 x, 'foo' y, CAST(NULL AS bigint) z")).isTrue();
            ResultSet rs = statement.getResultSet();
            Assertions.assertThat((int)statement.getUpdateCount()).isEqualTo(-1);
            Assertions.assertThat((long)statement.getLargeUpdateCount()).isEqualTo(-1L);
            Assertions.assertThat((boolean)rs.next()).isTrue();
            Assertions.assertThat((long)rs.getLong(1)).isEqualTo(123L);
            Assertions.assertThat((boolean)rs.wasNull()).isFalse();
            Assertions.assertThat((long)rs.getLong("x")).isEqualTo(123L);
            Assertions.assertThat((boolean)rs.wasNull()).isFalse();
            Assertions.assertThat((long)rs.getLong(3)).isEqualTo(0L);
            Assertions.assertThat((boolean)rs.wasNull()).isTrue();
            Assertions.assertThat((long)rs.getLong("z")).isEqualTo(0L);
            Assertions.assertThat((boolean)rs.wasNull()).isTrue();
            Assertions.assertThat((Object)rs.getObject("z")).isNull();
            Assertions.assertThat((boolean)rs.wasNull()).isTrue();
            Assertions.assertThat((String)rs.getString(2)).isEqualTo("foo");
            Assertions.assertThat((boolean)rs.wasNull()).isFalse();
            Assertions.assertThat((String)rs.getString("y")).isEqualTo("foo");
            Assertions.assertThat((boolean)rs.wasNull()).isFalse();
            Assertions.assertThat((boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void testExecuteUpdateWithInsert() throws Exception {
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            Assertions.assertThat((int)statement.executeUpdate("INSERT INTO test_table VALUES (1), (2)")).isEqualTo(2);
            Assertions.assertThat((Object)statement.getResultSet()).isNull();
            Assertions.assertThat((int)statement.getUpdateCount()).isEqualTo(2);
            Assertions.assertThat((long)statement.getLargeUpdateCount()).isEqualTo(2L);
        }
    }

    @Test
    public void testExecuteUpdateWithCreateTable() throws Exception {
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            Assertions.assertThat((int)statement.executeUpdate("CREATE TABLE test_execute_create (x bigint)")).isEqualTo(0);
            Assertions.assertThat((Object)statement.getResultSet()).isNull();
            Assertions.assertThat((int)statement.getUpdateCount()).isEqualTo(0);
            Assertions.assertThat((long)statement.getLargeUpdateCount()).isEqualTo(0L);
        }
    }

    @Test
    public void testExecuteUpdateWithQuery() throws Exception {
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            String sql = "SELECT 123 x, 'foo' y, CAST(NULL AS bigint) z";
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> statement.executeUpdate(sql)).isInstanceOf(SQLException.class)).hasMessage("SQL is not an update statement: %s", new Object[]{sql});
        }
    }

    @Test
    public void testExecuteQueryWithInsert() throws Exception {
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            String sql = "INSERT INTO test_table VALUES (1)";
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> statement.executeQuery(sql)).isInstanceOf(SQLException.class)).hasMessage("SQL statement is not a query: %s", new Object[]{sql});
        }
    }

    @Test
    public void testStatementReuse() throws Exception {
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            Assertions.assertThat((boolean)statement.execute("INSERT INTO test_table VALUES (1), (2)")).isFalse();
            Assertions.assertThat((Object)statement.getResultSet()).isNull();
            Assertions.assertThat((int)statement.getUpdateCount()).isEqualTo(2);
            Assertions.assertThat((long)statement.getLargeUpdateCount()).isEqualTo(2L);
            Assertions.assertThat((boolean)statement.execute("SELECT 123 x, 'foo' y, CAST(NULL AS bigint) z")).isTrue();
            ResultSet resultSet = statement.getResultSet();
            Assertions.assertThat((Object)resultSet).isNotNull();
            Assertions.assertThat((int)statement.getUpdateCount()).isEqualTo(-1);
            Assertions.assertThat((long)statement.getLargeUpdateCount()).isEqualTo(-1L);
            resultSet.close();
            Assertions.assertThat((boolean)statement.execute("INSERT INTO test_table VALUES (1), (2), (3)")).isFalse();
            Assertions.assertThat((Object)statement.getResultSet()).isNull();
            Assertions.assertThat((int)statement.getUpdateCount()).isEqualTo(3);
            Assertions.assertThat((long)statement.getLargeUpdateCount()).isEqualTo(3L);
        }
    }

    @Test
    public void testGetUpdateCount() throws Exception {
        try (Connection connection = this.createConnection();
             Statement statement = connection.createStatement();){
            Assertions.assertThat((boolean)statement.execute("SELECT 123 x, 'foo' y")).isTrue();
            Assertions.assertThat((int)statement.getUpdateCount()).isEqualTo(-1);
            Assertions.assertThat((long)statement.getLargeUpdateCount()).isEqualTo(-1L);
        }
    }

    @Test
    public void testResultSetClose() throws Exception {
        try (Connection connection = this.createConnection();
             Statement statement = connection.createStatement();){
            Assertions.assertThat((boolean)statement.execute("SELECT 123 x, 'foo' y")).isTrue();
            ResultSet result = statement.getResultSet();
            Assertions.assertThat((boolean)result.isClosed()).isFalse();
            result.close();
            Assertions.assertThat((boolean)result.isClosed()).isTrue();
        }
    }

    @Test
    public void testGetResultSet() throws Exception {
        try (Connection connection = this.createConnection();
             Statement statement = connection.createStatement();){
            Assertions.assertThat((boolean)statement.execute("SELECT 123 x, 'foo' y")).isTrue();
            ResultSet result = statement.getResultSet();
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((boolean)result.isClosed()).isFalse();
            statement.getMoreResults();
            Assertions.assertThat((boolean)result.isClosed()).isTrue();
            Assertions.assertThat((boolean)statement.execute("SELECT 123 x, 'foo' y")).isTrue();
            result = statement.getResultSet();
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((boolean)result.isClosed()).isFalse();
            Assertions.assertThat((boolean)statement.execute("SELECT 123 x, 'foo' y")).isTrue();
            Assertions.assertThat((boolean)statement.getMoreResults(1)).isFalse();
        }
    }

    @Test
    public void testGetMoreResultsException() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try (Connection connection = this.createConnection();
                 Statement statement = connection.createStatement();){
                Assertions.assertThat((boolean)statement.execute("SELECT 123 x, 'foo' y")).isTrue();
                statement.getMoreResults(2);
            }
        }).isInstanceOf(SQLFeatureNotSupportedException.class)).hasMessage("Multiple open results not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMoreResultsClearsUpdateCount() throws Exception {
        try (Connection connection = this.createConnection("blackhole", "default");){
            Object statement;
            try {
                statement = connection.createStatement().unwrap(TrinoStatement.class);
                try {
                    Assertions.assertThat((boolean)statement.execute("CREATE TABLE test_more_results_clears_update_count (id bigint)")).isFalse();
                    Assertions.assertThat((int)statement.getUpdateCount()).isEqualTo(0);
                    Assertions.assertThat((String)statement.getUpdateType()).isEqualTo("CREATE TABLE");
                    Assertions.assertThat((boolean)statement.getMoreResults()).isFalse();
                    Assertions.assertThat((int)statement.getUpdateCount()).isEqualTo(-1);
                    Assertions.assertThat((String)statement.getUpdateType()).isNull();
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                statement = connection.createStatement();
                try {
                    statement.execute("DROP TABLE test_more_results_clears_update_count");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
        }
    }

    @Test
    public void testSetTimeZoneId() throws Exception {
        ResultSet rs;
        Statement statement;
        TimeZoneKey defaultZoneKey = TimeZoneKey.getTimeZoneKey((String)TimeZone.getDefault().getID());
        DateTimeZone defaultZone = DateTimeZone.forTimeZone((TimeZone)TimeZone.getDefault());
        String sql = "SELECT current_timezone() zone, TIMESTAMP '2001-02-03 3:04:05' ts";
        try (Connection connection = this.createConnection();){
            statement = connection.createStatement();
            try {
                rs = statement.executeQuery(sql);
                try {
                    Assertions.assertThat((boolean)rs.next()).isTrue();
                    Assertions.assertThat((String)rs.getString("zone")).isEqualTo(defaultZoneKey.getId());
                    Assertions.assertThat((java.util.Date)rs.getTimestamp("ts")).isEqualTo((Object)new Timestamp(new DateTime(2001, 2, 3, 3, 4, 5, defaultZone).getMillis()));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            connection.unwrap(TrinoConnection.class).setTimeZoneId("UTC");
            statement = connection.createStatement();
            try {
                rs = statement.executeQuery(sql);
                try {
                    Assertions.assertThat((boolean)rs.next()).isTrue();
                    Assertions.assertThat((String)rs.getString("zone")).isEqualTo("UTC");
                    Assertions.assertThat((java.util.Date)rs.getTimestamp("ts")).isEqualTo((Object)new Timestamp(new DateTime(2001, 2, 3, 3, 4, 5, defaultZone).getMillis()));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        connection = this.createConnectionWithParameter("timezone=Asia/Kolkata");
        try {
            statement = connection.createStatement();
            try {
                rs = statement.executeQuery(sql);
                try {
                    Assertions.assertThat((boolean)rs.next()).isTrue();
                    Assertions.assertThat((String)rs.getString("zone")).isEqualTo("Asia/Kolkata");
                    Assertions.assertThat((java.util.Date)rs.getTimestamp("ts")).isEqualTo((Object)new Timestamp(new DateTime(2001, 2, 3, 3, 4, 5, defaultZone).getMillis()));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = this.createConnectionWithParameter("timezone=UTC+05:30");
        try {
            statement = connection.createStatement();
            try {
                rs = statement.executeQuery(sql);
                try {
                    Assertions.assertThat((boolean)rs.next()).isTrue();
                    Assertions.assertThat((String)rs.getString("zone")).isEqualTo("+05:30");
                    Assertions.assertThat((java.util.Date)rs.getTimestamp("ts")).isEqualTo((Object)new Timestamp(new DateTime(2001, 2, 3, 3, 4, 5, defaultZone).getMillis()));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createConnectionWithParameter("timezone=Asia/NOT_FOUND")).isInstanceOf(SQLException.class)).hasMessage("Connection property timezone value is invalid: Asia/NOT_FOUND").hasRootCauseInstanceOf(ZoneRulesException.class).hasRootCauseMessage("Unknown time-zone ID: Asia/NOT_FOUND");
    }

    @Test
    public void testConnectionStringWithCatalogAndSchema() throws Exception {
        String prefix = String.format("jdbc:trino://%s", this.server.getAddress());
        Connection connection = DriverManager.getConnection(prefix + "/a/b/", "test", null);
        Assertions.assertThat((String)connection.getCatalog()).isEqualTo("a");
        Assertions.assertThat((String)connection.getSchema()).isEqualTo("b");
        connection = DriverManager.getConnection(prefix + "/a/b", "test", null);
        Assertions.assertThat((String)connection.getCatalog()).isEqualTo("a");
        Assertions.assertThat((String)connection.getSchema()).isEqualTo("b");
        connection = DriverManager.getConnection(prefix + "/a/", "test", null);
        Assertions.assertThat((String)connection.getCatalog()).isEqualTo("a");
        Assertions.assertThat((String)connection.getSchema()).isNull();
        connection = DriverManager.getConnection(prefix + "/a", "test", null);
        Assertions.assertThat((String)connection.getCatalog()).isEqualTo("a");
        Assertions.assertThat((String)connection.getSchema()).isNull();
        connection = DriverManager.getConnection(prefix + "/", "test", null);
        Assertions.assertThat((String)connection.getCatalog()).isNull();
        Assertions.assertThat((String)connection.getSchema()).isNull();
        connection = DriverManager.getConnection(prefix, "test", null);
        Assertions.assertThat((String)connection.getCatalog()).isNull();
        Assertions.assertThat((String)connection.getSchema()).isNull();
    }

    @Test
    public void testConnectionWithCatalogAndSchema() throws Exception {
        try (Connection connection = this.createConnection(TEST_CATALOG, "information_schema");
             Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery("SELECT table_catalog, table_schema FROM tables WHERE table_schema = 'information_schema'   AND table_name = 'tables'");){
            ResultSetMetaData metadata = rs.getMetaData();
            Assertions.assertThat((int)metadata.getColumnCount()).isEqualTo(2);
            Assertions.assertThat((String)metadata.getColumnLabel(1)).isEqualTo("table_catalog");
            Assertions.assertThat((String)metadata.getColumnLabel(2)).isEqualTo("table_schema");
            Assertions.assertThat((boolean)rs.next()).isTrue();
            Assertions.assertThat((String)rs.getString("table_catalog")).isEqualTo(TEST_CATALOG);
        }
    }

    @Test
    public void testConnectionWithCatalog() throws Exception {
        try (Connection connection = this.createConnection(TEST_CATALOG);
             Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery("SELECT table_catalog, table_schema FROM information_schema.tables WHERE table_schema = 'information_schema'   AND table_name = 'tables'");){
            ResultSetMetaData metadata = rs.getMetaData();
            Assertions.assertThat((int)metadata.getColumnCount()).isEqualTo(2);
            Assertions.assertThat((String)metadata.getColumnLabel(1)).isEqualTo("table_catalog");
            Assertions.assertThat((String)metadata.getColumnLabel(2)).isEqualTo("table_schema");
            Assertions.assertThat((boolean)rs.next()).isTrue();
            Assertions.assertThat((String)rs.getString("table_catalog")).isEqualTo(TEST_CATALOG);
        }
    }

    @Test
    public void testConnectionResourceHandling() throws Exception {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (int i = 0; i < 100; ++i) {
            Connection connection = this.createConnection();
            connections.add(connection);
            try (Statement statement = connection.createStatement();
                 ResultSet rs = statement.executeQuery("SELECT 123");){
                Assertions.assertThat((boolean)rs.next()).isTrue();
                continue;
            }
        }
        for (Connection connection : connections) {
            connection.close();
        }
    }

    @Test
    public void testBadQuery() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try (Connection connection = this.createConnection(TEST_CATALOG, "tiny");
                 Statement statement = connection.createStatement();
                 ResultSet ignored = statement.executeQuery("SELECT * FROM bad_table");){
                Fail.fail((String)"expected exception");
            }
        }).isInstanceOf(SQLException.class)).hasMessageMatching(".* does not exist");
    }

    @Test
    public void testNullConnectProperties() throws Exception {
        DriverManager.getDriver("jdbc:trino:").connect(this.jdbcUrl(), null);
    }

    @Test
    public void testPropertyAllowed() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DriverManager.getConnection(this.jdbcUrl(), TestTrinoDriver.toProperties((Map<String, String>)ImmutableMap.builder().put((Object)"user", (Object)"test").put((Object)"KerberosPrincipal", (Object)"test").buildOrThrow()))).isInstanceOf(SQLException.class)).hasMessage("Connection property KerberosPrincipal requires KerberosRemoteServiceName to be set");
        Assertions.assertThat((Object)DriverManager.getConnection(this.jdbcUrl(), TestTrinoDriver.toProperties((Map<String, String>)ImmutableMap.builder().put((Object)"user", (Object)"test").put((Object)"KerberosRemoteServiceName", (Object)"example.com").put((Object)"KerberosPrincipal", (Object)"test").put((Object)"SSL", (Object)"true").buildOrThrow()))).isNotNull();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DriverManager.getConnection(this.jdbcUrl(), TestTrinoDriver.toProperties((Map<String, String>)ImmutableMap.builder().put((Object)"user", (Object)"test").put((Object)"SSLVerification", (Object)"NONE").buildOrThrow()))).isInstanceOf(SQLException.class)).hasMessage("Connection property SSLVerification requires TLS/SSL to be enabled");
        Assertions.assertThat((Object)DriverManager.getConnection(this.jdbcUrl(), TestTrinoDriver.toProperties((Map<String, String>)ImmutableMap.builder().put((Object)"user", (Object)"test").put((Object)"SSL", (Object)"true").put((Object)"SSLVerification", (Object)"NONE").buildOrThrow()))).isNotNull();
        Assertions.assertThat((Object)DriverManager.getConnection(this.jdbcUrl(), TestTrinoDriver.toProperties((Map<String, String>)ImmutableMap.builder().put((Object)"user", (Object)"test").put((Object)"SSL", (Object)"true").put((Object)"SSLVerification", (Object)"NONE").put((Object)"assumeLiteralNamesInMetadataCallsForNonConformingClients", (Object)"true").buildOrThrow()))).isNotNull();
        Assertions.assertThat((Object)DriverManager.getConnection(this.jdbcUrl(), TestTrinoDriver.toProperties((Map<String, String>)ImmutableMap.builder().put((Object)"user", (Object)"test").put((Object)"SSL", (Object)"true").put((Object)"SSLVerification", (Object)"NONE").put((Object)"assumeLiteralUnderscoreInMetadataCallsForNonConformingClients", (Object)"true").buildOrThrow()))).isNotNull();
    }

    @Test
    public void testSetRole() throws Exception {
        try (TrinoConnection connection = this.createConnection(TEST_CATALOG, "tiny").unwrap(TrinoConnection.class);){
            try (Statement statement = connection.createStatement();){
                statement.executeUpdate("SET ROLE ALL");
            }
            Assertions.assertThat((Map)connection.getRoles()).isEqualTo((Object)ImmutableMap.of((Object)"system", (Object)new ClientSelectedRole(ClientSelectedRole.Type.ALL, Optional.empty())));
            statement = connection.createStatement();
            try {
                statement.executeUpdate("SET ROLE NONE");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            Assertions.assertThat((Map)connection.getRoles()).isEqualTo((Object)ImmutableMap.of((Object)"system", (Object)new ClientSelectedRole(ClientSelectedRole.Type.NONE, Optional.empty())));
            statement = connection.createStatement();
            try {
                Assertions.assertThatThrownBy(() -> statement.executeUpdate("SET ROLE bar")).hasMessageMatching(".* Role 'bar' does not exist");
                Assertions.assertThatThrownBy(() -> statement.executeUpdate("SET ROLE ALL IN test_catalog")).hasMessageMatching(".* Catalog '.*' does not support role management");
                Assertions.assertThatThrownBy(() -> statement.executeUpdate("SET ROLE NONE IN test_catalog")).hasMessageMatching(".* Catalog '.*' does not support role management");
                Assertions.assertThatThrownBy(() -> statement.executeUpdate("SET ROLE bar IN test_catalog")).hasMessageMatching(".* Catalog '.*' does not support role management");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    @Test
    @Timeout(value=10L)
    public void testQueryCancelByInterrupt() throws Exception {
        CountDownLatch queryStarted = new CountDownLatch(1);
        CountDownLatch queryFinished = new CountDownLatch(1);
        AtomicReference queryId = new AtomicReference();
        AtomicReference queryFailure = new AtomicReference();
        Future<Object> queryFuture = this.executorService.submit(() -> {
            try (Connection connection = this.createConnection("blackhole", "blackhole");
                 Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT * FROM slow_test_table");){
                queryId.set(resultSet.unwrap(TrinoResultSet.class).getQueryId());
                queryStarted.countDown();
                try {
                    resultSet.next();
                }
                catch (SQLException t) {
                    queryFailure.set(t);
                }
                finally {
                    queryFinished.countDown();
                }
            }
            return null;
        });
        Assertions.assertThat((boolean)queryStarted.await(10L, TimeUnit.SECONDS)).isTrue();
        Assertions.assertThat((String)((String)queryId.get())).isNotNull();
        Assertions.assertThat((boolean)this.getQueryState((String)queryId.get()).isDone()).isFalse();
        queryFuture.cancel(true);
        Assertions.assertThat((boolean)queryFinished.await(10L, TimeUnit.SECONDS)).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)((Throwable)queryFailure.get())).isInstanceOf(SQLException.class)).hasMessage("Interrupted");
        Assertions.assertThat((Comparable)this.getQueryState((String)queryId.get())).isEqualTo((Object)QueryState.FAILED);
    }

    @Test
    @Timeout(value=10L)
    public void testQueryCancelExplicit() throws Exception {
        CountDownLatch queryStarted = new CountDownLatch(1);
        CountDownLatch queryFinished = new CountDownLatch(1);
        AtomicReference queryId = new AtomicReference();
        AtomicReference queryFailure = new AtomicReference();
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            this.executorService.execute(() -> {
                try (ResultSet resultSet = statement.executeQuery("SELECT * FROM slow_test_table");){
                    queryId.set(resultSet.unwrap(TrinoResultSet.class).getQueryId());
                    queryStarted.countDown();
                    resultSet.next();
                }
                catch (SQLException t) {
                    queryFailure.set(t);
                }
                finally {
                    queryFinished.countDown();
                }
            });
            queryStarted.await(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)((String)queryId.get())).isNotNull();
            Assertions.assertThat((boolean)this.getQueryState((String)queryId.get()).isDone()).isFalse();
            statement.cancel();
            queryFinished.await(10L, TimeUnit.SECONDS);
            Assertions.assertThat((Throwable)((Throwable)queryFailure.get())).isNotNull();
            Assertions.assertThat((Comparable)this.getQueryState((String)queryId.get())).isEqualTo((Object)QueryState.FAILED);
        }
    }

    @Test
    @Timeout(value=10L)
    public void testUpdateCancelExplicit() throws Exception {
        CountDownLatch queryFinished = new CountDownLatch(1);
        AtomicReference queryFailure = new AtomicReference();
        String queryUuid = "/* " + UUID.randomUUID().toString() + " */";
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            Optional<QueryState> state;
            this.executorService.execute(() -> {
                try {
                    statement.executeUpdate("CREATE TABLE test_cancel_create AS SELECT * FROM slow_test_table " + queryUuid);
                }
                catch (SQLException t) {
                    queryFailure.set(t);
                }
                finally {
                    queryFinished.countDown();
                }
            });
            while (true) {
                if ((state = this.findQueryState(queryUuid)).isPresent()) break;
                TimeUnit.MILLISECONDS.sleep(50L);
            }
            Assertions.assertThat((boolean)state.get().isDone()).isFalse();
            statement.cancel();
            queryFinished.await(10L, TimeUnit.SECONDS);
            Assertions.assertThat((Throwable)((Throwable)queryFailure.get())).isNotNull();
            Assertions.assertThat(this.findQueryState(queryUuid)).isEqualTo(Optional.of(QueryState.FAILED));
        }
    }

    @Test
    @Timeout(value=10L)
    public void testQueryTimeout() throws Exception {
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE test_query_timeout (key BIGINT) WITH (   split_count = 1,    pages_per_split = 1,    rows_per_page = 1,    page_processing_delay = '1m')");
        }
        CountDownLatch queryFinished = new CountDownLatch(1);
        AtomicReference queryFailure = new AtomicReference();
        this.executorService.submit(() -> {
            try (Connection connection = this.createConnection("blackhole", "blackhole");
                 Statement statement = connection.createStatement();){
                statement.setQueryTimeout(1);
                try (ResultSet resultSet = statement.executeQuery("SELECT * FROM test_query_timeout");){
                    try {
                        resultSet.next();
                    }
                    catch (SQLException t) {
                        queryFailure.set(t);
                    }
                    finally {
                        queryFinished.countDown();
                    }
                }
            }
            return null;
        });
        queryFinished.await();
        Assertions.assertThat((Throwable)((Throwable)queryFailure.get())).isNotNull();
        Assertions.assertThat((Throwable)((Throwable)queryFailure.get())).hasMessageContaining("Query exceeded maximum time limit of 1.00s");
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            statement.executeUpdate("DROP TABLE test_query_timeout");
        }
    }

    @Test
    @Timeout(value=10L)
    public void testQueryPartialCancel() throws Exception {
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT count(*) FROM slow_test_table");){
            statement.unwrap(TrinoStatement.class).partialCancel();
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
            Assertions.assertThat((long)resultSet.getLong(1)).isEqualTo(0L);
        }
    }

    @Test
    @Timeout(value=10L)
    public void testUpdatePartialCancel() throws Exception {
        CountDownLatch queryRunning = new CountDownLatch(1);
        try (Connection connection = this.createConnection("blackhole", "blackhole");
             Statement statement = connection.createStatement();){
            Future<Integer> future = this.executorService.submit(() -> statement.executeUpdate("INSERT INTO test_table SELECT count(*) x FROM slow_test_table"));
            statement.unwrap(TrinoStatement.class).setProgressMonitor(stats -> {
                if (stats.getState().equals(QueryState.RUNNING.toString())) {
                    queryRunning.countDown();
                }
            });
            queryRunning.await(10L, TimeUnit.SECONDS);
            statement.unwrap(TrinoStatement.class).partialCancel();
            Assertions.assertThat((Integer)future.get(10L, TimeUnit.SECONDS)).isEqualTo((Object)1);
        }
    }

    @Test
    public void testCustomDnsResolver() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("dnsResolver", TestingDnsResolver.class.getName());
        properties.setProperty("dnsResolverContext", this.server.getAddress().getHost());
        properties.setProperty("user", "test");
        String url = "jdbc:trino://mycustomaddress:" + this.server.getAddress().getPort();
        try (Connection connection = DriverManager.getConnection(url, properties);
             Statement statement = connection.createStatement();){
            Assertions.assertThat((boolean)statement.execute("SELECT 1")).isTrue();
        }
    }

    @Test
    @Timeout(value=10L)
    public void testResetSessionAuthorization() throws Exception {
        try (TrinoConnection connection = this.createConnection("blackhole", "blackhole").unwrap(TrinoConnection.class);
             Statement statement = connection.createStatement();){
            Assertions.assertThat((String)connection.getAuthorizationUser()).isEqualTo(null);
            Assertions.assertThat((String)TestTrinoDriver.getCurrentUser((Connection)connection)).isEqualTo("test");
            statement.execute("SET SESSION AUTHORIZATION john");
            Assertions.assertThat((String)connection.getAuthorizationUser()).isEqualTo("john");
            Assertions.assertThat((String)TestTrinoDriver.getCurrentUser((Connection)connection)).isEqualTo("john");
            statement.execute("SET SESSION AUTHORIZATION bob");
            Assertions.assertThat((String)connection.getAuthorizationUser()).isEqualTo("bob");
            Assertions.assertThat((String)TestTrinoDriver.getCurrentUser((Connection)connection)).isEqualTo("bob");
            statement.execute("RESET SESSION AUTHORIZATION");
            Assertions.assertThat((String)connection.getAuthorizationUser()).isEqualTo(null);
            Assertions.assertThat((String)TestTrinoDriver.getCurrentUser((Connection)connection)).isEqualTo("test");
        }
    }

    @Test
    @Timeout(value=10L)
    public void testSetRoleAfterSetSessionAuthorization() throws Exception {
        try (TrinoConnection connection = this.createConnection("blackhole", "blackhole").unwrap(TrinoConnection.class);
             Statement statement = connection.createStatement();){
            statement.execute("SET SESSION AUTHORIZATION john");
            Assertions.assertThat((String)connection.getAuthorizationUser()).isEqualTo("john");
            statement.execute("SET ROLE ALL");
            Assertions.assertThat((Map)connection.getRoles()).isEqualTo((Object)ImmutableMap.of((Object)"system", (Object)new ClientSelectedRole(ClientSelectedRole.Type.ALL, Optional.empty())));
            statement.execute("SET SESSION AUTHORIZATION bob");
            Assertions.assertThat((String)connection.getAuthorizationUser()).isEqualTo("bob");
            Assertions.assertThat((Map)connection.getRoles()).isEqualTo((Object)ImmutableMap.of());
            statement.execute("SET ROLE NONE");
            Assertions.assertThat((Map)connection.getRoles()).isEqualTo((Object)ImmutableMap.of((Object)"system", (Object)new ClientSelectedRole(ClientSelectedRole.Type.NONE, Optional.empty())));
            statement.execute("RESET SESSION AUTHORIZATION");
            Assertions.assertThat((String)connection.getAuthorizationUser()).isEqualTo(null);
            Assertions.assertThat((Map)connection.getRoles()).isEqualTo((Object)ImmutableMap.of());
        }
    }

    /*
     * Exception decompiling
     */
    private QueryState getQueryState(String queryId) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Optional<QueryState> findQueryState(String text) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String jdbcUrl() {
        return String.format("jdbc:trino://%s", this.server.getAddress());
    }

    private Connection createConnection() throws SQLException {
        String url = String.format("jdbc:trino://%s", this.server.getAddress());
        return DriverManager.getConnection(url, "test", null);
    }

    private Connection createConnection(String catalog) throws SQLException {
        String url = String.format("jdbc:trino://%s/%s", this.server.getAddress(), catalog);
        return DriverManager.getConnection(url, "test", null);
    }

    private Connection createConnection(String catalog, String schema) throws SQLException {
        String url = String.format("jdbc:trino://%s/%s/%s", this.server.getAddress(), catalog, schema);
        return DriverManager.getConnection(url, "test", null);
    }

    private Connection createConnectionWithParameter(String parameter) throws SQLException {
        String url = String.format("jdbc:trino://%s?%s", this.server.getAddress(), parameter);
        return DriverManager.getConnection(url, "test", null);
    }

    private static Properties toProperties(Map<String, String> map) {
        Properties properties = new Properties();
        map.forEach(properties::setProperty);
        return properties;
    }

    private static String getCurrentUser(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery("SELECT current_user");){
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        throw new RuntimeException("Failed to get CURRENT_USER");
    }

    public static class TestingDnsResolver
    implements DnsResolver {
        private final String context;

        public TestingDnsResolver(String context) {
            this.context = Objects.requireNonNull(context, "context is null");
        }

        public List<InetAddress> lookup(String hostname) throws UnknownHostException {
            if ("mycustomaddress".equals(hostname)) {
                return ImmutableList.of((Object)InetAddress.getByName(this.context));
            }
            throw new UnknownHostException("Cannot resolve host: " + hostname);
        }
    }
}

