/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.$internal.client.Column;
import io.trino.jdbc.$internal.client.JsonQueryData;
import io.trino.jdbc.$internal.client.JsonResultRows;
import io.trino.jdbc.$internal.client.OkHttpSegmentLoader;
import io.trino.jdbc.$internal.client.QueryData;
import io.trino.jdbc.$internal.client.QueryDataDecoder;
import io.trino.jdbc.$internal.client.QueryResults;
import io.trino.jdbc.$internal.client.ResultRows;
import io.trino.jdbc.$internal.client.TypedQueryData;
import io.trino.jdbc.$internal.client.spooling.DataAttributes;
import io.trino.jdbc.$internal.client.spooling.EncodedQueryData;
import io.trino.jdbc.$internal.client.spooling.InlineSegment;
import io.trino.jdbc.$internal.client.spooling.Segment;
import io.trino.jdbc.$internal.client.spooling.SegmentLoader;
import io.trino.jdbc.$internal.client.spooling.SpooledSegment;
import io.trino.jdbc.$internal.client.spooling.encoding.QueryDataDecoders;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.base.Verify;
import io.trino.jdbc.$internal.guava.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

public class ResultRowsDecoder
implements AutoCloseable {
    private final SegmentLoader loader;
    private QueryDataDecoder decoder;

    public ResultRowsDecoder() {
        this(new OkHttpSegmentLoader());
    }

    public ResultRowsDecoder(SegmentLoader loader) {
        this.loader = Objects.requireNonNull(loader, "loader is null");
    }

    private void setEncoding(List<Column> columns, String encoding) {
        if (this.decoder != null) {
            Preconditions.checkState(this.decoder.encoding().equals(encoding), "Decoder is configured for encoding %s but got %s", (Object)this.decoder.encoding(), (Object)encoding);
        } else {
            Preconditions.checkState(!columns.isEmpty(), "Columns must be set when decoding data");
            this.decoder = QueryDataDecoders.get(encoding).create(columns, DataAttributes.empty());
        }
    }

    public ResultRows toRows(QueryResults results) {
        if (results == null || results.getData() == null) {
            return ResultRows.NULL_ROWS;
        }
        return this.toRows(results.getColumns(), results.getData());
    }

    public ResultRows toRows(List<Column> columns, QueryData data) {
        if (data == null || data.isNull()) {
            return ResultRows.NULL_ROWS;
        }
        Verify.verify(columns != null && !columns.isEmpty(), "Columns must be set when decoding data", new Object[0]);
        if (data instanceof TypedQueryData) {
            TypedQueryData rawData = (TypedQueryData)data;
            if (rawData.isNull()) {
                return ResultRows.NULL_ROWS;
            }
            return () -> rawData.getIterable().iterator();
        }
        if (data instanceof JsonQueryData) {
            JsonQueryData jsonData = (JsonQueryData)data;
            if (jsonData.isNull()) {
                return ResultRows.NULL_ROWS;
            }
            return () -> JsonResultRows.forJsonParser(jsonData.getJsonParser(), columns).iterator();
        }
        if (data instanceof EncodedQueryData) {
            EncodedQueryData encodedData = (EncodedQueryData)data;
            this.setEncoding(columns, encodedData.getEncoding());
            return ResultRowsDecoder.concat(Iterables.transform(encodedData.getSegments(), this::segmentToRows));
        }
        throw new UnsupportedOperationException("Unsupported data type: " + data.getClass().getName());
    }

    private ResultRows segmentToRows(Segment segment) {
        if (segment instanceof InlineSegment) {
            InlineSegment inlineSegment = (InlineSegment)segment;
            try {
                return this.decoder.decode(new ByteArrayInputStream(inlineSegment.getData()), inlineSegment.getMetadata());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (segment instanceof SpooledSegment) {
            SpooledSegment spooledSegment = (SpooledSegment)segment;
            try {
                InputStream stream = this.loader.load(spooledSegment);
                return this.decoder.decode(stream, spooledSegment.getMetadata());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new UnsupportedOperationException("Unsupported segment type: " + segment.getClass().getName());
    }

    public Optional<String> getEncoding() {
        return Optional.ofNullable(this.decoder).map(QueryDataDecoder::encoding);
    }

    @Override
    public void close() throws Exception {
        this.loader.close();
    }

    @SuppressModernizer
    private static ResultRows concat(Iterable<ResultRows> resultRows) {
        return ResultRows.fromIterableRows(Iterables.concat(Iterables.filter(resultRows, rows -> !rows.isNull())));
    }
}

