/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.airlift.compress.v3.zstd;

import io.trino.jdbc.$internal.airlift.compress.v3.zstd.UnsafeUtil;
import io.trino.jdbc.$internal.airlift.compress.v3.zstd.ZstdCompressor;
import io.trino.jdbc.$internal.airlift.compress.v3.zstd.ZstdFrameCompressor;
import java.lang.foreign.MemorySegment;
import java.lang.ref.Reference;
import java.util.Objects;
import sun.misc.Unsafe;

public class ZstdJavaCompressor
implements ZstdCompressor {
    @Override
    public int maxCompressedLength(int uncompressedSize) {
        int result = uncompressedSize + (uncompressedSize >>> 8);
        if (uncompressedSize < 131072) {
            result += 131072 - uncompressedSize >>> 11;
        }
        return result;
    }

    @Override
    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        ZstdJavaCompressor.verifyRange(input, inputOffset, inputLength);
        ZstdJavaCompressor.verifyRange(output, outputOffset, maxOutputLength);
        long inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + inputOffset;
        long outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + outputOffset;
        return ZstdFrameCompressor.compress(input, inputAddress, inputAddress + (long)inputLength, output, outputAddress, outputAddress + (long)maxOutputLength, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compress(MemorySegment input, MemorySegment output) {
        try {
            byte[] inputBase = UnsafeUtil.getBase(input);
            long inputAddress = UnsafeUtil.getAddress(input);
            long inputLimit = Math.addExact(inputAddress, input.byteSize());
            byte[] outputBase = UnsafeUtil.getBase(output);
            long outputAddress = UnsafeUtil.getAddress(output);
            long outputLimit = Math.addExact(outputAddress, output.byteSize());
            int n = ZstdFrameCompressor.compress(inputBase, inputAddress, inputLimit, outputBase, outputAddress, outputLimit, 3);
            return n;
        }
        finally {
            Reference.reachabilityFence(input);
            Reference.reachabilityFence(output);
        }
    }

    private static void verifyRange(byte[] data, int offset, int length) {
        Objects.requireNonNull(data, "data is null");
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new IllegalArgumentException(String.format("Invalid offset or length (%s, %s) in array of length %s", offset, length, data.length));
        }
    }
}

