/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import com.google.errorprone.annotations.ThreadSafe;
import io.trino.jdbc.;
import io.trino.jdbc.$internal.airlift.units.Duration;
import io.trino.jdbc.$internal.client.ClientCapabilities;
import io.trino.jdbc.$internal.client.ClientException;
import io.trino.jdbc.$internal.client.ClientSelectedRole;
import io.trino.jdbc.$internal.client.ClientSession;
import io.trino.jdbc.$internal.client.HttpStatusCodes;
import io.trino.jdbc.$internal.client.JsonResponse;
import io.trino.jdbc.$internal.client.OkHttpSegmentLoader;
import io.trino.jdbc.$internal.client.ProtocolHeaders;
import io.trino.jdbc.$internal.client.QueryData;
import io.trino.jdbc.$internal.client.QueryResults;
import io.trino.jdbc.$internal.client.QueryStatusInfo;
import io.trino.jdbc.$internal.client.ResultRows;
import io.trino.jdbc.$internal.client.ResultRowsDecoder;
import io.trino.jdbc.$internal.client.StatementClient;
import io.trino.jdbc.$internal.client.StatementStats;
import io.trino.jdbc.$internal.client.TrinoJsonCodec;
import io.trino.jdbc.$internal.guava.base.Joiner;
import io.trino.jdbc.$internal.guava.base.MoreObjects;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.base.Splitter;
import io.trino.jdbc.$internal.guava.base.Throwables;
import io.trino.jdbc.$internal.guava.collect.ImmutableList;
import io.trino.jdbc.$internal.guava.collect.ImmutableMap;
import io.trino.jdbc.$internal.guava.collect.ImmutableSet;
import io.trino.jdbc.$internal.guava.collect.Sets;
import io.trino.jdbc.$internal.okhttp3.Call;
import io.trino.jdbc.$internal.okhttp3.Headers;
import io.trino.jdbc.$internal.okhttp3.HttpUrl;
import io.trino.jdbc.$internal.okhttp3.MediaType;
import io.trino.jdbc.$internal.okhttp3.Request;
import io.trino.jdbc.$internal.okhttp3.RequestBody;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Stream;

@ThreadSafe
class StatementClientV1
implements StatementClient {
    private static final MediaType MEDIA_TYPE_TEXT = MediaType.parse("text/plain; charset=utf-8");
    private static final TrinoJsonCodec<QueryResults> QUERY_RESULTS_CODEC = TrinoJsonCodec.jsonCodec(QueryResults.class);
    private static final Splitter COLLECTION_HEADER_SPLITTER = Splitter.on('=').limit(2).trimResults();
    private static final String USER_AGENT_VALUE = StatementClientV1.class.getSimpleName() + "/" + MoreObjects.firstNonNull(StatementClientV1.class.getPackage().getImplementationVersion(), "unknown");
    private static final long MAX_MATERIALIZED_JSON_RESPONSE_SIZE = 131072L;
    private final Call.Factory httpCallFactory;
    private final String query;
    private final AtomicReference<QueryResults> currentResults = new AtomicReference();
    private final AtomicReference<ResultRows> currentRows = new AtomicReference();
    private final AtomicReference<String> setCatalog = new AtomicReference();
    private final AtomicReference<String> setSchema = new AtomicReference();
    private final AtomicReference<List<String>> setPath = new AtomicReference();
    private final AtomicReference<String> setAuthorizationUser = new AtomicReference();
    private final AtomicBoolean resetAuthorizationUser = new AtomicBoolean();
    private final Map<String, String> setSessionProperties = new ConcurrentHashMap<String, String>();
    private final Set<String> resetSessionProperties = Sets.newConcurrentHashSet();
    private final Map<String, ClientSelectedRole> setRoles = new ConcurrentHashMap<String, ClientSelectedRole>();
    private final Map<String, String> addedPreparedStatements = new ConcurrentHashMap<String, String>();
    private final Set<String> deallocatedPreparedStatements = Sets.newConcurrentHashSet();
    private final AtomicReference<String> startedTransactionId = new AtomicReference();
    private final AtomicBoolean clearTransactionId = new AtomicBoolean();
    private final ZoneId timeZone;
    private final Duration requestTimeoutNanos;
    private final Optional<String> user;
    private final Optional<String> originalUser;
    private final String clientCapabilities;
    private final boolean compressionDisabled;
    private final AtomicReference<State> state = new AtomicReference<State>(State.RUNNING);
    private final ResultRowsDecoder resultRowsDecoder;

    public StatementClientV1(Call.Factory httpCallFactory, Call.Factory segmentHttpCallFactory, ClientSession session, String query, Optional<Set<String>> clientCapabilities) {
        Objects.requireNonNull(httpCallFactory, "httpCallFactory is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(query, "query is null");
        this.httpCallFactory = httpCallFactory;
        this.timeZone = session.getTimeZone();
        this.query = query;
        this.requestTimeoutNanos = session.getClientRequestTimeout();
        this.user = Stream.of(session.getAuthorizationUser(), session.getSessionUser(), session.getUser()).filter(Optional::isPresent).map(Optional::get).findFirst();
        this.originalUser = Stream.of(session.getSessionUser(), session.getUser()).filter(Optional::isPresent).map(Optional::get).findFirst();
        this.clientCapabilities = Joiner.on(",").join(clientCapabilities.orElseGet(() -> Arrays.stream(ClientCapabilities.values()).map(Enum::name).collect(ImmutableSet.toImmutableSet())));
        this.compressionDisabled = session.isCompressionDisabled();
        this.resultRowsDecoder = new ResultRowsDecoder(new OkHttpSegmentLoader(Objects.requireNonNull(segmentHttpCallFactory, "segmentHttpCallFactory is null")));
        Request request = this.buildQueryRequest(session, query, session.getEncoding());
        this.executeRequest(request, "starting query", OptionalLong.empty(), this::isTransient);
    }

    private Request buildQueryRequest(ClientSession session, String query, Optional<String> requestedEncoding) {
        HttpUrl url = HttpUrl.get(session.getServer());
        if (url == null) {
            throw new ClientException("Invalid server URL: " + String.valueOf(session.getServer()));
        }
        url = url.newBuilder().encodedPath("/v1/statement").build();
        Request.Builder builder = this.prepareRequest(url).post(RequestBody.create(query, MEDIA_TYPE_TEXT));
        if (session.getSource() != null) {
            builder.addHeader(ProtocolHeaders.TRINO_HEADERS.requestSource(), session.getSource());
        }
        session.getTraceToken().ifPresent(token -> builder.addHeader(ProtocolHeaders.TRINO_HEADERS.requestTraceToken(), (String)token));
        if (session.getClientTags() != null && !session.getClientTags().isEmpty()) {
            builder.addHeader(ProtocolHeaders.TRINO_HEADERS.requestClientTags(), Joiner.on(",").join(session.getClientTags()));
        }
        if (session.getClientInfo() != null) {
            builder.addHeader(ProtocolHeaders.TRINO_HEADERS.requestClientInfo(), session.getClientInfo());
        }
        session.getCatalog().ifPresent(value -> builder.addHeader(ProtocolHeaders.TRINO_HEADERS.requestCatalog(), (String)value));
        session.getSchema().ifPresent(value -> builder.addHeader(ProtocolHeaders.TRINO_HEADERS.requestSchema(), (String)value));
        if (session.getPath() != null && !session.getPath().isEmpty()) {
            builder.addHeader(ProtocolHeaders.TRINO_HEADERS.requestPath(), Joiner.on(",").join(session.getPath()));
        }
        builder.addHeader(ProtocolHeaders.TRINO_HEADERS.requestTimeZone(), session.getTimeZone().getId());
        if (session.getLocale() != null) {
            builder.addHeader(ProtocolHeaders.TRINO_HEADERS.requestLanguage(), session.getLocale().toLanguageTag());
        }
        Map<String, String> property = session.getProperties();
        for (Map.Entry<String, String> entry : property.entrySet()) {
            builder.addHeader(ProtocolHeaders.TRINO_HEADERS.requestSession(), entry.getKey() + "=" + StatementClientV1.urlEncode(entry.getValue()));
        }
        Map<String, String> resourceEstimates = session.getResourceEstimates();
        for (Map.Entry<String, String> entry : resourceEstimates.entrySet()) {
            builder.addHeader(ProtocolHeaders.TRINO_HEADERS.requestResourceEstimate(), entry.getKey() + "=" + StatementClientV1.urlEncode(entry.getValue()));
        }
        Map<String, ClientSelectedRole> map = session.getRoles();
        for (Map.Entry<String, ClientSelectedRole> entry : map.entrySet()) {
            builder.addHeader(ProtocolHeaders.TRINO_HEADERS.requestRole(), entry.getKey() + "=" + StatementClientV1.urlEncode(entry.getValue().toString()));
        }
        Map<String, String> map2 = session.getExtraCredentials();
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            builder.addHeader(ProtocolHeaders.TRINO_HEADERS.requestExtraCredential(), entry.getKey() + "=" + StatementClientV1.urlEncode(entry.getValue()));
        }
        Map<String, String> map3 = session.getPreparedStatements();
        for (Map.Entry<String, String> entry : map3.entrySet()) {
            builder.addHeader(ProtocolHeaders.TRINO_HEADERS.requestPreparedStatement(), StatementClientV1.urlEncode(entry.getKey()) + "=" + StatementClientV1.urlEncode(entry.getValue()));
        }
        builder.addHeader(ProtocolHeaders.TRINO_HEADERS.requestTransactionId(), session.getTransactionId() == null ? "NONE" : session.getTransactionId());
        builder.addHeader(ProtocolHeaders.TRINO_HEADERS.requestClientCapabilities(), this.clientCapabilities);
        requestedEncoding.ifPresent(encoding -> builder.addHeader(ProtocolHeaders.TRINO_HEADERS.requestQueryDataEncoding(), (String)encoding));
        return builder.build();
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    @Override
    public boolean isRunning() {
        return this.state.get() == State.RUNNING;
    }

    @Override
    public boolean isClientAborted() {
        return this.state.get() == State.CLIENT_ABORTED;
    }

    @Override
    public boolean isClientError() {
        return this.state.get() == State.CLIENT_ERROR;
    }

    @Override
    public boolean isFinished() {
        return this.state.get() == State.FINISHED;
    }

    @Override
    public StatementStats getStats() {
        return this.currentResults.get().getStats();
    }

    @Override
    public QueryStatusInfo currentStatusInfo() {
        return this.currentResults.get();
    }

    @Override
    public ResultRows currentRows() {
        Preconditions.checkState(this.isRunning(), "current position is not valid (cursor past end)");
        return this.currentRows.get();
    }

    @Override
    public QueryData currentData() {
        Preconditions.checkState(this.isRunning(), "current position is not valid (cursor past end)");
        QueryResults queryResults = this.currentResults.get();
        if (queryResults == null || queryResults.getData() == null) {
            return null;
        }
        return queryResults.getData();
    }

    @Override
    public QueryStatusInfo finalStatusInfo() {
        Preconditions.checkState(!this.isRunning(), "current position is still valid");
        return this.currentResults.get();
    }

    @Override
    public Optional<String> getEncoding() {
        return this.resultRowsDecoder.getEncoding();
    }

    @Override
    public Optional<String> getSetCatalog() {
        return Optional.ofNullable(this.setCatalog.get());
    }

    @Override
    public Optional<String> getSetSchema() {
        return Optional.ofNullable(this.setSchema.get());
    }

    @Override
    public Optional<List<String>> getSetPath() {
        return Optional.ofNullable(this.setPath.get());
    }

    @Override
    public Optional<String> getSetAuthorizationUser() {
        return Optional.ofNullable(this.setAuthorizationUser.get());
    }

    @Override
    public boolean isResetAuthorizationUser() {
        return this.resetAuthorizationUser.get();
    }

    @Override
    public Map<String, String> getSetSessionProperties() {
        return ImmutableMap.copyOf(this.setSessionProperties);
    }

    @Override
    public Set<String> getResetSessionProperties() {
        return ImmutableSet.copyOf(this.resetSessionProperties);
    }

    @Override
    public Map<String, ClientSelectedRole> getSetRoles() {
        return ImmutableMap.copyOf(this.setRoles);
    }

    @Override
    public Map<String, String> getAddedPreparedStatements() {
        return ImmutableMap.copyOf(this.addedPreparedStatements);
    }

    @Override
    public Set<String> getDeallocatedPreparedStatements() {
        return ImmutableSet.copyOf(this.deallocatedPreparedStatements);
    }

    @Override
    @.Nullable
    public String getStartedTransactionId() {
        return this.startedTransactionId.get();
    }

    @Override
    public boolean isClearTransactionId() {
        return this.clearTransactionId.get();
    }

    private Request.Builder prepareRequest(HttpUrl url) {
        Request.Builder builder = new Request.Builder().addHeader("User-Agent", USER_AGENT_VALUE).url(url);
        this.user.ifPresent(requestUser -> builder.addHeader(ProtocolHeaders.TRINO_HEADERS.requestUser(), (String)requestUser));
        this.originalUser.ifPresent(originalUser -> builder.addHeader(ProtocolHeaders.TRINO_HEADERS.requestOriginalUser(), (String)originalUser));
        if (this.compressionDisabled) {
            builder.header("Accept-Encoding", "identity");
        }
        return builder;
    }

    @Override
    public boolean advance() {
        if (!this.isRunning()) {
            return false;
        }
        URI nextUri = this.currentStatusInfo().getNextUri();
        if (nextUri == null) {
            this.state.compareAndSet(State.RUNNING, State.FINISHED);
            return false;
        }
        Request request = this.prepareRequest(HttpUrl.get(nextUri)).build();
        return this.executeRequest(request, "fetching next", OptionalLong.of(131072L), e -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeRequest(Request request, String taskName, OptionalLong materializedJsonSizeLimit, Function<Exception, Boolean> isRetryable) {
        JsonResponse<QueryResults> response;
        block14: {
            RuntimeException cause = null;
            long start = System.nanoTime();
            long attempts = 0L;
            while (true) {
                if (this.isClientAborted()) {
                    return false;
                }
                if (attempts > 0L) {
                    Duration sinceStart = Duration.nanosSince(start);
                    if (sinceStart.compareTo(this.requestTimeoutNanos) > 0) {
                        this.close();
                        this.state.compareAndSet(State.RUNNING, State.CLIENT_ERROR);
                        throw new RuntimeException(String.format("Error fetching next (attempts: %s, duration: %s)", attempts, sinceStart), cause);
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(attempts * 100L);
                    }
                    catch (InterruptedException e) {
                        try {
                            this.close();
                        }
                        finally {
                            Thread.currentThread().interrupt();
                        }
                        this.state.compareAndSet(State.RUNNING, State.CLIENT_ERROR);
                        throw new RuntimeException("StatementClient thread was interrupted");
                    }
                }
                ++attempts;
                try {
                    response = JsonResponse.execute(QUERY_RESULTS_CODEC, this.httpCallFactory, request, materializedJsonSizeLimit);
                }
                catch (RuntimeException e) {
                    if (!isRetryable.apply(e).booleanValue()) {
                        throw e;
                    }
                    cause = e;
                    continue;
                }
                if (this.isTransient(response.getException())) {
                    cause = response.getException();
                    continue;
                }
                if (response.getStatusCode() == 200 && response.hasValue()) break block14;
                if (!HttpStatusCodes.shouldRetry(response.getStatusCode())) break;
            }
            this.state.compareAndSet(State.RUNNING, State.CLIENT_ERROR);
            throw this.requestFailedException(taskName, request, response);
        }
        this.processResponse(response.getHeaders(), response.getValue());
        return true;
    }

    private boolean isTransient(Throwable exception) {
        return exception != null && Throwables.getCausalChain(exception).stream().anyMatch(e -> e instanceof InterruptedIOException && e.getMessage().equals("timeout") || e instanceof ProtocolException || e instanceof SocketTimeoutException);
    }

    private void processResponse(Headers headers, QueryResults results) {
        List<String> keyValue;
        String resetAuthorizationUser;
        this.setCatalog.set(headers.get(ProtocolHeaders.TRINO_HEADERS.responseSetCatalog()));
        this.setSchema.set(headers.get(ProtocolHeaders.TRINO_HEADERS.responseSetSchema()));
        this.setPath.set(this.safeSplitToList(headers.get(ProtocolHeaders.TRINO_HEADERS.responseSetPath())));
        String setAuthorizationUser = headers.get(ProtocolHeaders.TRINO_HEADERS.responseSetAuthorizationUser());
        if (setAuthorizationUser != null) {
            this.setAuthorizationUser.set(setAuthorizationUser);
        }
        if ((resetAuthorizationUser = headers.get(ProtocolHeaders.TRINO_HEADERS.responseResetAuthorizationUser())) != null) {
            this.resetAuthorizationUser.set(Boolean.parseBoolean(resetAuthorizationUser));
        }
        for (String setSession : headers.values(ProtocolHeaders.TRINO_HEADERS.responseSetSession())) {
            keyValue = COLLECTION_HEADER_SPLITTER.splitToList(setSession);
            if (keyValue.size() != 2) continue;
            this.setSessionProperties.put(keyValue.get(0), StatementClientV1.urlDecode(keyValue.get(1)));
        }
        this.resetSessionProperties.addAll(headers.values(ProtocolHeaders.TRINO_HEADERS.responseClearSession()));
        for (String setRole : headers.values(ProtocolHeaders.TRINO_HEADERS.responseSetRole())) {
            keyValue = COLLECTION_HEADER_SPLITTER.splitToList(setRole);
            if (keyValue.size() != 2) continue;
            this.setRoles.put(keyValue.get(0), ClientSelectedRole.valueOf(StatementClientV1.urlDecode(keyValue.get(1))));
        }
        for (String entry : headers.values(ProtocolHeaders.TRINO_HEADERS.responseAddedPrepare())) {
            keyValue = COLLECTION_HEADER_SPLITTER.splitToList(entry);
            if (keyValue.size() != 2) continue;
            this.addedPreparedStatements.put(StatementClientV1.urlDecode(keyValue.get(0)), StatementClientV1.urlDecode(keyValue.get(1)));
        }
        for (String entry : headers.values(ProtocolHeaders.TRINO_HEADERS.responseDeallocatedPrepare())) {
            this.deallocatedPreparedStatements.add(StatementClientV1.urlDecode(entry));
        }
        String startedTransactionId = headers.get(ProtocolHeaders.TRINO_HEADERS.responseStartedTransactionId());
        if (startedTransactionId != null) {
            this.startedTransactionId.set(startedTransactionId);
        }
        if (headers.get(ProtocolHeaders.TRINO_HEADERS.responseClearTransactionId()) != null) {
            this.clearTransactionId.set(true);
        }
        this.currentResults.set(results);
        this.currentRows.set(this.resultRowsDecoder.toRows(results));
    }

    private List<String> safeSplitToList(String value) {
        if (value == null || value.isEmpty()) {
            return ImmutableList.of();
        }
        return Splitter.on(',').trimResults().splitToList(value);
    }

    private RuntimeException requestFailedException(String task, Request request, JsonResponse<QueryResults> response) {
        if (!response.hasValue()) {
            if (response.getStatusCode() == 401) {
                return new ClientException("Authentication failed" + response.getResponseBody().map(message -> ": " + message).orElse(""));
            }
            return new RuntimeException(String.format("Error %s at %s returned an invalid response: %s [Error: %s]", task, request.url(), response, response.getResponseBody().orElse("<Response Too Large>")), response.getException());
        }
        return new RuntimeException(String.format("Error %s at %s returned HTTP %s", task, request.url(), response.getStatusCode()));
    }

    @Override
    public void cancelLeafStage() {
        Preconditions.checkState(!this.isClientAborted(), "client is closed");
        URI uri = this.currentStatusInfo().getPartialCancelUri();
        if (uri != null) {
            this.httpDelete(uri);
        }
    }

    @Override
    public void close() {
        URI uri;
        if (this.state.compareAndSet(State.RUNNING, State.CLIENT_ABORTED) && (uri = this.currentResults.get().getNextUri()) != null) {
            this.httpDelete(uri);
        }
    }

    private void httpDelete(URI uri) {
        Request request = this.prepareRequest(HttpUrl.get(uri)).delete().build();
        try {
            this.httpCallFactory.newCall(request).execute().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String urlEncode(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    private static String urlDecode(String value) {
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }

    private static enum State {
        RUNNING,
        CLIENT_ERROR,
        CLIENT_ABORTED,
        FINISHED;

    }
}

