/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import com.google.errorprone.annotations.Immutable;
import io.trino.jdbc.;
import io.trino.jdbc.$internal.client.StageStats;
import io.trino.jdbc.$internal.guava.base.MoreObjects;
import java.util.Objects;
import java.util.OptionalDouble;

@Immutable
public class StatementStats {
    private final String state;
    private final boolean queued;
    private final boolean scheduled;
    private final OptionalDouble progressPercentage;
    private final OptionalDouble runningPercentage;
    private final int nodes;
    private final int totalSplits;
    private final int queuedSplits;
    private final int runningSplits;
    private final int completedSplits;
    private final long planningTimeMillis;
    private final long analysisTimeMillis;
    private final long cpuTimeMillis;
    private final long wallTimeMillis;
    private final long queuedTimeMillis;
    private final long elapsedTimeMillis;
    private final long finishingTimeMillis;
    private final long physicalInputTimeMillis;
    private final long processedRows;
    private final long processedBytes;
    private final long physicalInputBytes;
    private final long physicalWrittenBytes;
    private final long internalNetworkInputBytes;
    private final long peakMemoryBytes;
    private final long spilledBytes;
    private final StageStats rootStage;

    @.JsonCreator
    public StatementStats(@.JsonProperty(value="state") String state, @.JsonProperty(value="queued") boolean queued, @.JsonProperty(value="scheduled") boolean scheduled, @.JsonProperty(value="progressPercentage") OptionalDouble progressPercentage, @.JsonProperty(value="runningPercentage") OptionalDouble runningPercentage, @.JsonProperty(value="nodes") int nodes, @.JsonProperty(value="totalSplits") int totalSplits, @.JsonProperty(value="queuedSplits") int queuedSplits, @.JsonProperty(value="runningSplits") int runningSplits, @.JsonProperty(value="completedSplits") int completedSplits, @.JsonProperty(value="planningTimeMillis") long planningTimeMillis, @.JsonProperty(value="analysisTimeMillis") long analysisTimeMillis, @.JsonProperty(value="cpuTimeMillis") long cpuTimeMillis, @.JsonProperty(value="wallTimeMillis") long wallTimeMillis, @.JsonProperty(value="queuedTimeMillis") long queuedTimeMillis, @.JsonProperty(value="elapsedTimeMillis") long elapsedTimeMillis, @.JsonProperty(value="finishingTimeMillis") long finishingTimeMillis, @.JsonProperty(value="physicalInputTimeMillis") long physicalInputTimeMillis, @.JsonProperty(value="processedRows") long processedRows, @.JsonProperty(value="processedBytes") long processedBytes, @.JsonProperty(value="physicalInputBytes") long physicalInputBytes, @.JsonProperty(value="physicalWrittenBytes") long physicalWrittenBytes, @.JsonProperty(value="internalNetworkInputBytes") long internalNetworkInputBytes, @.JsonProperty(value="peakMemoryBytes") long peakMemoryBytes, @.JsonProperty(value="spilledBytes") long spilledBytes, @.JsonProperty(value="rootStage") StageStats rootStage) {
        this.state = Objects.requireNonNull(state, "state is null");
        this.queued = queued;
        this.scheduled = scheduled;
        this.progressPercentage = Objects.requireNonNull(progressPercentage, "progressPercentage is null");
        this.runningPercentage = Objects.requireNonNull(runningPercentage, "runningPercentage is null");
        this.nodes = nodes;
        this.totalSplits = totalSplits;
        this.queuedSplits = queuedSplits;
        this.runningSplits = runningSplits;
        this.completedSplits = completedSplits;
        this.planningTimeMillis = planningTimeMillis;
        this.analysisTimeMillis = analysisTimeMillis;
        this.cpuTimeMillis = cpuTimeMillis;
        this.wallTimeMillis = wallTimeMillis;
        this.queuedTimeMillis = queuedTimeMillis;
        this.elapsedTimeMillis = elapsedTimeMillis;
        this.finishingTimeMillis = finishingTimeMillis;
        this.physicalInputTimeMillis = physicalInputTimeMillis;
        this.processedRows = processedRows;
        this.processedBytes = processedBytes;
        this.physicalInputBytes = physicalInputBytes;
        this.physicalWrittenBytes = physicalWrittenBytes;
        this.internalNetworkInputBytes = internalNetworkInputBytes;
        this.peakMemoryBytes = peakMemoryBytes;
        this.spilledBytes = spilledBytes;
        this.rootStage = rootStage;
    }

    @.JsonProperty
    public String getState() {
        return this.state;
    }

    @.JsonProperty
    public boolean isQueued() {
        return this.queued;
    }

    @.JsonProperty
    public boolean isScheduled() {
        return this.scheduled;
    }

    @.JsonProperty
    public OptionalDouble getProgressPercentage() {
        return this.progressPercentage;
    }

    @.JsonProperty
    public OptionalDouble getRunningPercentage() {
        return this.runningPercentage;
    }

    @.JsonProperty
    public int getNodes() {
        return this.nodes;
    }

    @.JsonProperty
    public int getTotalSplits() {
        return this.totalSplits;
    }

    @.JsonProperty
    public int getQueuedSplits() {
        return this.queuedSplits;
    }

    @.JsonProperty
    public int getRunningSplits() {
        return this.runningSplits;
    }

    @.JsonProperty
    public int getCompletedSplits() {
        return this.completedSplits;
    }

    @.JsonProperty
    public long getPlanningTimeMillis() {
        return this.planningTimeMillis;
    }

    @.JsonProperty
    public long getAnalysisTimeMillis() {
        return this.analysisTimeMillis;
    }

    @.JsonProperty
    public long getCpuTimeMillis() {
        return this.cpuTimeMillis;
    }

    @.JsonProperty
    public long getWallTimeMillis() {
        return this.wallTimeMillis;
    }

    @.JsonProperty
    public long getQueuedTimeMillis() {
        return this.queuedTimeMillis;
    }

    @.JsonProperty
    public long getElapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    @.JsonProperty
    public long getFinishingTimeMillis() {
        return this.finishingTimeMillis;
    }

    @.JsonProperty
    public long getPhysicalInputTimeMillis() {
        return this.physicalInputTimeMillis;
    }

    @.JsonProperty
    public long getProcessedRows() {
        return this.processedRows;
    }

    @.JsonProperty
    public long getProcessedBytes() {
        return this.processedBytes;
    }

    @.JsonProperty
    public long getPhysicalInputBytes() {
        return this.physicalInputBytes;
    }

    @.JsonProperty
    public long getPhysicalWrittenBytes() {
        return this.physicalWrittenBytes;
    }

    @.JsonProperty
    public long getInternalNetworkInputBytes() {
        return this.internalNetworkInputBytes;
    }

    @.JsonProperty
    public long getPeakMemoryBytes() {
        return this.peakMemoryBytes;
    }

    @.Nullable
    @.JsonProperty
    public StageStats getRootStage() {
        return this.rootStage;
    }

    @.JsonProperty
    public long getSpilledBytes() {
        return this.spilledBytes;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("state", this.state).add("queued", this.queued).add("scheduled", this.scheduled).add("progressPercentage", this.progressPercentage).add("runningPercentage", this.runningPercentage).add("nodes", this.nodes).add("totalSplits", this.totalSplits).add("queuedSplits", this.queuedSplits).add("runningSplits", this.runningSplits).add("completedSplits", this.completedSplits).add("planningTimeMillis", this.planningTimeMillis).add("analysisTimeMillis", this.analysisTimeMillis).add("cpuTimeMillis", this.cpuTimeMillis).add("wallTimeMillis", this.wallTimeMillis).add("queuedTimeMillis", this.queuedTimeMillis).add("elapsedTimeMillis", this.elapsedTimeMillis).add("finishingTimeMillis", this.finishingTimeMillis).add("physicalInputTimeMillis", this.physicalInputTimeMillis).add("processedRows", this.processedRows).add("processedBytes", this.processedBytes).add("physicalInputBytes", this.physicalInputBytes).add("physicalWrittenBytes", this.physicalWrittenBytes).add("internalNetworkInputBytes", this.internalNetworkInputBytes).add("peakMemoryBytes", this.peakMemoryBytes).add("spilledBytes", this.spilledBytes).add("rootStage", this.rootStage).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String state;
        private boolean queued;
        private boolean scheduled;
        private OptionalDouble progressPercentage;
        private OptionalDouble runningPercentage;
        private int nodes;
        private int totalSplits;
        private int queuedSplits;
        private int runningSplits;
        private int completedSplits;
        private long planningTimeMillis;
        private long analysisTimeMillis;
        private long cpuTimeMillis;
        private long wallTimeMillis;
        private long queuedTimeMillis;
        private long elapsedTimeMillis;
        private long finishingTimeMillis;
        private long physicalInputTimeMillis;
        private long processedRows;
        private long processedBytes;
        private long physicalInputBytes;
        private long physicalWrittenBytes;
        private long internalNetworkInputBytes;
        private long peakMemoryBytes;
        private long spilledBytes;
        private StageStats rootStage;

        private Builder() {
        }

        public Builder setState(String state) {
            this.state = Objects.requireNonNull(state, "state is null");
            return this;
        }

        public Builder setNodes(int nodes) {
            this.nodes = nodes;
            return this;
        }

        public Builder setQueued(boolean queued) {
            this.queued = queued;
            return this;
        }

        public Builder setScheduled(boolean scheduled) {
            this.scheduled = scheduled;
            return this;
        }

        public Builder setProgressPercentage(OptionalDouble progressPercentage) {
            this.progressPercentage = progressPercentage;
            return this;
        }

        public Builder setRunningPercentage(OptionalDouble runningPercentage) {
            this.runningPercentage = runningPercentage;
            return this;
        }

        public Builder setTotalSplits(int totalSplits) {
            this.totalSplits = totalSplits;
            return this;
        }

        public Builder setQueuedSplits(int queuedSplits) {
            this.queuedSplits = queuedSplits;
            return this;
        }

        public Builder setRunningSplits(int runningSplits) {
            this.runningSplits = runningSplits;
            return this;
        }

        public Builder setCompletedSplits(int completedSplits) {
            this.completedSplits = completedSplits;
            return this;
        }

        public Builder setPlanningTimeMillis(long planningTimeMillis) {
            this.planningTimeMillis = planningTimeMillis;
            return this;
        }

        public Builder setAnalysisTimeMillis(long analysisTimeMillis) {
            this.analysisTimeMillis = analysisTimeMillis;
            return this;
        }

        public Builder setCpuTimeMillis(long cpuTimeMillis) {
            this.cpuTimeMillis = cpuTimeMillis;
            return this;
        }

        public Builder setWallTimeMillis(long wallTimeMillis) {
            this.wallTimeMillis = wallTimeMillis;
            return this;
        }

        public Builder setQueuedTimeMillis(long queuedTimeMillis) {
            this.queuedTimeMillis = queuedTimeMillis;
            return this;
        }

        public Builder setElapsedTimeMillis(long elapsedTimeMillis) {
            this.elapsedTimeMillis = elapsedTimeMillis;
            return this;
        }

        public Builder setFinishingTimeMillis(long finishingTimeMillis) {
            this.finishingTimeMillis = finishingTimeMillis;
            return this;
        }

        public Builder setPhysicalInputTimeMillis(long physicalInputTimeMillis) {
            this.physicalInputTimeMillis = physicalInputTimeMillis;
            return this;
        }

        public Builder setProcessedRows(long processedRows) {
            this.processedRows = processedRows;
            return this;
        }

        public Builder setProcessedBytes(long processedBytes) {
            this.processedBytes = processedBytes;
            return this;
        }

        public Builder setPhysicalInputBytes(long physicalInputBytes) {
            this.physicalInputBytes = physicalInputBytes;
            return this;
        }

        public Builder setPhysicalWrittenBytes(long physicalWrittenBytes) {
            this.physicalWrittenBytes = physicalWrittenBytes;
            return this;
        }

        public Builder setInternalNetworkInputBytes(long internalNetworkInputBytes) {
            this.internalNetworkInputBytes = internalNetworkInputBytes;
            return this;
        }

        public Builder setPeakMemoryBytes(long peakMemoryBytes) {
            this.peakMemoryBytes = peakMemoryBytes;
            return this;
        }

        public Builder setSpilledBytes(long spilledBytes) {
            this.spilledBytes = spilledBytes;
            return this;
        }

        public Builder setRootStage(StageStats rootStage) {
            this.rootStage = rootStage;
            return this;
        }

        public StatementStats build() {
            return new StatementStats(this.state, this.queued, this.scheduled, this.progressPercentage, this.runningPercentage, this.nodes, this.totalSplits, this.queuedSplits, this.runningSplits, this.completedSplits, this.planningTimeMillis, this.analysisTimeMillis, this.cpuTimeMillis, this.wallTimeMillis, this.queuedTimeMillis, this.elapsedTimeMillis, this.finishingTimeMillis, this.physicalInputTimeMillis, this.processedRows, this.processedBytes, this.physicalInputBytes, this.physicalWrittenBytes, this.internalNetworkInputBytes, this.peakMemoryBytes, this.spilledBytes, this.rootStage);
        }
    }
}

