/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.$internal.client.ClientException;
import io.trino.jdbc.$internal.client.QueryStatusInfo;
import io.trino.jdbc.$internal.client.StatementClient;
import io.trino.jdbc.$internal.guava.collect.ImmutableMap;
import io.trino.jdbc.$internal.guava.primitives.Ints;
import io.trino.jdbc.QueryStats;
import io.trino.jdbc.ResultUtils;
import io.trino.jdbc.TrinoConnection;
import io.trino.jdbc.TrinoResultSet;
import io.trino.jdbc.WarningsManager;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class TrinoStatement
implements Statement {
    private final AtomicLong maxRows = new AtomicLong();
    private final AtomicInteger queryTimeoutSeconds = new AtomicInteger();
    private final AtomicInteger fetchSize = new AtomicInteger();
    private final AtomicBoolean closeOnCompletion = new AtomicBoolean();
    private final AtomicReference<TrinoConnection> connection;
    private final Consumer<TrinoStatement> onClose;
    private final AtomicReference<StatementClient> executingClient = new AtomicReference();
    private final AtomicReference<TrinoResultSet> currentResult = new AtomicReference();
    private final AtomicReference<Optional<WarningsManager>> currentWarningsManager = new AtomicReference(Optional.empty());
    private final AtomicLong currentUpdateCount = new AtomicLong(-1L);
    private final AtomicReference<String> currentUpdateType = new AtomicReference();
    private final AtomicReference<Optional<Consumer<QueryStats>>> progressCallback = new AtomicReference(Optional.empty());
    private final Consumer<QueryStats> progressConsumer = value -> this.progressCallback.get().ifPresent(callback -> callback.accept(value));

    TrinoStatement(TrinoConnection connection, Consumer<TrinoStatement> onClose) {
        this.connection = new AtomicReference<TrinoConnection>(Objects.requireNonNull(connection, "connection is null"));
        this.onClose = Objects.requireNonNull(onClose, "onClose is null");
    }

    public void setProgressMonitor(Consumer<QueryStats> progressMonitor) {
        this.progressCallback.set(Optional.of(Objects.requireNonNull(progressMonitor, "progressMonitor is null")));
    }

    public void clearProgressMonitor() {
        this.progressCallback.set(Optional.empty());
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (!this.execute(sql)) {
            throw new SQLException("SQL statement is not a query: " + sql);
        }
        return this.currentResult.get();
    }

    @Override
    public void close() throws SQLException {
        TrinoConnection connection = this.connection.getAndSet(null);
        if (connection == null) {
            return;
        }
        this.onClose.accept(this);
        StatementClient client = this.executingClient.get();
        if (client != null) {
            client.close();
        }
        this.closeResultSet();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkOpen();
        if (max < 0) {
            throw new SQLException("Max field size must be positive");
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        long result = this.getLargeMaxRows();
        if (result > Integer.MAX_VALUE) {
            throw new SQLException("Max rows exceeds limit of 2147483647");
        }
        return Math.toIntExact(result);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.checkOpen();
        return this.maxRows.get();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.setLargeMaxRows(max);
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.checkOpen();
        if (max < 0L) {
            throw new SQLException("Max rows must be positive");
        }
        this.maxRows.set(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkOpen();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        return this.queryTimeoutSeconds.get();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkOpen();
        if (seconds < 0) {
            throw new SQLException("Query timeout seconds must be positive");
        }
        this.queryTimeoutSeconds.set(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.checkOpen();
        StatementClient client = this.executingClient.get();
        if (client != null) {
            client.close();
        }
        this.closeResultSet();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this.currentWarningsManager.get().map(WarningsManager::getWarnings).orElse(null);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this.currentWarningsManager.get().ifPresent(WarningsManager::clearWarnings);
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkOpen();
    }

    private Map<String, String> getStatementSessionProperties() {
        ImmutableMap.Builder<String, CallSite> sessionProperties = ImmutableMap.builder();
        if (this.queryTimeoutSeconds.get() > 0) {
            sessionProperties.put("query_max_run_time", (CallSite)((Object)(this.queryTimeoutSeconds.get() + "s")));
        }
        return sessionProperties.buildOrThrow();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        if (this.connection().shouldStartTransaction()) {
            this.internalExecute(this.connection().getStartTransactionSql());
        }
        return this.internalExecute(sql);
    }

    final boolean internalExecute(String sql) throws SQLException {
        this.clearCurrentResults();
        this.checkOpen();
        StatementClient client = null;
        TrinoResultSet resultSet = null;
        try {
            QueryStatusInfo finalStatusInfo;
            client = this.connection().startQuery(sql, this.getStatementSessionProperties());
            if (client.isFinished() && (finalStatusInfo = client.finalStatusInfo()).getError() != null) {
                throw ResultUtils.resultsException(finalStatusInfo);
            }
            this.executingClient.set(client);
            WarningsManager warningsManager = new WarningsManager();
            this.currentWarningsManager.set(Optional.of(warningsManager));
            resultSet = TrinoResultSet.create(this, client, this.maxRows.get(), this.progressConsumer, warningsManager);
            if (client.currentStatusInfo().getUpdateType() == null) {
                this.currentResult.set(resultSet);
                boolean bl = true;
                return bl;
            }
            while (resultSet.next()) {
            }
            this.connection().updateSession(client);
            Long updateCount = client.finalStatusInfo().getUpdateCount();
            this.currentUpdateCount.set(updateCount != null ? updateCount : 0L);
            this.currentUpdateType.set(client.finalStatusInfo().getUpdateType());
            warningsManager.addWarnings(client.finalStatusInfo().getWarnings());
            boolean bl = false;
            return bl;
        }
        catch (ClientException e) {
            throw new SQLException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw new SQLException("Error executing query: " + e.getMessage(), e);
        }
        finally {
            this.executingClient.set(null);
            if (this.currentResult.get() == null) {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (client != null) {
                    client.close();
                }
            }
        }
    }

    private void clearCurrentResults() {
        this.currentResult.set(null);
        this.currentUpdateCount.set(-1L);
        this.currentUpdateType.set(null);
        this.currentWarningsManager.set(Optional.empty());
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        return this.currentResult.get();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return Ints.saturatedCast(this.getLargeUpdateCount());
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkOpen();
        return this.currentUpdateCount.get();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        if (!TrinoStatement.validFetchDirection(direction)) {
            throw new SQLException("Invalid fetch direction");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        if (rows < 0) {
            throw new SQLException("Fetch size must be positive");
        }
        this.fetchSize.set(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.fetchSize.get();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batches not supported");
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batches not supported");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batches not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkOpen();
        this.currentUpdateCount.set(-1L);
        this.currentUpdateType.set(null);
        if (current == 1) {
            this.closeResultSet();
            return false;
        }
        if (current != 2 && current != 3) {
            throw new SQLException("Invalid argument: " + current);
        }
        throw new SQLFeatureNotSupportedException("Multiple open results not supported");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException("getGeneratedKeys");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return Ints.saturatedCast(this.executeLargeUpdate(sql));
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        if (this.execute(sql)) {
            throw new SQLException("SQL is not an update statement: " + sql);
        }
        return this.currentUpdateCount.get();
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeLargeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection.get() == null;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkOpen();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkOpen();
        this.closeOnCompletion.set(true);
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkOpen();
        return this.closeOnCompletion.get();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException("No wrapper for " + String.valueOf(iface));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    public String getUpdateType() throws SQLException {
        this.checkOpen();
        return this.currentUpdateType.get();
    }

    public void partialCancel() throws SQLException {
        this.checkOpen();
        StatementClient client = this.executingClient.get();
        if (client != null) {
            client.cancelLeafStage();
        } else {
            TrinoResultSet resultSet = this.currentResult.get();
            if (resultSet != null) {
                resultSet.partialCancel();
            }
        }
    }

    protected final void checkOpen() throws SQLException {
        this.connection();
    }

    protected final TrinoConnection connection() throws SQLException {
        TrinoConnection connection = this.connection.get();
        if (connection == null) {
            throw new SQLException("Statement is closed");
        }
        if (connection.isClosed()) {
            throw new SQLException("Connection is closed");
        }
        return connection;
    }

    protected final Optional<TrinoConnection> optionalConnection() {
        return Optional.ofNullable(this.connection.get());
    }

    private void closeResultSet() throws SQLException {
        ResultSet resultSet = this.currentResult.getAndSet(null);
        if (resultSet != null) {
            resultSet.close();
        }
    }

    private static boolean validFetchDirection(int direction) {
        return direction == 1000 || direction == 1001 || direction == 1002;
    }
}

