/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.$internal.guava.base.Verify;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

class MaterializingReader
extends FilterReader {
    private final char[] headChars;
    private int remaining;
    private int currentOffset;

    protected MaterializingReader(Reader reader, int maxHeadChars) {
        super(reader);
        Verify.verify(maxHeadChars > 0 && maxHeadChars <= 131072, "maxHeadChars must be between 1 and 128 KB", new Object[0]);
        this.headChars = new char[maxHeadChars];
    }

    @Override
    public int read() throws IOException {
        int value = super.read();
        if (value != -1) {
            if (this.currentOffset < this.headChars.length) {
                this.headChars[this.currentOffset++] = (char)value;
            } else {
                ++this.remaining;
            }
        }
        return value;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int read = super.read(cbuf, off, len);
        if (read > 0) {
            int copyLength = Math.min(read, this.headChars.length - this.currentOffset);
            if (read > copyLength) {
                this.remaining += read - copyLength;
            }
            if (copyLength > 0) {
                System.arraycopy(cbuf, off, this.headChars, this.currentOffset, copyLength);
                this.currentOffset += copyLength;
            }
        }
        return read;
    }

    public String getHeadString() {
        return String.valueOf(this.headChars, 0, this.currentOffset) + (this.remaining > 0 ? String.format("... [" + this.bytesOmitted(this.remaining) + "]", this.remaining) : "");
    }

    private String bytesOmitted(long bytes) {
        if (bytes == 1L) {
            return "1 more byte";
        }
        return String.format("%d more bytes", bytes);
    }
}

