/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.auth.external;

import io.trino.jdbc.$internal.client.auth.external.ExternalRedirectStrategy;
import io.trino.jdbc.$internal.client.auth.external.RedirectException;
import io.trino.jdbc.$internal.client.auth.external.RedirectHandler;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.collect.ImmutableList;
import java.net.URI;
import java.util.List;

public class CompositeRedirectHandler
implements RedirectHandler {
    private final List<RedirectHandler> handlers;

    public CompositeRedirectHandler(List<ExternalRedirectStrategy> strategies) {
        this.handlers = strategies.stream().map(ExternalRedirectStrategy::getHandler).collect(ImmutableList.toImmutableList());
        Preconditions.checkState(!this.handlers.isEmpty(), "Expected at least one external redirect handler");
    }

    @Override
    public void redirectTo(URI uri) throws RedirectException {
        RedirectException redirectException = new RedirectException("Could not redirect to " + String.valueOf(uri));
        for (RedirectHandler handler : this.handlers) {
            try {
                handler.redirectTo(uri);
                return;
            }
            catch (Throwable e) {
                redirectException.addSuppressed(e);
            }
        }
        throw redirectException;
    }
}

