/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.okhttp.v3_0;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.incubator.builder.internal.DefaultHttpClientInstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.trino.jdbc.$internal.okhttp3.Interceptor;
import io.trino.jdbc.$internal.okhttp3.Response;
import io.trino.jdbc.$internal.opentelemetry.okhttp.v3_0.OkHttpTelemetry;
import io.trino.jdbc.$internal.opentelemetry.okhttp.v3_0.internal.Experimental;
import io.trino.jdbc.$internal.opentelemetry.okhttp.v3_0.internal.OkHttpClientInstrumenterBuilderFactory;
import java.util.Collection;
import java.util.function.Function;

public final class OkHttpTelemetryBuilder {
    private final DefaultHttpClientInstrumenterBuilder<Interceptor.Chain, Response> builder;
    private final OpenTelemetry openTelemetry;

    OkHttpTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.builder = OkHttpClientInstrumenterBuilderFactory.create(openTelemetry);
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder addAttributesExtractor(AttributesExtractor<? super Interceptor.Chain, ? super Response> attributesExtractor) {
        this.builder.addAttributesExtractor(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder setCapturedRequestHeaders(Collection<String> requestHeaders) {
        this.builder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder setCapturedResponseHeaders(Collection<String> responseHeaders) {
        this.builder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder setKnownMethods(Collection<String> knownMethods) {
        this.builder.setKnownMethods(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder setSpanNameExtractor(Function<SpanNameExtractor<? super Interceptor.Chain>, ? extends SpanNameExtractor<? super Interceptor.Chain>> spanNameExtractorTransformer) {
        this.builder.setSpanNameExtractor(spanNameExtractorTransformer);
        return this;
    }

    public OkHttpTelemetry build() {
        return new OkHttpTelemetry((Instrumenter<Interceptor.Chain, Response>)this.builder.build(), this.openTelemetry.getPropagators());
    }

    static {
        Experimental.internalSetEmitExperimentalTelemetry((builder, emit) -> builder.builder.setEmitExperimentalHttpClientMetrics(emit.booleanValue()));
    }
}

