/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.client.QueryStatusInfo;
import io.trino.jdbc.$internal.client.StatementClient;
import io.trino.jdbc.$internal.guava.base.Throwables;
import io.trino.jdbc.$internal.guava.base.Verify;
import io.trino.jdbc.$internal.guava.collect.AbstractIterator;
import io.trino.jdbc.$internal.guava.util.concurrent.ThreadFactoryBuilder;
import io.trino.jdbc.CancellableIterator;
import io.trino.jdbc.QueryStats;
import io.trino.jdbc.ResultUtils;
import io.trino.jdbc.WarningsManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;

public class AsyncResultIterator
extends AbstractIterator<List<Object>>
implements CancellableIterator<List<Object>> {
    private static final int BATCH_SIZE = 100;
    private static final int MAX_QUEUED_ROWS = 50000;
    private static final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("Trino JDBC worker-%s").setDaemon(true).build());
    private final StatementClient client;
    private final BlockingQueue<List<Object>> rowQueue;
    private final Semaphore semaphore = new Semaphore(0);
    private final Future<?> future;
    private volatile boolean cancelled;
    private volatile boolean finished;

    AsyncResultIterator(StatementClient client, Consumer<QueryStats> progressCallback, WarningsManager warningsManager, Optional<BlockingQueue<List<Object>>> queue) {
        Objects.requireNonNull(progressCallback, "progressCallback is null");
        Objects.requireNonNull(warningsManager, "warningsManager is null");
        this.client = client;
        this.rowQueue = queue.orElseGet(() -> new ArrayBlockingQueue(50000));
        this.cancelled = false;
        this.finished = false;
        this.future = executorService.submit(() -> {
            try {
                QueryStatusInfo results;
                int rowsProcessed = 0;
                do {
                    results = client.currentStatusInfo();
                    progressCallback.accept(QueryStats.create(results.getId(), results.getStats()));
                    warningsManager.addWarnings(results.getWarnings());
                    for (List row : client.currentRows()) {
                        this.rowQueue.put(row);
                        if (rowsProcessed++ % 100 != 0) continue;
                        this.semaphore.release(rowsProcessed);
                        rowsProcessed = 0;
                    }
                } while (!this.cancelled && client.advance());
                if (rowsProcessed > 0) {
                    this.semaphore.release(rowsProcessed);
                }
                Verify.verify(client.isFinished());
                results = client.finalStatusInfo();
                progressCallback.accept(QueryStats.create(results.getId(), results.getStats()));
                warningsManager.addWarnings(results.getWarnings());
                if (results.getError() != null) {
                    throw new RuntimeException(ResultUtils.resultsException(results));
                }
            }
            catch (InterruptedException | CancellationException e) {
                this.close();
                throw new RuntimeException(new SQLException("ResultSet thread was interrupted", e));
            }
            finally {
                this.finished = true;
                this.semaphore.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        AsyncResultIterator asyncResultIterator = this;
        synchronized (asyncResultIterator) {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
        }
        this.future.cancel(true);
        this.close();
    }

    private void close() {
        this.client.close();
        this.rowQueue.clear();
    }

    @.VisibleForTesting
    Future<?> getFuture() {
        return this.future;
    }

    @.VisibleForTesting
    boolean isBackgroundThreadFinished() {
        return this.finished;
    }

    @Override
    protected List<Object> computeNext() {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            this.handleInterrupt(e);
        }
        if (this.rowQueue.isEmpty()) {
            try {
                this.future.get();
            }
            catch (InterruptedException e) {
                this.handleInterrupt(e);
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked(e.getCause());
                throw new RuntimeException(e.getCause());
            }
            return (List)this.endOfData();
        }
        return (List)this.rowQueue.poll();
    }

    private void handleInterrupt(InterruptedException e) {
        this.cancel();
        Thread.currentThread().interrupt();
        throw new RuntimeException(new SQLException("Interrupted", e));
    }
}

