/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.spooling;

import io.trino.jdbc.$internal.guava.base.Verify;
import java.util.Objects;

public enum DataAttribute {
    ROW_OFFSET("rowOffset", Long.class),
    ROWS_COUNT("rowsCount", Long.class),
    SEGMENT_SIZE("segmentSize", Integer.class),
    UNCOMPRESSED_SIZE("uncompressedSize", Integer.class),
    SCHEMA("schema", String.class),
    EXPIRES_AT("expiresAt", String.class);

    private final String name;
    private final Class<?> javaClass;

    private DataAttribute(String name, Class<?> javaClass) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.javaClass = Objects.requireNonNull(javaClass, "javaClass is null");
    }

    public String attributeName() {
        return this.name;
    }

    public Class<?> javaClass() {
        return this.javaClass;
    }

    public static DataAttribute getByName(String name) {
        for (DataAttribute attributeName : DataAttribute.values()) {
            if (!attributeName.attributeName().equals(name)) continue;
            return attributeName;
        }
        throw new IllegalArgumentException("Unknown attribute name: " + name);
    }

    public <T> T decode(Class<T> clazz, Object value) {
        Verify.verify(clazz == this.javaClass, "Expected %s, but got %s", this.javaClass, clazz);
        if (clazz == Long.class) {
            if (value instanceof Long) {
                return clazz.cast(value);
            }
            if (value instanceof Integer) {
                return clazz.cast(((Integer)Integer.class.cast(value)).longValue());
            }
            if (value instanceof String) {
                return clazz.cast(Long.parseLong((String)String.class.cast(value)));
            }
        }
        if (clazz == Integer.class) {
            if (value instanceof Long) {
                return clazz.cast(Math.toIntExact((Long)Long.class.cast(value)));
            }
            if (value instanceof Integer) {
                return clazz.cast(value);
            }
            if (value instanceof String) {
                return clazz.cast(Integer.parseInt((String)String.class.cast(value)));
            }
        }
        if (clazz == String.class && value instanceof String) {
            return clazz.cast(value);
        }
        if (clazz == Boolean.class) {
            if (value instanceof Boolean) {
                return clazz.cast(value);
            }
            if (value instanceof String) {
                return clazz.cast(Boolean.parseBoolean((String)String.class.cast(value)));
            }
        }
        throw new IllegalArgumentException("Unsupported class: " + String.valueOf(clazz));
    }
}

