/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import com.google.common.collect.ImmutableList;
import io.trino.client.ClientSelectedRole;
import io.trino.client.Column;
import io.trino.client.QueryData;
import io.trino.client.QueryError;
import io.trino.client.QueryStatusInfo;
import io.trino.client.ResultRows;
import io.trino.client.StageStats;
import io.trino.client.StatementClient;
import io.trino.client.StatementStats;
import io.trino.client.Warning;
import io.trino.jdbc.AsyncResultIterator;
import io.trino.jdbc.WarningsManager;
import java.net.URI;
import java.time.ZoneId;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

class TestAsyncResultIterator {
    TestAsyncResultIterator() {
    }

    @Test
    @Timeout(value=10L)
    public void testIteratorCancelWhenQueueNotFull() throws Exception {
        AtomicReference thread = new AtomicReference();
        CountDownLatch interruptedButSwallowedLatch = new CountDownLatch(1);
        AsyncResultIterator iterator = new AsyncResultIterator((StatementClient)new MockStatementClient(() -> {
            thread.compareAndSet(null, Thread.currentThread());
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
            }
            catch (InterruptedException e) {
                interruptedButSwallowedLatch.countDown();
            }
            return TestAsyncResultIterator.fromList((List<List<Object>>)ImmutableList.of((Object)ImmutableList.of((Object)new Object())));
        }), ignored -> {}, new WarningsManager(), Optional.of(new ArrayBlockingQueue(100)));
        while (thread.get() == null || ((Thread)thread.get()).getState() != Thread.State.TIMED_WAITING) {
        }
        iterator.cancel();
        while (!iterator.getFuture().isDone() || !iterator.isBackgroundThreadFinished()) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        boolean interruptedButSwallowed = interruptedButSwallowedLatch.await(5000L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((boolean)interruptedButSwallowed).isTrue();
    }

    @Test
    @Timeout(value=10L)
    public void testIteratorCancelWhenQueueIsFull() throws Exception {
        ArrayBlockingQueue<ImmutableList> queue = new ArrayBlockingQueue<ImmutableList>(1);
        queue.put(ImmutableList.of());
        AtomicReference thread = new AtomicReference();
        AsyncResultIterator iterator = new AsyncResultIterator((StatementClient)new MockStatementClient(() -> {
            thread.compareAndSet(null, Thread.currentThread());
            return TestAsyncResultIterator.fromList((List<List<Object>>)ImmutableList.of((Object)ImmutableList.of((Object)new Object())));
        }), ignored -> {}, new WarningsManager(), Optional.of(queue));
        while (thread.get() == null || ((Thread)thread.get()).getState() != Thread.State.WAITING) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        iterator.cancel();
        while (!iterator.isBackgroundThreadFinished()) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
    }

    private static QueryStatusInfo statusInfo(final String status) {
        return new QueryStatusInfo(){

            public String getId() {
                return "";
            }

            public URI getInfoUri() {
                return null;
            }

            public URI getPartialCancelUri() {
                return null;
            }

            public URI getNextUri() {
                return null;
            }

            public List<Column> getColumns() {
                return ImmutableList.of();
            }

            public StatementStats getStats() {
                return new StatementStats(status, false, true, OptionalDouble.of(50.0), OptionalDouble.of(50.0), 1, 100, 50, 25, 50, 100L, 100L, 100L, 100L, 100L, 100L, 100L, 100L, 100L, 100L, 100L, 100L, 100L, 100L, 100L, StageStats.builder().setStageId("id").setDone(false).setState(status).setSubStages((List)ImmutableList.of()).build());
            }

            public QueryError getError() {
                return null;
            }

            public List<Warning> getWarnings() {
                return ImmutableList.of();
            }

            public String getUpdateType() {
                throw new UnsupportedOperationException();
            }

            public OptionalLong getUpdateCount() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static ResultRows fromList(final List<List<Object>> values) {
        return new ResultRows(){

            public void close() {
            }

            public Iterator<List<Object>> iterator() {
                return values.iterator();
            }

            public String toString() {
                return "ResultRows{values=" + String.valueOf(values) + "}";
            }
        };
    }

    private static class MockStatementClient
    implements StatementClient {
        private final Supplier<ResultRows> queryData;

        public MockStatementClient(Supplier<ResultRows> queryData) {
            this.queryData = Objects.requireNonNull(queryData, "queryData is null");
        }

        public String getQuery() {
            throw new UnsupportedOperationException();
        }

        public ZoneId getTimeZone() {
            throw new UnsupportedOperationException();
        }

        public boolean isRunning() {
            return true;
        }

        public boolean isClientAborted() {
            throw new UnsupportedOperationException();
        }

        public boolean isClientError() {
            throw new UnsupportedOperationException();
        }

        public boolean isFinished() {
            return true;
        }

        public StatementStats getStats() {
            throw new UnsupportedOperationException();
        }

        public QueryStatusInfo currentStatusInfo() {
            return TestAsyncResultIterator.statusInfo("RUNNING");
        }

        public QueryData currentData() {
            throw new UnsupportedOperationException();
        }

        public ResultRows currentRows() {
            return this.queryData.get();
        }

        public QueryStatusInfo finalStatusInfo() {
            return TestAsyncResultIterator.statusInfo("FINISHED");
        }

        public Optional<String> getSetCatalog() {
            throw new UnsupportedOperationException();
        }

        public Optional<String> getSetSchema() {
            throw new UnsupportedOperationException();
        }

        public Optional<List<String>> getSetPath() {
            throw new UnsupportedOperationException();
        }

        public Optional<String> getSetAuthorizationUser() {
            throw new UnsupportedOperationException();
        }

        public boolean isResetAuthorizationUser() {
            throw new UnsupportedOperationException();
        }

        public Map<String, String> getSetSessionProperties() {
            throw new UnsupportedOperationException();
        }

        public Set<String> getResetSessionProperties() {
            throw new UnsupportedOperationException();
        }

        public Map<String, ClientSelectedRole> getSetRoles() {
            throw new UnsupportedOperationException();
        }

        public Map<String, String> getAddedPreparedStatements() {
            throw new UnsupportedOperationException();
        }

        public Set<String> getDeallocatedPreparedStatements() {
            throw new UnsupportedOperationException();
        }

        public String getStartedTransactionId() {
            throw new UnsupportedOperationException();
        }

        public boolean isClearTransactionId() {
            throw new UnsupportedOperationException();
        }

        public boolean advance() {
            return true;
        }

        public void cancelLeafStage() {
            throw new UnsupportedOperationException();
        }

        public void close() {
        }
    }
}

