/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import com.google.common.collect.ImmutableList;
import io.airlift.log.Logging;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.trino.jdbc.TracingTrinoDriver;
import io.trino.plugin.memory.MemoryPlugin;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.Plugin;
import java.io.IOException;
import java.net.URI;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestTracingTrinoDriver {
    private TestingTrinoServer server;

    @BeforeAll
    public void setupServer() {
        Logging.initialize();
        this.server = TestingTrinoServer.create();
        this.server.installPlugin((Plugin)new MemoryPlugin());
        this.server.createCatalog("memory", "memory");
    }

    @AfterAll
    public void tearDown() throws Exception {
        this.server.close();
        this.server = null;
    }

    @Test
    public void testInitialize() throws IOException, SQLException {
        InMemorySpanExporter exporter = InMemorySpanExporter.create();
        SdkTracerProvider tracerProvider = SdkTracerProvider.builder().addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)exporter)).build();
        OpenTelemetrySdk telemetry = OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).build();
        try (TracingTrinoDriver tracingDriver = new TracingTrinoDriver((OpenTelemetry)telemetry);
             Connection connection = this.createConnection((Driver)tracingDriver, "memory");
             Statement statement = connection.createStatement();){
            statement.execute("SHOW SCHEMAS FROM memory");
        }
        List uris = (List)exporter.getFinishedSpanItems().stream().filter(span -> span.getAttributes().get(AttributeKey.longKey((String)"http.response.status_code")) != null).map(span -> (String)span.getAttributes().get(AttributeKey.stringKey((String)"url.full"))).map(value -> URI.create(value).getPath()).collect(ImmutableList.toImmutableList());
        ((ListAssert)Assertions.assertThat((List)uris).hasSizeBetween(3, 10)).contains((Object[])new String[]{"/v1/statement"});
    }

    private Connection createConnection(Driver driver, String catalog) throws SQLException {
        String url = String.format("jdbc:trino://%s/%s?explicitPrepare=true&user=test", this.server.getAddress(), catalog);
        return driver.connect(url, new Properties());
    }
}

