/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.BaseTrinoDriverTest;
import io.trino.jdbc.TrinoDataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTrinoDriverUsingDataSource
extends BaseTrinoDriverTest {
    @Override
    protected Connection createConnection() throws SQLException {
        String url = "jdbc:trino://" + String.valueOf(this.server.getAddress());
        TrinoDataSource trinoDataSource = new TrinoDataSource();
        trinoDataSource.setUrl(url);
        return trinoDataSource.getConnection("test", null);
    }

    @Override
    protected Connection createConnection(String catalog) throws SQLException {
        String url = "jdbc:trino://" + String.valueOf(this.server.getAddress());
        TrinoDataSource trinoDataSource = new TrinoDataSource();
        trinoDataSource.setUrl(url);
        trinoDataSource.setCatalog(catalog);
        return trinoDataSource.getConnection("test", null);
    }

    @Override
    protected Connection createConnection(String catalog, String schema) throws SQLException {
        String url = "jdbc:trino://" + String.valueOf(this.server.getAddress());
        TrinoDataSource trinoDataSource = new TrinoDataSource();
        trinoDataSource.setUrl(url);
        trinoDataSource.setCatalog(catalog);
        trinoDataSource.setSchema(schema);
        return trinoDataSource.getConnection("test", null);
    }

    @Override
    protected Connection createConnectionWithParameter(String parameter) throws SQLException {
        String url = String.format("jdbc:trino://%s?%s", this.server.getAddress(), parameter);
        TrinoDataSource trinoDataSource = new TrinoDataSource();
        trinoDataSource.setUrl(url);
        return trinoDataSource.getConnection("test", null);
    }

    @Override
    @Test
    public void testGetDriverVersion() throws Exception {
        TrinoDataSource trinoDataSource = new TrinoDataSource();
        Driver driver = trinoDataSource.getDriver();
        Assertions.assertThat((int)driver.getMajorVersion()).isGreaterThan(350);
        Assertions.assertThat((int)driver.getMinorVersion()).isEqualTo(0);
        try (Connection connection = this.createConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            Assertions.assertThat((String)metaData.getDriverName()).isEqualTo("Trino JDBC Driver");
            Assertions.assertThat((String)metaData.getDriverVersion()).startsWith((CharSequence)String.valueOf(driver.getMajorVersion()));
            Assertions.assertThat((int)metaData.getDriverMajorVersion()).isEqualTo(driver.getMajorVersion());
            Assertions.assertThat((int)metaData.getDriverMinorVersion()).isEqualTo(driver.getMinorVersion());
        }
    }

    @Override
    @Test
    public void testNullUrl() throws Exception {
        TrinoDataSource trinoDataSource = new TrinoDataSource();
        trinoDataSource.setUrl(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> trinoDataSource.getConnection()).isInstanceOf(SQLException.class)).hasMessage("URL is null");
    }

    @Override
    @Test
    public void testDriverPropertyInfoEmpty() throws Exception {
        TrinoDataSource trinoDataSource = new TrinoDataSource();
        trinoDataSource.setUrl(this.jdbcUrl());
        Properties properties = new Properties();
        Object[] infos = trinoDataSource.getDriver().getPropertyInfo(this.jdbcUrl(), properties);
        ((AbstractListAssert)((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Object[])infos).extracting(BaseTrinoDriverTest::driverPropertyInfoToString).contains((Object[])new String[]{"{name=user, required=false}"})).contains((Object[])new String[]{"{name=password, required=false}"})).contains((Object[])new String[]{"{name=accessToken, required=false}"})).contains((Object[])new String[]{"{name=SSL, value=false, required=false, choices=[true, false]}"});
    }

    @Override
    @Test
    public void testDriverPropertyInfoSslEnabled() throws Exception {
        TrinoDataSource trinoDataSource = new TrinoDataSource();
        trinoDataSource.setUrl(this.jdbcUrl());
        Properties properties = new Properties();
        properties.setProperty("user", "test");
        properties.setProperty("SSL", "true");
        Object[] infos = trinoDataSource.getDriver().getPropertyInfo(this.jdbcUrl(), properties);
        ((AbstractListAssert)((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Object[])infos).extracting(BaseTrinoDriverTest::driverPropertyInfoToString).contains((Object[])new String[]{"{name=user, value=test, required=false}"})).contains((Object[])new String[]{"{name=SSL, value=true, required=false, choices=[true, false]}"})).contains((Object[])new String[]{"{name=SSLVerification, value=FULL, required=false, choices=[FULL, CA, NONE]}"})).contains((Object[])new String[]{"{name=SSLTrustStorePath, required=false}"});
    }
}

