/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.airlift.compress.v3.lz4;

import io.trino.jdbc.$internal.airlift.compress.v3.hadoop.HadoopInputStream;
import io.trino.jdbc.$internal.airlift.compress.v3.hadoop.HadoopOutputStream;
import io.trino.jdbc.$internal.airlift.compress.v3.hadoop.HadoopStreams;
import io.trino.jdbc.$internal.airlift.compress.v3.lz4.Lz4Compressor;
import io.trino.jdbc.$internal.airlift.compress.v3.lz4.Lz4Decompressor;
import io.trino.jdbc.$internal.airlift.compress.v3.lz4.Lz4HadoopInputStream;
import io.trino.jdbc.$internal.airlift.compress.v3.lz4.Lz4HadoopOutputStream;
import io.trino.jdbc.$internal.airlift.compress.v3.lz4.Lz4JavaCompressor;
import io.trino.jdbc.$internal.airlift.compress.v3.lz4.Lz4JavaDecompressor;
import io.trino.jdbc.$internal.airlift.compress.v3.lz4.Lz4Native;
import io.trino.jdbc.$internal.airlift.compress.v3.lz4.Lz4NativeCompressor;
import io.trino.jdbc.$internal.airlift.compress.v3.lz4.Lz4NativeDecompressor;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;

public class Lz4HadoopStreams
implements HadoopStreams {
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 262144;
    private final boolean useNative;
    private final int bufferSize;

    public Lz4HadoopStreams() {
        this(true, 262144);
    }

    public Lz4HadoopStreams(boolean useNative, int bufferSize) {
        this.useNative = useNative && Lz4Native.isEnabled();
        this.bufferSize = bufferSize;
    }

    @Override
    public String getDefaultFileExtension() {
        return ".lz4";
    }

    @Override
    public List<String> getHadoopCodecName() {
        return Collections.singletonList("org.apache.hadoop.io.compress.Lz4Codec");
    }

    @Override
    public HadoopInputStream createInputStream(InputStream in) {
        Lz4Decompressor decompressor = this.useNative ? new Lz4NativeDecompressor() : new Lz4JavaDecompressor();
        return new Lz4HadoopInputStream(decompressor, in, this.bufferSize);
    }

    @Override
    public HadoopOutputStream createOutputStream(OutputStream out) {
        Lz4Compressor compressor = this.useNative ? new Lz4NativeCompressor() : new Lz4JavaCompressor();
        return new Lz4HadoopOutputStream(compressor, out, this.bufferSize);
    }
}

