/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.$internal.client.CloseableIterator;
import io.trino.jdbc.$internal.guava.base.Verify;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public interface ResultRows
extends Iterable<List<Object>>,
Closeable {
    public static final ResultRows NULL_ROWS = new ResultRows(){

        @Override
        public void close() {
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public Iterator<List<Object>> iterator() {
            return Collections.emptyIterator();
        }

        public String toString() {
            return "EmptyResultRows{}";
        }
    };

    public static ResultRows wrapIterator(final CloseableIterator<List<Object>> iterator2) {
        return new ResultRows(){
            private volatile boolean fetched;

            @Override
            public void close() throws IOException {
                iterator2.close();
            }

            @Override
            public Iterator<List<Object>> iterator() {
                Verify.verify(!this.fetched, "Iterator already fetched", new Object[0]);
                this.fetched = true;
                return iterator2;
            }

            public String toString() {
                return "ResultRows{iterator=" + String.valueOf(iterator2) + "}";
            }
        };
    }

    default public boolean isNull() {
        return false;
    }
}

