/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.$internal.client.QueryDataClientJacksonModule;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.jackson.core.JsonFactory;
import io.trino.jdbc.$internal.jackson.core.JsonParser;
import io.trino.jdbc.$internal.jackson.core.JsonProcessingException;
import io.trino.jdbc.$internal.jackson.core.StreamReadConstraints;
import io.trino.jdbc.$internal.jackson.core.StreamReadFeature;
import io.trino.jdbc.$internal.jackson.core.TSFBuilder;
import io.trino.jdbc.$internal.jackson.databind.DeserializationFeature;
import io.trino.jdbc.$internal.jackson.databind.JavaType;
import io.trino.jdbc.$internal.jackson.databind.MapperFeature;
import io.trino.jdbc.$internal.jackson.databind.ObjectMapper;
import io.trino.jdbc.$internal.jackson.databind.json.JsonMapper;
import io.trino.jdbc.$internal.jackson.datatype.jdk8.Jdk8Module;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Supplier;

public class TrinoJsonCodec<T> {
    static final Supplier<ObjectMapper> OBJECT_MAPPER_SUPPLIER = () -> {
        Object jsonFactory = ((TSFBuilder)JsonFactory.builder().streamReadConstraints(StreamReadConstraints.builder().maxStringLength(Integer.MAX_VALUE).maxNestingDepth(Integer.MAX_VALUE).maxNumberLength(Integer.MAX_VALUE).build())).build();
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder(jsonFactory).enable(StreamReadFeature.USE_FAST_DOUBLE_PARSER)).enable(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER)).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).disable(MapperFeature.AUTO_DETECT_CREATORS)).disable(MapperFeature.AUTO_DETECT_FIELDS)).disable(MapperFeature.AUTO_DETECT_SETTERS)).disable(MapperFeature.AUTO_DETECT_GETTERS)).disable(MapperFeature.AUTO_DETECT_IS_GETTERS)).disable(MapperFeature.USE_GETTERS_AS_SETTERS)).disable(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS)).disable(MapperFeature.INFER_PROPERTY_MUTATORS)).disable(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS)).disable(StreamReadFeature.AUTO_CLOSE_SOURCE)).addModule(new Jdk8Module())).addModule(new QueryDataClientJacksonModule())).build();
    };
    private final ObjectMapper mapper;
    private final Type type;
    private final JavaType javaType;

    public static <T> TrinoJsonCodec<T> jsonCodec(Class<T> type) {
        return new TrinoJsonCodec<T>(OBJECT_MAPPER_SUPPLIER.get(), type);
    }

    private TrinoJsonCodec(ObjectMapper mapper, Type type) {
        this.mapper = Objects.requireNonNull(mapper, "mapper is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.javaType = mapper.getTypeFactory().constructType(type);
    }

    public Type getType() {
        return this.type;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T fromJson(String json) throws JsonProcessingException {
        try (JsonParser parser = this.mapper.createParser(json);){
            Object value = this.mapper.readerFor(this.javaType).readValue(parser);
            Preconditions.checkArgument(parser.nextToken() == null, "Found characters after the expected end of input");
            Object t = value;
            return t;
        }
        catch (JsonProcessingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public T fromJson(InputStream inputStream2) throws IOException {
        try (JsonParser parser = this.mapper.createParser(inputStream2);){
            Object value = this.mapper.readerFor(this.javaType).readValue(parser);
            Preconditions.checkArgument(parser.nextToken() == null, "Found characters after the expected end of input");
            Object t = value;
            return t;
        }
    }

    public T fromJson(Reader inputReader) throws IOException {
        try (JsonParser parser = this.mapper.createParser(inputReader);){
            Object value = this.mapper.readerFor(this.javaType).readValue(parser);
            Preconditions.checkArgument(parser.nextToken() == null, "Found characters after the expected end of input");
            Object t = value;
            return t;
        }
    }

    public String toJson(T instance) {
        try {
            return this.mapper.writerFor(this.javaType).writeValueAsString(instance);
        }
        catch (IOException exception) {
            throw new IllegalArgumentException(String.format("%s could not be converted to JSON", instance.getClass().getName()), exception);
        }
    }
}

