/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.airlift.compress.v3.zstd;

import io.trino.jdbc.$internal.airlift.compress.v3.zstd.BlockCompressionState;
import io.trino.jdbc.$internal.airlift.compress.v3.zstd.CompressionParameters;
import io.trino.jdbc.$internal.airlift.compress.v3.zstd.HuffmanCompressionContext;
import io.trino.jdbc.$internal.airlift.compress.v3.zstd.RepeatedOffsets;
import io.trino.jdbc.$internal.airlift.compress.v3.zstd.SequenceEncodingContext;
import io.trino.jdbc.$internal.airlift.compress.v3.zstd.SequenceStore;
import io.trino.jdbc.$internal.airlift.compress.v3.zstd.Util;

class CompressionContext {
    public final CompressionParameters parameters;
    public final RepeatedOffsets offsets = new RepeatedOffsets();
    public final BlockCompressionState blockCompressionState;
    public final SequenceStore sequenceStore;
    public final SequenceEncodingContext sequenceEncodingContext = new SequenceEncodingContext();
    public final HuffmanCompressionContext huffmanContext = new HuffmanCompressionContext();

    public CompressionContext(CompressionParameters parameters, long baseAddress, int inputSize) {
        this.parameters = parameters;
        int windowSize = Math.clamp((long)inputSize, 1, parameters.getWindowSize());
        int blockSize = Math.min(131072, windowSize);
        int divider = parameters.getSearchLength() == 3 ? 3 : 4;
        int maxSequences = blockSize / divider;
        this.sequenceStore = new SequenceStore(blockSize, maxSequences);
        this.blockCompressionState = new BlockCompressionState(parameters, baseAddress);
    }

    public void slideWindow(int slideWindowSize) {
        Util.checkArgument(slideWindowSize > 0, "slideWindowSize must be positive");
        this.blockCompressionState.slideWindow(slideWindowSize);
    }

    public void commit() {
        this.offsets.commit();
        this.huffmanContext.saveChanges();
    }
}

