/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.$internal.client.spooling.SegmentLoader;
import io.trino.jdbc.$internal.client.spooling.SpooledSegment;
import io.trino.jdbc.$internal.okhttp3.Call;
import io.trino.jdbc.$internal.okhttp3.Callback;
import io.trino.jdbc.$internal.okhttp3.Headers;
import io.trino.jdbc.$internal.okhttp3.OkHttpClient;
import io.trino.jdbc.$internal.okhttp3.Request;
import io.trino.jdbc.$internal.okhttp3.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OkHttpSegmentLoader
implements SegmentLoader {
    private static final Logger logger = Logger.getLogger(SegmentLoader.class.getPackage().getName());
    private final Call.Factory callFactory;

    public OkHttpSegmentLoader() {
        this(new OkHttpClient());
    }

    public OkHttpSegmentLoader(Call.Factory callFactory) {
        this.callFactory = Objects.requireNonNull(callFactory, "callFactory is null");
    }

    @Override
    public InputStream load(SpooledSegment segment) throws IOException {
        Request request = new Request.Builder().url(segment.getDataUri().toString()).headers(OkHttpSegmentLoader.toHeaders(segment.getHeaders())).addHeader("Accept-Encoding", "identity").build();
        Response response = this.callFactory.newCall(request).execute();
        if (response.body() == null) {
            throw new IOException("Could not open segment for streaming, got empty body");
        }
        if (response.isSuccessful()) {
            return response.body().byteStream();
        }
        throw new IOException(String.format("Could not open segment for streaming, got error '%s' with code %d", response.message(), response.code()));
    }

    @Override
    public void acknowledge(SpooledSegment segment) {
        Request ackRequest = new Request.Builder().get().url(segment.getAckUri().toString()).headers(OkHttpSegmentLoader.toHeaders(segment.getHeaders())).build();
        this.callFactory.newCall(ackRequest).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException cause) {
                logger.log(Level.WARNING, "Could not acknowledge spooled segment", cause);
            }

            @Override
            public void onResponse(Call call, Response response) {
                response.close();
            }
        });
    }

    private static Headers toHeaders(Map<String, List<String>> headers) {
        Headers.Builder builder = new Headers.Builder();
        headers.forEach((key, values2) -> values2.forEach(value -> builder.add((String)key, (String)value)));
        return builder.build();
    }

    @Override
    public void close() {
        if (this.callFactory instanceof OkHttpClient) {
            ((OkHttpClient)this.callFactory).dispatcher().executorService().shutdown();
        }
    }
}

