/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.airlift.compress.bzip2;

import io.trino.jdbc.$internal.airlift.compress.bzip2.CBZip2InputStream;
import io.trino.jdbc.$internal.airlift.compress.hadoop.HadoopInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

class BZip2HadoopInputStream
extends HadoopInputStream {
    private final BufferedInputStream bufferedIn;
    private CBZip2InputStream input;

    public BZip2HadoopInputStream(InputStream in) {
        this.bufferedIn = new BufferedInputStream(in);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int result2;
        if (length == 0) {
            return 0;
        }
        if (this.input == null) {
            this.bufferedIn.mark(2);
            if (this.bufferedIn.read() != 66 || this.bufferedIn.read() != 90) {
                this.bufferedIn.reset();
            }
            this.input = new CBZip2InputStream(this.bufferedIn);
        }
        if ((result2 = this.input.read(buffer, offset, length)) == -2) {
            result2 = this.input.read(buffer, offset, 1);
        }
        return result2;
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        int result2 = this.read(buffer, 0, 1);
        if (result2 < 0) {
            return result2;
        }
        return buffer[0] & 0xFF;
    }

    @Override
    public void resetState() {
        this.input = null;
    }

    @Override
    public void close() throws IOException {
        this.input = null;
        this.bufferedIn.close();
    }
}

