/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.airlift.compress.v3.lz4;

import io.trino.jdbc.$internal.airlift.compress.v3.internal.NativeLoader;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.util.Optional;

final class Lz4Native {
    private static final Optional<LinkageError> LINKAGE_ERROR;
    private static final MethodHandle MAX_COMPRESSED_LENGTH_METHOD;
    private static final MethodHandle COMPRESS_METHOD;
    private static final MethodHandle COMPRESS_EXTERNAL_STATE_METHOD;
    private static final MethodHandle DECOMPRESS_METHOD;
    public static final int DEFAULT_ACCELERATION = 1;
    public static final int MAX_ACCELERATION = 65537;
    public static final int STATE_SIZE;

    private Lz4Native() {
    }

    public static boolean isEnabled() {
        return LINKAGE_ERROR.isEmpty();
    }

    public static void verifyEnabled() {
        if (LINKAGE_ERROR.isPresent()) {
            throw new IllegalStateException("Lz4 native library is not enabled", LINKAGE_ERROR.get());
        }
    }

    public static int maxCompressedLength(int inputLength) {
        try {
            return MAX_COMPRESSED_LENGTH_METHOD.invokeExact(inputLength);
        }
        catch (Throwable e) {
            throw new AssertionError("should not reach here", e);
        }
    }

    public static int compress(MemorySegment input, int inputLength, MemorySegment compressed, int compressedLength, int acceleration) {
        int result2;
        try {
            result2 = COMPRESS_METHOD.invokeExact(input, compressed, inputLength, compressedLength, acceleration);
        }
        catch (Throwable e) {
            throw new AssertionError("should not reach here", e);
        }
        if (result2 <= 0) {
            throw new IllegalArgumentException("Unknown error occurred during compression: result=" + result2);
        }
        return result2;
    }

    public static int compress(MemorySegment input, int inputLength, MemorySegment compressed, int compressedLength, int acceleration, MemorySegment state) {
        int result2;
        try {
            result2 = COMPRESS_EXTERNAL_STATE_METHOD.invokeExact(state, input, compressed, inputLength, compressedLength, acceleration);
        }
        catch (Throwable e) {
            throw new AssertionError("should not reach here", e);
        }
        if (result2 <= 0) {
            throw new IllegalArgumentException("Unknown error occurred during compression: result=" + result2);
        }
        return result2;
    }

    public static int decompress(MemorySegment compressed, int compressedLength, MemorySegment output, int outputLength) {
        int result2;
        try {
            result2 = DECOMPRESS_METHOD.invokeExact(compressed, output, compressedLength, outputLength);
        }
        catch (Throwable e) {
            throw new AssertionError("should not reach here", e);
        }
        if (result2 < 0) {
            throw new IllegalArgumentException("Unknown error occurred during decompression: result=" + result2);
        }
        return result2;
    }

    static {
        NativeLoader.Symbols<MethodHandles> symbols = NativeLoader.loadSymbols("lz4", MethodHandles.class, java.lang.invoke.MethodHandles.lookup());
        LINKAGE_ERROR = symbols.linkageError();
        MethodHandles methodHandles = symbols.symbols();
        MAX_COMPRESSED_LENGTH_METHOD = methodHandles.maxCompressedLength();
        COMPRESS_METHOD = methodHandles.compress();
        COMPRESS_EXTERNAL_STATE_METHOD = methodHandles.compressExternalState();
        DECOMPRESS_METHOD = methodHandles.decompress();
        if (LINKAGE_ERROR.isEmpty()) {
            try {
                STATE_SIZE = methodHandles.sizeofState().invokeExact();
            }
            catch (Throwable e) {
                throw new ExceptionInInitializerError(e);
            }
        } else {
            STATE_SIZE = -1;
        }
    }

    private record MethodHandles(MethodHandle maxCompressedLength, MethodHandle compress, MethodHandle compressExternalState, MethodHandle decompress, MethodHandle sizeofState) {
    }
}

