/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.airlift.compress.v3.zstd;

import io.trino.jdbc.$internal.airlift.compress.v3.internal.NativeLoader;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.util.Optional;

final class ZstdNative {
    private static final Optional<LinkageError> LINKAGE_ERROR;
    private static final MethodHandle MAX_COMPRESSED_LENGTH_METHOD;
    private static final MethodHandle COMPRESS_METHOD;
    private static final MethodHandle DECOMPRESS_METHOD;
    private static final MethodHandle UNCOMPRESSED_LENGTH_METHOD;
    private static final MethodHandle IS_ERROR_METHOD;
    private static final MethodHandle GET_ERROR_NAME_METHOD;
    public static final int DEFAULT_COMPRESSION_LEVEL;
    private static final long CONTENT_SIZE_UNKNOWN = -1L;

    private ZstdNative() {
    }

    public static boolean isEnabled() {
        return LINKAGE_ERROR.isEmpty();
    }

    public static void verifyEnabled() {
        if (LINKAGE_ERROR.isPresent()) {
            throw new IllegalStateException("Zstd native library is not enabled", LINKAGE_ERROR.get());
        }
    }

    public static long maxCompressedLength(long inputLength) {
        long result2;
        try {
            result2 = MAX_COMPRESSED_LENGTH_METHOD.invokeExact(inputLength);
        }
        catch (Throwable e) {
            throw new AssertionError("should not reach here", e);
        }
        if (ZstdNative.isError(result2)) {
            throw new IllegalArgumentException("Unknown error occurred during compression: " + ZstdNative.getErrorName(result2));
        }
        return result2;
    }

    public static long compress(MemorySegment input, long inputLength, MemorySegment compressed, long compressedLength, int compressionLevel) {
        long result2;
        try {
            result2 = COMPRESS_METHOD.invokeExact(compressed, compressedLength, input, inputLength, compressionLevel);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new Error("Unexpected exception", e);
        }
        if (ZstdNative.isError(result2)) {
            throw new IllegalArgumentException("Unknown error occurred during compression: " + ZstdNative.getErrorName(result2));
        }
        return result2;
    }

    public static long decompress(MemorySegment compressed, long compressedLength, MemorySegment output, long outputLength) {
        long result2;
        try {
            result2 = DECOMPRESS_METHOD.invokeExact(output, outputLength, compressed, compressedLength);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new Error("Unexpected exception", e);
        }
        if (ZstdNative.isError(result2)) {
            throw new IllegalArgumentException("Unknown error occurred during decompression: " + ZstdNative.getErrorName(result2));
        }
        return result2;
    }

    public static long decompressedLength(MemorySegment compressed, long compressedLength) {
        long result2;
        try {
            result2 = UNCOMPRESSED_LENGTH_METHOD.invokeExact(compressed, compressedLength);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new Error("Unexpected exception", e);
        }
        if (-1L != result2 && result2 < 0L) {
            throw new IllegalArgumentException("Unknown error occurred during decompression: " + ZstdNative.getErrorName(result2));
        }
        return result2;
    }

    private static boolean isError(long code) {
        try {
            return IS_ERROR_METHOD.invokeExact(code) != 0;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new Error("Unexpected exception", e);
        }
    }

    private static String getErrorName(long code) {
        try {
            MemorySegment name = GET_ERROR_NAME_METHOD.invokeExact(code);
            return name.reinterpret(Long.MAX_VALUE).getString(0L);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new Error("Unexpected exception", e);
        }
    }

    static {
        NativeLoader.Symbols<MethodHandles> symbols = NativeLoader.loadSymbols("zstd", MethodHandles.class, java.lang.invoke.MethodHandles.lookup());
        LINKAGE_ERROR = symbols.linkageError();
        MethodHandles methodHandles = symbols.symbols();
        MAX_COMPRESSED_LENGTH_METHOD = methodHandles.maxCompressedLength();
        COMPRESS_METHOD = methodHandles.compress();
        DECOMPRESS_METHOD = methodHandles.decompress();
        UNCOMPRESSED_LENGTH_METHOD = methodHandles.uncompressedLength();
        IS_ERROR_METHOD = methodHandles.isError();
        GET_ERROR_NAME_METHOD = methodHandles.getErrorName();
        if (LINKAGE_ERROR.isEmpty()) {
            try {
                DEFAULT_COMPRESSION_LEVEL = methodHandles.defaultCLevel().invokeExact();
            }
            catch (Throwable e) {
                throw new ExceptionInInitializerError(e);
            }
        } else {
            DEFAULT_COMPRESSION_LEVEL = -1;
        }
    }

    private record MethodHandles(MethodHandle maxCompressedLength, MethodHandle compress, MethodHandle decompress, MethodHandle uncompressedLength, MethodHandle isError, MethodHandle getErrorName, MethodHandle defaultCLevel) {
    }
}

