/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.client.JsonQueryData;
import io.trino.jdbc.$internal.client.QueryData;
import io.trino.jdbc.$internal.client.TypedQueryData;
import io.trino.jdbc.$internal.client.spooling.EncodedQueryData;
import io.trino.jdbc.$internal.client.spooling.Segment;
import io.trino.jdbc.$internal.jackson.core.JsonGenerator;
import io.trino.jdbc.$internal.jackson.core.JsonParser;
import io.trino.jdbc.$internal.jackson.core.JsonToken;
import io.trino.jdbc.$internal.jackson.core.Version;
import io.trino.jdbc.$internal.jackson.core.type.TypeReference;
import io.trino.jdbc.$internal.jackson.databind.JsonMappingException;
import io.trino.jdbc.$internal.jackson.databind.JsonNode;
import io.trino.jdbc.$internal.jackson.databind.JsonSerializer;
import io.trino.jdbc.$internal.jackson.databind.SerializerProvider;
import io.trino.jdbc.$internal.jackson.databind.deser.std.StdDeserializer;
import io.trino.jdbc.$internal.jackson.databind.module.SimpleModule;
import io.trino.jdbc.$internal.jackson.databind.ser.BeanSerializerFactory;
import io.trino.jdbc.$internal.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

public class QueryDataJacksonModule
extends SimpleModule {
    private static final TypeReference<EncodedQueryData> ENCODED_FORMAT = new TypeReference<EncodedQueryData>(){};

    public QueryDataJacksonModule() {
        super(QueryDataJacksonModule.class.getSimpleName(), Version.unknownVersion());
        this.addDeserializer(QueryData.class, new Deserializer());
        this.addSerializer(QueryData.class, new QueryDataSerializer());
        this.addSerializer(Segment.class, new SegmentSerializer());
    }

    private static <T> JsonSerializer<T> createSerializer(SerializerProvider provider, .JavaType javaType) throws JsonMappingException {
        return BeanSerializerFactory.instance.createSerializer(provider, javaType);
    }

    public static class Deserializer
    extends StdDeserializer<QueryData> {
        public Deserializer() {
            super(QueryData.class);
        }

        @Override
        public QueryData deserialize(JsonParser jsonParser, .DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.currentToken().equals((Object)JsonToken.START_ARRAY)) {
                return new JsonQueryData((JsonNode)jsonParser.readValueAsTree());
            }
            return (QueryData)jsonParser.readValueAs(ENCODED_FORMAT);
        }
    }

    public static class QueryDataSerializer
    extends StdSerializer<QueryData> {
        public QueryDataSerializer() {
            super(QueryData.class);
        }

        @Override
        public void serialize(QueryData value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            if (value == null) {
                provider.defaultSerializeNull(generator);
            } else if (value instanceof JsonQueryData) {
                generator.writeTree(((JsonQueryData)value).getNode());
            } else if (value instanceof TypedQueryData) {
                provider.defaultSerializeValue(((TypedQueryData)value).getIterable(), generator);
            } else if (value instanceof EncodedQueryData) {
                QueryDataJacksonModule.createSerializer(provider, provider.constructType((Type)((Object)EncodedQueryData.class))).serialize(value, generator, provider);
            } else {
                throw new IllegalArgumentException("Unsupported QueryData implementation: " + value.getClass().getSimpleName());
            }
        }

        @Override
        public boolean isEmpty(SerializerProvider provider, QueryData value) {
            return value == null || value.isNull();
        }
    }

    public static class SegmentSerializer
    extends StdSerializer<Segment> {
        public SegmentSerializer() {
            super(Segment.class);
        }

        @Override
        public void serialize(Segment value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            this.serializeWithType(value, gen, provider, SegmentSerializer.segmentSerializer(provider));
        }

        @Override
        public void serializeWithType(Segment value, JsonGenerator gen, SerializerProvider provider, .TypeSerializer typeSerializer) throws IOException {
            QueryDataJacksonModule.createSerializer(provider, provider.constructSpecializedType(provider.constructType((Type)((Object)Segment.class)), value.getClass())).serializeWithType(value, gen, provider, typeSerializer);
        }

        private static .TypeSerializer segmentSerializer(SerializerProvider provider) {
            try {
                return provider.findTypeSerializer(provider.constructType((Type)((Object)Segment.class)));
            }
            catch (JsonMappingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

