/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.spooling;

import com.google.errorprone.annotations.DoNotCall;
import io.trino.jdbc.;
import io.trino.jdbc.$internal.client.spooling.DataAttribute;
import io.trino.jdbc.$internal.guava.base.MoreObjects;
import io.trino.jdbc.$internal.guava.base.Verify;
import io.trino.jdbc.$internal.guava.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class DataAttributes {
    final Map<String, Object> attributes;

    DataAttributes(Map<String, Object> attributes) {
        this.attributes = ImmutableMap.copyOf(MoreObjects.firstNonNull(attributes, ImmutableMap.of()));
    }

    public static DataAttributes empty() {
        return new DataAttributes(ImmutableMap.of());
    }

    public <T> T get(DataAttribute attribute, Class<T> clazz) {
        return this.getOptional(attribute, clazz).orElseThrow(() -> new IllegalArgumentException(String.format("Required data attribute '%s' does not exist", attribute.name())));
    }

    public <T> Optional<T> getOptional(DataAttribute attribute, Class<T> clazz) {
        return Optional.ofNullable(this.attributes.get(attribute.attributeName())).map(value -> attribute.decode(clazz, value));
    }

    @.JsonValue
    public Map<String, Object> toMap() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataAttributes that = (DataAttributes)o;
        return Objects.equals(this.attributes, that.attributes);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("attributes", this.attributes.keySet()).toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.attributes);
    }

    @.JsonCreator
    @DoNotCall
    public static DataAttributes fromMap(Map<String, Object> attributes) {
        if (attributes == null) {
            return DataAttributes.builder().build();
        }
        Builder builder = DataAttributes.builder();
        attributes.forEach(builder::set);
        return builder.build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DataAttributes dataAttributes) {
        return new Builder(dataAttributes);
    }

    public static class Builder {
        private final ImmutableMap.Builder<String, Object> builder = ImmutableMap.builder();

        private Builder() {
        }

        private Builder(DataAttributes attributes) {
            this.builder.putAll(attributes.attributes);
        }

        public <T> Builder set(DataAttribute attribute, T value) {
            Verify.verify(attribute.javaClass().isInstance(value), "Invalid value type: %s for attribute: %s", value.getClass(), (Object)attribute.attributeName());
            this.builder.put(attribute.attributeName(), value);
            return this;
        }

        public Builder set(String key, Object value) {
            DataAttribute attribute = DataAttribute.getByName(key);
            return this.set(attribute, attribute.decode(attribute.javaClass(), value));
        }

        public DataAttributes build() {
            return new DataAttributes(this.builder.buildKeepingLast());
        }
    }
}

