/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.dev.failsafe;

import io.trino.jdbc.$internal.dev.failsafe.DelayablePolicyConfig;
import io.trino.jdbc.$internal.dev.failsafe.FailurePolicyBuilder;
import io.trino.jdbc.$internal.dev.failsafe.function.ContextualSupplier;
import io.trino.jdbc.$internal.dev.failsafe.internal.util.Assert;
import java.time.Duration;

public abstract class DelayablePolicyBuilder<S, C extends DelayablePolicyConfig<R>, R>
extends FailurePolicyBuilder<S, C, R> {
    protected DelayablePolicyBuilder(C config) {
        super(config);
    }

    public S withDelay(Duration delay) {
        Assert.notNull(delay, "delay");
        Assert.isTrue(delay.toNanos() > 0L, "delay must be greater than 0", new Object[0]);
        ((DelayablePolicyConfig)this.config).delay = delay;
        return (S)this;
    }

    public S withDelayFn(ContextualSupplier<R, Duration> delayFunction) {
        Assert.notNull(delayFunction, "delayFunction");
        ((DelayablePolicyConfig)this.config).delayFn = delayFunction;
        return (S)this;
    }

    public <F extends Throwable> S withDelayFnOn(ContextualSupplier<R, Duration> delayFunction, Class<F> exception) {
        this.withDelayFn(delayFunction);
        Assert.notNull(exception, "exception");
        ((DelayablePolicyConfig)this.config).delayException = exception;
        return (S)this;
    }

    public S withDelayFnWhen(ContextualSupplier<R, Duration> delayFunction, R result2) {
        this.withDelayFn(delayFunction);
        Assert.notNull(result2, "result");
        ((DelayablePolicyConfig)this.config).delayResult = result2;
        return (S)this;
    }
}

