/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.dev.failsafe.internal;

import io.trino.jdbc.$internal.dev.failsafe.BulkheadConfig;
import io.trino.jdbc.$internal.dev.failsafe.BulkheadFullException;
import io.trino.jdbc.$internal.dev.failsafe.ExecutionContext;
import io.trino.jdbc.$internal.dev.failsafe.internal.BulkheadImpl;
import io.trino.jdbc.$internal.dev.failsafe.spi.ExecutionResult;
import io.trino.jdbc.$internal.dev.failsafe.spi.FailsafeFuture;
import io.trino.jdbc.$internal.dev.failsafe.spi.PolicyExecutor;
import io.trino.jdbc.$internal.dev.failsafe.spi.Scheduler;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class BulkheadExecutor<R>
extends PolicyExecutor<R> {
    private final BulkheadImpl<R> bulkhead;
    private final Duration maxWaitTime;

    public BulkheadExecutor(BulkheadImpl<R> bulkhead, int policyIndex) {
        super(bulkhead, policyIndex);
        this.bulkhead = bulkhead;
        this.maxWaitTime = ((BulkheadConfig)bulkhead.getConfig()).getMaxWaitTime();
    }

    @Override
    protected ExecutionResult<R> preExecute() {
        try {
            return this.bulkhead.tryAcquirePermit(this.maxWaitTime) ? null : ExecutionResult.exception(new BulkheadFullException(this.bulkhead));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return ExecutionResult.exception(e);
        }
    }

    @Override
    protected CompletableFuture<ExecutionResult<R>> preExecuteAsync(Scheduler scheduler, FailsafeFuture<R> future) {
        CompletableFuture promise = new CompletableFuture();
        CompletableFuture<Void> acquireFuture = this.bulkhead.acquirePermitAsync();
        acquireFuture.whenComplete((result2, error) -> promise.complete(ExecutionResult.none()));
        if (!promise.isDone()) {
            try {
                ScheduledFuture<?> timeoutFuture = scheduler.schedule(() -> {
                    promise.complete(ExecutionResult.exception(new BulkheadFullException(this.bulkhead)));
                    acquireFuture.cancel(true);
                    return null;
                }, this.maxWaitTime.toNanos(), TimeUnit.NANOSECONDS);
                future.setCancelFn(this, (mayInterrupt, cancelResult) -> {
                    promise.complete((ExecutionResult)cancelResult);
                    acquireFuture.cancel((boolean)mayInterrupt);
                    timeoutFuture.cancel((boolean)mayInterrupt);
                });
            }
            catch (Throwable t) {
                promise.completeExceptionally(t);
            }
        }
        return promise;
    }

    @Override
    public void onSuccess(ExecutionResult<R> result2) {
        this.bulkhead.releasePermit();
    }

    @Override
    protected ExecutionResult<R> onFailure(ExecutionContext<R> context, ExecutionResult<R> result2) {
        this.bulkhead.releasePermit();
        return result2;
    }
}

