/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.dev.failsafe.internal;

import io.trino.jdbc.$internal.dev.failsafe.ExecutionContext;
import io.trino.jdbc.$internal.dev.failsafe.FallbackConfig;
import io.trino.jdbc.$internal.dev.failsafe.internal.EventHandler;
import io.trino.jdbc.$internal.dev.failsafe.internal.FallbackImpl;
import io.trino.jdbc.$internal.dev.failsafe.spi.AsyncExecutionInternal;
import io.trino.jdbc.$internal.dev.failsafe.spi.ExecutionResult;
import io.trino.jdbc.$internal.dev.failsafe.spi.FailsafeFuture;
import io.trino.jdbc.$internal.dev.failsafe.spi.PolicyExecutor;
import io.trino.jdbc.$internal.dev.failsafe.spi.Scheduler;
import io.trino.jdbc.$internal.dev.failsafe.spi.SyncExecutionInternal;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class FallbackExecutor<R>
extends PolicyExecutor<R> {
    private final FallbackImpl<R> fallback;
    private final FallbackConfig<R> config;
    private final EventHandler<R> failedAttemptHandler;

    public FallbackExecutor(FallbackImpl<R> fallback, int policyIndex) {
        super(fallback, policyIndex);
        this.fallback = fallback;
        this.config = fallback.getConfig();
        this.failedAttemptHandler = EventHandler.ofExecutionAttempted(this.config.getFailedAttemptListener());
    }

    @Override
    public Function<SyncExecutionInternal<R>, ExecutionResult<R>> apply(Function<SyncExecutionInternal<R>, ExecutionResult<R>> innerFn, Scheduler scheduler) {
        return execution -> {
            ExecutionResult<R> result2 = (ExecutionResult<R>)innerFn.apply((SyncExecutionInternal<R>)execution);
            if (execution.isCancelled(this)) {
                return result2;
            }
            if (this.isFailure(result2)) {
                if (this.failedAttemptHandler != null) {
                    this.failedAttemptHandler.handle(result2, (ExecutionContext<R>)execution);
                }
                try {
                    result2 = this.fallback == FallbackImpl.NONE ? result2.withNonResult() : result2.withResult(this.fallback.apply(result2.getResult(), result2.getException(), execution));
                }
                catch (Throwable t) {
                    result2 = ExecutionResult.exception(t);
                }
            }
            return this.postExecute(execution, result2);
        };
    }

    @Override
    public Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> applyAsync(Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> innerFn, Scheduler scheduler, FailsafeFuture<R> future) {
        return execution -> ((CompletableFuture)innerFn.apply((AsyncExecutionInternal<R>)execution)).thenCompose(result2 -> {
            if (result2 == null || future.isDone()) {
                return ExecutionResult.nullFuture();
            }
            if (execution.isCancelled(this)) {
                return CompletableFuture.completedFuture(result2);
            }
            if (!this.isFailure(result2)) {
                return this.postExecuteAsync(execution, result2, scheduler, future);
            }
            if (this.failedAttemptHandler != null) {
                this.failedAttemptHandler.handle((ExecutionResult<R>)result2, (ExecutionContext<R>)execution);
            }
            CompletableFuture promise = new CompletableFuture();
            Callable<Object> callable = () -> {
                try {
                    CompletableFuture<R> fallbackFuture = this.fallback.applyStage(result2.getResult(), result2.getException(), execution);
                    fallbackFuture.whenComplete((innerResult, exception) -> {
                        if (exception instanceof CompletionException) {
                            exception = exception.getCause();
                        }
                        ExecutionResult<Object> r = exception == null ? result2.withResult(innerResult) : ExecutionResult.exception(exception);
                        promise.complete(r);
                    });
                }
                catch (Throwable t) {
                    promise.complete(ExecutionResult.exception(t));
                }
                return null;
            };
            try {
                if (!this.config.isAsync()) {
                    callable.call();
                } else {
                    ScheduledFuture<?> scheduledFallback = scheduler.schedule(callable, 0L, TimeUnit.NANOSECONDS);
                    future.setCancelFn(this, (mayInterrupt, cancelResult) -> {
                        scheduledFallback.cancel((boolean)mayInterrupt);
                        promise.complete(cancelResult);
                    });
                }
            }
            catch (Throwable t) {
                promise.completeExceptionally(t);
            }
            return promise.thenCompose(ss -> this.postExecuteAsync(execution, ss, scheduler, future));
        });
    }
}

