/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.dev.failsafe.internal;

import io.trino.jdbc.$internal.dev.failsafe.ExecutionContext;
import io.trino.jdbc.$internal.dev.failsafe.Fallback;
import io.trino.jdbc.$internal.dev.failsafe.FallbackConfig;
import io.trino.jdbc.$internal.dev.failsafe.event.ExecutionAttemptedEvent;
import io.trino.jdbc.$internal.dev.failsafe.internal.FallbackExecutor;
import io.trino.jdbc.$internal.dev.failsafe.spi.FailurePolicy;
import io.trino.jdbc.$internal.dev.failsafe.spi.PolicyExecutor;
import java.util.concurrent.CompletableFuture;

public class FallbackImpl<R>
implements Fallback<R>,
FailurePolicy<R> {
    public static Fallback<Void> NONE = Fallback.builder(() -> null).build();
    private final FallbackConfig<R> config;

    public FallbackImpl(FallbackConfig<R> config) {
        this.config = config;
    }

    @Override
    public FallbackConfig<R> getConfig() {
        return this.config;
    }

    protected R apply(R result2, Throwable exception, ExecutionContext<R> context) throws Throwable {
        ExecutionAttemptedEvent<R> event = new ExecutionAttemptedEvent<R>(result2, exception, context);
        return this.config.getFallback() != null ? this.config.getFallback().apply(event) : this.config.getFallbackStage().apply(event).get();
    }

    protected CompletableFuture<R> applyStage(R result2, Throwable exception, ExecutionContext<R> context) throws Throwable {
        ExecutionAttemptedEvent<R> event = new ExecutionAttemptedEvent<R>(result2, exception, context);
        return this.config.getFallback() != null ? CompletableFuture.completedFuture(this.config.getFallback().apply(event)) : this.config.getFallbackStage().apply(event);
    }

    @Override
    public PolicyExecutor<R> toExecutor(int policyIndex) {
        return new FallbackExecutor(this, policyIndex);
    }
}

