/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.dev.failsafe.spi;

import io.trino.jdbc.$internal.dev.failsafe.ExecutionContext;
import io.trino.jdbc.$internal.dev.failsafe.Policy;
import io.trino.jdbc.$internal.dev.failsafe.internal.EventHandler;
import io.trino.jdbc.$internal.dev.failsafe.spi.AsyncExecutionInternal;
import io.trino.jdbc.$internal.dev.failsafe.spi.ExecutionInternal;
import io.trino.jdbc.$internal.dev.failsafe.spi.ExecutionResult;
import io.trino.jdbc.$internal.dev.failsafe.spi.FailsafeFuture;
import io.trino.jdbc.$internal.dev.failsafe.spi.FailurePolicy;
import io.trino.jdbc.$internal.dev.failsafe.spi.Scheduler;
import io.trino.jdbc.$internal.dev.failsafe.spi.SyncExecutionInternal;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public abstract class PolicyExecutor<R> {
    private final int policyIndex;
    private final FailurePolicy<R> failurePolicy;
    private final EventHandler<R> successHandler;
    private final EventHandler<R> failureHandler;

    protected PolicyExecutor(Policy<R> policy, int policyIndex) {
        this.policyIndex = policyIndex;
        this.failurePolicy = policy instanceof FailurePolicy ? (FailurePolicy)policy : null;
        this.successHandler = EventHandler.ofExecutionCompleted(policy.getConfig().getSuccessListener());
        this.failureHandler = EventHandler.ofExecutionCompleted(policy.getConfig().getFailureListener());
    }

    public int getPolicyIndex() {
        return this.policyIndex;
    }

    protected ExecutionResult<R> preExecute() {
        return null;
    }

    protected CompletableFuture<ExecutionResult<R>> preExecuteAsync(Scheduler scheduler, FailsafeFuture<R> future) {
        ExecutionResult<R> result2 = this.preExecute();
        return result2 == null ? null : CompletableFuture.completedFuture(result2);
    }

    public Function<SyncExecutionInternal<R>, ExecutionResult<R>> apply(Function<SyncExecutionInternal<R>, ExecutionResult<R>> innerFn, Scheduler scheduler) {
        return execution -> {
            ExecutionResult<R> result2 = this.preExecute();
            if (result2 != null) {
                execution.preExecute();
                return result2;
            }
            return this.postExecute((ExecutionInternal<R>)execution, (ExecutionResult)innerFn.apply((SyncExecutionInternal<R>)execution));
        };
    }

    public Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> applyAsync(Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> innerFn, Scheduler scheduler, FailsafeFuture<R> future) {
        return execution -> {
            CompletableFuture<ExecutionResult<R>> preResult;
            CompletableFuture promise = new CompletableFuture();
            Runnable runnable2 = () -> ((CompletableFuture)((CompletableFuture)innerFn.apply((AsyncExecutionInternal<R>)execution)).thenCompose(r -> r == null ? ExecutionResult.nullFuture() : this.postExecuteAsync((AsyncExecutionInternal<R>)execution, (ExecutionResult<R>)r, scheduler, future))).whenComplete((postResult, postError) -> {
                if (postError != null) {
                    promise.completeExceptionally((Throwable)postError);
                } else {
                    promise.complete(postResult);
                }
            });
            if (!execution.isRecorded() && (preResult = this.preExecuteAsync(scheduler, future)) != null) {
                preResult.whenComplete((result2, error) -> {
                    if (error != null) {
                        promise.completeExceptionally((Throwable)error);
                    } else if (result2 != null) {
                        if (result2.isNonResult()) {
                            runnable2.run();
                        } else {
                            execution.preExecute();
                            promise.complete(result2);
                        }
                    } else {
                        promise.complete(null);
                    }
                });
                return promise;
            }
            runnable2.run();
            return promise;
        };
    }

    public ExecutionResult<R> postExecute(ExecutionInternal<R> execution, ExecutionResult<R> result2) {
        execution.recordAttempt();
        if (this.isFailure(result2)) {
            result2 = this.onFailure(execution, result2.withException());
            this.handleFailure(result2, execution);
        } else {
            result2 = result2.withSuccess();
            this.onSuccess(result2);
            this.handleSuccess(result2, execution);
        }
        return result2;
    }

    protected synchronized CompletableFuture<ExecutionResult<R>> postExecuteAsync(AsyncExecutionInternal<R> execution, ExecutionResult<R> result2, Scheduler scheduler, FailsafeFuture<R> future) {
        CompletableFuture<ExecutionResult<R>> postFuture = null;
        if (!execution.isAsyncExecution() || !execution.isPostExecuted(this.policyIndex)) {
            execution.recordAttempt();
            if (this.isFailure(result2)) {
                postFuture = this.onFailureAsync(execution, result2.withException(), scheduler, future).whenComplete((postResult, error) -> this.handleFailure((ExecutionResult<R>)postResult, execution));
            } else {
                result2 = result2.withSuccess();
                this.onSuccess(result2);
                this.handleSuccess(result2, execution);
                postFuture = CompletableFuture.completedFuture(result2);
            }
            if (execution.isAsyncExecution()) {
                execution.setPostExecuted(this.policyIndex);
            }
        }
        return postFuture;
    }

    protected boolean isFailure(ExecutionResult<R> result2) {
        if (result2.isNonResult()) {
            return false;
        }
        if (this.failurePolicy != null) {
            return this.failurePolicy.isFailure(result2.getResult(), result2.getException());
        }
        return result2.getException() != null;
    }

    protected void onSuccess(ExecutionResult<R> result2) {
    }

    protected ExecutionResult<R> onFailure(ExecutionContext<R> context, ExecutionResult<R> result2) {
        return result2;
    }

    protected CompletableFuture<ExecutionResult<R>> onFailureAsync(ExecutionContext<R> context, ExecutionResult<R> result2, Scheduler scheduler, FailsafeFuture<R> future) {
        try {
            return CompletableFuture.completedFuture(this.onFailure(context, result2));
        }
        catch (Throwable t) {
            CompletableFuture<ExecutionResult<R>> r = new CompletableFuture<ExecutionResult<R>>();
            r.completeExceptionally(t);
            return r;
        }
    }

    private void handleSuccess(ExecutionResult<R> result2, ExecutionContext<R> context) {
        if (this.successHandler != null && result2.isComplete()) {
            this.successHandler.handle(result2, context);
        }
    }

    private void handleFailure(ExecutionResult<R> result2, ExecutionContext<R> context) {
        if (this.failureHandler != null && result2.isComplete()) {
            this.failureHandler.handle(result2, context);
        }
    }
}

