/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.guava.base;

import io.trino.jdbc.$internal.guava.annotations.GwtIncompatible;
import io.trino.jdbc.$internal.guava.annotations.J2ktIncompatible;
import io.trino.jdbc.$internal.guava.base.Converter;
import io.trino.jdbc.$internal.guava.base.Optional;
import io.trino.jdbc.$internal.guava.base.Platform;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.jspecify.annotations.Nullable;

@GwtIncompatible
@J2ktIncompatible
public final class Enums {
    private static final Map<Class<? extends Enum<?>>, Map<String, WeakReference<? extends Enum<?>>>> enumConstantCache = new WeakHashMap();

    private Enums() {
    }

    public static Field getField(Enum<?> enumValue) {
        Class<?> clazz = enumValue.getDeclaringClass();
        try {
            return clazz.getDeclaredField(enumValue.name());
        }
        catch (NoSuchFieldException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    public static <T extends Enum<T>> Optional<T> getIfPresent(Class<T> enumClass, String value) {
        Preconditions.checkNotNull(enumClass);
        Preconditions.checkNotNull(value);
        return Platform.getEnumIfPresent(enumClass, value);
    }

    private static <T extends Enum<T>> Map<String, WeakReference<? extends Enum<?>>> populateCache(Class<T> enumClass) {
        HashMap result2 = new HashMap();
        for (Enum enumInstance : EnumSet.allOf(enumClass)) {
            result2.put(enumInstance.name(), new WeakReference<Enum>(enumInstance));
        }
        enumConstantCache.put(enumClass, result2);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends Enum<T>> Map<String, WeakReference<? extends Enum<?>>> getEnumConstants(Class<T> enumClass) {
        Map<Class<? extends Enum<?>>, Map<String, WeakReference<? extends Enum<?>>>> map = enumConstantCache;
        synchronized (map) {
            Map<String, WeakReference<Enum>> constants = enumConstantCache.get(enumClass);
            if (constants == null) {
                constants = Enums.populateCache(enumClass);
            }
            return constants;
        }
    }

    public static <T extends Enum<T>> Converter<String, T> stringConverter(Class<T> enumClass) {
        return new StringConverter<T>(enumClass);
    }

    private static final class StringConverter<T extends Enum<T>>
    extends Converter<String, T>
    implements Serializable {
        private final Class<T> enumClass;
        @J2ktIncompatible
        private static final long serialVersionUID = 0L;

        StringConverter(Class<T> enumClass) {
            this.enumClass = Preconditions.checkNotNull(enumClass);
        }

        @Override
        protected T doForward(String value) {
            return Enum.valueOf(this.enumClass, value);
        }

        @Override
        protected String doBackward(T enumValue) {
            return ((Enum)enumValue).name();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj instanceof StringConverter) {
                StringConverter that = (StringConverter)obj;
                return this.enumClass.equals(that.enumClass);
            }
            return false;
        }

        public int hashCode() {
            return this.enumClass.hashCode();
        }

        public String toString() {
            return "Enums.stringConverter(" + this.enumClass.getName() + ".class)";
        }
    }
}

