/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.guava.escape;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.trino.jdbc.$internal.guava.annotations.GwtCompatible;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.escape.CharEscaper;
import io.trino.jdbc.$internal.guava.escape.Escaper;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;

@GwtCompatible
public final class CharEscaperBuilder {
    private final Map<Character, String> map = new HashMap<Character, String>();
    private int max = -1;

    @CanIgnoreReturnValue
    public CharEscaperBuilder addEscape(char c, String r) {
        this.map.put(Character.valueOf(c), Preconditions.checkNotNull(r));
        if (c > this.max) {
            this.max = c;
        }
        return this;
    }

    @CanIgnoreReturnValue
    public CharEscaperBuilder addEscapes(char[] cs, String r) {
        Preconditions.checkNotNull(r);
        for (char c : cs) {
            this.addEscape(c, r);
        }
        return this;
    }

    public char[] @Nullable [] toArray() {
        char[][] result2 = new char[this.max + 1][];
        for (Map.Entry<Character, String> entry : this.map.entrySet()) {
            result2[entry.getKey().charValue()] = entry.getValue().toCharArray();
        }
        return result2;
    }

    public Escaper toEscaper() {
        return new CharArrayDecorator(this.toArray());
    }

    private static final class CharArrayDecorator
    extends CharEscaper {
        private final char[] @Nullable [] replacements;
        private final int replaceLength;

        CharArrayDecorator(char[] @Nullable [] replacements) {
            this.replacements = replacements;
            this.replaceLength = replacements.length;
        }

        @Override
        public String escape(String s) {
            int slen = s.length();
            for (int index = 0; index < slen; ++index) {
                char c = s.charAt(index);
                if (c >= this.replacements.length || this.replacements[c] == null) continue;
                return this.escapeSlow(s, index);
            }
            return s;
        }

        @Override
        protected char @Nullable [] escape(char c) {
            return c < this.replaceLength ? this.replacements[c] : null;
        }
    }
}

