/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.guava.graph;

import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.collect.ImmutableSet;
import io.trino.jdbc.$internal.guava.collect.Iterators;
import io.trino.jdbc.$internal.guava.collect.UnmodifiableIterator;
import java.util.AbstractSet;
import java.util.Map;
import org.jspecify.annotations.Nullable;

final class EdgesConnecting<E>
extends AbstractSet<E> {
    private final Map<?, E> nodeToOutEdge;
    private final Object targetNode;

    EdgesConnecting(Map<?, E> nodeToEdgeMap, Object targetNode) {
        this.nodeToOutEdge = Preconditions.checkNotNull(nodeToEdgeMap);
        this.targetNode = Preconditions.checkNotNull(targetNode);
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        E connectingEdge = this.getConnectingEdge();
        return connectingEdge == null ? ImmutableSet.of().iterator() : Iterators.singletonIterator(connectingEdge);
    }

    @Override
    public int size() {
        return this.getConnectingEdge() == null ? 0 : 1;
    }

    @Override
    public boolean contains(@Nullable Object edge) {
        E connectingEdge = this.getConnectingEdge();
        return connectingEdge != null && connectingEdge.equals(edge);
    }

    private @Nullable E getConnectingEdge() {
        return this.nodeToOutEdge.get(this.targetNode);
    }
}

