/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.guava.io;

import io.trino.jdbc.$internal.guava.annotations.GwtIncompatible;
import io.trino.jdbc.$internal.guava.annotations.J2ktIncompatible;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.jspecify.annotations.Nullable;

@J2ktIncompatible
@GwtIncompatible
final class MultiInputStream
extends InputStream {
    private final Iterator<? extends ByteSource> it;
    private @Nullable InputStream in;

    public MultiInputStream(Iterator<? extends ByteSource> it) throws IOException {
        this.it = Preconditions.checkNotNull(it);
        this.advance();
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }

    private void advance() throws IOException {
        this.close();
        if (this.it.hasNext()) {
            this.in = this.it.next().openStream();
        }
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            return 0;
        }
        return this.in.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        while (this.in != null) {
            int result2 = this.in.read();
            if (result2 != -1) {
                return result2;
            }
            this.advance();
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Preconditions.checkNotNull(b);
        while (this.in != null) {
            int result2 = this.in.read(b, off, len);
            if (result2 != -1) {
                return result2;
            }
            this.advance();
        }
        return -1;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.in == null || n <= 0L) {
            return 0L;
        }
        long result2 = this.in.skip(n);
        if (result2 != 0L) {
            return result2;
        }
        if (this.read() == -1) {
            return 0L;
        }
        return 1L + this.in.skip(n - 1L);
    }
}

