/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.jackson.databind.deser.std;

import io.trino.jdbc.$internal.jackson.annotation.JsonFormat;
import io.trino.jdbc.$internal.jackson.core.JsonParser;
import io.trino.jdbc.$internal.jackson.core.JsonToken;
import io.trino.jdbc.$internal.jackson.databind.BeanProperty;
import io.trino.jdbc.$internal.jackson.databind.DeserializationConfig;
import io.trino.jdbc.$internal.jackson.databind.DeserializationContext;
import io.trino.jdbc.$internal.jackson.databind.DeserializationFeature;
import io.trino.jdbc.$internal.jackson.databind.JsonDeserializer;
import io.trino.jdbc.$internal.jackson.databind.JsonMappingException;
import io.trino.jdbc.$internal.jackson.databind.MapperFeature;
import io.trino.jdbc.$internal.jackson.databind.annotation.JacksonStdImpl;
import io.trino.jdbc.$internal.jackson.databind.cfg.CoercionAction;
import io.trino.jdbc.$internal.jackson.databind.cfg.CoercionInputShape;
import io.trino.jdbc.$internal.jackson.databind.deser.ContextualDeserializer;
import io.trino.jdbc.$internal.jackson.databind.deser.SettableBeanProperty;
import io.trino.jdbc.$internal.jackson.databind.deser.ValueInstantiator;
import io.trino.jdbc.$internal.jackson.databind.deser.std.FactoryBasedEnumDeserializer;
import io.trino.jdbc.$internal.jackson.databind.deser.std.StdScalarDeserializer;
import io.trino.jdbc.$internal.jackson.databind.introspect.AnnotatedClass;
import io.trino.jdbc.$internal.jackson.databind.introspect.AnnotatedMethod;
import io.trino.jdbc.$internal.jackson.databind.type.LogicalType;
import io.trino.jdbc.$internal.jackson.databind.util.ClassUtil;
import io.trino.jdbc.$internal.jackson.databind.util.CompactStringObjectMap;
import io.trino.jdbc.$internal.jackson.databind.util.EnumResolver;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;

@JacksonStdImpl
public class EnumDeserializer
extends StdScalarDeserializer<Object>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected Object[] _enumsByIndex;
    private final Enum<?> _enumDefaultValue;
    protected final CompactStringObjectMap _lookupByName;
    protected volatile CompactStringObjectMap _lookupByToString;
    protected final Boolean _caseInsensitive;
    private Boolean _useDefaultValueForUnknownEnum;
    private Boolean _useNullForUnknownEnum;
    protected final boolean _isFromIntValue;
    protected final boolean _hasAsValueAnnotation;
    protected final CompactStringObjectMap _lookupByEnumNaming;

    @Deprecated
    public EnumDeserializer(EnumResolver byNameResolver, Boolean caseInsensitive) {
        this(byNameResolver, Boolean.TRUE.equals(caseInsensitive), null);
    }

    @Deprecated
    public EnumDeserializer(EnumResolver byNameResolver, boolean caseInsensitive, EnumResolver byEnumNamingResolver) {
        super(byNameResolver.getEnumClass());
        this._lookupByName = byNameResolver.constructLookup();
        this._hasAsValueAnnotation = byNameResolver.hasAsValueAnnotation();
        this._enumsByIndex = byNameResolver.getRawEnums();
        this._enumDefaultValue = byNameResolver.getDefaultValue();
        this._caseInsensitive = caseInsensitive;
        this._isFromIntValue = byNameResolver.isFromIntValue();
        this._lookupByEnumNaming = byEnumNamingResolver == null ? null : byEnumNamingResolver.constructLookup();
        this._lookupByToString = null;
    }

    public EnumDeserializer(EnumResolver byNameResolver, boolean caseInsensitive, EnumResolver byEnumNamingResolver, EnumResolver toStringResolver) {
        super(byNameResolver.getEnumClass());
        this._lookupByName = byNameResolver.constructLookup();
        this._hasAsValueAnnotation = byNameResolver.hasAsValueAnnotation();
        this._enumsByIndex = byNameResolver.getRawEnums();
        this._enumDefaultValue = byNameResolver.getDefaultValue();
        this._caseInsensitive = caseInsensitive;
        this._isFromIntValue = byNameResolver.isFromIntValue();
        this._lookupByEnumNaming = byEnumNamingResolver == null ? null : byEnumNamingResolver.constructLookup();
        this._lookupByToString = toStringResolver == null ? null : toStringResolver.constructLookup();
    }

    protected EnumDeserializer(EnumDeserializer base, Boolean caseInsensitive, Boolean useDefaultValueForUnknownEnum, Boolean useNullForUnknownEnum) {
        super(base);
        this._lookupByName = base._lookupByName;
        this._hasAsValueAnnotation = base._hasAsValueAnnotation;
        this._enumsByIndex = base._enumsByIndex;
        this._enumDefaultValue = base._enumDefaultValue;
        this._caseInsensitive = Boolean.TRUE.equals(caseInsensitive);
        this._isFromIntValue = base._isFromIntValue;
        this._useDefaultValueForUnknownEnum = useDefaultValueForUnknownEnum;
        this._useNullForUnknownEnum = useNullForUnknownEnum;
        this._lookupByEnumNaming = base._lookupByEnumNaming;
        this._lookupByToString = base._lookupByToString;
    }

    @Deprecated
    public static JsonDeserializer<?> deserializerForCreator(DeserializationConfig config, Class<?> enumClass, AnnotatedMethod factory, ValueInstantiator valueInstantiator, SettableBeanProperty[] creatorProps) {
        return EnumDeserializer.deserializerForCreator(config, enumClass, factory, valueInstantiator, creatorProps, null);
    }

    public static JsonDeserializer<?> deserializerForCreator(DeserializationConfig config, Class<?> enumClass, AnnotatedMethod factory, ValueInstantiator valueInstantiator, SettableBeanProperty[] creatorProps, EnumResolver byNameResolver) {
        if (config.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(factory.getMember(), config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        return new FactoryBasedEnumDeserializer(enumClass, factory, factory.getParameterType(0), valueInstantiator, creatorProps, byNameResolver);
    }

    public static JsonDeserializer<?> deserializerForNoArgsCreator(DeserializationConfig config, Class<?> enumClass, AnnotatedMethod factory) {
        if (config.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(factory.getMember(), config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        return new FactoryBasedEnumDeserializer(enumClass, factory);
    }

    public EnumDeserializer withResolved(Boolean caseInsensitive, Boolean useDefaultValueForUnknownEnum, Boolean useNullForUnknownEnum) {
        if (Objects.equals(this._caseInsensitive, caseInsensitive) && Objects.equals(this._useDefaultValueForUnknownEnum, useDefaultValueForUnknownEnum) && Objects.equals(this._useNullForUnknownEnum, useNullForUnknownEnum)) {
            return this;
        }
        return new EnumDeserializer(this, caseInsensitive, useDefaultValueForUnknownEnum, useNullForUnknownEnum);
    }

    @Deprecated
    public EnumDeserializer withResolved(Boolean caseInsensitive) {
        return this.withResolved(caseInsensitive, this._useDefaultValueForUnknownEnum, this._useNullForUnknownEnum);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        Boolean caseInsensitive = Optional.ofNullable(this.findFormatFeature(ctxt, property, this.handledType(), JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES)).orElse(this._caseInsensitive);
        Boolean useDefaultValueForUnknownEnum = Optional.ofNullable(this.findFormatFeature(ctxt, property, this.handledType(), JsonFormat.Feature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE)).orElse(this._useDefaultValueForUnknownEnum);
        Boolean useNullForUnknownEnum = Optional.ofNullable(this.findFormatFeature(ctxt, property, this.handledType(), JsonFormat.Feature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)).orElse(this._useNullForUnknownEnum);
        return this.withResolved(caseInsensitive, useDefaultValueForUnknownEnum, useNullForUnknownEnum);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Enum;
    }

    @Override
    public Object getEmptyValue(DeserializationContext ctxt) throws JsonMappingException {
        return this._enumDefaultValue;
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(p, ctxt, p.getText());
        }
        if (p.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            if (this._isFromIntValue) {
                return this._fromString(p, ctxt, p.getText());
            }
            return this._fromInteger(p, ctxt, p.getIntValue());
        }
        if (p.isExpectedStartObjectToken()) {
            String str = ctxt.extractScalarFromObject(p, this, this._valueClass);
            if (str == null) {
                return ctxt.handleUnexpectedToken(this._enumClass(), p);
            }
            return this._fromString(p, ctxt, str);
        }
        return this._deserializeOther(p, ctxt);
    }

    protected Object _fromString(JsonParser p, DeserializationContext ctxt, String text) throws IOException {
        String trimmed;
        CompactStringObjectMap lookup = this._resolveCurrentLookup(ctxt);
        Object result2 = lookup.find(text);
        if (result2 == null && ((trimmed = text.trim()) == text || (result2 = lookup.find(trimmed)) == null)) {
            return this._deserializeAltString(p, ctxt, lookup, trimmed);
        }
        return result2;
    }

    private CompactStringObjectMap _resolveCurrentLookup(DeserializationContext ctxt) {
        if (this._lookupByEnumNaming != null) {
            return this._lookupByEnumNaming;
        }
        if (this._hasAsValueAnnotation || !ctxt.isEnabled(DeserializationFeature.READ_ENUMS_USING_TO_STRING)) {
            return this._lookupByName;
        }
        return this._getToStringLookup(ctxt);
    }

    protected Object _fromInteger(JsonParser p, DeserializationContext ctxt, int index) throws IOException {
        CoercionAction act = ctxt.findCoercionAction(this.logicalType(), this.handledType(), CoercionInputShape.Integer);
        if (act == CoercionAction.Fail) {
            if (ctxt.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS)) {
                return ctxt.handleWeirdNumberValue(this._enumClass(), index, "not allowed to deserialize Enum value out of number: disable DeserializationConfig.DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS to allow", new Object[0]);
            }
            this._checkCoercionFail(ctxt, act, this.handledType(), index, "Integer value (" + index + ")");
        }
        switch (act) {
            case AsNull: {
                return null;
            }
            case AsEmpty: {
                return this.getEmptyValue(ctxt);
            }
        }
        if (index >= 0 && index < this._enumsByIndex.length) {
            return this._enumsByIndex[index];
        }
        if (this.useDefaultValueForUnknownEnum(ctxt)) {
            return this._enumDefaultValue;
        }
        if (!this.useNullForUnknownEnum(ctxt)) {
            return ctxt.handleWeirdNumberValue(this._enumClass(), index, "index value outside legal index range [0..%s]", this._enumsByIndex.length - 1);
        }
        return null;
    }

    private final Object _deserializeAltString(JsonParser p, DeserializationContext ctxt, CompactStringObjectMap lookup, String nameOrig) throws IOException {
        char c;
        Object match;
        String name = nameOrig.trim();
        if (name.isEmpty()) {
            CoercionAction act;
            if (this.useDefaultValueForUnknownEnum(ctxt)) {
                return this._enumDefaultValue;
            }
            if (this.useNullForUnknownEnum(ctxt)) {
                return null;
            }
            if (nameOrig.isEmpty()) {
                act = this._findCoercionFromEmptyString(ctxt);
                act = this._checkCoercionFail(ctxt, act, this.handledType(), nameOrig, "empty String (\"\")");
            } else {
                act = this._findCoercionFromBlankString(ctxt);
                act = this._checkCoercionFail(ctxt, act, this.handledType(), nameOrig, "blank String (all whitespace)");
            }
            switch (act) {
                case AsEmpty: 
                case TryConvert: {
                    return this.getEmptyValue(ctxt);
                }
            }
            return null;
        }
        if (Boolean.TRUE.equals(this._caseInsensitive) && (match = lookup.findCaseInsensitive(name)) != null) {
            return match;
        }
        if (!(ctxt.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS) || this._isFromIntValue || (c = name.charAt(0)) < '0' || c > '9' || c == '0' && name.length() > 1)) {
            try {
                int index = Integer.parseInt(name);
                if (!ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
                    return ctxt.handleWeirdStringValue(this._enumClass(), name, "value looks like quoted Enum index, but `MapperFeature.ALLOW_COERCION_OF_SCALARS` prevents use", new Object[0]);
                }
                if (index >= 0 && index < this._enumsByIndex.length) {
                    return this._enumsByIndex[index];
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.useDefaultValueForUnknownEnum(ctxt)) {
            return this._enumDefaultValue;
        }
        if (this.useNullForUnknownEnum(ctxt)) {
            return null;
        }
        return ctxt.handleWeirdStringValue(this._enumClass(), name, "not one of the values accepted for Enum class: %s", lookup.keys());
    }

    protected Object _deserializeOther(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.START_ARRAY)) {
            return this._deserializeFromArray(p, ctxt);
        }
        return ctxt.handleUnexpectedToken(this._enumClass(), p);
    }

    protected Class<?> _enumClass() {
        return this.handledType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected CompactStringObjectMap _getToStringLookup(DeserializationContext ctxt) {
        CompactStringObjectMap lookup = this._lookupByToString;
        if (lookup == null) {
            EnumDeserializer enumDeserializer = this;
            synchronized (enumDeserializer) {
                lookup = this._lookupByToString;
                if (lookup == null) {
                    DeserializationConfig config = ctxt.getConfig();
                    AnnotatedClass ac = config.introspectClassAnnotations(this._enumClass()).getClassInfo();
                    this._lookupByToString = EnumResolver.constructUsingToString(config, ac).constructLookup();
                }
            }
        }
        return lookup;
    }

    protected boolean useNullForUnknownEnum(DeserializationContext ctxt) {
        if (this._useNullForUnknownEnum != null) {
            return this._useNullForUnknownEnum;
        }
        return ctxt.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL);
    }

    protected boolean useDefaultValueForUnknownEnum(DeserializationContext ctxt) {
        if (this._enumDefaultValue != null) {
            if (this._useDefaultValueForUnknownEnum != null) {
                return this._useDefaultValueForUnknownEnum;
            }
            return ctxt.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE);
        }
        return false;
    }
}

