/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.okhttp3;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.kotlin.jvm.internal.Intrinsics;
import io.trino.jdbc.$internal.kotlin.text.StringsKt;
import io.trino.jdbc.$internal.okhttp3.Address;
import io.trino.jdbc.$internal.okhttp3.Protocol;
import io.trino.jdbc.$internal.okhttp3.internal._HostnamesCommonKt;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@.Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u0002\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b\rJ\r\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\u000eJ\r\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\b\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0013\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0013\u0010\u0002\u001a\u00020\u00038G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\nR\u0013\u0010\u0004\u001a\u00020\u00058G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000bR\u0013\u0010\u0006\u001a\u00020\u00078G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\f\u00a8\u0006\u0018"}, d2={"Lio/trino/jdbc/$internal/okhttp3/Route;", "", "address", "Lio/trino/jdbc/$internal/okhttp3/Address;", "proxy", "Ljava/net/Proxy;", "socketAddress", "Ljava/net/InetSocketAddress;", "<init>", "(Lokhttp3/Address;Ljava/net/Proxy;Ljava/net/InetSocketAddress;)V", "()Lokhttp3/Address;", "()Ljava/net/Proxy;", "()Ljava/net/InetSocketAddress;", "-deprecated_address", "-deprecated_proxy", "-deprecated_socketAddress", "requiresTunnel", "", "equals", "other", "hashCode", "", "toString", "", "okhttp"})
public final class Route {
    @NotNull
    private final Address address;
    @NotNull
    private final Proxy proxy;
    @NotNull
    private final InetSocketAddress socketAddress;

    public Route(@NotNull Address address, @NotNull Proxy proxy, @NotNull InetSocketAddress socketAddress) {
        Intrinsics.checkNotNullParameter(address, "address");
        Intrinsics.checkNotNullParameter(proxy, "proxy");
        Intrinsics.checkNotNullParameter(socketAddress, "socketAddress");
        this.address = address;
        this.proxy = proxy;
        this.socketAddress = socketAddress;
    }

    @.JvmName(name="address")
    @NotNull
    public final Address address() {
        return this.address;
    }

    @.JvmName(name="proxy")
    @NotNull
    public final Proxy proxy() {
        return this.proxy;
    }

    @.JvmName(name="socketAddress")
    @NotNull
    public final InetSocketAddress socketAddress() {
        return this.socketAddress;
    }

    @.Deprecated(message="moved to val", replaceWith=@.ReplaceWith(expression="address", imports={}), level=.DeprecationLevel.ERROR)
    @.JvmName(name="-deprecated_address")
    @NotNull
    public final Address -deprecated_address() {
        return this.address;
    }

    @.Deprecated(message="moved to val", replaceWith=@.ReplaceWith(expression="proxy", imports={}), level=.DeprecationLevel.ERROR)
    @.JvmName(name="-deprecated_proxy")
    @NotNull
    public final Proxy -deprecated_proxy() {
        return this.proxy;
    }

    @.Deprecated(message="moved to val", replaceWith=@.ReplaceWith(expression="socketAddress", imports={}), level=.DeprecationLevel.ERROR)
    @.JvmName(name="-deprecated_socketAddress")
    @NotNull
    public final InetSocketAddress -deprecated_socketAddress() {
        return this.socketAddress;
    }

    public final boolean requiresTunnel() {
        if (this.proxy.type() != Proxy.Type.HTTP) {
            return false;
        }
        return this.address.sslSocketFactory() != null || this.address.protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Route && Intrinsics.areEqual(((Route)other).address, this.address) && Intrinsics.areEqual(((Route)other).proxy, this.proxy) && Intrinsics.areEqual(((Route)other).socketAddress, this.socketAddress);
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 31 * result2 + this.address.hashCode();
        result2 = 31 * result2 + this.proxy.hashCode();
        result2 = 31 * result2 + this.socketAddress.hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String addressHostname = this.address.url().host();
        Object object = this.socketAddress.getAddress();
        String socketHostname = object != null && (object = ((InetAddress)object).getHostAddress()) != null ? _HostnamesCommonKt.toCanonicalHost((String)object) : null;
        StringBuilder stringBuilder2 = StringsKt.contains$default((CharSequence)addressHostname, ':', false, 2, null) ? $this$toString_u24lambda_u240.append("[").append(addressHostname).append("]") : $this$toString_u24lambda_u240.append(addressHostname);
        if (this.address.url().port() != this.socketAddress.getPort() || Intrinsics.areEqual(addressHostname, socketHostname)) {
            $this$toString_u24lambda_u240.append(":");
            $this$toString_u24lambda_u240.append(this.address.url().port());
        }
        if (!Intrinsics.areEqual(addressHostname, socketHostname)) {
            StringBuilder stringBuilder3 = Intrinsics.areEqual(this.proxy, Proxy.NO_PROXY) ? $this$toString_u24lambda_u240.append(" at ") : $this$toString_u24lambda_u240.append(" via proxy ");
            StringBuilder stringBuilder4 = socketHostname == null ? $this$toString_u24lambda_u240.append("<unresolved>") : (StringsKt.contains$default((CharSequence)socketHostname, ':', false, 2, null) ? $this$toString_u24lambda_u240.append("[").append(socketHostname).append("]") : $this$toString_u24lambda_u240.append(socketHostname));
            $this$toString_u24lambda_u240.append(":");
            $this$toString_u24lambda_u240.append(this.socketAddress.getPort());
        }
        return stringBuilder.toString();
    }
}

