/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.okhttp3.java.net.cookiejar;

import io.trino.jdbc.$internal.kotlin.Metadata;
import io.trino.jdbc.$internal.kotlin.TuplesKt;
import io.trino.jdbc.$internal.kotlin.collections.CollectionsKt;
import io.trino.jdbc.$internal.kotlin.collections.MapsKt;
import io.trino.jdbc.$internal.kotlin.jvm.internal.Intrinsics;
import io.trino.jdbc.$internal.kotlin.text.StringsKt;
import io.trino.jdbc.$internal.okhttp3.Cookie;
import io.trino.jdbc.$internal.okhttp3.CookieJar;
import io.trino.jdbc.$internal.okhttp3.HttpUrl;
import io.trino.jdbc.$internal.okhttp3.internal.Internal;
import io.trino.jdbc.$internal.okhttp3.internal._UtilCommonKt;
import io.trino.jdbc.$internal.okhttp3.internal.platform.Platform;
import java.io.IOException;
import java.net.CookieHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/trino/jdbc/$internal/okhttp3/java/net/cookiejar/JavaNetCookieJar;", "Lio/trino/jdbc/$internal/okhttp3/CookieJar;", "cookieHandler", "Ljava/net/CookieHandler;", "<init>", "(Ljava/net/CookieHandler;)V", "saveFromResponse", "", "url", "Lio/trino/jdbc/$internal/okhttp3/HttpUrl;", "cookies", "", "Lio/trino/jdbc/$internal/okhttp3/Cookie;", "loadForRequest", "decodeHeaderAsJavaNetCookies", "header", "", "okhttp-java-net-cookiejar"})
public final class JavaNetCookieJar
implements CookieJar {
    @NotNull
    private final CookieHandler cookieHandler;

    public JavaNetCookieJar(@NotNull CookieHandler cookieHandler) {
        Intrinsics.checkNotNullParameter(cookieHandler, "cookieHandler");
        this.cookieHandler = cookieHandler;
    }

    @Override
    public void saveFromResponse(@NotNull HttpUrl url, @NotNull List<Cookie> cookies) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(cookies, "cookies");
        List cookieStrings = new ArrayList();
        for (Cookie cookie : cookies) {
            cookieStrings.add(Internal.cookieToString(cookie, true));
        }
        Map<String, List<String>> multimap = MapsKt.mapOf(TuplesKt.to("Set-Cookie", cookieStrings));
        try {
            this.cookieHandler.put(url.uri(), multimap);
        }
        catch (IOException e) {
            Platform platform = Platform.Companion.get();
            StringBuilder stringBuilder = new StringBuilder().append("Saving cookies failed for ");
            HttpUrl httpUrl = url.resolve("/...");
            Intrinsics.checkNotNull(httpUrl);
            platform.log(stringBuilder.append(httpUrl).toString(), 5, e);
        }
    }

    @Override
    @NotNull
    public List<Cookie> loadForRequest(@NotNull HttpUrl url) {
        Object object;
        Map<String, List<String>> map;
        Intrinsics.checkNotNullParameter(url, "url");
        try {
            map = this.cookieHandler.get(url.uri(), MapsKt.emptyMap());
        }
        catch (IOException e) {
            Platform platform = Platform.Companion.get();
            StringBuilder stringBuilder = new StringBuilder().append("Loading cookies failed for ");
            HttpUrl httpUrl = url.resolve("/...");
            Intrinsics.checkNotNull(httpUrl);
            platform.log(stringBuilder.append(httpUrl).toString(), 5, e);
            return CollectionsKt.emptyList();
        }
        Map<String, List<String>> cookieHeaders = map;
        List cookies = null;
        Intrinsics.checkNotNull(cookieHeaders);
        for (Map.Entry<String, List<String>> entry : cookieHeaders.entrySet()) {
            String key = entry.getKey();
            List<String> value = entry.getValue();
            if (!StringsKt.equals("Cookie", key, true) && !StringsKt.equals("Cookie2", key, true)) continue;
            Intrinsics.checkNotNull(value);
            if (!(!((Collection)value).isEmpty())) continue;
            for (String header : value) {
                if (cookies == null) {
                    cookies = new ArrayList();
                }
                Intrinsics.checkNotNull(header);
                cookies.addAll((Collection)this.decodeHeaderAsJavaNetCookies(url, header));
            }
        }
        if (cookies != null) {
            List list = Collections.unmodifiableList(cookies);
            Intrinsics.checkNotNull(list);
            object = list;
        } else {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final List<Cookie> decodeHeaderAsJavaNetCookies(HttpUrl url, String header) {
        List result2 = new ArrayList();
        int pos = 0;
        int limit = header.length();
        int pairEnd = 0;
        while (pos < limit) {
            String value;
            pairEnd = _UtilCommonKt.delimiterOffset(header, ";,", pos, limit);
            int equalsSign = _UtilCommonKt.delimiterOffset(header, '=', pos, pairEnd);
            String name = _UtilCommonKt.trimSubstring(header, pos, equalsSign);
            if (StringsKt.startsWith$default(name, "$", false, 2, null)) {
                pos = pairEnd + 1;
                continue;
            }
            String string = value = equalsSign < pairEnd ? _UtilCommonKt.trimSubstring(header, equalsSign + 1, pairEnd) : "";
            if (StringsKt.startsWith$default(value, "\"", false, 2, null) && StringsKt.endsWith$default(value, "\"", false, 2, null) && value.length() >= 2) {
                String string2 = value.substring(1, value.length() - 1);
                Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                value = string2;
            }
            result2.add(new Cookie.Builder().name(name).value(value).domain(url.host()).build());
            pos = pairEnd + 1;
        }
        return result2;
    }
}

